/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews5.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:41:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _OUTLINER_HXX
#include <bf_svx/outliner.hxx>
#endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <bf_svx/svdpagv.hxx>
#endif
#ifndef _SV_SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SVX_FMSHELL_HXX //autogen
#include <bf_svx/fmshell.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
#include <com/sun/star/document/XEventListener.hpp>
#endif

#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"
#include "app.hrc"

#include "optsitem.hxx"
#include "app.hxx"
#include "frmview.hxx"
#include "sdattr.hxx"
#include "sdpage.hxx"
#include "stlpool.hxx"
#include "sdresid.hxx"
#include "sdwindow.hxx"
#include "drawview.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "drviewsh.hxx"
#include "presvish.hxx"
#include "sdoutl.hxx"
#include "sdclient.hxx"
#include "fuslshow.hxx"
#include "unokywds.hxx"
#include "SdUnoDrawView.hxx"
namespace binfilter {

#define TABCONTROL_INITIAL_SIZE     350
#define PAPER_SHADOW_EXT_PIXEL        2

/*************************************************************************
|*
|* Wird gerufen, wenn sich das Model aendert
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ModelHasChanged()
/*N*/ {
/*N*/ 	Invalidate();
/*N*/ 	// Damit der Navigator auch einen aktuellen Status bekommt
/*N*/ 	GetViewFrame()->GetBindings().Invalidate( SID_NAVIGATOR_STATE, TRUE, FALSE );
/*N*/ 
/*N*/ 	// Damit das Effekte-Window die Reihenfolge updaten kann
/*N*/ 	UpdateEffectWindow();
/*N*/ 
/*N*/ 	//Update3DWindow();
/*N*/ 	SfxBoolItem aItem( SID_3D_STATE, TRUE );
/*N*/ 	GetViewFrame()->GetDispatcher()->Execute( 
/*N*/ 		SID_3D_STATE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
/*N*/ 
/*N*/ 	// jetzt den von der Drawing Engine neu erzeugten TextEditOutliner
/*N*/ 	// initialisieren
/*N*/ 	Outliner* pOutliner 	  = pDrView->GetTextEditOutliner();
/*N*/ 	if (pOutliner)
/*N*/ 	{
/*?*/ 		SfxStyleSheetPool* pSPool = (SfxStyleSheetPool*) pDocSh->GetStyleSheetPool();
/*?*/ 		pOutliner->SetStyleSheetPool(pSPool);
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Daten der FrameView auf die aktuelle View uebertragen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ReadFrameViewData(FrameView* pView)
/*N*/ {
/*N*/ 	BOOL bChanged = pDoc->IsChanged();		// merken
/*N*/ 
/*N*/ 	// Diese Option wird am Model eingestellt
/*N*/ 	pDoc->SetPickThroughTransparentTextFrames(
/*N*/ 			 SD_MOD()->GetSdOptions(pDoc->GetDocumentType())->IsPickThrough());
/*N*/ 
/*N*/ 	// Initialisierungen der Zeichen-(Bildschirm-)Attribute
/*N*/ 	if (HasRuler() != pView->HasRuler())
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	SetRuler( pView->HasRuler() );
/*N*/ 
/*N*/ 	if (pDrView->GetGridCoarse() != pView->GetGridCoarse())
/*N*/ 		pDrView->SetGridCoarse( pView->GetGridCoarse() );
/*N*/ 
/*N*/ 	if (pDrView->GetGridFine() != pView->GetGridFine())
/*N*/ 		pDrView->SetGridFine( pView->GetGridFine() );
/*N*/ 
/*N*/ 	if (pDrView->GetSnapGrid() != pView->GetSnapGrid())
/*N*/ 		pDrView->SetSnapGrid( pView->GetSnapGrid() );
/*N*/ 
/*N*/ 	if (pDrView->GetSnapGridWidthX() != pView->GetSnapGridWidthX() || pDrView->GetSnapGridWidthY() != pView->GetSnapGridWidthY())
/*N*/ 		pDrView->SetSnapGridWidth(pView->GetSnapGridWidthX(), pView->GetSnapGridWidthY());
/*N*/ 
/*N*/ 	if (pDrView->IsGridVisible() != pView->IsGridVisible())
/*N*/ 		pDrView->SetGridVisible( pView->IsGridVisible() );
/*N*/ 
/*N*/ 	if (pDrView->IsGridFront() != pView->IsGridFront())
/*N*/ 		pDrView->SetGridFront( pView->IsGridFront() );
/*N*/ 
/*N*/ 	if (pDrView->GetSnapAngle() != pView->GetSnapAngle())
/*N*/ 		pDrView->SetSnapAngle( pView->GetSnapAngle() );
/*N*/ 
/*N*/ 	if (pDrView->IsGridSnap() !=  pView->IsGridSnap() )
/*N*/ 		pDrView->SetGridSnap( pView->IsGridSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsBordSnap() !=  pView->IsBordSnap() )
/*N*/ 		pDrView->SetBordSnap( pView->IsBordSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsHlplSnap() !=  pView->IsHlplSnap() )
/*N*/ 		pDrView->SetHlplSnap( pView->IsHlplSnap() );

/*N*/ 	if (pDrView->IsOFrmSnap() !=  pView->IsOFrmSnap() )
/*N*/ 		pDrView->SetOFrmSnap( pView->IsOFrmSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsOPntSnap() !=  pView->IsOPntSnap() )
/*N*/ 		pDrView->SetOPntSnap( pView->IsOPntSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsOConSnap() !=  pView->IsOConSnap() )
/*N*/ 		pDrView->SetOConSnap( pView->IsOConSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsHlplVisible() != pView->IsHlplVisible() )
/*?*/ 		pDrView->SetHlplVisible( pView->IsHlplVisible() );
/*?*/ 
/*N*/ 	if (pDrView->IsDragStripes() != pView->IsDragStripes() )
/*?*/ 		pDrView->SetDragStripes( pView->IsDragStripes() );
/*?*/ 
/*N*/ 	if (pDrView->IsPlusHandlesAlwaysVisible() != pView->IsPlusHandlesAlwaysVisible() )
/*?*/ 		pDrView->SetPlusHandlesAlwaysVisible( pView->IsPlusHandlesAlwaysVisible() );
/*?*/ 
/*N*/ 	if (pDrView->GetSnapMagneticPixel() != pView->GetSnapMagneticPixel() )
/*N*/ 		pDrView->SetSnapMagneticPixel( pView->GetSnapMagneticPixel() );
/*N*/ 
/*N*/ 	if (pDrView->IsMarkedHitMovesAlways() != pView->IsMarkedHitMovesAlways() )
/*N*/ 		pDrView->SetMarkedHitMovesAlways( pView->IsMarkedHitMovesAlways() );
/*N*/ 
/*N*/ 	if (pDrView->IsMoveOnlyDragging() != pView->IsMoveOnlyDragging() )
/*?*/ 		pDrView->SetMoveOnlyDragging( pView->IsMoveOnlyDragging() );
/*?*/ 
//    pDrView->SetSlantButShear( pView->IsSlantButShear() );
/*N*/ 
/*N*/ 	if (pDrView->IsNoDragXorPolys() != pView->IsNoDragXorPolys() )
/*?*/ 		pDrView->SetNoDragXorPolys( pView->IsNoDragXorPolys() );
/*?*/ 
/*N*/ 	if (pDrView->IsCrookNoContortion() != pView->IsCrookNoContortion() )
/*?*/ 		pDrView->SetCrookNoContortion( pView->IsCrookNoContortion() );
/*?*/ 
/*N*/ 	if (pDrView->IsAngleSnapEnabled() != pView->IsAngleSnapEnabled() )
/*?*/ 		pDrView->SetAngleSnapEnabled( pView->IsAngleSnapEnabled() );
/*?*/ 
/*N*/ 	if (pDrView->IsBigOrtho() != pView->IsBigOrtho() )
/*N*/ 		pDrView->SetBigOrtho( pView->IsBigOrtho() );
/*N*/ 
/*N*/ 	if (pDrView->IsOrtho() != pView->IsOrtho() )
/*?*/ 		pDrView->SetOrtho( pView->IsOrtho() );
/*?*/ 
/*N*/ 	if (pDrView->GetEliminatePolyPointLimitAngle() != pView->GetEliminatePolyPointLimitAngle() )
/*N*/ 		pDrView->SetEliminatePolyPointLimitAngle( pView->GetEliminatePolyPointLimitAngle() );
/*N*/ 
/*N*/ 	if (pDrView->IsEliminatePolyPoints() != pView->IsEliminatePolyPoints() )
/*?*/ 		pDrView->SetEliminatePolyPoints( pView->IsEliminatePolyPoints() );
/*?*/ 
/*N*/ 	if (pDrView->IsLineDraft() != pView->IsLineDraft() )
/*?*/ 		pDrView->SetLineDraft( pView->IsLineDraft() );
/*?*/ 
/*N*/ 	if (pDrView->IsFillDraft() != pView->IsFillDraft() )
/*N*/ 	{
/*?*/ 		pDrView->ReleaseMasterPagePaintCache();
/*?*/ 		pDrView->SetFillDraft( pView->IsFillDraft() );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pDrView->IsTextDraft() != pView->IsTextDraft() )
/*?*/ 		pDrView->SetTextDraft( pView->IsTextDraft() );
/*?*/ 
/*N*/ 	if (pDrView->IsGrafDraft() != pView->IsGrafDraft() )
/*?*/ 		pDrView->SetGrafDraft( pView->IsGrafDraft() );
/*?*/ 
/*N*/ 	if (pDrView->IsSolidMarkHdl() != pView->IsSolidMarkHdl() )
/*N*/ 		pDrView->SetSolidMarkHdl( pView->IsSolidMarkHdl() );
/*N*/ 
/*N*/ 	if (pDrView->IsSolidDragging() != pView->IsSolidDragging() )
/*?*/ 		pDrView->SetSolidDragging( pView->IsSolidDragging() );
/*?*/ 
/*N*/ 	if (pDrView->IsQuickTextEditMode() != pView->IsQuickEdit())
/*N*/ 		pDrView->SetQuickTextEditMode( pView->IsQuickEdit() );
/*N*/ 
/*N*/ 	// Definition:
/*N*/ 	//	grosse Handles:	9
/*N*/ 	//	kleine Handles:	7
/*N*/ 	USHORT nTmp = pDrView->GetMarkHdlSizePixel();
/*N*/ 	//DBG_ASSERT(nTmp != 7, "HandleSize != 7 oder 9");
/*N*/ 	if( nTmp == 9 && !pView->IsBigHandles() )
/*?*/ 		pDrView->SetMarkHdlSizePixel( 7 );
/*?*/ 	else if( nTmp == 7 && pView->IsBigHandles() )
/*?*/ 		pDrView->SetMarkHdlSizePixel( 9 );
/*N*/ 
/*N*/ 
/*N*/ 	SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
/*N*/ 
/*N*/ 	if (pPageView)
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pPageView->GetVisibleLayers() != pView->GetVisibleLayers() )
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pDrView->GetActiveLayer() != pView->GetActiveLayer() )
/*N*/ 		pDrView->SetActiveLayer( pView->GetActiveLayer() );
/*N*/ 
/*N*/ 	USHORT nSelectedPage = 0;
/*N*/ 
/*N*/ 	if (ePageKind != PK_HANDOUT)
/*N*/ 	{
/*N*/ 		nSelectedPage = pView->GetSelectedPage();
/*N*/ 	}
/*N*/ 
/*N*/ 	EditMode eNewEditMode = pView->GetViewShEditMode(ePageKind);
/*N*/ 	BOOL bNewLayerMode = pView->IsLayerMode();
/*N*/ 	ChangeEditMode(eNewEditMode, bNewLayerMode);
/*N*/ 	SwitchPage(nSelectedPage);
/*N*/ 
/*N*/ 	// DrawMode fuer 'Normales' Fenster wiederherstellen
/*N*/ 	if(pWindow->GetDrawMode() != pView->GetDrawMode())
/*?*/ 	  pWindow->SetDrawMode(pView->GetDrawMode());

/*N*/ 	if ( pDrView->IsDesignMode() != pView->IsDesignMode() )
/*N*/ 	{
/*?*/ 		SfxBoolItem aDesignModeItem( SID_FM_DESIGN_MODE, pView->IsDesignMode() );
/*?*/ 		GetViewFrame()->GetDispatcher()->Execute( SID_FM_DESIGN_MODE, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aDesignModeItem, 0L );
/*N*/ 	}

	// Muss am Ende gerufen werden, da ein WriteFrameViewData() ausgeloest wird
/*N*/ 	if (pDrView->IsFrameDragSingles() != pView->IsFrameDragSingles() )
/*N*/  		pDrView->SetFrameDragSingles( pView->IsFrameDragSingles() );
/*N*/ 
/*N*/ 	pDoc->SetChanged( bChanged );
/*N*/ }

/*************************************************************************
|*
|* Daten der aktuellen View auf die FrameView uebertragen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::WriteFrameViewData()
/*N*/ {
/*N*/ 	// Zeichen-(Bildschirm-)Attribute an FrameView merken
/*N*/ 	pFrameView->SetRuler( HasRuler() );
/*N*/ 	pFrameView->SetGridCoarse( pDrView->GetGridCoarse() );
/*N*/ 	pFrameView->SetGridFine( pDrView->GetGridFine() );
/*N*/ 	pFrameView->SetSnapGrid( pDrView->GetSnapGrid() );
/*N*/ 	pFrameView->SetSnapGridWidth(pDrView->GetSnapGridWidthX(), pDrView->GetSnapGridWidthY());
/*N*/ 	pFrameView->SetGridVisible( pDrView->IsGridVisible() );
/*N*/ 	pFrameView->SetGridFront( pDrView->IsGridFront() );
/*N*/ 	pFrameView->SetSnapAngle( pDrView->GetSnapAngle() );
/*N*/ 	pFrameView->SetGridSnap( pDrView->IsGridSnap() );
/*N*/ 	pFrameView->SetBordSnap( pDrView->IsBordSnap() );
/*N*/ 	pFrameView->SetHlplSnap( pDrView->IsHlplSnap() );
/*N*/ 	pFrameView->SetOFrmSnap( pDrView->IsOFrmSnap() );
/*N*/ 	pFrameView->SetOPntSnap( pDrView->IsOPntSnap() );
/*N*/ 	pFrameView->SetOConSnap( pDrView->IsOConSnap() );
/*N*/ 	pFrameView->SetHlplVisible( pDrView->IsHlplVisible() );
/*N*/ 	pFrameView->SetDragStripes( pDrView->IsDragStripes() );
/*N*/ 	pFrameView->SetPlusHandlesAlwaysVisible( pDrView->IsPlusHandlesAlwaysVisible() );
/*N*/ 	pFrameView->SetFrameDragSingles( pDrView->IsFrameDragSingles() );
/*N*/ 	pFrameView->SetMarkedHitMovesAlways( pDrView->IsMarkedHitMovesAlways() );
/*N*/ 	pFrameView->SetMoveOnlyDragging( pDrView->IsMoveOnlyDragging() );
/*N*/ 	pFrameView->SetNoDragXorPolys( pDrView->IsNoDragXorPolys() );
/*N*/ 	pFrameView->SetCrookNoContortion( pDrView->IsCrookNoContortion() );
/*N*/ 	pFrameView->SetBigOrtho( pDrView->IsBigOrtho() );
/*N*/ 	pFrameView->SetEliminatePolyPointLimitAngle( pDrView->GetEliminatePolyPointLimitAngle() );
/*N*/ 	pFrameView->SetEliminatePolyPoints( pDrView->IsEliminatePolyPoints() );
/*N*/ 
/*N*/ 	pFrameView->SetLineDraft( pDrView->IsLineDraft() );
/*N*/ 	pFrameView->SetFillDraft( pDrView->IsFillDraft() );
/*N*/ 	pFrameView->SetTextDraft( pDrView->IsTextDraft() );
/*N*/ 	pFrameView->SetGrafDraft( pDrView->IsGrafDraft() );
/*N*/ 	pFrameView->SetSolidMarkHdl( pDrView->IsSolidMarkHdl() );
/*N*/ 	pFrameView->SetSolidDragging( pDrView->IsSolidDragging() );
/*N*/ 	pFrameView->SetQuickEdit( pDrView->IsQuickTextEditMode() );
/*N*/ 
/*N*/ 	pFrameView->SetDesignMode( pDrView->IsDesignMode() );
/*N*/ 
/*N*/ 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
/*N*/ 	Rectangle aVisArea = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
/*N*/ 	pFrameView->SetVisArea(aVisArea);
/*N*/ 
/*N*/ 	if( ePageKind == PK_HANDOUT )
/*N*/  		pFrameView->SetSelectedPage(0);
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if( !ISA( SdPresViewShell ) )
/*N*/ 		{
/*N*/ 			if( pFuSlideShow && ( pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_SHOW ) )
/*?*/     		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pFrameView->SetSelectedPage( pFuSlideShow->GetCurrentPage() );
/*N*/ 			else 
/*N*/     			pFrameView->SetSelectedPage( aTabControl.GetCurPageId() - 1 );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pFrameView->SetViewShEditMode(eEditMode, ePageKind);
/*N*/ 	pFrameView->SetLayerMode(bLayerMode);
/*N*/ 
/*N*/ 	SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
/*N*/ 
/*N*/ 	if (pPageView)
/*N*/ 	{
/*N*/ 		if ( pFrameView->GetVisibleLayers() != pPageView->GetVisibleLayers() )
/*?*/ 			pFrameView->SetVisibleLayers( pPageView->GetVisibleLayers() );

/*N*/ 		if ( pFrameView->GetPrintableLayers() != pPageView->GetPrintableLayers() )
/*?*/ 			pFrameView->SetPrintableLayers( pPageView->GetPrintableLayers() );

/*N*/ 		if ( pFrameView->GetLockedLayers() != pPageView->GetLockedLayers() )
/*?*/ 			pFrameView->SetLockedLayers( pPageView->GetLockedLayers() );

/*N*/ 		if (ePageKind == PK_NOTES)
/*N*/ 		{
/*?*/ 			pFrameView->SetNotesHelpLines( pPageView->GetHelpLines() );
/*?*/ 		}
/*N*/ 		else if (ePageKind == PK_HANDOUT)
/*N*/ 		{
/*?*/ 			pFrameView->SetHandoutHelpLines( pPageView->GetHelpLines() );
/*?*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			pFrameView->SetStandardHelpLines( pPageView->GetHelpLines() );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pFrameView->GetActiveLayer() != pDrView->GetActiveLayer() )
/*?*/ 		pFrameView->SetActiveLayer( pDrView->GetActiveLayer() );

	// DrawMode fuer 'Normales' Fenster merken
/*N*/ 	if(pFrameView->GetDrawMode() != pWindow->GetDrawMode())
/*?*/ 	  pFrameView->SetDrawMode(pWindow->GetDrawMode());

    // remember tabcontrol extent as percentage of whole frame width
/*N*/     const Size aFrameSize( GetViewFrame()->GetWindow().GetOutputSizePixel() );
/*N*/ 
/*N*/     if( aFrameSize.Width() )
/*N*/         pFrameView->SetTabCtrlPercent( (double) aTabControl.GetSizePixel().Width() / aFrameSize.Width() );
/*N*/     else
/*N*/         pFrameView->SetTabCtrlPercent( 0.0 );
/*N*/ }

/*************************************************************************
|*
|* Seite wird gehided
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::HidePage(SdrPageView* pPV)
/*N*/ {
/*N*/ 	FmFormShell* pShell = (FmFormShell*) aShellTable.Get(RID_FORMLAYER_TOOLBOX);
/*N*/ 
/*N*/ 	if (pShell)
/*N*/ 		pShell->PrepareClose(FALSE);
/*N*/ }



/*N*/ void SdDrawViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	WriteFrameViewData();
/*N*/ 
/*N*/ 	SdViewShell::WriteUserDataSequence( rSequence, bBrowse );
/*N*/ 
/*N*/ 	const sal_Int32 nIndex = rSequence.getLength();
/*N*/ 	rSequence.realloc( nIndex + 1 );
/*N*/ 	rSequence[nIndex].Name = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sUNO_View_ZoomOnPage ) );
/*N*/ 	rSequence[nIndex].Value <<= (sal_Bool)bZoomOnPage;
/*N*/ }


/*N*/ void SdDrawViewShell::VisAreaChanged(const Rectangle& rRect)
/*N*/ {
/*N*/ 	SdViewShell::VisAreaChanged( rRect );
/*N*/ 
/*N*/ 	if( pController )
/*N*/ 	{
/*N*/ 		pController->fireVisAreaChanged( rRect );
/*N*/ 	}
/*N*/ }


/*?*/ int SdDrawViewShell::GetTabLayerCount (void) const
/*?*/ {
/*?*/ {DBG_BF_ASSERT(0, "STRIP");} return 0;//STRIP001     return aLayerTab.GetPageCount();
/*?*/ }

/*?*/ int SdDrawViewShell::GetActiveTabLayerIndex (void) const
/*?*/ {
/*?*/ {DBG_BF_ASSERT(0, "STRIP");} return 0;//STRIP001 /*?*/     return aLayerTab.GetPagePos (aLayerTab.GetCurPageId());
/*?*/ }
    
/*?*/ void SdDrawViewShell::SetActiveTabLayerIndex (int nIndex)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/     // Ignore invalid indices silently.
/*?*/ }

}
