/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drawview.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:40:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SVXIDS_HRC //autogen
#include <bf_svx/svxids.hrc>
#endif



#ifndef _SD_STLSHEET_HXX
#include "stlsheet.hxx"
#endif


#include "glob.hrc"
#include "strings.hrc"

#include "drawview.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "sdpage.hxx"
#include "drviewsh.hxx"
namespace binfilter {

using namespace ::com::sun::star;

TYPEINIT1( SdDrawView, SdView );

/*************************************************************************
|*
|* Konstruktor
|* zeigt die erste Seite des Dokuments auf Position 0,0 an;
|* falls noch keine Seite vorhanden ist, wird eine erzeugt
|*
\************************************************************************/

/*N*/ SdDrawView::SdDrawView(SdDrawDocShell* pDocSh, OutputDevice* pOutDev,
/*N*/ 					   SdDrawViewShell* pShell) :
/*N*/ 					   SdView(pDocSh->GetDoc(), pOutDev, pShell),
/*N*/ 					   pDrawViewShell(pShell),
/*N*/ 					   pDocShell(pDocSh),
/*N*/ 					   nPOCHSmph(0),
/*N*/ 					   nPresPaintSmph(0),
/*N*/ 					   pVDev(NULL),
/*N*/ 					   bPixelMode(FALSE),
/*N*/ 					   pSlideShow(NULL),
/*N*/ 					   nMagic(SDDRAWVIEW_MAGIC),
/*N*/ 					   bInAnimation(FALSE),
/*N*/ 					   bActionMode(TRUE)
/*N*/ {
/*N*/ 	SetCurrentObj(OBJ_RECT, SdrInventor);
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdDrawView::~SdDrawView()
/*N*/ {
/*N*/ 	nMagic = 0;
/*N*/ 	delete pVDev;
/*N*/ 
/*N*/ 	if( pSlideShow )
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		pSlideShow->Destroy();
/*N*/ }

/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Selektionsaenderung gerufen
|*
\************************************************************************/

/*N*/ void SdDrawView::MarkListHasChanged()
/*N*/ {
/*N*/ 	SdView::MarkListHasChanged();
/*N*/ 
/*N*/ 	if (pDrawViewShell)
/*N*/ 		pDrawViewShell->SelectionHasChanged();
/*N*/ }

/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Modelaenderung gerufen
|*
\************************************************************************/

/*N*/ void SdDrawView::ModelHasChanged()
/*N*/ {
/*N*/ 	SdView::ModelHasChanged();
/*N*/ 
/*N*/ 	// den Gestalter zur Neudarstellung zwingen
/*N*/ 	SfxStyleSheetBasePool* pSSPool = pDoc->GetStyleSheetPool();
/*N*/ 	pSSPool->Broadcast(SfxStyleSheetPoolHint(SFX_STYLESHEETPOOL_CHANGES));
/*N*/ 
/*N*/ 	if (pViewSh)
/*N*/ 	{
/*N*/ 		// falls wir in der Diashow sind und das Gliederungstextobjekt selektiert
/*N*/ 		// ist wird der Gliederungsclone der Diashow aktualisiert
/*N*/ 		FuSlideShow* pFuSlideShow = pSlideShow;
/*N*/ 
/*N*/ 		if (!pFuSlideShow)
/*N*/ 		{
/*N*/ 			pFuSlideShow = pViewSh->GetSlideShow();
/*N*/ 		}
/*N*/ 
/*N*/ 		if (pFuSlideShow)
/*N*/ 		{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			SdrRectObj* pLayoutText = pFuSlideShow->GetLayoutText();
/*?*/ 		}

/*N*/ 		pDrawViewShell->ModelHasChanged();
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Attribute auf Titel- und Gliederungtext und Hintergrundrechteck einer
|* Masterpage in Vorlagen umlenken, sonst an Basisklasse weitergeben
|*
\************************************************************************/


/*************************************************************************
|*
|* Notify fuer Aenderung der Seitenanordnung
|*
\************************************************************************/

/*N*/ void SdDrawView::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 								 const SfxHint& rHint, const TypeId& rHintType)
/*N*/ {
/*N*/ 	if ( pDrawViewShell && rHint.ISA(SdrHint) )
/*N*/ 	{
/*N*/ 		SdrHintKind eHintKind = ( (SdrHint&) rHint).GetKind();
/*N*/ 
/*N*/ 		if ( nPOCHSmph == 0 && eHintKind == HINT_PAGEORDERCHG )
/*N*/ 		{
/*N*/ 			pDrawViewShell->ResetActualPage();
/*N*/ 		}
/*N*/ 		else if ( eHintKind == HINT_LAYERCHG || eHintKind == HINT_LAYERORDERCHG )
/*N*/ 		{
/*N*/ 			pDrawViewShell->ResetActualLayer();
/*N*/ 		}
/*N*/ 
/*N*/ 		// #94278# switch to that page when it's not a master page
/*N*/ 		if(HINT_SWITCHTOPAGE == eHintKind)
/*N*/ 		{
/*?*/ 			const SdrPage* pPage = ((const SdrHint&)rHint).GetPage();
/*?*/ 
/*?*/ 			if(pPage && !pPage->IsMasterPage())
/*?*/ 			{
/*?*/ 				if(pDrawViewShell->GetActualPage() != pPage)
/*?*/ 				{
/*?*/ 					sal_uInt16 nPageNum = (pPage->GetPageNum() - 1) / 2; // Sdr --> Sd
/*?*/ 					pDrawViewShell->SwitchPage(nPageNum);
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SdView::SFX_NOTIFY(rBC, rBCType, rHint, rHintType);
/*N*/ }

/*************************************************************************
|*
|* PageOrderChangedHint blockieren/freigeben
|*
\************************************************************************/


/*************************************************************************
|*
|* StyleSheet-Setzen auf der Masterpage abfangen, wenn Praesentationsobjekte
|* selektiert sind
|*
\************************************************************************/


/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird an die View weitergeleitet
|*
\************************************************************************/



/*************************************************************************
|*
|* PaintEvents waehrend der Praesentation erlauben oder auch nicht.
|*
\************************************************************************/


/*************************************************************************
|*
|* Paint-Event waehrend der Praesenation
|*
\************************************************************************/


/*************************************************************************
|*
|* Paint-Proc filtert fuer die Praesentation Objekte heraus, die unsichtbar
|* sind oder anders dargestellt werden muessen.
|*
\************************************************************************/


/*************************************************************************
|* entscheidet, ob ein Objekt markiert werden kann (z. B. noch nicht
|* erschienene Animationsobjekte in der Diashow)
\************************************************************************/


/*************************************************************************
|*
|* Pixelmodus ein- oder ausschalten
|*
\************************************************************************/




/*************************************************************************
|*
|* Uebergebenen Bereich sichtbar machen (es wird ggf. gescrollt)
|*
\************************************************************************/



/*************************************************************************
|*
|* Animations-Modus starten
|*
\************************************************************************/



/*************************************************************************
|*
|* Objekt animieren
|*
\************************************************************************/



/*************************************************************************
|*
|* Seite animieren
|*
\************************************************************************/


/*************************************************************************
|*
|* Seite wird gehided
|*
\************************************************************************/

/*N*/ void SdDrawView::HidePage(SdrPageView* pPV)
/*N*/ {
/*N*/ 	if (pDrawViewShell)
/*N*/ 	{
/*N*/ 		pDrawViewShell->HidePage(pPV);
/*N*/ 	}
/*N*/ 
/*N*/ 	SdView::HidePage(pPV);
/*N*/ }



}
