/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fupoor.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:21:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <bf_svx/svxids.hrc>

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SV_SELENG_HXX //autogen
#include <vcl/seleng.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif


#include "app.hrc"

#include "drawview.hxx"
#include "sdwindow.hxx"
#include "drawdoc.hxx"
#include "fuslshow.hxx"

// #97016# IV

// #98533#
namespace binfilter {

using namespace ::com::sun::star;
using ::com::sun::star::uno::Reference;


TYPEINIT0( FuPoor );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ FuPoor::FuPoor(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
/*N*/ 			   SdDrawDocument* pDrDoc, SfxRequest& rReq) :
/*N*/ 	pViewShell(pViewSh),
/*N*/ 	pWindow(pWin),
/*N*/ 	pView(pView),
/*N*/ 	pDoc(pDrDoc),
/*N*/ 	pDocSh( pDrDoc->GetDocSh() ),
/*N*/ 	nSlotId( rReq.GetSlot() ),
/*N*/ 	pDialog(NULL),
/*N*/ 	bIsInDragMode(FALSE),
/*N*/ 	bScrollable (FALSE),
/*N*/ 	bDelayActive (FALSE),
/*N*/ 	bNoScrollUntilInside (TRUE),
/*N*/ 	nSlotValue(0),
/*N*/ 	// #95491# remember MouseButton state
/*N*/ 	mnCode(0)
/*N*/ {
/*N*/ 	ReceiveRequest(rReq);
/*N*/ 
/*N*/ 	aScrollTimer.SetTimeoutHdl( LINK(this, FuPoor, ScrollHdl) );
/*N*/ 	aScrollTimer.SetTimeout(SELENG_AUTOREPEAT_INTERVAL);
/*N*/ 
/*N*/ 	aDragTimer.SetTimeoutHdl( LINK(this, FuPoor, DragHdl) );
/*N*/ 	aDragTimer.SetTimeout(SELENG_DRAGDROP_TIMEOUT);
/*N*/ 
/*N*/ 	aDelayToScrollTimer.SetTimeoutHdl( LINK(this, FuPoor, DelayHdl) );
/*N*/ 	aDelayToScrollTimer.SetTimeout(2000);
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ FuPoor::~FuPoor()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 	aScrollTimer.Stop();
/*N*/ 	aDelayToScrollTimer.Stop ();

/*N*/ 	if (pDialog)
/*?*/ 		delete pDialog;
/*N*/ }

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void FuPoor::Activate()
/*N*/ {
/*N*/ 	if (pDialog)
/*?*/ 	{
/*?*/ 		pDialog->Show();
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void FuPoor::Deactivate()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 	aScrollTimer.Stop();
/*N*/ 	aDelayToScrollTimer.Stop ();
/*N*/ 		bScrollable  =
/*N*/ 		bDelayActive = FALSE;

/*N*/ 	if (pDialog)
/*?*/ 	{
/*?*/ 		pDialog->Hide();
/*?*/ 	}

/*N*/ 	if (pWindow) pWindow->ReleaseMouse ();
/*N*/ }

/*************************************************************************
|*
|* Scrollen bei Erreichen des Fensterrandes; wird von
|* MouseMove aufgerufen
|*
\************************************************************************/

/*		Size aSize = pWindow->GetSizePixel();
		short dx = 0, dy = 0;

		if ( aPixPos.X() <= 0			   ) dx = -1;
		if ( aPixPos.X() >= aSize.Width()  ) dx =  1;
		if ( aPixPos.Y() <= 0			   ) dy = -1;
		if ( aPixPos.Y() >= aSize.Height() ) dy =  1;
*/

/*************************************************************************
|*
|* Timer-Handler fuer Fensterscrolling
|*
\************************************************************************/

IMPL_LINK_INLINE_START( FuPoor, ScrollHdl, Timer *, pTimer )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001  	Point aPnt(pWindow->GetPointerPosPixel());
	return 0;
}
IMPL_LINK_INLINE_END( FuPoor, ScrollHdl, Timer *, pTimer )

/*************************************************************************
|*
|* String in Applikations-Statuszeile ausgeben
|*
\************************************************************************/

/*
//	SFX_APP()->SetHelpText(aStr);
	SfxStatusBarManager* pStatBarMan = SFX_APP()->GetStatusBarManager();
	pStatBarMan->ShowHelpText(aStr);
*/

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/


// #97016# II
/*N*/ void FuPoor::SelectionHasChanged()
/*N*/ {
/*N*/ 	const SdrHdlList& rHdlList = pView->GetHdlList();
/*N*/ 	((SdrHdlList&)rHdlList).ResetFocusHdl();
/*N*/ }

/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/


/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/


/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/


/*************************************************************************
|*
|* Timer-Handler fuer Drag&Drop
|*
\************************************************************************/

IMPL_LINK( FuPoor, DragHdl, Timer *, pTimer )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001  	USHORT nHitLog = USHORT ( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
	return 0;
}

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/


/*************************************************************************
|*
|* Timer-Handler fuer Fensterscrolling
|*
\************************************************************************/

IMPL_LINK_INLINE_START( FuPoor, DelayHdl, Timer *, pTimer )
{
{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	aDelayToScrollTimer.Stop ();
	return 0;
}
IMPL_LINK_INLINE_END( FuPoor, DelayHdl, Timer *, pTimer )

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/



/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/


/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/


/*************************************************************************
|*
|* Help-event
|*
\************************************************************************/


/*************************************************************************
|*
|* Request verarbeiten
|*
\************************************************************************/

/*N*/ void FuPoor::ReceiveRequest(SfxRequest& rReq)
/*N*/ {
/*N*/ 	const SfxItemSet* pSet = rReq.GetArgs();
/*N*/ 
/*N*/ 	if (pSet)
/*N*/ 	{
/*?*/ 		if( pSet->GetItemState( nSlotId ) == SFX_ITEM_SET )
/*?*/ 		{
/*?*/ 			const SfxPoolItem& rItem = pSet->Get( nSlotId );
/*?*/ 
/*?*/ 			if( rItem.ISA( SfxAllEnumItem ) )
/*?*/ 			{
/*?*/ 				nSlotValue = ( ( const SfxAllEnumItem& ) rItem ).GetValue();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* #97016#
|*
\************************************************************************/







/** is called when the currenct function should be aborted. <p>
	This is used when a function gets a KEY_ESCAPE but can also
	be called directly.

	@returns true if a active function was aborted
*/

}
