/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_viewfunc.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:19:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <stdlib.h>				// qsort

#include "tabvwsh.hxx"
#include "docsh.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "stlsheet.hxx"
#include "dociter.hxx"
namespace binfilter {

//==================================================================

/*N*/ ScViewFunc::ScViewFunc( Window* pParent, ScDocShell& rDocSh, ScTabViewShell* pViewShell ) :
/*N*/ 	ScTabView( pParent, rDocSh, pViewShell ),
/*N*/ 	bFormatValid( FALSE )
/*N*/ {
/*N*/ }

/*N*/ ScViewFunc::ScViewFunc( Window* pParent, const ScViewFunc& rViewFunc, ScTabViewShell* pViewShell ) :
/*N*/ 	ScTabView( pParent, rViewFunc, pViewShell ),
/*N*/ 	bFormatValid( FALSE )
/*N*/ {
/*N*/ }

/*N*/ ScViewFunc::~ScViewFunc()
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------

//		Hilfsroutinen


/*N*/ BOOL ScViewFunc::SelectionEditable( BOOL* pOnlyNotBecauseOfMatrix /* = NULL */ )
/*N*/ {
/*N*/ 	BOOL bRet;
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 	ScMarkData& rMark = GetViewData()->GetMarkData();
/*N*/ 	if (rMark.IsMarked() || rMark.IsMultiMarked())
/*?*/ 		bRet = pDoc->IsSelectionEditable( rMark, pOnlyNotBecauseOfMatrix );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		USHORT nCol = GetViewData()->GetCurX();
/*N*/ 		USHORT nRow = GetViewData()->GetCurY();
/*N*/ 		USHORT nTab = GetViewData()->GetTabNo();
/*N*/ 		bRet = pDoc->IsBlockEditable( nTab, nCol, nRow, nCol, nRow,
/*N*/ 			pOnlyNotBecauseOfMatrix );
/*N*/ 	}
/*N*/ 	return bRet;
/*N*/ }

#ifndef	LRU_MAX
#define LRU_MAX 10
#endif



//		eigentliche Funktionen

//	Eingabe - Undo OK


//	Wert in einzele Zelle eintragen (nur auf nTab)
//!	umbenennen in EnterValue !!!!

/*!				Zeilenhoehe anpassen? Dann auch bei Undo...
			if (bNeedHeight)
				AdjustRowHeight(nRow,nRow);
*/




/*N*/ BYTE ScViewFunc::GetSelectionScriptType()
/*N*/ {
/*N*/ 	BYTE nScript = 0;
/*N*/ 
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 	const ScMarkData& rMark = GetViewData()->GetMarkData();
/*N*/ 	if ( !rMark.IsMarked() && !rMark.IsMultiMarked() )
/*N*/ 	{
/*N*/ 		// no selection -> cursor
/*N*/ 
/*N*/ 		nScript = pDoc->GetScriptType( GetViewData()->GetCurX(),
/*N*/ 							GetViewData()->GetCurY(), GetViewData()->GetTabNo() );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		ScRangeList aRanges;
/*?*/ 		rMark.FillRangeListWithMarks( &aRanges, FALSE );
/*?*/ 		ULONG nCount = aRanges.Count();
/*?*/ 		for (ULONG i=0; i<nCount; i++)
/*?*/ 		{
/*?*/ 			ScRange aRange = *aRanges.GetObject(i);
/*?*/ 			ScCellIterator aIter( pDoc, aRange );
/*?*/ 			ScBaseCell* pCell = aIter.GetFirst();
/*?*/ 			while ( pCell )
/*?*/ 			{
/*?*/ 				nScript |= pDoc->GetScriptType( aIter.GetCol(), aIter.GetRow(), aIter.GetTab(), pCell );
/*?*/ 				pCell = aIter.GetNext();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if (nScript == 0)
/*N*/ 		nScript = ScGlobal::GetDefaultScriptType();
/*N*/ 
/*N*/ 	return nScript;
/*N*/ }

/*N*/ const ScPatternAttr* ScViewFunc::GetSelectionPattern()
/*N*/ {
/*N*/ 	const ScMarkData& rMark = GetViewData()->GetMarkData();
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
/*N*/ 	{
/*?*/ 		//	MarkToMulti ist fuer pDoc->GetSelectionPattern nicht mehr noetig
/*?*/ 		const ScPatternAttr* pAttr = pDoc->GetSelectionPattern( rMark );
/*?*/ 		return pAttr;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		USHORT  nCol = GetViewData()->GetCurX();
/*N*/ 		USHORT  nRow = GetViewData()->GetCurY();
/*N*/ 		USHORT  nTab = GetViewData()->GetTabNo();
/*N*/ 
/*N*/ 		ScMarkData aTempMark( rMark );		// Tabellen kopieren
/*N*/ 		aTempMark.SetMarkArea( ScRange( nCol, nRow, nTab ) );
/*N*/ 		const ScPatternAttr* pAttr = pDoc->GetSelectionPattern( aTempMark );
/*N*/ 		return pAttr;
/*N*/ 	}
/*N*/ }


//
//	Attribute anwenden - Undo OK
//
//	kompletter Set ( ATTR_STARTINDEX, ATTR_ENDINDEX )
//




//	Pattern und Rahmen


//	nur Pattern



/*N*/ const SfxStyleSheet* ScViewFunc::GetStyleSheetFromMarked()
/*N*/ {
/*N*/ 	const ScStyleSheet*	pSheet		= NULL;
/*N*/ 	ScViewData*			pViewData	= GetViewData();
/*N*/ 	ScDocument*			pDoc		= pViewData->GetDocument();
/*N*/ 	ScMarkData&			rMark		= pViewData->GetMarkData();
/*N*/ 
/*N*/ 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
/*?*/ 		pSheet = pDoc->GetSelectionStyle( rMark );					// MarkToMulti nicht noetig !!
/*N*/ 	else
/*N*/ 		pSheet = pDoc->GetStyle( pViewData->GetCurX(),
/*N*/ 								 pViewData->GetCurY(),
/*N*/ 								 pViewData->GetTabNo() );
/*N*/ 
/*N*/ 	return pSheet;
/*N*/ }





//	Zellen einfuegen - Undo OK


//	Zellen loeschen - Undo OK



//	Inhalte loeschen


//	Spaltenbreiten/Zeilenhoehen (ueber Header) - Undo OK


//	Spaltenbreiten/Zeilenhoehen (ueber Blockmarken)

















}
