/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridwin4.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:11:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <svtools/colorcfg.hxx>
#include <bf_sfx2/printer.hxx>

#ifdef MAC
#endif

#include "gridwin.hxx"
#include "output.hxx"
#include "attrib.hxx"
#include "patattr.hxx"			// InvertSimple
#include "docoptio.hxx"
#include "dbfunc.hxx"			// oder GetPageBreakData an die ViewData
#include "scmod.hxx"
#include "inputhdl.hxx"
#include "rfindlst.hxx"
#include "globstr.hrc"
#include "docsh.hxx"			// oder GetSfxInPlaceObject
#include "inputopt.hxx"
namespace binfilter {

//#include "tabvwsh.hxx"			//! Test !!!!

//------------------------------------------------------------------------



//------------------------------------------------------------------------


//------------------------------------------------------------------------


//
// 	Draw  ----------------------------------------------------------------
//

/*N*/ void ScGridWindow::Draw( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2, ScUpdateMode eMode )
/*N*/ {
/*N*/ 	ScModule* pScMod = SC_MOD();
/*N*/ 	BOOL bTextWysiwyg = pScMod->GetInputOptions().GetTextWysiwyg();
/*N*/ 	BOOL bGridFirst = TRUE;		//! entscheiden!!!
/*N*/ 
/*N*/ 	if (pViewData->IsMinimized())
/*N*/ 		return;
/*N*/ 
/*N*/ 	PutInOrder( nX1, nX2 );
/*N*/ 	PutInOrder( nY1, nY2 );
/*N*/ 	USHORT i;
/*N*/ 
/*N*/ 	DBG_ASSERT( nX2<=MAXCOL && nY2<=MAXROW, "GridWin Draw Bereich zu gross" );
/*N*/ 
/*N*/ 	USHORT nPosX = pViewData->GetPosX( eHWhich );
/*N*/ 	USHORT nPosY = pViewData->GetPosY( eVWhich );
/*N*/ 	if (nX2 < nPosX || nY2 < nPosY)
/*N*/ 		return;											// unsichtbar
/*N*/ 	if (nX1 < nPosX) nX1 = nPosX;
/*N*/ 	if (nY1 < nPosY) nY1 = nPosY;
/*N*/ 
/*N*/ 	USHORT nXRight = nPosX + pViewData->VisibleCellsX(eHWhich);
/*N*/ 	if (nXRight > MAXCOL) nXRight = MAXCOL;
/*N*/ 	USHORT nYBottom = nPosY + pViewData->VisibleCellsY(eVWhich);
/*N*/ 	if (nYBottom > MAXROW) nYBottom = MAXROW;
/*N*/ 
/*N*/ 	if (nX1 > nXRight || nY1 > nYBottom)
/*N*/ 		return;											// unsichtbar
/*N*/ 	if (nX2 > nXRight) nX2 = nXRight;
/*N*/ 	if (nY2 > nYBottom) nY2 = nYBottom;
/*N*/ 
/*N*/ 	if ( eMode != SC_UPDATE_MARKS )
/*N*/ 		if (nX2 < nXRight)
/*N*/ 			nX2 = nXRight;								// zum Weiterzeichnen
/*N*/ 
/*N*/ 		//	ab hier kein return mehr
/*N*/ 
/*N*/ 	++nPaintCount;					// merken, dass gemalt wird (wichtig beim Invertieren)
/*N*/ 
/*N*/ 	ScDocShell* pDocSh = pViewData->GetDocShell();
/*N*/ 	ScDocument* pDoc = pDocSh->GetDocument();
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 
/*N*/ 	pDoc->ExtendHidden( nX1, nY1, nX2, nY2, nTab );
/*N*/ 
/*N*/ 	Point aScrPos = pViewData->GetScrPos( nX1, nY1, eWhich );
/*N*/ 	USHORT nScrX = (USHORT) aScrPos.X();
/*N*/ 	USHORT nScrY = (USHORT) aScrPos.Y();
/*N*/ 
/*N*/ 	USHORT nCurX = pViewData->GetCurX();
/*N*/ 	USHORT nCurY = pViewData->GetCurY();
/*N*/ 	USHORT nCurEndX = nCurX;
/*N*/ 	USHORT nCurEndY = nCurY;
/*N*/ 	pDoc->ExtendMerge( nCurX, nCurY, nCurEndX, nCurEndY, nTab );
/*N*/ 	BOOL bCurVis = nCursorHideCount==0 &&
/*N*/ 					( nCurEndX+1 >= nX1 && nCurX <= nX2+1 && nCurEndY+1 >= nY1 && nCurY <= nY2+1 );
/*N*/ 
/*N*/ 	//	AutoFill-Anfasser
/*N*/ 	if ( !bCurVis && nCursorHideCount==0 && bAutoMarkVisible && aAutoMarkPos.Tab() == nTab &&
/*N*/ 			( aAutoMarkPos.Col() != nCurX || aAutoMarkPos.Row() != nCurY ) )
/*N*/ 	{
/*?*/ 		USHORT nHdlX = aAutoMarkPos.Col();
/*?*/ 		USHORT nHdlY = aAutoMarkPos.Row();
/*?*/ 		pDoc->ExtendMerge( nHdlX, nHdlY, nHdlX, nHdlY, nTab );
/*?*/ 		bCurVis = ( nHdlX+1 >= nX1 && nHdlX <= nX2 && nHdlY+1 >= nY1 && nHdlY <= nY2 );
/*?*/ 		//	links und oben ist nicht betroffen
/*?*/ 
/*?*/ 		//!	AutoFill-Anfasser alleine (ohne Cursor) zeichnen ???
/*N*/ 	}
/*N*/ 
/*N*/ 	double nPPTX = pViewData->GetPPTX();
/*N*/ 	double nPPTY = pViewData->GetPPTY();
/*N*/ 
/*N*/ 	const ScViewOptions& rOpts = pViewData->GetOptions();
/*N*/ 	BOOL bFormulaMode = rOpts.GetOption( VOPT_FORMULAS );
/*N*/ 	BOOL bMarkClipped = rOpts.GetOption( VOPT_CLIPMARKS );
/*N*/ 
/*N*/ 		// Datenblock
/*N*/ 
/*N*/ 	RowInfo* pRowInfo = new RowInfo[ROWINFO_MAX];
/*N*/ 	USHORT nArrCount = pDoc->FillInfo( pRowInfo, nX1, nY1, nX2, nY2, nTab,
/*N*/ 										nPPTX, nPPTY, FALSE, bFormulaMode,
/*N*/ 										&pViewData->GetMarkData() );
/*N*/ 
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 
/*N*/ 	Fraction aZoomX = pViewData->GetZoomX();
/*N*/ 	Fraction aZoomY = pViewData->GetZoomY();
/*N*/ 	ScOutputData aOutputData( this, OUTTYPE_WINDOW, pRowInfo, nArrCount, pDoc, nTab,
/*N*/ 								nScrX, nScrY, nX1, nY1, nX2, nY2, nPPTX, nPPTY,
/*N*/ 								&aZoomX, &aZoomY );
/*N*/ 
/*N*/ 	if ( bTextWysiwyg )
/*N*/ 	{
/*N*/ 		//	use printer for text formatting
/*N*/ 
/*N*/ 		OutputDevice* pFmtDev = pDoc->GetPrinter();
/*N*/ 		pFmtDev->SetMapMode( pViewData->GetLogicMode(eWhich) );
/*N*/ 		aOutputData.SetFmtDevice( pFmtDev );
/*N*/ 	}
/*N*/ 
/*N*/     const svtools::ColorConfig& rColorCfg = pScMod->GetColorConfig();
/*N*/     Color aGridColor( rColorCfg.GetColorValue( svtools::CALCGRID, FALSE ).nColor );
/*N*/ 	if ( aGridColor.GetColor() == COL_TRANSPARENT )
/*N*/ 	{
/*N*/ 		//	use view options' grid color only if color config has "automatic" color
/*N*/ 		aGridColor = rOpts.GetGridColor();
/*N*/ 	}
/*N*/ 
/*N*/ 	aOutputData.SetSyntaxMode		( pViewData->IsSyntaxMode() );
/*N*/ 	aOutputData.SetGridColor		( aGridColor );
/*N*/ 	aOutputData.SetShowNullValues	( rOpts.GetOption( VOPT_NULLVALS ) );
/*N*/ 	aOutputData.SetShowFormulas		( bFormulaMode );
/*N*/ 	aOutputData.SetShowSpellErrors	( !rOpts.IsHideAutoSpell() &&
/*N*/ 										pDoc->GetDocOptions().IsAutoSpell() );
/*N*/ 	aOutputData.SetMarkClipped		( bMarkClipped );
/*N*/ 
/*N*/ 	aOutputData.SetUseStyleColor( TRUE );		// always set in table view
/*N*/ 
/*N*/ 	aOutputData.SetEditObject( GetEditObject() );
/*N*/ 	aOutputData.SetViewShell( pViewData->GetViewShell() );
/*N*/ 
/*N*/ 	BOOL bGrid = rOpts.GetOption( VOPT_GRID );
/*N*/ 	BOOL bPage = rOpts.GetOption( VOPT_PAGEBREAKS );
/*N*/ 
/*N*/ 	if ( eMode == SC_UPDATE_CHANGED )
/*N*/ 	{
/*N*/ 		aOutputData.FindChanged();
/*N*/ 		aOutputData.SetSingleGrid(TRUE);
/*N*/ 	}
/*N*/ 
/*N*/ 	BOOL bPageMode = pViewData->IsPagebreakMode();
/*N*/ 	if (bPageMode)										// nach FindChanged
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/ 	EditView*	pEditView = NULL;
/*N*/ 	BOOL		bEditMode = pViewData->HasEditView(eWhich);
/*N*/ 	if ( bEditMode && pViewData->GetRefTabNo() == nTab )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/ 	MapMode aDrawMode = GetDrawMapMode();
/*N*/ 	Rectangle aDrawingRect = PixelToLogic( Rectangle( Point( nScrX, nScrY ),
/*N*/ 										Size( aOutputData.GetScrW(), aOutputData.GetScrH() ) ),
/*N*/ 										aDrawMode );
/*N*/ 
/*N*/ 	if (bCurVis)
/*N*/ 		HideCursor();
/*N*/ 
/*N*/ 	if ( pDoc->HasBackgroundDraw( nTab, aDrawingRect ) )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 	else
/*N*/ 		aOutputData.SetSolidBackground(TRUE);
/*N*/ 
/*N*/ 	SetMapMode(MAP_PIXEL);
/*N*/ 	aOutputData.DrawBackground();
/*N*/ 	if ( bGridFirst && ( bGrid || bPage ) )
/*N*/ 		aOutputData.DrawGrid( bGrid, bPage );
/*N*/ 	if ( bPageMode )
/*N*/ 	{
/*?*/ 		// #87655# DrawPagePreview draws complete lines/page numbers, must always be clipped
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( aOutputData.SetChangedClip() )
/*N*/ 	}
/*N*/ 	aOutputData.DrawShadow();
/*N*/ 	aOutputData.DrawFrame();
/*N*/ 	if ( !bTextWysiwyg )
/*?*/ 		aOutputData.DrawStrings(FALSE);		// in pixel MapMode
/*N*/ 
/*N*/ 		// Autofilter- und Pivot-Buttons
/*N*/ 
/*N*/ 	DrawButtons( nX1, nY1, nX2, nY2, pRowInfo, nArrCount );			// Pixel
/*N*/ 
/*N*/ 		// Notiz-Anzeiger
/*N*/ 
/*N*/ 	if ( rOpts.GetOption( VOPT_NOTES ) )
/*N*/ 		aOutputData.DrawNoteMarks();
/*N*/ 
/*N*/ 		// Edit-Zellen
/*N*/ 
/*N*/ 	SetMapMode(pViewData->GetLogicMode(eWhich));
/*N*/ 	if ( bTextWysiwyg )
/*N*/ 		aOutputData.DrawStrings(TRUE);		// in logic MapMode if bTextWysiwyg is set
/*N*/ 	aOutputData.DrawEdit(TRUE);
/*N*/ 
/*N*/ 	SetMapMode(MAP_PIXEL);
/*N*/ 	if ( !bGridFirst && ( bGrid || bPage ) )
/*N*/ 	{
/*?*/ //		SetMapMode(MAP_PIXEL);
/*?*/ 		aOutputData.DrawGrid( bGrid, bPage );
/*N*/ 	}
/*N*/ 	aOutputData.DrawClipMarks();
/*N*/ 
/*N*/ 	//	Szenario / ChangeTracking muss auf jeden Fall nach DrawGrid sein, auch bei !bGridFirst
/*N*/ 
/*N*/ 	//!	Test, ob ChangeTrack-Anzeige aktiv ist
/*N*/ 	//!	Szenario-Rahmen per View-Optionen abschaltbar?
/*N*/ 
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	ScHighlightRanges* pHigh = pViewData->GetView()->GetHighlightRanges();
/*N*/ 	BOOL bHasScenario = ( nTab+1<nTabCount && pDoc->IsScenario(nTab+1) && !pDoc->IsScenario(nTab) );
/*N*/ 	BOOL bHasChange = ( pDoc->GetChangeTrack() != NULL );
/*N*/ 
/*N*/ 	if ( bHasChange || bHasScenario || pHigh != NULL )
/*N*/ 	{
/*?*/ //		SetMapMode(MAP_PIXEL);
/*?*/ 
/*?*/ 		//! SetChangedClip() mit DrawMarks() zusammenfassen?? (anderer MapMode!)
/*?*/ 
/*?*/ 		BOOL bAny = TRUE;
/*?*/ 		if (eMode == SC_UPDATE_CHANGED)
				bAny = aOutputData.SetChangedClip();
/*?*/ 		if (bAny)
/*?*/ 		{
/*?*/ 			if ( bHasChange )
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				aOutputData.DrawChangeTrack();
/*?*/ 
/*?*/ 			if ( bHasScenario )
						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				lcl_DrawScenarioFrames( this, pViewData, eWhich, nX1,nY1,nX2,nY2 );
/*?*/ 
/*?*/ 			if ( pHigh )
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				lcl_DrawHighlight( aOutputData, pViewData, *pHigh );
/*?*/ 
/*?*/ 			if (eMode == SC_UPDATE_CHANGED)
/*?*/ 				SetClipRegion();
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 		// Drawing Vordergrund
/*N*/ 
/*N*/ 	SetMapMode(aDrawMode);
/*N*/ 	DrawRedraw( aOutputData, aDrawingRect, eMode, SC_LAYER_FRONT );
/*N*/ 	DrawRedraw( aOutputData, aDrawingRect, eMode, SC_LAYER_INTERN );
/*N*/ 	DrawRedraw( aOutputData, aDrawingRect, eMode, SC_LAYER_CONTROLS );	// als letztes
/*N*/ 	DrawSdrGrid( aDrawingRect );
/*N*/ 
/*N*/ 	if (!bIsInScroll)								// Drawing Markierungen
/*N*/ 	{
/*N*/ 		BOOL bDraw = TRUE;
/*N*/ 		if (eMode == SC_UPDATE_CHANGED)
/*N*/ 			bDraw = NeedDrawMarks() && aOutputData.SetChangedClip();
/*N*/ 		if (bDraw)
/*N*/ 		{ 
/*N*/ 			DrawMarks();
/*N*/ 			if (eMode == SC_UPDATE_CHANGED)
/*N*/ 				SetClipRegion();
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SetMapMode(MAP_PIXEL);
/*N*/ 							//	InPlace Edit-View
/*N*/ 							//! gleich beim Zeichnen leer lassen !!!
/*N*/ 	if ( bEditMode && (pViewData->GetRefTabNo() == pViewData->GetTabNo()) )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 USHORT nCol1 = pViewData->GetEditViewCol();
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pViewData->IsActive())
/*N*/ 		aOutputData.DrawMark( this );
/*N*/ 
/*N*/ 	if ( pViewData->IsRefMode() && nTab >= pViewData->GetRefStartZ() && nTab <= pViewData->GetRefEndZ() )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/ 		//	Range-Finder
/*N*/ 
/*N*/ 	ScInputHandler* pHdl = pScMod->GetInputHdl( pViewData->GetViewShell() );
/*N*/ 	if (pHdl)
/*N*/ 	{
/*N*/ 		ScRangeFindList* pRangeFinder = pHdl->GetRangeFindList();
/*N*/ 		if ( pRangeFinder && !pRangeFinder->IsHidden() &&
/*N*/ 				pRangeFinder->GetDocName() == pDocSh->GetTitle() )
/*N*/ 		{
/*?*/ 			USHORT nCount = (USHORT)pRangeFinder->Count();
/*?*/ 			for (USHORT i=0; i<nCount; i++)
/*?*/ 			{
/*?*/ 				ScRangeFindData* pData = pRangeFinder->GetObject(i);
/*?*/ 				if (pData)
/*?*/ 				{
/*?*/ 					ScRange aRef = pData->aRef;
/*?*/ 					aRef.Justify();
/*?*/ 					if ( aRef.aStart.Tab() >= nTab && aRef.aEnd.Tab() <= nTab )
							{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 						aOutputData.DrawRefMark( aRef.aStart.Col(), aRef.aStart.Row(),
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 		//	Rand (Pixel)
/*N*/ 
/*N*/ 	if ( nX2==MAXCOL || nY2==MAXROW )
/*N*/ 	{
/*?*/ 		Rectangle aPixRect = Rectangle( Point(), GetOutputSizePixel() );
/*?*/         SetFillColor( rColorCfg.GetColorValue(svtools::APPBACKGROUND).nColor );
/*?*/ 		SetLineColor();
/*?*/ 		if ( nX2==MAXCOL )
/*?*/ 		{
/*?*/ 			Rectangle aDrawRect( aPixRect );
/*?*/ 			aDrawRect.Left() = nScrX + aOutputData.GetScrW();
/*?*/ 			if (aDrawRect.Right() >= aDrawRect.Left())
/*?*/ 				DrawRect( aDrawRect );
/*?*/ 		}
/*?*/ 		if ( nY2==MAXROW )
/*?*/ 		{
/*?*/ 			Rectangle aDrawRect( aPixRect );
/*?*/ 			aDrawRect.Top() = nScrY + aOutputData.GetScrH();
/*?*/ 			if ( nX2==MAXCOL )
/*?*/ 				aDrawRect.Right() = nScrX + aOutputData.GetScrW() - 1;		// Ecke nicht doppelt
/*?*/ 			if (aDrawRect.Bottom() >= aDrawRect.Top())
/*?*/ 				DrawRect( aDrawRect );
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bCurVis)
/*N*/ 		ShowCursor();
/*N*/ 
/*N*/ 	for (i=0; i<nArrCount; i++)
/*N*/ 		delete[] pRowInfo[i].pCellInfo;
/*N*/ 	delete[] pRowInfo;
/*N*/ 
/*N*/ 	if (pViewData->HasEditView(eWhich))
/*?*/ 		SetMapMode(pViewData->GetLogicMode());
/*N*/ 	else
/*N*/ 		SetMapMode(aDrawMode);
/*N*/ 
/*N*/ 	if ( pNoteMarker )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		pNoteMarker->Draw();		// ueber den Cursor, im Drawing-MapMode
/*N*/ 
/*N*/ 	DrawStartTimer();				// fuer bunte Handles ohne System-Clipping
/*N*/ 
/*N*/ 	//
/*N*/ 	//	Wenn waehrend des Paint etwas invertiert wurde (Selektion geaendert aus Basic-Macro),
/*N*/ 	//	ist das jetzt durcheinandergekommen und es muss neu gemalt werden
/*N*/ 	//
/*N*/ 
/*N*/ 	DBG_ASSERT(nPaintCount, "nPaintCount falsch");
/*N*/ 	--nPaintCount;
/*N*/ 	if (!nPaintCount)
/*N*/ 		CheckNeedsRepaint();
/*N*/ }

/*N*/ void ScGridWindow::CheckNeedsRepaint()
/*N*/ {
/*N*/ 	//	called at the end of painting, and from timer after background text width calculation
/*N*/ 
/*N*/ 	if (bNeedsRepaint)
/*N*/ 	{
/*?*/ 		bNeedsRepaint = FALSE;
/*?*/ 		if (aRepaintPixel.IsEmpty())
/*?*/ 			Invalidate();
/*?*/ 		else
/*?*/ 			Invalidate(PixelToLogic(aRepaintPixel));
/*?*/ 		aRepaintPixel = Rectangle();
/*N*/ 	}
/*N*/ }



/*N*/ void ScGridWindow::DrawButtons( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2,
/*N*/ 									RowInfo* pRowInfo, USHORT nArrCount )
/*N*/ {
/*N*/ 	USHORT			nCol, nRow, nArrY, nQuery;
/*N*/ 	USHORT			nTab = pViewData->GetTabNo();
/*N*/ 	ScDocument*		pDoc = pViewData->GetDocument();
/*N*/ 	ScDBData*		pDBData = NULL;
/*N*/ 	ScQueryParam*	pQueryParam = NULL;
/*N*/ 
/*N*/ 	Point aOldPos  = aComboButton.GetPosPixel();	// Zustand fuer MouseDown/Up
/*N*/ 	Size  aOldSize = aComboButton.GetSizePixel();   // merken
/*N*/ 
/*N*/ 	for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		if ( pRowInfo[nArrY].bAutoFilter && pRowInfo[nArrY].bChanged )
/*N*/ 		{
/*?*/ 			RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*?*/ 
/*?*/ 			nRow = pThisRowInfo->nRowNo;
/*?*/ 
/*?*/ 
/*?*/ 			for (nCol=nX1; nCol<=nX2; nCol++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nCol+1];
/*?*/ 				if ( pInfo->bAutoFilter && !pInfo->bHOverlapped && !pInfo->bVOverlapped )
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pRowInfo[nArrY].bPushButton && pRowInfo[nArrY].bChanged )
/*N*/ 		{
/*?*/ 			RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*?*/ 			nRow = pThisRowInfo->nRowNo;
/*?*/ 			for (nCol=nX1; nCol<=nX2; nCol++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nCol+1];
/*?*/ 				if ( pInfo->bPushButton && !pInfo->bHOverlapped && !pInfo->bVOverlapped )
/*?*/ 				{
/*?*/ 					Point aScrPos = pViewData->GetScrPos( nCol, nRow, eWhich );
/*?*/ 					long nSizeX;
/*?*/ 					long nSizeY;
/*?*/ 					pViewData->GetMergeSizePixel( nCol, nRow, nSizeX, nSizeY );
/*?*/ 					long nPosX = aScrPos.X();
/*?*/ 					long nPosY = aScrPos.Y();
/*?*/ 
/*?*/                     SetLineColor( GetSettings().GetStyleSettings().GetLightColor() );
/*?*/ 					DrawLine( Point(nPosX,nPosY), Point(nPosX,nPosY+nSizeY-1) );
/*?*/ 					DrawLine( Point(nPosX,nPosY), Point(nPosX+nSizeX-1,nPosY) );
/*?*/                     SetLineColor( GetSettings().GetStyleSettings().GetDarkShadowColor() );
/*?*/ 					DrawLine( Point(nPosX,nPosY+nSizeY-1), Point(nPosX+nSizeX-1,nPosY+nSizeY-1) );
/*?*/ 					DrawLine( Point(nPosX+nSizeX-1,nPosY), Point(nPosX+nSizeX-1,nPosY+nSizeY-1) );
/*?*/ 					SetLineColor( COL_BLACK );
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pQueryParam;
/*N*/ }




// -------------------------------------------------------------------------


// -------------------------------------------------------------------------

/*N*/ void ScGridWindow::DrawCursor()
/*N*/ {
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 	USHORT nX = pViewData->GetCurX();
/*N*/ 	USHORT nY = pViewData->GetCurY();
/*N*/ 
/*N*/ 	//	in verdeckten Zellen nicht zeichnen
/*N*/ 
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	const ScPatternAttr* pPattern = pDoc->GetPattern(nX,nY,nTab);
/*N*/ 	const ScMergeFlagAttr& rMerge = (const ScMergeFlagAttr&) pPattern->GetItem(ATTR_MERGE_FLAG);
/*N*/ 	if (rMerge.IsOverlapped())
/*N*/ 		return;
/*N*/ 
/*N*/ 	//	links/oben ausserhalb des Bildschirms ?
/*N*/ 
/*N*/ 	BOOL bVis = ( nX>=pViewData->GetPosX(eHWhich) && nY>=pViewData->GetPosY(eVWhich) );
/*N*/ 	if (!bVis)
/*N*/ 	{
/*?*/ 		USHORT nEndX = nX;
/*?*/ 		USHORT nEndY = nY;
/*?*/ 		ScDocument* pDoc = pViewData->GetDocument();
/*?*/ 		const ScMergeAttr& rMerge = (const ScMergeAttr&) pPattern->GetItem(ATTR_MERGE);
/*?*/ 		if (rMerge.GetColMerge() > 1)
/*?*/ 			nEndX += rMerge.GetColMerge()-1;
/*?*/ 		if (rMerge.GetRowMerge() > 1)
/*?*/ 			nEndX += rMerge.GetRowMerge()-1;
/*?*/ 		bVis = ( nEndX>=pViewData->GetPosX(eHWhich) && nEndY>=pViewData->GetPosY(eVWhich) );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bVis )
/*N*/ 	{
/*N*/ 		//	hier kein Update, da aus Paint gerufen und laut Zaehler Cursor schon da
/*N*/ 		//	wenn Update noetig, dann bei Hide/Showcursor vor dem Hoch-/Runterzaehlen
/*N*/ 
/*N*/ 		MapMode aOld = GetMapMode(); SetMapMode(MAP_PIXEL);
/*N*/ 
/*N*/ 		Point aScrPos = pViewData->GetScrPos( nX, nY, eWhich, TRUE );
/*N*/ 
/*N*/ 		//	rechts/unten ausserhalb des Bildschirms ?
/*N*/ 
/*N*/ 		Size aOutSize = GetOutputSizePixel();
/*N*/ 		if ( aScrPos.X() <= aOutSize.Width() + 2 && aScrPos.Y() <= aOutSize.Height() + 2 )
/*N*/ 		{
/*N*/ 			long nSizeXPix;
/*N*/ 			long nSizeYPix;
/*N*/ 			pViewData->GetMergeSizePixel( nX, nY, nSizeXPix, nSizeYPix );
/*N*/ 
/*N*/ 			BOOL bFix = ( pViewData->GetHSplitMode() == SC_SPLIT_FIX ||
/*N*/ 							pViewData->GetVSplitMode() == SC_SPLIT_FIX );
/*N*/ 			if ( pViewData->GetActivePart()==eWhich || bFix )
/*N*/ 			{
/*N*/ 				//	old UNX version with two Invert calls causes flicker.
/*N*/ 				//	if optimization is needed, a new flag should be added
/*N*/ 				//	to InvertTracking
/*N*/ 
/*N*/ 				aScrPos.X() -= 2;
/*N*/ 				aScrPos.Y() -= 2;
/*N*/ 				Rectangle aRect( aScrPos, Size( nSizeXPix + 3, nSizeYPix + 3 ) );
/*N*/ 
/*N*/ 				Invert(Rectangle( aRect.Left(), aRect.Top(), aRect.Left()+2, aRect.Bottom() ));
/*N*/ 				Invert(Rectangle( aRect.Right()-2, aRect.Top(), aRect.Right(), aRect.Bottom() ));
/*N*/ 				Invert(Rectangle( aRect.Left()+3, aRect.Top(), aRect.Right()-3, aRect.Top()+2 ));
/*N*/ 				Invert(Rectangle( aRect.Left()+3, aRect.Bottom()-2, aRect.Right()-3, aRect.Bottom() ));
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*?*/ 				Rectangle aRect( aScrPos, Size( nSizeXPix - 1, nSizeYPix - 1 ) );
/*?*/ 				Invert( aRect );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SetMapMode(aOld);
/*N*/ 	}
/*N*/ }

	//	AutoFill-Anfasser:

/*N*/ void ScGridWindow::DrawAutoFillMark()
/*N*/ {
/*N*/ 	if ( bAutoMarkVisible && aAutoMarkPos.Tab() == pViewData->GetTabNo() )
/*N*/ 	{
/*N*/ 		USHORT nX = aAutoMarkPos.Col();
/*N*/ 		USHORT nY = aAutoMarkPos.Row();
/*N*/ 
/*N*/ 		Point aFillPos = pViewData->GetScrPos( nX, nY, eWhich, TRUE );
/*N*/ 		long nSizeXPix;
/*N*/ 		long nSizeYPix;
/*N*/ 		pViewData->GetMergeSizePixel( nX, nY, nSizeXPix, nSizeYPix );
/*N*/ 		aFillPos.X() += nSizeXPix;
/*N*/ 		aFillPos.Y() += nSizeYPix;
/*N*/ 
/*N*/ 		aFillPos.X() -= 2;
/*N*/ 		aFillPos.Y() -= 2;
/*N*/ 		Rectangle aFillRect( aFillPos, Size(6,6) );
/*N*/ 		//	Anfasser von Zeichenobjekten sind 7*7
/*N*/ 
/*N*/ 		MapMode aOld = GetMapMode(); SetMapMode(MAP_PIXEL);
/*N*/ 		Invert( aFillRect );
/*N*/ 		SetMapMode(aOld);
/*N*/ 	}
/*N*/ }

// -------------------------------------------------------------------------





}
