/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_cellsh.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:07:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"

#include <svtools/cjkoptions.hxx>
#include <svtools/slstitm.hxx>
#include <svtools/stritem.hxx>
#include <svtools/whiter.hxx>
#include <svtools/moduleoptions.hxx>
#include <svtools/cliplistener.hxx>
#include <bf_offmgr/sbasltid.hrc>
#include <bf_sfx2/bindings.hxx>
//#include <bf_sfx2/objitem.hxx>
#include <bf_svx/clipfmtitem.hxx>
//#include <vcl/system.hxx>

#include "cellsh.hxx"
#include "bf_sc.hrc"
#include "docsh.hxx"
#include "attrib.hxx"
#include "scresid.hxx"
#include "tabvwsh.hxx"
#include "cell.hxx"
#include "globstr.hrc"
#include "transobj.hxx"
#include "drwtrans.hxx"

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

//------------------------------------------------------------------
namespace binfilter {//STRIP009
#define ScCellShell
#define	CellMovement
#include "scslots.hxx"
#define SearchSettings

/*N*/ TYPEINIT1( ScCellShell, ScFormatShell );

/*N*/ SFX_IMPL_INTERFACE(ScCellShell, ScFormatShell , ScResId(SCSTR_CELLSHELL) )
/*N*/ {
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT | SFX_VISIBILITY_STANDARD |
/*N*/ 								SFX_VISIBILITY_SERVER,
/*N*/ 								ScResId(RID_OBJECTBAR_FORMAT));
/*N*/ 	SFX_OBJECTMENU_REGISTRATION(SID_OBJECTMENU0, ScResId(RID_OBJECTMENU_CELLS));
/*N*/ 	SFX_POPUPMENU_REGISTRATION(ScResId(RID_POPUP_CELLS));
/*N*/ }


/*N*/ ScCellShell::ScCellShell(ScViewData* pData) :
/*N*/ 	ScFormatShell(pData),
/*N*/ 	pClipEvtLstnr(NULL),
/*N*/ 	bPastePossible(FALSE)
/*N*/ {
/*N*/ 	SetHelpId(HID_SCSHELL_CELLSH);
/*N*/ 	SetName(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Cell")));
/*N*/ }

/*N*/ ScCellShell::~ScCellShell()
/*N*/ {
/*N*/ 	if ( pClipEvtLstnr )
/*N*/ 	{
/*N*/ 		pClipEvtLstnr->AddRemoveListener( GetViewData()->GetActiveWin(), FALSE );
/*N*/ 
/*N*/ 		//  #103849# The listener may just now be waiting for the SolarMutex and call the link
/*N*/ 		//  afterwards, in spite of RemoveListener. So the link has to be reset, too.
/*N*/ 		pClipEvtLstnr->ClearCallbackLink();
/*N*/ 
/*N*/ 		pClipEvtLstnr->release();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

/*N*/ void ScCellShell::GetBlockState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
/*N*/ 	ScRange aMarkRange;
/*N*/ 	BOOL bSimpleArea = GetViewData()->GetSimpleArea( aMarkRange );
/*N*/ 	BOOL bOnlyNotBecauseOfMatrix;
/*N*/ 	BOOL bEditable = pTabViewShell->SelectionEditable( &bOnlyNotBecauseOfMatrix );
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 	ScMarkData& rMark = GetViewData()->GetMarkData();
/*N*/ 	USHORT nCol1, nCol2, nRow1, nRow2;
/*N*/ 	nCol1 = aMarkRange.aStart.Col();
/*N*/ 	nRow1 = aMarkRange.aStart.Row();
/*N*/ 	nCol2 = aMarkRange.aEnd.Col();
/*N*/ 	nRow2 = aMarkRange.aEnd.Row();
/*N*/ 
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		BOOL bDisable = FALSE;
/*N*/ 		BOOL bNeedEdit = TRUE;		// muss Selektion editierbar sein?
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*?*/ 			case FID_FILL_TO_BOTTOM:	// Fuellen oben/unten
/*?*/ 			case FID_FILL_TO_TOP:		// mind. 2 Zeilen markiert?
/*?*/ 				bDisable = (!bSimpleArea) || (nRow1 == nRow2);
/*?*/ 				if ( !bDisable && bEditable )
/*?*/ 				{	// Matrix nicht zerreissen
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( nWhich == FID_FILL_TO_BOTTOM )
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_FILL_TO_RIGHT:		// Fuellen links/rechts
/*?*/ 			case FID_FILL_TO_LEFT:		// mind. 2 Spalten markiert?
/*?*/ 				bDisable = (!bSimpleArea) || (nCol1 == nCol2);
/*?*/ 				if ( !bDisable && bEditable )
/*?*/ 				{	// Matrix nicht zerreissen
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( nWhich == FID_FILL_TO_RIGHT )
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_FILL_SERIES:		// Block fuellen
/*?*/ 			case SID_OPENDLG_TABOP:		// Mehrfachoperationen, mind. 2 Zellen markiert?
/*?*/ 				if (pDoc->GetChangeTrack()!=NULL &&nWhich ==SID_OPENDLG_TABOP)
/*?*/ 					bDisable = TRUE;
/*?*/ 				else
/*?*/ 					bDisable = (!bSimpleArea) || (nCol1 == nCol2 && nRow1 == nRow2);
/*?*/ 
/*?*/ 				if ( !bDisable && bEditable && nWhich == FID_FILL_SERIES )
/*?*/ 				{	// Matrix nicht zerreissen
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	bDisable = pDoc->HasSelectedBlockMatrixFragment(
/*?*/ 				}
/*?*/ 				break;
/*N*/ 
/*N*/ 			case SID_CUT:				// Ausschneiden,
/*N*/ 			case FID_INS_ROW:			// Zeilen einfuegen
/*N*/ 			case FID_INS_COLUMN:		// Spalten einfuegen
/*N*/ 			case FID_INS_CELL:			// Zellen einfuegen, nur einf. Selektion
/*N*/ 			case FID_INS_CELLSDOWN:
/*N*/ 			case FID_INS_CELLSRIGHT:
/*N*/ 				bDisable = (!bSimpleArea);
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_COPY:						// Kopieren
/*N*/ 				bDisable = (!bSimpleArea);
/*N*/ 				// nur wegen Matrix nicht editierbar? Matrix nicht zerreissen
/*N*/ 				//! schlaegt nicht zu, wenn geschuetzt UND Matrix, aber damit
/*N*/ 				//! muss man leben.. wird in Copy-Routine abgefangen, sonst
/*N*/ 				//! muesste hier nochmal Aufwand getrieben werden
/*N*/ 				if ( !(!bEditable && bOnlyNotBecauseOfMatrix) )
/*N*/ 					bNeedEdit = FALSE;			// erlaubt, wenn geschuetzt/ReadOnly
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_AUTOFORMAT:		// Autoformat, mind. 3x3 selektiert
/*N*/ 				bDisable =    (!bSimpleArea)
/*N*/ 						   || ((nCol2 - nCol1) < 2) || ((nRow2 - nRow1) < 2);
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_OPENDLG_CONDFRMT :
/*N*/ 			case FID_CONDITIONAL_FORMAT :
/*N*/ 			case SID_CELL_FORMAT_RESET :
/*N*/ 			case FID_CELL_FORMAT :
/*N*/ 			case SID_ENABLE_HYPHENATION :
/*N*/ 				// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
/*N*/ 				if ( !bEditable && bOnlyNotBecauseOfMatrix )
/*N*/ 					bNeedEdit = FALSE;
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_TRANSLITERATE_HALFWIDTH:
/*N*/ 			case SID_TRANSLITERATE_FULLWIDTH:
/*N*/ 			case SID_TRANSLITERATE_HIRAGANA:
/*N*/ 			case SID_TRANSLITERATE_KATAGANA:
/*N*/ 				{
/*N*/ 					// SvtCJKOptions is ref-counted - can be constructed every time
/*N*/ 		            SvtCJKOptions aCJKOptions;
/*N*/ 		            bDisable = !aCJKOptions.IsChangeCaseMapEnabled();
/*N*/ 				}
/*N*/ 				break;
/*N*/ 		}
/*N*/ 		if (!bDisable && bNeedEdit && !bEditable)
/*N*/ 			bDisable = TRUE;
/*N*/ 
/*N*/ 		if (bDisable)
/*N*/ 			rSet.DisableItem(nWhich);
/*N*/ 		else if (nWhich == SID_ENABLE_HYPHENATION)
/*N*/ 		{
/*?*/ 			// toggle slots need a bool item
/*?*/ 			rSet.Put( SfxBoolItem( nWhich, FALSE ) );
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//	Funktionen, die je nach Cursorposition disabled sind
//	Default:
//		SID_INSERT_POSTIT, SID_CHARMAP, SID_OPENDLG_FUNCTION

/*N*/ void ScCellShell::GetCellState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocShell()->GetDocument();
/*N*/ 	ScAddress aCursor( GetViewData()->GetCurX(), GetViewData()->GetCurY(),
/*N*/ 						GetViewData()->GetTabNo() );
/*N*/ 
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		BOOL bDisable = FALSE;
/*N*/ 		BOOL bNeedEdit = TRUE;		// muss Cursorposition editierbar sein?
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*N*/ 			case SID_THESAURUS:
/*N*/ 				{
/*N*/ 					CellType eType = pDoc->GetCellType( aCursor );
/*N*/ 					bDisable = ( eType != CELLTYPE_STRING && eType != CELLTYPE_EDIT);
/*N*/ 					if (!bDisable)
/*N*/ 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 					}
/*N*/ 				}
/*N*/ 				break;
/*?*/ 			case SID_OPENDLG_FUNCTION:
/*?*/ 				{
/*?*/ 					ScMarkData aMarkData=GetViewData()->GetMarkData();
/*M*/ 					aMarkData.MarkToSimple();
/*?*/ 					ScRange aRange;
/*?*/ 					aMarkData.GetMarkArea(aRange);
/*?*/ 					if(aMarkData.IsMarked())
/*?*/ 					{
/*?*/ 						if (!pDoc->IsBlockEditable( aCursor.Tab(), aRange.aStart.Col(),aRange.aStart.Row(),
/*?*/ 											aRange.aEnd.Col(),aRange.aEnd.Row() ))
/*?*/ 						{
/*?*/ 							bDisable = TRUE;
/*?*/ 						}
/*?*/ 						bNeedEdit=FALSE;
/*?*/ 					}
/*?*/ 
/*?*/ 				}
/*?*/ 				break;
/*N*/ 		}
/*N*/ 		if (!bDisable && bNeedEdit)
/*?*/ 			if (!pDoc->IsBlockEditable( aCursor.Tab(), aCursor.Col(),aCursor.Row(),
/*?*/ 										aCursor.Col(),aCursor.Row() ))
/*?*/ 				bDisable = TRUE;
/*N*/ 		if (bDisable)
/*N*/ 			rSet.DisableItem(nWhich);
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

/*N*/ void lcl_TestFormat( SvxClipboardFmtItem& rFormats, const TransferableDataHelper& rDataHelper,
/*N*/ 						SotFormatStringId nFormatId )
/*N*/ {
/*N*/ 	if ( rDataHelper.HasFormat( nFormatId ) )
/*N*/ 	{
/*N*/ 		//	#90675# translated format name strings are no longer inserted here,
/*N*/ 		//	handled by "paste special" dialog / toolbox controller instead.
/*N*/ 		//	Only the object type name has to be set here:
/*N*/ 		String aStrVal;
/*N*/ 		if ( nFormatId == SOT_FORMATSTR_ID_EMBED_SOURCE )
/*N*/ 		{
/*?*/ 			TransferableObjectDescriptor aDesc;
/*?*/ 			if ( ((TransferableDataHelper&)rDataHelper).GetTransferableObjectDescriptor(
/*?*/ 										SOT_FORMATSTR_ID_OBJECTDESCRIPTOR, aDesc ) )
/*?*/ 				aStrVal = aDesc.maTypeName;
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( aStrVal.Len() )
/*?*/ 			rFormats.AddClipbrdFormat( nFormatId, aStrVal );
/*N*/ 		else
/*N*/ 			rFormats.AddClipbrdFormat( nFormatId );
/*N*/ 	}
/*N*/ }

/*N*/ void ScCellShell::GetPossibleClipboardFormats( SvxClipboardFmtItem& rFormats )
/*N*/ {
/*N*/ 	Window* pWin = GetViewData()->GetActiveWin();
/*N*/ 	BOOL bDraw = ( ScDrawTransferObj::GetOwnClipboard( pWin ) != NULL );
/*N*/ 
/*N*/ 	TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pWin ) );
/*N*/ 
/*N*/ 	lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_DRAWING );
/*N*/ 	lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_SVXB );
/*N*/ 	lcl_TestFormat( rFormats, aDataHelper, SOT_FORMAT_GDIMETAFILE );
/*N*/ 	lcl_TestFormat( rFormats, aDataHelper, SOT_FORMAT_BITMAP );
/*N*/ 	lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_EMBED_SOURCE );
/*N*/ 
/*N*/ 	if ( !bDraw )
/*N*/ 	{
/*N*/ 		lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_LINK );
/*N*/ 		lcl_TestFormat( rFormats, aDataHelper, SOT_FORMAT_STRING );
/*N*/ 		lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_DIF );
/*N*/ 		lcl_TestFormat( rFormats, aDataHelper, SOT_FORMAT_RTF );
/*N*/ 		lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_HTML );
/*N*/ 		lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_HTML_SIMPLE );
/*N*/         lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_BIFF_8 );
/*N*/ 		lcl_TestFormat( rFormats, aDataHelper, SOT_FORMATSTR_ID_BIFF_5 );
/*N*/ 	}
/*N*/ }

//	Einfuegen, Inhalte einfuegen

/*N*/ BOOL lcl_IsCellPastePossible( const TransferableDataHelper& rData )
/*N*/ {
/*N*/ 	BOOL bPossible = FALSE;
/*N*/ 	if ( ScTransferObj::GetOwnClipboard( NULL ) || ScDrawTransferObj::GetOwnClipboard( NULL ) )
/*N*/ 		bPossible = TRUE;
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( rData.HasFormat( SOT_FORMAT_BITMAP ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMAT_GDIMETAFILE ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_SVXB ) ||
/*N*/ 			 rData.HasFormat( FORMAT_PRIVATE ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMAT_RTF ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_EMBED_SOURCE ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_LINK_SOURCE ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_EMBED_SOURCE_OLE ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_LINK_SOURCE_OLE ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMAT_STRING ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_SYLK ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_LINK ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_HTML ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_HTML_SIMPLE ) ||
/*N*/ 			 rData.HasFormat( SOT_FORMATSTR_ID_DIF ) )
/*N*/ 		{
/*N*/ 			bPossible = TRUE;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return bPossible;
/*N*/ }

/*N*/ IMPL_LINK( ScCellShell, ClipboardChanged, TransferableDataHelper*, pDataHelper )
/*N*/ {
/*N*/ 	if ( pDataHelper )
/*N*/ 	{
/*N*/ 		bPastePossible = lcl_IsCellPastePossible( *pDataHelper );
/*N*/ 
/*N*/ 		SfxBindings& rBindings = GetViewData()->GetBindings();
/*N*/ 		rBindings.Invalidate( SID_PASTE );
/*N*/ 		rBindings.Invalidate( FID_PASTE_CONTENTS );
/*N*/ 		rBindings.Invalidate( SID_CLIPBOARD_FORMAT_ITEMS );
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }


/*N*/ void __EXPORT ScCellShell::GetClipState( SfxItemSet& rSet )
/*N*/ {
/*N*/ // SID_PASTE
/*N*/ // FID_PASTE_CONTENTS
/*N*/ // SID_CLIPBOARD_FORMAT_ITEMS
/*N*/ 
/*N*/ 	if ( !pClipEvtLstnr )
/*N*/ 	{
/*N*/ 		// create listener
/*N*/ 		pClipEvtLstnr = new TransferableClipboardListener( LINK( this, ScCellShell, ClipboardChanged ) );
/*N*/ 		pClipEvtLstnr->acquire();
/*N*/ 		Window* pWin = GetViewData()->GetActiveWin();
/*N*/ 		pClipEvtLstnr->AddRemoveListener( pWin, TRUE );
/*N*/ 
/*N*/ 		// get initial state
/*N*/ 		TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pWin ) );
/*N*/ 		bPastePossible = lcl_IsCellPastePossible( aDataHelper );
/*N*/ 	}
/*N*/ 
/*N*/ 	BOOL bDisable = !bPastePossible;
/*N*/ 
/*N*/ 	//	Zellschutz / Multiselektion
/*N*/ 
/*M*/ 	if (!bDisable)
/*M*/ 	{
/*M*/ 		USHORT nCol = GetViewData()->GetCurX();
/*M*/ 		USHORT nRow = GetViewData()->GetCurY();
/*M*/ 		USHORT nTab = GetViewData()->GetTabNo();
/*M*/ 		ScDocument* pDoc = GetViewData()->GetDocShell()->GetDocument();
/*M*/ 		if (!pDoc->IsBlockEditable( nTab, nCol,nRow, nCol,nRow ))
/*M*/ 			bDisable = TRUE;
/*M*/ 		if (GetViewData()->IsMultiMarked())
/*M*/ 			bDisable = TRUE;
/*M*/ 	}
/*N*/ 
/*N*/ 	if (bDisable)
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_PASTE );
/*N*/ 		rSet.DisableItem( FID_PASTE_CONTENTS );
/*N*/ 		rSet.DisableItem( SID_CLIPBOARD_FORMAT_ITEMS );
/*N*/ 	}
/*N*/ 	else if ( rSet.GetItemState( SID_CLIPBOARD_FORMAT_ITEMS ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		SvxClipboardFmtItem aFormats( SID_CLIPBOARD_FORMAT_ITEMS );
/*N*/ 		GetPossibleClipboardFormats( aFormats );
/*N*/ 		rSet.Put( aFormats );
/*N*/ 	}
/*N*/ }

//	only SID_HYPERLINK_GETLINK:


/*N*/ void ScCellShell::GetState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	// removed: SID_BORDER_OBJECT (old Basic)
/*N*/ 
/*N*/ 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
/*N*/ 	BOOL bOle = pTabViewShell->GetViewFrame()->ISA(SfxInPlaceFrame);
/*N*/ 	BOOL bTabProt = GetViewData()->GetDocument()->IsTabProtected(GetViewData()->GetTabNo());
/*N*/ 	SfxApplication* pSfxApp = SFX_APP();
/*N*/ 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*N*/ 	ScViewData* pViewData	= GetViewData();
/*N*/ 	ScDocument* pDoc		= pViewData->GetDocument();
/*N*/ 	ScMarkData& rMark		= pViewData->GetMarkData();
/*N*/ 	USHORT		nPosX		= pViewData->GetCurX();
/*N*/ 	USHORT		nPosY		= pViewData->GetCurY();
/*N*/ 	USHORT		nTab		= pViewData->GetTabNo();
/*N*/ 	USHORT		nMyId		= 0;
/*N*/ 
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	USHORT nTabSelCount = rMark.GetSelectCount();
/*N*/ 
/*N*/ 
/*N*/ 
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*?*/ 			case SID_OPENDLG_CHART:
/*?*/ 				if ( bOle || bTabProt || !SvtModuleOptions().IsChart() )
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_DETECTIVE_REFRESH:
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (!pDoc->HasDetectiveOperations())
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_ADDRESS:
/*?*/ 				{
/*?*/ 					ScRange aRange;
/*?*/ 					if ( pViewData->GetSimpleArea( aRange ) )
/*?*/ 					{
/*?*/ 						String aStr;
/*?*/ 						USHORT nFlags = SCA_VALID | SCA_TAB_3D;
/*?*/ 						aRange.Format(aStr,nFlags,pDoc);
/*?*/ 						rSet.Put( SfxStringItem( nWhich, aStr ) );
/*?*/ 					}
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_NOTETEXT:
/*?*/ 				{
/*?*/ 					USHORT nNoteCol, nNoteRow, nNoteTab;
/*?*/ 
/*?*/ 					//	#43343# immer Cursorposition
/*?*/ #if 0
/*?*/ 					ScRange aRange;
/*?*/ 					if (GetViewData()->GetSimpleArea(aRange,TRUE))
/*?*/ 					{
/*?*/ 						nNoteCol = aRange.aStart.Col();
/*?*/ 						nNoteRow = aRange.aStart.Row();
/*?*/ 						nNoteTab = aRange.aStart.Tab();
/*?*/ 					}
/*?*/ 					else		// Cursor bei Mehrfachselektion
/*?*/ #endif
/*?*/ 					{
/*?*/ 						nNoteCol = nPosX;
/*?*/ 						nNoteRow = nPosY;
/*?*/ 						nNoteTab = nTab;
/*?*/ 					}
/*?*/ 
/*?*/ 					String aNoteText;
/*?*/ 					ScPostIt aNote;
/*?*/ 					if ( pDoc->GetNote( nNoteCol, nNoteRow, nNoteTab, aNote ) )
/*?*/ 						aNoteText = aNote.GetText();
/*?*/ 
/*?*/ 					rSet.Put( SfxStringItem( nWhich, aNoteText ) );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_ROW:
/*?*/ 				rSet.Put( SfxUInt16Item( nWhich, nPosY+1 ) );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_COL:
/*?*/ 				rSet.Put( SfxUInt16Item( nWhich, nPosX+1 ) );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_TABLE:
/*?*/ 				rSet.Put( SfxUInt16Item( nWhich, nTab+1 ) );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_VALUE:
/*?*/ 				{
/*?*/ 					double nValue;
/*?*/ 					pDoc->GetValue( nPosX, nPosY, nTab, nValue );
/*?*/ 					rSet.Put( ScDoubleItem( nWhich, nValue ) );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_FORMULA:
/*?*/ 				{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	String aString;
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_RANGE_TEXTVALUE:
/*?*/ 				{
/*?*/ 					String aString;
/*?*/ 					pDoc->GetString( nPosX, nPosY, nTab, aString );
/*?*/ 					rSet.Put( SfxStringItem( nWhich, aString ) );
/*?*/ 				}
/*?*/ 				break;
/*N*/ 
/*N*/ 			case SID_STATUS_SELMODE:
/*N*/ 				{
					/* 0: STD	Click hebt Sel auf
					 * 1: ER	Click erweitert Selektion
					 * 2: ERG	Click definiert weitere Selektion
					 */
/*N*/ 					USHORT nMode = pTabViewShell->GetLockedModifiers();
/*N*/ 
/*N*/ 					switch ( nMode )
/*N*/ 					{
/*N*/ 						case KEY_SHIFT: nMode = 1;	break;
/*N*/ 						case KEY_MOD1:	nMode = 2;	break; // Control-Taste
/*N*/ 						case 0:
/*N*/ 						default:
/*N*/ 							nMode = 0;
/*N*/ 					}
/*N*/ 
/*N*/ 					rSet.Put( SfxUInt16Item( nWhich, nMode ) );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STATUS_DOCPOS:
/*N*/ 				{
/*N*/ 					String	aStr( ScGlobal::GetRscString( STR_TABLE ) );
/*N*/ 
/*N*/ 					aStr += ' ';
/*N*/ 					aStr += String::CreateFromInt32( nTab + 1 );
/*N*/ 					aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM( " / " ));
/*N*/ 					aStr += String::CreateFromInt32( nTabCount );
/*N*/ 					rSet.Put( SfxStringItem( nWhich, aStr ) );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			//	Summe etc. mit Datum/Zeit/Fehler/Pos&Groesse zusammengefasst
/*N*/ 
/*N*/ 			case SID_TABLE_CELL:
/*N*/ 			case SID_ATTR_POSITION:
/*N*/ 			case SID_ATTR_SIZE:
/*N*/ 				{
/*N*/ 					//	Testen, ob Fehler unter Cursor
/*N*/ 					//	(nicht pDoc->GetErrCode, um keine zirkulaeren Referenzen auszuloesen)
/*N*/ 
/*N*/ 					// In interpreter may happen via rescheduled Basic
/*N*/ 					if ( pDoc->IsInInterpreter() )
/*?*/ 						rSet.Put( SfxStringItem( nWhich,
/*?*/ 							String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("...")) ) );
/*N*/ 					else
/*N*/ 					{
/*N*/ 						USHORT nErrCode = 0;
/*N*/ 						ScBaseCell* pCell;
/*N*/ 						pDoc->GetCell( nPosX, nPosY, nTab, pCell );
/*N*/ 						if ( pCell && pCell->GetCellType() == CELLTYPE_FORMULA )
/*N*/ 						{
/*?*/ 							ScFormulaCell* pFCell = (ScFormulaCell*) pCell;
/*?*/ 							if (!pFCell->IsRunning())
/*?*/ 								nErrCode = pFCell->GetErrCode();
/*N*/ 						}
/*N*/ 
/*N*/ 						if ( nErrCode > 0 )
/*?*/ 							{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 rSet.Put( SfxStringItem( nWhich,
/*N*/ 						else
/*N*/ 						{
/*N*/ 							String aFuncStr;
/*N*/ 							if ( pTabViewShell->GetFunction( aFuncStr ) )
/*N*/ 								rSet.Put( SfxStringItem( nWhich, aFuncStr ) );
/*N*/ 						}
/*N*/ 					}
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case SID_DATA_SELECT:
/*?*/ 				//	ab 506f wird die ganze Spalte angesehen
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( !pDoc->HasStringCells(ScRange(nPosX,0,nTab, nPosX,MAXROW,nTab)) )
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_STATUS_SUM:
/*?*/ 				{
/*?*/ 					String aFuncStr;
/*?*/ 					if ( pTabViewShell->GetFunction( aFuncStr ) )
/*?*/ 						rSet.Put( SfxStringItem( nWhich, aFuncStr ) );
/*?*/ 				}
/*?*/ 				break;
/*N*/ 
/*N*/ 			case FID_MERGE_ON:
/*N*/ 				if ( pDoc->GetChangeTrack() || !pTabViewShell->TestMergeCells() )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 
/*N*/ 			case FID_MERGE_OFF:
/*N*/ 				if ( pDoc->GetChangeTrack() || !pTabViewShell->TestRemoveMerge() )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_INS_ROWBRK:
/*?*/ 				if ( nPosY==0 || (pDoc->GetRowFlags(nPosY,nTab) & CR_MANUALBREAK) )
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_INS_COLBRK:
/*?*/ 				if ( nPosX==0 || (pDoc->GetColFlags(nPosX,nTab) & CR_MANUALBREAK) )
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_DEL_ROWBRK:
/*?*/ 				if ( nPosY==0 || (pDoc->GetRowFlags(nPosY,nTab) & CR_MANUALBREAK)==0 )
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_DEL_COLBRK:
/*?*/ 				if ( nPosX==0 || (pDoc->GetColFlags(nPosX,nTab) & CR_MANUALBREAK)==0 )
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_FILL_TAB:
/*?*/ 				if ( nTabSelCount < 2 )
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*N*/ 
/*N*/ 			case SID_SELECT_SCENARIO:
/*N*/ 				{
/*N*/ 					ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 					USHORT		nTab = GetViewData()->GetTabNo();
/*N*/ 					List		aList;
/*N*/ 
/*N*/ 					Color	aDummyCol;
/*N*/ 					USHORT	nDummyFlags;
/*N*/ 
/*N*/ 					if ( !pDoc->IsScenario(nTab) )
/*N*/ 					{
/*N*/ 						String aStr;
/*N*/ 						USHORT nScTab = nTab + 1;
/*N*/ 
/*N*/ 						while ( pDoc->IsScenario(nScTab) )
/*N*/ 						{
/*?*/ 							pDoc->GetName( nScTab, aStr );
/*?*/ 							aList.Insert( new String( aStr ), LIST_APPEND );
/*?*/ 							pDoc->GetScenarioData( nScTab, aStr, aDummyCol, nDummyFlags );
/*?*/ 							aList.Insert( new String( aStr ), LIST_APPEND );
/*?*/ 							++nScTab;
/*N*/ 						}
/*N*/ 					}
/*N*/ 					else
/*N*/ 					{
/*?*/ 						String	aComment;
/*?*/ 						pDoc->GetScenarioData( nTab, aComment, aDummyCol, nDummyFlags );
/*?*/ 						DBG_ASSERT( aList.Count() == 0, "List not empty!" );
/*?*/ 						aList.Insert( new String( aComment ) );
/*N*/ 					}
/*N*/ 
/*N*/ 					rSet.Put( SfxStringListItem( nWhich, &aList ) );
/*N*/ 
/*N*/ 					ULONG nCount = aList.Count();
/*N*/ 					for ( ULONG i=0; i<nCount; i++ )
/*?*/ 						delete (String*) aList.GetObject(i);
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case FID_ROW_HIDE:
/*N*/ 			case FID_ROW_SHOW:
/*N*/ 			case FID_COL_HIDE:
/*N*/ 			case FID_COL_SHOW:
/*N*/ 			case FID_COL_OPT_WIDTH:
/*N*/ 			case FID_ROW_OPT_HEIGHT:
/*N*/ 			case FID_DELETE_CELL:
/*N*/ 				if ( pDoc->IsTabProtected(nTab) || pDocSh->IsReadOnly())
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 
/*	Zellschutz bei selektierten Zellen wird bei anderen Funktionen auch nicht abgefragt...
			case SID_DELETE:
				{
					if ( pDoc->IsTabProtected(nTab) )
					{
						const SfxItemSet&		rAttrSet  = GetSelectionPattern()->GetItemSet();
						const ScProtectionAttr& rProtAttr = (const ScProtectionAttr&)rAttrSet.Get( ATTR_PROTECTION, TRUE );
						if ( rProtAttr.GetProtection() )
							rSet.DisableItem( nWhich );
					}
				}
				break;
*/
/*N*/ 			case SID_OUTLINE_MAKE:
/*M*/ 				{
/*M*/ 					if (pDoc->GetChangeTrack()!=NULL || GetViewData()->IsMultiMarked())
/*M*/ 					{
/*M*/ 						rSet.DisableItem( nWhich );
/*M*/ 					}
/*M*/ 				}
/*N*/ 				break;
/*?*/ 			case SID_OUTLINE_SHOW:
					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				if (!pTabViewShell->OutlinePossible(FALSE))
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_OUTLINE_HIDE:
					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				if (!pTabViewShell->OutlinePossible(TRUE))
/*?*/ 				break;
/*?*/ 
/*N*/ 			case SID_OUTLINE_REMOVE:
/*N*/ 				{
/*N*/ 					BOOL bCol, bRow;
/*N*/ 					pTabViewShell->TestRemoveOutline( bCol, bRow );
/*N*/ 					if ( !bCol && !bRow )
/*N*/ 						rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case FID_COL_WIDTH:
/*N*/ 				{
/*N*/ 					//GetViewData()->GetCurX();
/*N*/ 					SfxUInt16Item aWidthItem( FID_COL_WIDTH, pDoc->GetColWidth( nPosX , nTab) );
/*N*/ 					rSet.Put( aWidthItem );
/*N*/ 					if ( pDocSh->IsReadOnly())
/*?*/ 						rSet.DisableItem( nWhich );
/*N*/ 
/*N*/ 					//XXX Disablen wenn nicht eindeutig
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case FID_ROW_HEIGHT:
/*N*/ 				{
/*N*/ 					//GetViewData()->GetCurY();
/*N*/ 					SfxUInt16Item aHeightItem( FID_ROW_HEIGHT, pDoc->GetRowHeight( nPosY , nTab) );
/*N*/ 					rSet.Put( aHeightItem );
/*N*/ 					//XXX Disablen wenn nicht eindeutig
/*N*/ 					if ( pDocSh->IsReadOnly())
/*?*/ 						rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case SID_DETECTIVE_FILLMODE:
					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				rSet.Put(SfxBoolItem( nWhich, pTabViewShell->IsAuditShell() ));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_INPUTLINE_STATUS:
/*?*/ 				DBG_ERROR( "Old update method. Use ScTabViewShell::UpdateInputHandler()." );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_SCENARIOS:										// Szenarios:
/*?*/ 				if (!(rMark.IsMarked() || rMark.IsMultiMarked()))	// nur, wenn etwas selektiert
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_NOTE_VISIBLE:
/*?*/ 				{
/*?*/ 					ScPostIt aNote;
/*?*/ 					if ( pDoc->IsBlockEditable( nTab, nPosX,nPosY, nPosX,nPosY ) &&
/*?*/ 						 pDoc->GetNote( nPosX, nPosY, nTab, aNote ) )
/*?*/ 					{
/*?*/ 						BOOL bShown = aNote.IsShown() &&
/*?*/ 									pDoc->HasNoteObject( nPosX, nPosY, nTab );
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, bShown ) );
/*?*/ 					}
/*?*/ 					else
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_OPENDLG_CONSOLIDATE:
/*?*/ 			case SCITEM_CONSOLIDATEDATA:
/*?*/ 				{
/*?*/ 					if(pDoc->GetChangeTrack()!=NULL)
/*?*/ 								rSet.DisableItem( nWhich);
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*N*/ 		} // switch ( nWitch )
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	} // while ( nWitch )
/*N*/ }

//------------------------------------------------------------------



}
