/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undocell.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:59:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#define ITEMID_FIELD EE_FEATURE_FIELD


#include "undocell.hxx"
#include "docsh.hxx"
#include "globstr.hrc"
#include "cell.hxx"
#include "undoolk.hxx"
#include "rangenam.hxx"
#include "bf_sc.hrc"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------



// -----------------------------------------------------------------------
//
//		Attribute auf Cursor anwenden
//










// -----------------------------------------------------------------------
//
//		Daten eingeben
//











// -----------------------------------------------------------------------
//
//		Wert aendern
//










// -----------------------------------------------------------------------
//
//		Beliebige Zelle eingeben
//

/*N*/ ScUndoPutCell::ScUndoPutCell( ScDocShell* pNewDocShell, const ScAddress& rNewPos,
/*N*/ 							ScBaseCell* pUndoCell, ScBaseCell* pRedoCell, BOOL bHeight ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aPos		( rNewPos ),
/*N*/ 	pOldCell	( pUndoCell ),
/*N*/ 	pEnteredCell( pRedoCell ),
/*N*/ 	bNeedHeight	( bHeight )
/*N*/ {
/*N*/ 	SetChangeTrack();
/*N*/ }

/*N*/ __EXPORT ScUndoPutCell::~ScUndoPutCell()
/*N*/ {
/*N*/ 	if (pOldCell)
/*N*/ 		pOldCell->Delete();
/*N*/ 	if (pEnteredCell)
/*N*/ 		pEnteredCell->Delete();
/*N*/ }

/*N*/ String __EXPORT ScUndoPutCell::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_ENTERDATA ); // "Eingabe"
/*N*/ }

/*N*/ void ScUndoPutCell::SetChangeTrack()
/*N*/ {
/*N*/ 	ScDocument* pDoc = pDocShell->GetDocument();
/*N*/ 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
/*N*/ 	if ( pChangeTrack )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 nEndChangeAction = pChangeTrack->GetActionMax() + 1;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nEndChangeAction = 0;
/*N*/ }




/*N*/ BOOL __EXPORT ScUndoPutCell::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return FALSE;
/*N*/ }


// -----------------------------------------------------------------------
//
//		Seitenumbrueche
//









// -----------------------------------------------------------------------
//
//		Druck-Skalierung
//










// -----------------------------------------------------------------------
//
//		Thesaurus
//











// -----------------------------------------------------------------------
//
//		Notizen ein-/ausblenden
//

/*N*/ ScUndoNote::ScUndoNote( ScDocShell* pNewDocShell, BOOL bShow,
/*N*/ 						const ScAddress& rNewPos, SdrUndoAction* pDraw ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	bIsShow		( bShow ),
/*N*/ 	aPos		( rNewPos ),
/*N*/ 	pDrawUndo	( pDraw )
/*N*/ 
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoNote::~ScUndoNote()
/*N*/ {
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }








// -----------------------------------------------------------------------
//
//		Text von Notiz aendern (ohne Drawing-Krempel)
//









// -----------------------------------------------------------------------
//
//		Detektiv
//









// -----------------------------------------------------------------------
//
//		Benannte Bereiche
//

/*N*/ ScUndoRangeNames::ScUndoRangeNames( ScDocShell* pNewDocShell,
/*N*/ 									ScRangeName* pOld, ScRangeName* pNew ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	pOldRanges	( pOld ),
/*N*/ 	pNewRanges	( pNew )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoRangeNames::~ScUndoRangeNames()
/*N*/ {
/*N*/ 	delete pOldRanges;
/*N*/ 	delete pNewRanges;
/*N*/ }

/*N*/ String __EXPORT ScUndoRangeNames::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_RANGENAMES );
/*N*/ }





/*N*/ BOOL __EXPORT ScUndoRangeNames::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return FALSE;
/*N*/ }




}
