/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_seltrans.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 15:40:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifdef PCH
#endif

#pragma hdrstop


#include <bf_svx/svdograf.hxx>

#include "seltrans.hxx"
#include "dbfunc.hxx"	// for CopyToClip
#include "drawview.hxx"
namespace binfilter {

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

BOOL lcl_IsURLButton( SdrObject* pObject )
{
	BOOL bRet = FALSE;

	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdrUnoObj* pUnoCtrl = PTR_CAST(SdrUnoObj, pObject);

	return bRet;
}

// static

/*M*/ ScSelectionTransferObj* ScSelectionTransferObj::CreateFromView( ScTabView* pView )
/*M*/ {
/*M*/ 	ScSelectionTransferObj* pRet = NULL;
/*M*/ 
/*M*/ 	if ( pView )
/*M*/ 	{
/*M*/ 		ScSelectionTransferMode eMode = SC_SELTRANS_INVALID;
/*M*/ 
/*M*/ 		SdrView* pSdrView = pView->GetSdrView();
/*M*/ 		if ( pSdrView )
/*M*/ 		{
/*M*/ 			//	handle selection on drawing layer
/*M*/ 			const SdrMarkList& rMarkList = pSdrView->GetMarkList();
/*M*/ 			ULONG nMarkCount = rMarkList.GetMarkCount();
/*M*/ 			if ( nMarkCount )
/*M*/ 			{
/*M*/ 				if ( nMarkCount == 1 )
/*M*/ 				{
/*M*/ 					SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
/*M*/ 					UINT16 nSdrObjKind = pObj->GetObjIdentifier();
/*M*/ 
/*M*/ 					if ( nSdrObjKind == OBJ_GRAF )
/*M*/ 					{
/*M*/ 						if ( ((SdrGrafObj*)pObj)->GetGraphic().GetType() == GRAPHIC_BITMAP )
/*M*/ 							eMode = SC_SELTRANS_DRAW_BITMAP;
/*M*/ 						else
/*M*/ 							eMode = SC_SELTRANS_DRAW_GRAPHIC;
/*M*/ 					}
/*M*/ 					else if ( nSdrObjKind == OBJ_OLE2 )
/*M*/ 						eMode = SC_SELTRANS_DRAW_OLE;
/*M*/ 					else if ( lcl_IsURLButton( pObj ) )
/*M*/ 						eMode = SC_SELTRANS_DRAW_BOOKMARK;
/*M*/ 				}
/*M*/ 	
/*M*/ 				if ( eMode == SC_SELTRANS_INVALID )
/*M*/ 					eMode = SC_SELTRANS_DRAW_OTHER;		// something selected but no special selection
/*M*/ 			}
/*M*/ 		}
/*M*/ 		if ( eMode == SC_SELTRANS_INVALID )				// no drawing object selected
/*M*/ 		{
/*M*/ 			ScRange aRange;
/*M*/ 			ScViewData* pViewData = pView->GetViewData();
/*M*/ 			const ScMarkData& rMark = pViewData->GetMarkData();
/*M*/ 			//	allow MultiMarked because GetSimpleArea may be able to merge into a simple range
/*M*/ 			//	(GetSimpleArea modifies a local copy of MarkData)
/*N*/ 			if ( ( rMark.IsMarked() || rMark.IsMultiMarked() ) && pViewData->GetSimpleArea( aRange ) )
/*M*/ 			{
/*M*/ 				//	only for "real" selection, cursor alone isn't used
/*M*/ 				if ( aRange.aStart == aRange.aEnd )
/*M*/ 					eMode = SC_SELTRANS_CELL;
/*M*/ 				else
/*M*/ 					eMode = SC_SELTRANS_CELLS;
/*M*/ 			}
/*M*/ 		}
/*M*/ 
/*M*/ 		if ( eMode != SC_SELTRANS_INVALID )
/*M*/ 			pRet = new ScSelectionTransferObj( pView, eMode );
/*M*/ 	}
/*M*/ 
/*M*/ 	return pRet;
/*M*/ }




/*N*/ BOOL ScSelectionTransferObj::StillValid()
/*N*/ {
/*N*/ 	//!	check if view still has same cell selection
/*N*/ 	//!	(but return FALSE if data has changed inbetween)
/*N*/ 	return FALSE;
/*N*/ }




//!	make static member of ScDrawView
extern void lcl_CheckOle( const SdrMarkList& rMarkList, BOOL& rAnyOle, BOOL& rOneOle );







}
