/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_inputhdl.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 15:38:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/editobj.hxx>
#include <bf_svx/editstat.hxx>
#include <bf_svx/escpitem.hxx>
#include <bf_svx/svxacorr.hxx>
#include <bf_sfx2/printer.hxx>
#include <bf_offmgr/app.hxx>
#include <svtools/zforlist.hxx>

#ifndef _SV_HELP_HXX //autogen
#include <vcl/help.hxx>
#endif



#include "inputwin.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
//#include "appmain.hxx"
#include "scmod.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "patattr.hxx"
#include "editutil.hxx"
#include "userlist.hxx"
#include "rfindlst.hxx"
#include "inputopt.hxx"

#define _INPUTHDL_CXX
#include "inputhdl.hxx"
namespace binfilter {

//	max. Ranges im RangeFinder
#define RANGEFIND_MAX	32

// STATIC DATA -----------------------------------------------------------

BOOL ScInputHandler::bOptLoaded = FALSE;			// App-Optionen ausgewertet
BOOL ScInputHandler::bAutoComplete = FALSE;			// wird in KeyInput gesetzt

//	delimiters (in addition to ScEditUtil) needed for range finder:
//	only characters that are allowed in formulas next to references
//	and the quotation mark (so string constants can be skipped)

static const sal_Char __FAR_DATA pMinDelimiters[] = " !\"";

extern USHORT nEditAdjust;		//! Member an ViewData

//==================================================================




/*N*/ void ScInputHandler::DeleteRangeFinder()
/*N*/ {
/*N*/ 	ScTabViewShell* pPaintView = pRefViewSh ? pRefViewSh : pActiveViewSh;
/*N*/ 	if ( pRangeFindList && pPaintView )
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001  /*?*/ 		ScDocShell* pDocSh = pActiveViewSh->GetViewData()->GetDocShell();
/*N*/ 	}
/*N*/ }

//==================================================================

/*N*/ inline String GetEditText(EditEngine* pEng)
/*N*/ {
/*?*/ 	 return ScEditUtil::GetSpaceDelimitedString(*pEng);
/*N*/ }

/*N*/ void lcl_RemoveTabs(String& rStr)
/*N*/ {
/*N*/ 	xub_StrLen nPos;
/*N*/ 	while ( (nPos=rStr.Search('\t')) != STRING_NOTFOUND )
/*N*/ 		rStr.SetChar( nPos, ' ' );
/*N*/ }


//==================================================================

/*N*/ ScInputHandler::ScInputHandler()
/*N*/ 	:	eMode( SC_INPUT_NONE ),
/*N*/ 		bModified( FALSE ),
/*N*/ 		bFormulaMode( FALSE ),
/*N*/ 		bSelIsRef( FALSE ),
/*N*/ 		bInRangeUpdate( FALSE ),
/*N*/ 		pInputWin( NULL ),
/*N*/ 		pRefViewSh( NULL ),
/*N*/ 		pLastPattern( NULL ),
/*N*/ 		pLastState( NULL ),
/*N*/ 		bLastIsSymbol( FALSE ),
/*N*/ 		bProtected( FALSE ),
/*N*/ 		bTextValid( TRUE ),
/*N*/ 		bCellHasPercentFormat( FALSE ),
/*N*/ 		nValidation( 0 ),
/*N*/ 		nAttrAdjust( SVX_HOR_JUSTIFY_STANDARD ),
/*N*/ 		aScaleX( 1,1 ),
/*N*/ 		aScaleY( 1,1 ),
/*N*/ 		pTopView( NULL ),
/*N*/ 		pTableView( NULL ),
/*N*/ 		pEngine( NULL ),
/*N*/ 		pEditDefaults( NULL ),
/*N*/ 		pDelayTimer( NULL ),
/*N*/ 		pColumnData( NULL ),
/*N*/ 		pFormulaData( NULL ),
/*N*/ 		nTipVisible( 0 ),
/*N*/ 		nAutoPos( SCPOS_INVALID ),
/*N*/ 		bUseTab( FALSE ),
/*N*/ 		nFormSelStart( 0 ),
/*N*/ 		nFormSelEnd( 0 ),
/*N*/ 		nAutoPar( 0 ),
/*N*/ 		pRangeFindList( NULL ),
/*N*/ 		bParenthesisShown( FALSE ),
/*N*/ 		bCreatingFuncView( FALSE ),
/*N*/ 		bInEnterHandler( FALSE ),
/*N*/ 		bCommandErrorShown( FALSE ),
/*N*/ 		bInOwnChange( FALSE )
/*N*/ {
/*N*/ 	//	The InputHandler is constructed with the view, so SfxViewShell::Current
/*N*/ 	//	doesn't have the right view yet. pActiveViewSh is updated in NotifyChange.
/*N*/ 	pActiveViewSh = NULL;
/*N*/ 
/*N*/ 	//	Bindings (nur noch fuer Invalidate benutzt) werden bei Bedarf aktuell geholt
/*N*/ }

/*N*/ __EXPORT ScInputHandler::~ScInputHandler()
/*N*/ {
/*N*/ 	//	Wenn dies der Applikations-InputHandler ist, wird der dtor erst nach SfxApplication::Main
/*N*/ 	//	gerufen, darf sich also auf keine Sfx-Funktionen mehr verlassen
/*N*/ 
/*N*/ 	if ( !SFX_APP()->IsDowning() )			// inplace
/*N*/ 		EnterHandler();						// Eingabe noch abschliessen
/*N*/ 
/*N*/ 	if (SC_MOD()->GetRefInputHdl()==this)
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		SC_MOD()->SetRefInputHdl(NULL);
/*N*/ 
/*N*/ 	if ( pInputWin && pInputWin->GetInputHandler() == this )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pInputWin->SetInputHandler( NULL );

/*N*/ 	delete pRangeFindList;
/*N*/ 	delete pEditDefaults;
/*N*/ 	delete pEngine;
/*N*/ 	delete pLastState;
/*N*/ 	delete pDelayTimer;
/*N*/ 	delete pColumnData;
/*N*/ 	delete pFormulaData;
/*N*/ }

/*N*/ void ScInputHandler::SetRefScale( const Fraction& rX, const Fraction& rY )
/*N*/ {
/*N*/ 	if ( rX != aScaleX || rY != aScaleY )
/*N*/ 	{
/*?*/ 		aScaleX = rX;
/*?*/ 		aScaleY = rY;
/*?*/ 		if (pEngine)
/*?*/ 		{
/*?*/ 			MapMode aMode( MAP_100TH_MM, Point(), aScaleX, aScaleY );
/*?*/ 			pEngine->SetRefMapMode( aMode );
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void ScInputHandler::UpdateRefDevice()
/*N*/ {
/*N*/ 	if (!pEngine)
/*?*/ 		return;
/*N*/ 
/*N*/ 	BOOL bTextWysiwyg = SC_MOD()->GetInputOptions().GetTextWysiwyg();
/*N*/ 	if ( bTextWysiwyg && pActiveViewSh )
/*?*/ 		pEngine->SetRefDevice( pActiveViewSh->GetViewData()->GetDocument()->GetPrinter() );
/*N*/ 	else
/*N*/ 		pEngine->SetRefDevice( NULL );
/*N*/ 
/*N*/ 	MapMode aMode( MAP_100TH_MM, Point(), aScaleX, aScaleY );
/*N*/ 	pEngine->SetRefMapMode( aMode );
/*N*/ 
/*N*/ 	//	SetRefDevice(NULL) uses VirtualDevice, SetRefMapMode forces creation of a local VDev,
/*N*/ 	//	so the DigitLanguage can be safely modified (might use an own VDev instead of NULL).
/*N*/ 	if ( !( bTextWysiwyg && pActiveViewSh ) )
/*N*/ 	{
/*?*/ 		pEngine->GetRefDevice()->SetDigitLanguage( SC_MOD()->GetOptDigitLanguage() );
/*N*/ 	}
/*N*/ }

/*N*/ void ScInputHandler::ImplCreateEditEngine()
/*N*/ {
/*N*/ 	if ( !pEngine )
/*N*/ 	{
/*N*/ 		if ( pActiveViewSh )
/*N*/ 		{
/*N*/ 			const ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocShell()->GetDocument();
/*N*/ 			pEngine = new ScFieldEditEngine( pDoc->GetEnginePool(), pDoc->GetEditPool() );
/*N*/ 		}
/*N*/ 		else
/*N*/ 			pEngine = new ScFieldEditEngine( EditEngine::CreatePool(), NULL, TRUE );
/*N*/ 		pEngine->SetWordDelimiters( ScEditUtil::ModifyDelimiters( pEngine->GetWordDelimiters() ) );
/*N*/ 		UpdateRefDevice();		// also sets MapMode
/*N*/ 		pEngine->SetPaperSize( Size( 1000000, 1000000 ) );
/*N*/ 		pEditDefaults = new SfxItemSet( pEngine->GetEmptyItemSet() );
/*N*/ 
/*N*/ 		pEngine->SetControlWord( pEngine->GetControlWord() | EE_CNTRL_AUTOCORRECT );
/*N*/         pEngine->SetModifyHdl( LINK( this, ScInputHandler, ModifyHdl ) );
/*N*/ 	}
/*N*/ }



//
//		Funktionen/Bereichsnamen etc. als Tip-Hilfe
//

#define SC_STRTYPE_FUNCTIONS	1
//	die anderen Typen sind in ScDocument::GetFormulaEntries festgelegt


/*N*/ void ScInputHandler::HideTip()
/*N*/ {
/*N*/ 	if ( nTipVisible )
/*N*/ 	{
/*?*/ 		Help::HideTip( nTipVisible );
/*?*/ 		nTipVisible = 0;
/*N*/ 	}
/*N*/ 	aManualTip.Erase();
/*N*/ }






//
//		Selektion berechnen und als Tip-Hilfe anzeigen
//




/*N*/ void ScInputHandler::ResetAutoPar()
/*N*/ {
/*N*/ 	nAutoPar = 0;
/*N*/ }




//
//		Auto-Eingabe
//




//
//		Klammern hervorheben
//





/*N*/ void ScInputHandler::StopInputWinEngine( BOOL bAll )
/*N*/ {
/*N*/ 	if (pInputWin)
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		pInputWin->StopEditEngine( bAll );
/*N*/ 
/*N*/ 	pTopView = NULL;		// invalid now
/*N*/ }











/*N*/ IMPL_LINK( ScInputHandler, ModifyHdl, void *, EMPTYARG )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	return 0;
/*N*/ }








//
//		--------------- public Methoden --------------------------------------------
//


//----------------------------------------------------------------------------------------

//	lcl_IsNumber - TRUE, wenn nur Ziffern (dann keine Autokorrektur)

BOOL lcl_IsNumber(const String& rString)
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 xub_StrLen nLen = rString.Len();
	return TRUE;
}

/*N*/ void ScInputHandler::EnterHandler( BYTE nBlockMode )
/*N*/ {
/*N*/ 	//	#62806# Bei Makro-Aufrufen fuer Gueltigkeit kann Tod und Teufel passieren,
/*N*/ 	//	darum dafuer sorgen, dass EnterHandler nicht verschachtelt gerufen wird:
/*N*/ 
/*N*/ 	if (bInEnterHandler) return;
/*N*/ 	bInEnterHandler = TRUE;
/*N*/ 	bInOwnChange = TRUE;				// disable ModifyHdl (reset below)
/*N*/ 
/*N*/ 	ImplCreateEditEngine();
/*N*/ 
/*N*/ 	BOOL bMatrix = ( nBlockMode == SC_ENTER_MATRIX );
/*N*/ 
/*N*/ 	SfxApplication*	pSfxApp		= SFX_APP();
/*N*/ 	EditTextObject* pObject		= NULL;
/*N*/ 	ScPatternAttr*	pCellAttrs	= NULL;
/*N*/ 	BOOL			bAttrib		= FALSE;	// Formatierung vorhanden ?
/*N*/ 	BOOL			bForget		= FALSE;	// wegen Gueltigkeit streichen ?
/*N*/ 
/*N*/ 	String aString = GetEditText(pEngine);
/*N*/ 	EditView* pActiveView = pTopView ? pTopView : pTableView;
/*N*/ 	if (bModified && pActiveView && aString.Len() && !lcl_IsNumber(aString))
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	if (pTopView)
/*N*/ 	}
/*N*/ 	lcl_RemoveTabs(aString);
/*N*/ 
/*N*/ 	//	Test, ob zulaessig (immer mit einfachem String)
/*N*/ 
/*N*/ 	if ( bModified && nValidation && pActiveViewSh )
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocument();
/*N*/ 	}
/*N*/ 
/*N*/ 	pEngine->CompleteOnlineSpelling();
/*N*/ 	BOOL bSpellErrors = !bFormulaMode && pEngine->HasOnlineSpellErrors();
/*N*/ 	if ( bSpellErrors )
/*N*/ 	{
/*?*/ 		//	#i3820# If the spell checker flags numerical input as error,
/*?*/ 		//	it still has to be treated as number, not EditEngine object.
/*?*/ 
/*?*/ 		if ( pLastPattern && pActiveViewSh )
/*?*/ 		{
/*?*/ 			ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocument();
/*?*/ 			SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
/*?*/ 			// without conditional format, as in ScColumn::SetString
/*?*/ 			sal_uInt32 nFormat = pLastPattern->GetNumberFormat( pFormatter );
/*?*/ 			double nVal;
/*?*/ 			if ( pFormatter->IsNumberFormat( aString, nFormat, nVal ) )
/*?*/ 			{
/*?*/ 				bSpellErrors = FALSE;		// ignore the spelling errors
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	//	After RemoveAdjust, the EditView must not be repainted (has wrong font size etc).
/*N*/ 	//	SetUpdateMode must come after CompleteOnlineSpelling.
/*N*/ 	//	The view is hidden in any case below (Broadcast).
/*N*/ 	pEngine->SetUpdateMode( FALSE );
/*N*/ 
/*N*/ 	if ( bModified && !bForget )			// was wird eingeben (Text/Objekt) ?
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		USHORT nParCnt = pEngine->GetParagraphCount();
/*N*/ 	}
/*N*/ 
/*N*/ 	//	don't rely on ShowRefFrame switching the active view synchronously
/*N*/ 	//	execute the function directly on the correct view's bindings instead
/*N*/ 	//	pRefViewSh is reset in ShowRefFrame - get pointer before ShowRefFrame call
/*N*/ 	ScTabViewShell* pExecuteSh = pRefViewSh ? pRefViewSh : pActiveViewSh;
/*N*/ 
/*N*/ 	if (bFormulaMode)
/*N*/ 	{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		ShowRefFrame();
/*N*/ 	}
/*N*/ 	pRefViewSh = NULL;			// auch ohne FormulaMode wegen Funktions-AP
/*N*/ 	DeleteRangeFinder();
/*N*/ 	ResetAutoPar();
/*N*/ 
/*N*/ 	BOOL bOldMod = bModified;
/*N*/ 
/*N*/ 	bModified = FALSE;
/*N*/ 	bSelIsRef = FALSE;
/*N*/ 	eMode 	  = SC_INPUT_NONE;
/*N*/ 	StopInputWinEngine( TRUE );
/*N*/ 
/*N*/ 	if (bOldMod && !bProtected && !bForget)
/*N*/ 	{
/*?*/ 		//	keine typographische Anfuehrungszeichen in Formeln
/*?*/ 
/*?*/ 		if ( aString.GetChar(0) == '=' )
/*?*/ 		{
/*?*/ 			SvxAutoCorrect* pAuto = OFF_APP()->GetAutoCorrect();
/*?*/ 			if ( pAuto )
/*?*/ 			{
/*?*/ 				sal_Unicode cReplace = pAuto->GetStartDoubleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getDoubleQuotationMarkStart().GetChar(0);
/*?*/ 				if ( cReplace != '"' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '"' );
/*?*/ 
/*?*/ 				cReplace = pAuto->GetEndDoubleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getDoubleQuotationMarkEnd().GetChar(0);
/*?*/ 				if ( cReplace != '"' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '"' );
/*?*/ 
/*?*/ 				cReplace = pAuto->GetStartSingleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getQuotationMarkStart().GetChar(0);
/*?*/ 				if ( cReplace != '\'' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '\'' );
/*?*/ 
/*?*/ 				cReplace = pAuto->GetEndSingleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getQuotationMarkEnd().GetChar(0);
/*?*/ 				if ( cReplace != '\'' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '\'' );
/*?*/ 			}
/*?*/ 		}
/*?*/ 
/*?*/ 		pSfxApp->Broadcast( SfxSimpleHint( FID_KILLEDITVIEW_NOPAINT ) );
/*?*/ 
/*?*/ 		if ( pExecuteSh )
/*?*/ 		{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			SfxBindings& rBindings = pExecuteSh->GetViewFrame()->GetBindings();
/*?*/ 		}
/*?*/ 
/*?*/ 		delete pLastState;		// pLastState enthaelt noch den alten Text
/*?*/ 		pLastState = NULL;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		pSfxApp->Broadcast( SfxSimpleHint( FID_KILLEDITVIEW ) );
/*N*/ 
/*N*/ 	if ( bOldMod && pExecuteSh && pCellAttrs && !bForget )
/*N*/ 	{
/*?*/ 		//	mit Eingabe zusammenfassen ?
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pExecuteSh->ApplySelectionPattern( *pCellAttrs, TRUE, TRUE );
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pCellAttrs;
/*N*/ 	delete pObject;
/*N*/ 
/*N*/ 	HideTip();
/*N*/ 
/*N*/ 	nFormSelStart = nFormSelEnd = 0;
/*N*/ 	aFormText.Erase();
/*N*/ 
/*N*/ 	bInOwnChange = FALSE;
/*N*/ 	bInEnterHandler = FALSE;
/*N*/ }









/*N*/ void ScInputHandler::NotifyChange( const ScInputHdlState* pState,
/*N*/ 								   BOOL bForce, ScTabViewShell* pSourceSh,
/*N*/                                    BOOL bStopEditing)
/*N*/ {
/*N*/ 	//	#62806# Wenn der Aufruf aus einem Makro-Aufruf im EnterHandler kommt,
/*N*/ 	//	gleich abbrechen und nicht den Status durcheinander bringen
/*N*/ 	if (bInEnterHandler)
/*N*/ 		return;
/*N*/ 
/*N*/ 	BOOL bRepeat = (pState == pLastState);
/*N*/ 	if (!bRepeat && pState && pLastState)
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	bRepeat = (*pState == *pLastState);
/*N*/ 	if (bRepeat && !bForce)
/*N*/ 		return;
/*N*/ 
/*N*/ 	bInOwnChange = TRUE;				// disable ModifyHdl (reset below)
/*N*/ 
/*N*/ 	if ( pState && !pLastState )		// wieder enablen
/*N*/ 		bForce = TRUE;
/*N*/ 
/*N*/ 	BOOL bHadObject = pLastState && pLastState->GetEditData();
/*N*/ 
/*N*/ 	//! Before EditEngine gets eventually created (so it gets the right pools)
/*N*/ 	if ( pSourceSh )
/*N*/ 		pActiveViewSh = pSourceSh;
/*N*/ 	else
/*?*/ 		pActiveViewSh = PTR_CAST(ScTabViewShell, SfxViewShell::Current());
/*N*/ 
/*N*/ 	ImplCreateEditEngine();
/*N*/ 
/*N*/ 	if ( pState != pLastState )
/*N*/ 	{
/*N*/ 		delete pLastState;
/*N*/ 		pLastState = pState ? new ScInputHdlState( *pState ) : NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pState && pActiveViewSh )
/*N*/ 	{
/*N*/ 		ScModule* pScMod = SC_MOD();
/*N*/ 
/*N*/ 		if ( pState )
/*N*/ 		{
/*N*/ 			BOOL bIgnore = FALSE;
/*N*/ 
/*N*/ 			//	hier auch fremde Referenzeingabe beruecksichtigen (z.B. Funktions-AP),
/*N*/ 			//	FormEditData falls gerade von der Hilfe auf Calc umgeschaltet wird:
/*N*/ 
/*N*/ 			if ( !bFormulaMode && !pScMod->IsFormulaMode() && !pScMod->GetFormEditData() )
/*N*/ 			{
/*N*/ 				if ( bModified )
/*N*/ 				{
/*?*/ 					if (pState->GetPos() != aCursorPos)
/*?*/ 					{
/*?*/ 						if (!bProtected)
/*?*/ 							EnterHandler();
/*?*/ 					}
/*?*/ 					else
/*?*/ 						bIgnore = TRUE;
/*N*/ 				}
/*N*/ 
/*N*/ 				if ( !bIgnore /* || bRepeat */ )
/*N*/ 				{
/*N*/ 					const ScAddress& 		rSPos	= pState->GetStartPos();
/*N*/ 					const ScAddress& 		rEPos	= pState->GetEndPos();
/*N*/ 					const EditTextObject*	pData	= pState->GetEditData();
/*N*/ 					String					aString = pState->GetString();
/*N*/ 					BOOL					bTxtMod = FALSE;
/*N*/ 
/*N*/ 					aCursorPos	= pState->GetPos();
/*N*/ 
/*N*/ 					if ( pData /* || bRepeat */ )
/*?*/ 						bTxtMod = TRUE;
/*N*/ 					else if ( bHadObject )
/*?*/ 						bTxtMod = TRUE;
/*N*/ 					else if ( bTextValid )
/*N*/ 						bTxtMod = ( aString != aCurrentText );
/*N*/ 					else
/*?*/ 						bTxtMod = ( aString != GetEditText(pEngine) );
/*N*/ 
/*N*/ 					if ( bTxtMod || bForce )
/*N*/ 					{
/*N*/ 						if (pData)
/*N*/ 						{
/*?*/ 							pEngine->SetText( *pData );
/*?*/ 							aString = GetEditText(pEngine);
/*?*/ 							lcl_RemoveTabs(aString);
/*?*/ 							bTextValid = FALSE;
/*?*/ 							aCurrentText.Erase();
/*N*/ 						}
/*N*/ 						else
/*N*/ 						{
/*N*/ 							aCurrentText = aString;
/*N*/ 							bTextValid = TRUE;				//! erst nur als String merken
/*N*/ 						}
/*N*/ 
/*N*/ 						if ( pInputWin )
/*?*/ 						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pInputWin->SetTextString(aString);
/*N*/ 					}
/*N*/ 
/*N*/ 					if ( pInputWin )						// Bereichsanzeige
/*N*/ 					{
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 String aPosStr;
/*N*/ 					}
/*N*/ 
/*N*/                     if (bStopEditing)
/*N*/ 					    SFX_APP()->Broadcast( SfxSimpleHint( FID_KILLEDITVIEW ) );
/*N*/ 
/*N*/ 					//	As long as the content is not edited, turn off online spelling.
/*N*/ 					//	Online spelling is turned back on in StartTable, after setting
/*N*/ 					//	the right language from cell attributes.
/*N*/ 
/*N*/ 					ULONG nCntrl = pEngine->GetControlWord();
/*N*/ 					if ( nCntrl & EE_CNTRL_ONLINESPELLING )
/*?*/ 						pEngine->SetControlWord( nCntrl & ~EE_CNTRL_ONLINESPELLING );
/*N*/ 
/*N*/ 					bModified = FALSE;
/*N*/ 					bSelIsRef = FALSE;
/*N*/ 					bProtected = FALSE;
/*M*/ 					bCommandErrorShown = FALSE;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ //		bProtected = FALSE;
/*N*/ 
/*N*/ 		if ( pInputWin)
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(!pScMod->IsFormulaMode()&& !pScMod->IsRefDialogOpen())	//BugID 54702
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else // !pState || !pActiveViewSh
/*N*/ 	{
/*?*/ 		if ( !pDelayTimer )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDelayTimer = new Timer;
/*?*/ 		}
/*?*/ 	}
/*N*/ 
/*N*/ 	HideTip();
/*N*/ 	bInOwnChange = FALSE;
/*N*/ }









//------------------------------------------------------------------------
// Methoden fuer FunktionsAutopiloten:
// InputGetSelection, InputSetSelection, InputReplaceSelection, InputGetFormulaStr
//------------------------------------------------------------------------


//------------------------------------------------------------------------


//------------------------------------------------------------------------


//------------------------------------------------------------------------


//------------------------------------------------------------------------


//========================================================================
//	ScInputHdlState
//========================================================================

/*N*/ ScInputHdlState::ScInputHdlState( const ScAddress& rCurPos,
/*N*/ 								  const ScAddress& rStartPos,
/*N*/ 								  const ScAddress& rEndPos,
/*N*/ 								  const String& rString,
/*N*/ 								  const EditTextObject* pData )
/*N*/ 	:   aCursorPos	( rCurPos ),
/*N*/ 		aStartPos	( rStartPos ),
/*N*/ 		aEndPos		( rEndPos ),
/*N*/ 		aString		( rString ),
/*N*/ 		pEditData	( pData ? pData->Clone() : NULL )
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------

/*N*/ ScInputHdlState::ScInputHdlState( const ScInputHdlState& rCpy )
/*N*/ 	:	pEditData	( NULL )
/*N*/ {
/*N*/ 	*this = rCpy;
/*N*/ }
/*N*/ 
/*N*/ //------------------------------------------------------------------------
/*N*/ 
/*N*/ ScInputHdlState::~ScInputHdlState()
/*N*/ {
/*N*/ 	delete pEditData;
/*N*/ }
/*N*/ 
/*N*/ //------------------------------------------------------------------------
/*N*/ ScInputHdlState& ScInputHdlState::operator=( const ScInputHdlState& r )
/*N*/ {
/*N*/ 	delete pEditData;
/*N*/ 
/*N*/ 	aCursorPos	= r.aCursorPos;
/*N*/ 	aStartPos	= r.aStartPos;
/*N*/ 	aEndPos		= r.aEndPos;
/*N*/ 	aString		= r.aString;
/*N*/ 	pEditData	= r.pEditData ? r.pEditData->Clone() : NULL;
/*N*/ 
/*N*/ 	return *this;
/*N*/ }




}
