/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: basicmixer.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:09:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_MIXER_BASICMIXER_HXX
#include <svx/sdr/mixer/basicmixer.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACT_HXX
#include <svx/sdr/contact/viewobjectcontact.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWCONTACT_HXX
#include <svx/sdr/contact/viewcontact.hxx>
#endif

#ifndef _SDR_CONTACT_DISPLAYINFO_HXX
#include <svx/sdr/contact/displayinfo.hxx>
#endif

#ifndef _SVDOBJ_HXX
#include <svdobj.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		BasicMixer::BasicMixer()
		{
		}

		BasicMixer::~BasicMixer()
		{
		}

		// paint method. This will call SetupObject(fMixerState, rDisplayInfo), then the paint at the
		// associated ViewCOntact, and then RestoreObject().
		sal_Bool BasicMixer::PaintObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC)
		{
			// only animated paint if not printer and not (rInfoRec.nPaintMode & SDRPAINTMODE_ANILIKEPRN).
			// the second is old and needs to be checked again later.
			sal_Bool bDoAnimate(!rDisplayInfo.OutputToPrinter() && !(rDisplayInfo.GetPaintInfoRec()->nPaintMode & SDRPAINTMODE_ANILIKEPRN));

			if(bDoAnimate)
			{
				// prepare object
				SetupObject(fMixerState, rDisplayInfo);
			}

			// paint using normal ViewContact paint
			sal_Bool bRetval = rAssociatedVOC.GetViewContact().PaintObject(rDisplayInfo, rPaintRectangle, rAssociatedVOC);

			if(bDoAnimate)
			{
				// restore object values
				RestoreObject(rDisplayInfo);
			}

			return bRetval;
		}
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

// #test# color change mixer
#ifndef _SDR_PROPERTIES_PROPERTIES_HXX
#include <svx/sdr/properties/properties.hxx>
#endif

// #test# color change mixer
#ifndef _SVDOBJ_HXX
#include <svdobj.hxx>
#endif

// #test# color change mixer
#ifndef _SVX_XFLCLIT_HXX
#include <xflclit.hxx>
#endif

namespace sdr
{
	namespace mixer
	{
		// setup associated object for paint at given state
		void ColorChangeMixer::SetupObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo)
		{
			// #test# color change mixer
			sdr::properties::BaseProperties& rProps = GetSdrObject().GetProperties();
			Color aOrigColor = ((const XFillColorItem&)(rProps.GetItem(XATTR_FILLCOLOR))).GetValue();
			mnOrigColor = aOrigColor.GetColor();

			Color aInverseColor(
				((sal_uInt8)0xff) - aOrigColor.GetRed(),
				((sal_uInt8)0xff) - aOrigColor.GetGreen(),
				((sal_uInt8)0xff) - aOrigColor.GetBlue());
			
			sal_uInt16 nMultiplier(sal_uInt16(0x00ff * fMixerState));
			sal_uInt16 nInvMultiplier(0x00ff - nMultiplier);

			Color aNewColor(
				(sal_uInt8)(((aOrigColor.GetRed() * nMultiplier) + (aInverseColor.GetRed() * nInvMultiplier)) >> 8L),
				(sal_uInt8)(((aOrigColor.GetGreen() * nMultiplier) + (aInverseColor.GetGreen() * nInvMultiplier)) >> 8L),
				(sal_uInt8)(((aOrigColor.GetBlue() * nMultiplier) + (aInverseColor.GetBlue() * nInvMultiplier)) >> 8L));

			rProps.SetObjectItemDirect(XFillColorItem(String(), aNewColor));
		}

		// restore associated object to original state
		void ColorChangeMixer::RestoreObject(sdr::contact::DisplayInfo& rDisplayInfo)
		{
			// #test# color change mixer
			sdr::properties::BaseProperties& rProps = GetSdrObject().GetProperties();
			Color aOrigColor = mnOrigColor;
			rProps.SetObjectItemDirect(XFillColorItem(String(), aOrigColor));
		}

		ColorChangeMixer::ColorChangeMixer(SdrObject& rObject)
		:	mrObject(rObject)
		{
			// #test# color change mixer
		}

		ColorChangeMixer::~ColorChangeMixer()
		{
			// #test# color change mixer
		}
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
