 /*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: rtfkeywd.cxx,v $
 *
 *  $Revision: 1.13.166.1 $
 *
 *  last change: $Author: rt $ $Date: 2006/02/10 13:27:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil -*- */

#include "rtfkeywd.hxx"

#ifndef _RTFTOKEN_H
#include "rtftoken.h"
#endif

#ifndef _STRING_HXX
#include "tools/string.hxx"
#endif

#include <string.h>
#include <ctype.h>
#include <stdlib.h>

// die Tabelle muss noch sortiert werden
struct RTF_TokenEntry
{
	union{
		const sal_Char* sToken;
		const String* pUToken;
	};
	int nToken;
};

// Flag: RTF-Token Tabelle wurde schon sortiert
static int __FAR_DATA bSortKeyWords = FALSE;

static RTF_TokenEntry __FAR_DATA aRTFTokenTab[] = {
{sRTF_IGNORE,        RTF_IGNOREFLAG},
{sRTF_RTF,           RTF_RTF},
{sRTF_ANSI,          RTF_ANSITYPE},
{sRTF_MAC,           RTF_MACTYPE},
{sRTF_PC,            RTF_PCTYPE},
{sRTF_PCA,           RTF_PCATYPE},
{sRTF_NEXTCSET,      RTF_NEXTTYPE},
{sRTF_STYLESHEET,    RTF_STYLESHEET},
{sRTF_SBASEDON,      RTF_SBASEDON},
{sRTF_SNEXT,         RTF_SNEXT},
{sRTF_FONTTBL,       RTF_FONTTBL},
{sRTF_DEFF,          RTF_DEFF},
{sRTF_FNIL,          RTF_FNIL},
{sRTF_FROMAN,        RTF_FROMAN},
{sRTF_FSWISS,        RTF_FSWISS},
{sRTF_FMODERN,       RTF_FMODERN},
{sRTF_FSCRIPT,       RTF_FSCRIPT},
{sRTF_FDECOR,        RTF_FDECOR},
{sRTF_FTECH,         RTF_FTECH},
{sRTF_FCHARSET,		RTF_FCHARSET},
{sRTF_FALT,			RTF_FALT},
{sRTF_FPRQ,			RTF_FPRQ},
{sRTF_COLORTBL,      RTF_COLORTBL},
{sRTF_RED,           RTF_RED},
{sRTF_GREEN,         RTF_GREEN},
{sRTF_BLUE,          RTF_BLUE},
{sRTF_CF,            RTF_CF},
{sRTF_CB,            RTF_CB},
{sRTF_INFO,          RTF_INFO},
{sRTF_TITLE,         RTF_TITLE},
{sRTF_SUBJECT,       RTF_SUBJECT},
{sRTF_AUTHOR,        RTF_AUTHOR},
{sRTF_OPERATOR,      RTF_OPERATOR},
{sRTF_KEYWORDS,      RTF_KEYWORDS},
{sRTF_COMMENT,       RTF_COMMENT},
{sRTF_VERSION,       RTF_VERSION},
{sRTF_DOCCOMM,       RTF_DOCCOMM},
{sRTF_VERN,          RTF_VERN},
{sRTF_CREATIM,       RTF_CREATIM},
{sRTF_REVTIM,        RTF_REVTIM},
{sRTF_PRINTIM,       RTF_PRINTIM},
{sRTF_BUPTIM,        RTF_BUPTIM},
{sRTF_EDMINS,        RTF_EDMINS},
{sRTF_NOFPAGES,      RTF_NOFPAGES},
{sRTF_NOFWORDS,      RTF_NOFWORDS},
{sRTF_NOFCHARS,      RTF_NOFCHARS},
{sRTF_ID,            RTF_ID},
{sRTF_YR,            RTF_YR},
{sRTF_MO,            RTF_MO},
{sRTF_DY,            RTF_DY},
{sRTF_HR,            RTF_HR},
{sRTF_MIN,           RTF_MIN},
{sRTF_ANNOTATION,    RTF_ANNOTATION},
{sRTF_ATNID,         RTF_ATNID},
{sRTF_FOOTNOTE,      RTF_FOOTNOTE},
{sRTF_FOOTER,        RTF_FOOTER},
{sRTF_FOOTERL,       RTF_FOOTERL},
{sRTF_FOOTERR,       RTF_FOOTERR},
{sRTF_FOOTERF,       RTF_FOOTERF},
{sRTF_HEADER,        RTF_HEADER},
{sRTF_HEADERL,       RTF_HEADERL},
{sRTF_HEADERR,       RTF_HEADERR},
{sRTF_HEADERF,       RTF_HEADERF},
{sRTF_XE,            RTF_XE},
{sRTF_BXE,           RTF_BXE},
{sRTF_IXE,           RTF_IXE},
{sRTF_RXE,           RTF_RXE},
{sRTF_TXE,           RTF_TXE},
{sRTF_TC,            RTF_TC},
{sRTF_TCF,           RTF_TCF},
{sRTF_TCL,           RTF_TCL},
{sRTF_BKMKSTART,     RTF_BKMKSTART},
{sRTF_BKMKEND,       RTF_BKMKEND},
{sRTF_PICT,          RTF_PICT},
{sRTF_PICW,          RTF_PICW},
{sRTF_PICH,          RTF_PICH},
{sRTF_WBMBITSPIXEL,  RTF_WBMBITSPIXEL},
{sRTF_WBMPLANES,     RTF_WBMPLANES},
{sRTF_WBMWIDTHBYTES, RTF_WBMWIDTHBYTES},
{sRTF_PICWGOAL,      RTF_PICWGOAL},
{sRTF_PICHGOAL,      RTF_PICHGOAL},
{sRTF_BIN,           RTF_BIN},
{sRTF_PICSCALEX,     RTF_PICSCALEX},
{sRTF_PICSCALEY,     RTF_PICSCALEY},
{sRTF_PICSCALED,     RTF_PICSCALED},
{sRTF_WBITMAP,       RTF_WBITMAP},
{sRTF_WMETAFILE,     RTF_WMETAFILE},
{sRTF_MACPICT,       RTF_MACPICT},
{sRTF_PICCROPT,      RTF_PICCROPT},
{sRTF_PICCROPB,      RTF_PICCROPB},
{sRTF_PICCROPL,      RTF_PICCROPL},
{sRTF_PICCROPR,      RTF_PICCROPR},
{sRTF_FIELD,         RTF_FIELD},
{sRTF_FLDDIRTY,      RTF_FLDDIRTY},
{sRTF_FLDEDIT,       RTF_FLDEDIT},
{sRTF_FLDLOCK,       RTF_FLDLOCK},
{sRTF_FLDPRIV,       RTF_FLDPRIV},
{sRTF_FLDINST,       RTF_FLDINST},
{sRTF_FLDRSLT,       RTF_FLDRSLT},
{sRTF_PAPERW,        RTF_PAPERW},
{sRTF_PAPERH,        RTF_PAPERH},
{sRTF_MARGL,         RTF_MARGL},
{sRTF_MARGR,         RTF_MARGR},
{sRTF_MARGT,         RTF_MARGT},
{sRTF_MARGB,         RTF_MARGB},
{sRTF_FACINGP,       RTF_FACINGP},
{sRTF_GUTTER,        RTF_GUTTER},
{sRTF_DEFTAB,        RTF_DEFTAB},
{sRTF_WIDOWCTRL,     RTF_WIDOWCTRL},
{sRTF_HYPHHOTZ,      RTF_HYPHHOTZ},
{sRTF_FTNSEP,        RTF_FTNSEP},
{sRTF_FTNSEPC,       RTF_FTNSEPC},
{sRTF_FTNCN,         RTF_FTNCN},
{sRTF_ENDNOTES,      RTF_ENDNOTES},
{sRTF_ENDDOC,        RTF_ENDDOC},
{sRTF_FTNTJ,         RTF_FTNTJ},
{sRTF_FTNBJ,         RTF_FTNBJ},
{sRTF_FTNSTART,      RTF_FTNSTART},
{sRTF_FTNRESTART,    RTF_FTNRESTART},
{sRTF_PGNSTART,      RTF_PGNSTART},
{sRTF_LINESTART,     RTF_LINESTART},
{sRTF_LANDSCAPE,     RTF_LANDSCAPE},
{sRTF_FRACWIDTH,     RTF_FRACWIDTH},
{sRTF_NEXTFILE,      RTF_NEXTFILE},
{sRTF_TEMPLATE,      RTF_TEMPLATE},
{sRTF_MAKEBACKUP,    RTF_MAKEBACKUP},
{sRTF_DEFFORMAT,     RTF_DEFFORMAT},
{sRTF_REVISIONS,     RTF_REVISIONS},
{sRTF_MARGMIRROR,    RTF_MARGMIRROR},
{sRTF_REVPROP,       RTF_REVPROP},
{sRTF_REVBAR,        RTF_REVBAR},
{sRTF_SECTD,         RTF_SECTD},
{sRTF_SBKNONE,       RTF_SBKNONE},
{sRTF_SBKCOL,        RTF_SBKCOL},
{sRTF_SBKPAGE,       RTF_SBKPAGE},
{sRTF_SBKEVEN,       RTF_SBKEVEN},
{sRTF_SBKODD,        RTF_SBKODD},
{sRTF_PGNSTARTS,     RTF_PGNSTARTS},
{sRTF_PGNCONT,       RTF_PGNCONT},
{sRTF_PGNRESTART,    RTF_PGNRESTART},
{sRTF_PGNDEC,        RTF_PGNDEC},
{sRTF_PGNUCRM,       RTF_PGNUCRM},
{sRTF_PGNLCRM,       RTF_PGNLCRM},
{sRTF_PGNUCLTR,      RTF_PGNUCLTR},
{sRTF_PGNLCLTR,      RTF_PGNLCLTR},
{sRTF_PGNX,          RTF_PGNX},
{sRTF_PGNY,          RTF_PGNY},
{sRTF_HEADERY,       RTF_HEADERY},
{sRTF_FOOTERY,       RTF_FOOTERY},
{sRTF_LINEMOD,       RTF_LINEMOD},
{sRTF_LINEX,         RTF_LINEX},
{sRTF_LINESTARTS,    RTF_LINESTARTS},
{sRTF_LINERESTART,   RTF_LINERESTART},
{sRTF_LINEPPAGE,     RTF_LINEPAGE},
{sRTF_LINECONT,      RTF_LINECONT},
{sRTF_VERTALT,       RTF_VERTALT},
{sRTF_VERTALB,       RTF_VERTALB},
{sRTF_VERTALC,       RTF_VERTALC},
{sRTF_VERTALJ,       RTF_VERTALJ},
{sRTF_COLS,          RTF_COLS},
{sRTF_COLSX,         RTF_COLSX},
{sRTF_COLNO,			RTF_COLNO},
{sRTF_COLSR,			RTF_COLSR},
{sRTF_COLW,			RTF_COLW},
{sRTF_LINEBETCOL,    RTF_LINEBETCOL},
{sRTF_ENDNHERE,      RTF_ENDNHERE},
{sRTF_TITLEPG,       RTF_TITLEPG},
{sRTF_PARD,          RTF_PARD},
{sRTF_S,             RTF_S},
{sRTF_QL,            RTF_QL},
{sRTF_QR,            RTF_QR},
{sRTF_QJ,            RTF_QJ},
{sRTF_QC,            RTF_QC},
{sRTF_FI,            RTF_FI},
{sRTF_LI,            RTF_LI},
{sRTF_LIN,           RTF_LIN},
{sRTF_RI,            RTF_RI},
{sRTF_RIN,           RTF_RIN},
{sRTF_SB,            RTF_SB},
{sRTF_SA,            RTF_SA},
{sRTF_SL,            RTF_SL},
{sRTF_INTBL,         RTF_INTBL},
{sRTF_KEEP,          RTF_KEEP},
{sRTF_KEEPN,         RTF_KEEPN},
{sRTF_LEVEL,			RTF_LEVEL},
{sRTF_SBYS,          RTF_SBYS},
{sRTF_PAGEBB,        RTF_PAGEBB},
{sRTF_NOLINE,        RTF_NOLINE},
{sRTF_TX,            RTF_TX},
{sRTF_TQL,           RTF_TQL},
{sRTF_TQR,           RTF_TQR},
{sRTF_TQC,           RTF_TQC},
{sRTF_TQDEC,         RTF_TQDEC},
{sRTF_TB,            RTF_TB},
{sRTF_BRDRT,         RTF_BRDRT},
{sRTF_BRDRB,         RTF_BRDRB},
{sRTF_BRDRL,         RTF_BRDRL},
{sRTF_BRDRR,         RTF_BRDRR},
{sRTF_BOX,           RTF_BOX},
{sRTF_BRDRS,         RTF_BRDRS},
{sRTF_BRDRTH,        RTF_BRDRTH},
{sRTF_BRDRSH,        RTF_BRDRSH},
{sRTF_BRDRDB,        RTF_BRDRDB},
{sRTF_BRDRDOT,       RTF_BRDRDOT},
{sRTF_BRDRHAIR,      RTF_BRDRHAIR},
{sRTF_BRSP,          RTF_BRSP},
{sRTF_TLDOT,         RTF_TLDOT},
{sRTF_TLHYPH,        RTF_TLHYPH},
{sRTF_TLUL,          RTF_TLUL},
{sRTF_TLTH,          RTF_TLTH},
{sRTF_POSX,          RTF_POSX},
{sRTF_POSXC,         RTF_POSXC},
{sRTF_POSXI,         RTF_POSXI},
{sRTF_POSXL,         RTF_POSXL},
{sRTF_POSXO,         RTF_POSXO},
{sRTF_POSXR,         RTF_POSXR},
{sRTF_POSY,          RTF_POSY},
{sRTF_POSYIL,        RTF_POSYIL},
{sRTF_POSYT,         RTF_POSYT},
{sRTF_POSYC,         RTF_POSYC},
{sRTF_POSYB,         RTF_POSYB},
{sRTF_ABSW,          RTF_ABSW},
{sRTF_DXFRTEXT,      RTF_DXFRTEXT},
{sRTF_PVMRG,         RTF_PVMRG},
{sRTF_PVPG,          RTF_PVPG},
{sRTF_PHMRG,         RTF_PHMRG},
{sRTF_PHPG,          RTF_PHPG},
{sRTF_PHCOL,         RTF_PHCOL},
{sRTF_CLBRDRB,       RTF_CLBRDRB},
{sRTF_CLBRDRT,       RTF_CLBRDRT},
{sRTF_CLBRDRL,       RTF_CLBRDRL},
{sRTF_CLBRDRR,       RTF_CLBRDRR},
{sRTF_CLPADL,        RTF_CLPADL},
{sRTF_CLPADT,        RTF_CLPADT},
{sRTF_CLPADB,        RTF_CLPADB},
{sRTF_CLPADR,        RTF_CLPADR},
{sRTF_CLPADFL,       RTF_CLPADFL},
{sRTF_CLPADFT,       RTF_CLPADFT},
{sRTF_CLPADFB,       RTF_CLPADFB},
{sRTF_CLPADFR,       RTF_CLPADFR},
{sRTF_TROWD,         RTF_TROWD},
{sRTF_TRQL,          RTF_TRQL},
{sRTF_TRQR,          RTF_TRQR},
{sRTF_TRQC,          RTF_TRQC},
{sRTF_TRGAPH,        RTF_TRGAPH},
{sRTF_TRRH,          RTF_TRRH},
{sRTF_TRLEFT,        RTF_TRLEFT},
{sRTF_CELLX,         RTF_CELLX},
{sRTF_CLMGF,         RTF_CLMGF},
{sRTF_CLMRG,         RTF_CLMRG},
{sRTF_PLAIN,         RTF_PLAIN},
{sRTF_B,             RTF_B},
{sRTF_I,             RTF_I},
{sRTF_STRIKE,        RTF_STRIKE},
{sRTF_OUTL,          RTF_OUTL},
{sRTF_SHAD,          RTF_SHAD},
{sRTF_SCAPS,         RTF_SCAPS},
{sRTF_CAPS,          RTF_CAPS},
{sRTF_V,             RTF_V},
{sRTF_F,             RTF_F},
{sRTF_FS,            RTF_FS},
{sRTF_EXPND,         RTF_EXPND},
{sRTF_EXPNDTW,       RTF_EXPNDTW},
{sRTF_KERNING,       RTF_KERNING},
{sRTF_UL,            RTF_UL},
{sRTF_ULW,           RTF_ULW},
{sRTF_ULD,           RTF_ULD},
{sRTF_ULDB,          RTF_ULDB},
{sRTF_ULNONE,        RTF_ULNONE},
{sRTF_UP,            RTF_UP},
{sRTF_DN,            RTF_DN},
{sRTF_REVISED,       RTF_REVISED},
{sRTF_SUB,			RTF_SUB},
{sRTF_NOSUPERSUB,	RTF_NOSUPERSUB},
{sRTF_SUPER,			RTF_SUPER},
{sRTF_CHDATE,        RTF_CHDATE},
{sRTF_CHTIME,        RTF_CHTIME},
{sRTF_CHPGN,         RTF_CHPGN},
{sRTF_CHFTN,         RTF_CHFTN},
{sRTF_CHATN,         RTF_CHATN},
{sRTF_CHFTNSEP,      RTF_CHFTNSEP},
{sRTF_CHFTNSEPC,     RTF_CHFTNSEPC},
{sRTF_FORMULA,       RTF_FORMULA},
{sRTF_NOBREAK,       RTF_NONBREAKINGSPACE},
{sRTF_OPTHYPH,       RTF_OPTIONALHYPHEN},
{sRTF_NOBRKHYPH,     RTF_NONBREAKINGHYPHEN},
{sRTF_HEXCHAR,       RTF_HEX},
{sRTF_CELL,          RTF_CELL},
{sRTF_ROW,           RTF_ROW},
{sRTF_PAR,           RTF_PAR},
{sRTF_SECT,          RTF_SECT},
{sRTF_PAGE,          RTF_PAGE},
{sRTF_COLUMN,        RTF_COLUM},
{sRTF_LINE,          RTF_LINE},
{sRTF_TAB,           RTF_TAB},
{sRTF_SUBENTRY,      RTF_SUBENTRYINDEX},

{sRTF_DEFLANG,       RTF_DEFLANG},
{sRTF_LANG,          RTF_LANG},
{sRTF_PMMETAFILE,    RTF_OSMETAFILE},
{sRTF_DIBITMAP,      RTF_DIBITMAP},
{sRTF_KEYCODE,       RTF_KEYCODE},
{sRTF_FN,            RTF_FNKEY},
{sRTF_ALT,           RTF_ALTKEY},
{sRTF_SHIFT,         RTF_SHIFTKEY},
{sRTF_CTRL,          RTF_CTRLKEY},
{sRTF_CHDPL,         RTF_CHDATEL},
{sRTF_CHDPA,         RTF_CHDATEA},
{sRTF_EMDASH,        RTF_EMDASH},
{sRTF_ENDASH,        RTF_ENDASH},
{sRTF_BULLET,        RTF_BULLET},
{sRTF_LQUOTE,        RTF_LQUOTE},
{sRTF_RQUOTE,        RTF_RQUOTE},
{sRTF_LDBLQUOTE,     RTF_LDBLQUOTE},
{sRTF_RDBLQUOTE,     RTF_RDBLQUOTE},

{sRTF_BKMKCOLF,      RTF_BKMKCOLF},
{sRTF_BKMKCOLL,      RTF_BKMKCOLL},
{sRTF_PSOVER,        RTF_PSOVER},
{sRTF_DOCTEMP,       RTF_DOCTEMP},
{sRTF_BINFSXN,       RTF_BINFSXN},
{sRTF_BINSXN,        RTF_BINSXN},
{sRTF_PGWSXN,        RTF_PGWSXN},
{sRTF_PGHSXN,        RTF_PGHSXN},
{sRTF_MARGLSXN,      RTF_MARGLSXN},
{sRTF_MARGRSXN,      RTF_MARGRSXN},
{sRTF_MARGTSXN,      RTF_MARGTSXN},
{sRTF_MARGBSXN,      RTF_MARGBSXN},
{sRTF_GUTTERSXN,     RTF_GUTTERSXN},
{sRTF_LNDSCPSXN,     RTF_LNDSCPSXN},
{sRTF_FACPGSXN,      RTF_FACPGSXN},
{sRTF_TLEQ,          RTF_TLEQ},
{sRTF_BRDRBTW,       RTF_BRDRBTW},
{sRTF_BRDRBAR,       RTF_BRDRBAR},
{sRTF_BRDRW,         RTF_BRDRW},
{sRTF_BRDRCF,        RTF_BRDRCF},
{sRTF_ABSH,          RTF_ABSH},
{sRTF_PVPARA,        RTF_PVPARA},
{sRTF_NOWRAP,        RTF_NOWRAP},
{sRTF_DFRMTXTX,      RTF_DFRMTXTX},
{sRTF_DFRMTXTY,      RTF_DFRMTXTY},
{sRTF_DROPCAPLI,     RTF_DROPCAPLI},
{sRTF_DROPCAPT,      RTF_DROPCAPT},
{sRTF_ABSNOOVRLP,    RTF_ABSNOOVRLP},
{sRTF_POSNEGX,       RTF_POSNEGX},
{sRTF_POSNEGY,       RTF_POSNEGY},
{sRTF_DELETED,       RTF_DELETED},

{sRTF_SHADING,       RTF_SHADING},
{sRTF_BGHORIZ,       RTF_BGHORIZ},
{sRTF_BGVERT,        RTF_BGVERT},
{sRTF_BGFDIAG,       RTF_BGFDIAG},
{sRTF_BGBDIAG,       RTF_BGBDIAG},
{sRTF_BGCROSS,       RTF_BGCROSS},
{sRTF_BGDCROSS,      RTF_BGDCROSS},
{sRTF_BGDKHORIZ,     RTF_BGDKHORIZ},
{sRTF_BGDKVERT,      RTF_BGDKVERT},
{sRTF_BGDKFDIAG,     RTF_BGDKFDIAG},
{sRTF_BGDKBDIAG,     RTF_BGDKBDIAG},
{sRTF_BGDKCROSS,     RTF_BGDKCROSS},
{sRTF_BGDKDCROSS,    RTF_BGDKDCROSS},
{sRTF_CFPAT,         RTF_CFPAT},
{sRTF_CBPAT,         RTF_CBPAT},

{sRTF_CLSHDNG,       RTF_CLSHDNG},
{sRTF_CLBGHORIZ,     RTF_CLBGHORIZ},
{sRTF_CLBGVERT,      RTF_CLBGVERT},
{sRTF_CLBGFDIAG,     RTF_CLBGFDIAG},
{sRTF_CLBGBDIAG,     RTF_CLBGBDIAG},
{sRTF_CLBGCROSS,     RTF_CLBGCROSS},
{sRTF_CLBGDCROSS,    RTF_CLBGDCROSS},
{sRTF_CLBGDKHOR,   	RTF_CLBGDKHOR},
{sRTF_CLBGDKVERT,    RTF_CLBGDKVERT},
{sRTF_CLBGDKFDIAG,   RTF_CLBGDKFDIAG},
{sRTF_CLBGDKBDIAG,   RTF_CLBGDKBDIAG},
{sRTF_CLBGDKCROSS,   RTF_CLBGDKCROSS},
{sRTF_CLBGDKDCROSS,  RTF_CLBGDKDCROSS},
{sRTF_CLCFPAT,       RTF_CLCFPAT},
{sRTF_CLCBPAT,       RTF_CLCBPAT},

{sRTF_AB,			RTF_AB},
{sRTF_ACAPS,			RTF_ACAPS},
{sRTF_ACF,			RTF_ACF},
{sRTF_ADDITIVE,		RTF_ADDITIVE},
{sRTF_ADN,			RTF_ADN},
{sRTF_AENDDOC,		RTF_AENDDOC},
{sRTF_AENDNOTES,		RTF_AENDNOTES},
{sRTF_AEXPND,		RTF_AEXPND},
{sRTF_AF,			RTF_AF},
{sRTF_AFS,			RTF_AFS},
{sRTF_AFTNBJ,		RTF_AFTNBJ},
{sRTF_AFTNCN,		RTF_AFTNCN},
{sRTF_AFTNNALC,		RTF_AFTNNALC},
{sRTF_AFTNNAR,		RTF_AFTNNAR},
{sRTF_AFTNNAUC,		RTF_AFTNNAUC},
{sRTF_AFTNNCHI,		RTF_AFTNNCHI},
{sRTF_AFTNNRLC,		RTF_AFTNNRLC},
{sRTF_AFTNNRUC,		RTF_AFTNNRUC},
{sRTF_AFTNRESTART,	RTF_AFTNRESTART},
{sRTF_AFTNRSTCONT,	RTF_AFTNRSTCONT},
{sRTF_AFTNSEP,		RTF_AFTNSEP},
{sRTF_AFTNSEPC,		RTF_AFTNSEPC},
{sRTF_AFTNSTART,		RTF_AFTNSTART},
{sRTF_AFTNTJ,		RTF_AFTNTJ},
{sRTF_AI,			RTF_AI},
{sRTF_ALANG,			RTF_ALANG},
{sRTF_ALLPROT,		RTF_ALLPROT},
{sRTF_ANNOTPROT,		RTF_ANNOTPROT},
{sRTF_AOUTL,			RTF_AOUTL},
{sRTF_ASCAPS,		RTF_ASCAPS},
{sRTF_ASHAD,			RTF_ASHAD},
{sRTF_ASTRIKE,		RTF_ASTRIKE},
{sRTF_ATNAUTHOR,		RTF_ATNAUTHOR},
{sRTF_ATNICN,		RTF_ATNICN},
{sRTF_ATNREF,		RTF_ATNREF},
{sRTF_ATNTIME,		RTF_ATNTIME},
{sRTF_ATRFEND,		RTF_ATRFEND},
{sRTF_ATRFSTART,		RTF_ATRFSTART},
{sRTF_AUL,			RTF_AUL},
{sRTF_AULD,			RTF_AULD},
{sRTF_AULDB,			RTF_AULDB},
{sRTF_AULNONE,		RTF_AULNONE},
{sRTF_AULW,			RTF_AULW},
{sRTF_AUP,			RTF_AUP},
{sRTF_BKMKPUB,		RTF_BKMKPUB},
{sRTF_BRDRDASH,		RTF_BRDRDASH},
{sRTF_BRKFRM,		RTF_BRKFRM},
{sRTF_CCHS,			RTF_CCHS},
{sRTF_CPG,			RTF_CPG},
{sRTF_CS,			RTF_CS},
{sRTF_CVMME,			RTF_CVMME},
{sRTF_DATAFIELD,		RTF_DATAFIELD},
{sRTF_DO,			RTF_DO},
{sRTF_DOBXCOLUMN,	RTF_DOBXCOLUMN},
{sRTF_DOBXMARGIN,	RTF_DOBXMARGIN},
{sRTF_DOBXPAGE,		RTF_DOBXPAGE},
{sRTF_DOBYMARGIN,	RTF_DOBYMARGIN},
{sRTF_DOBYPAGE,		RTF_DOBYPAGE},
{sRTF_DOBYPARA,		RTF_DOBYPARA},
{sRTF_DODHGT,		RTF_DODHGT},
{sRTF_DOLOCK,		RTF_DOLOCK},
{sRTF_DPAENDHOL,		RTF_DPAENDHOL},
{sRTF_DPAENDL,		RTF_DPAENDL},
{sRTF_DPAENDSOL,		RTF_DPAENDSOL},
{sRTF_DPAENDW,		RTF_DPAENDW},
{sRTF_DPARC,			RTF_DPARC},
{sRTF_DPARCFLIPX,	RTF_DPARCFLIPX},
{sRTF_DPARCFLIPY,	RTF_DPARCFLIPY},
{sRTF_DPASTARTHOL,	RTF_DPASTARTHOL},
{sRTF_DPASTARTL,		RTF_DPASTARTL},
{sRTF_DPASTARTSOL,	RTF_DPASTARTSOL},
{sRTF_DPASTARTW,		RTF_DPASTARTW},
{sRTF_DPCALLOUT,		RTF_DPCALLOUT},
{sRTF_DPCOA,			RTF_DPCOA},
{sRTF_DPCOACCENT,	RTF_DPCOACCENT},
{sRTF_DPCOBESTFIT,	RTF_DPCOBESTFIT},
{sRTF_DPCOBORDER,	RTF_DPCOBORDER},
{sRTF_DPCODABS,		RTF_DPCODABS},
{sRTF_DPCODBOTTOM,	RTF_DPCODBOTTOM},
{sRTF_DPCODCENTER,	RTF_DPCODCENTER},
{sRTF_DPCODTOP,		RTF_DPCODTOP},
{sRTF_DPCOLENGTH,	RTF_DPCOLENGTH},
{sRTF_DPCOMINUSX,	RTF_DPCOMINUSX},
{sRTF_DPCOMINUSY,	RTF_DPCOMINUSY},
{sRTF_DPCOOFFSET,	RTF_DPCOOFFSET},
{sRTF_DPCOSMARTA,	RTF_DPCOSMARTA},
{sRTF_DPCOTDOUBLE,	RTF_DPCOTDOUBLE},
{sRTF_DPCOTRIGHT,	RTF_DPCOTRIGHT},
{sRTF_DPCOTSINGLE,	RTF_DPCOTSINGLE},
{sRTF_DPCOTTRIPLE,	RTF_DPCOTTRIPLE},
{sRTF_DPCOUNT,		RTF_DPCOUNT},
{sRTF_DPELLIPSE,		RTF_DPELLIPSE},
{sRTF_DPENDGROUP,	RTF_DPENDGROUP},
{sRTF_DPFILLBGCB,	RTF_DPFILLBGCB},
{sRTF_DPFILLBGCG,	RTF_DPFILLBGCG},
{sRTF_DPFILLBGCR,	RTF_DPFILLBGCR},
{sRTF_DPFILLBGGRAY,	RTF_DPFILLBGGRAY},
{sRTF_DPFILLBGPAL,	RTF_DPFILLBGPAL},
{sRTF_DPFILLFGCB,	RTF_DPFILLFGCB},
{sRTF_DPFILLFGCG,	RTF_DPFILLFGCG},
{sRTF_DPFILLFGCR,	RTF_DPFILLFGCR},
{sRTF_DPFILLFGGRAY,	RTF_DPFILLFGGRAY},
{sRTF_DPFILLFGPAL,	RTF_DPFILLFGPAL},
{sRTF_DPFILLPAT,		RTF_DPFILLPAT},
{sRTF_DPGROUP,		RTF_DPGROUP},
{sRTF_DPLINE,		RTF_DPLINE},
{sRTF_DPLINECOB,		RTF_DPLINECOB},
{sRTF_DPLINECOG,		RTF_DPLINECOG},
{sRTF_DPLINECOR,		RTF_DPLINECOR},
{sRTF_DPLINEDADO,	RTF_DPLINEDADO},
{sRTF_DPLINEDADODO,	RTF_DPLINEDADODO},
{sRTF_DPLINEDASH,	RTF_DPLINEDASH},
{sRTF_DPLINEDOT,		RTF_DPLINEDOT},
{sRTF_DPLINEGRAY,	RTF_DPLINEGRAY},
{sRTF_DPLINEHOLLOW,	RTF_DPLINEHOLLOW},
{sRTF_DPLINEPAL,		RTF_DPLINEPAL},
{sRTF_DPLINESOLID,	RTF_DPLINESOLID},
{sRTF_DPLINEW,		RTF_DPLINEW},
{sRTF_DPPOLYCOUNT,	RTF_DPPOLYCOUNT},
{sRTF_DPPOLYGON,		RTF_DPPOLYGON},
{sRTF_DPPOLYLINE,	RTF_DPPOLYLINE},
{sRTF_DPPTX,			RTF_DPPTX},
{sRTF_DPPTY,			RTF_DPPTY},
{sRTF_DPRECT,		RTF_DPRECT},
{sRTF_DPROUNDR,		RTF_DPROUNDR},
{sRTF_DPSHADOW,		RTF_DPSHADOW},
{sRTF_DPSHADX,		RTF_DPSHADX},
{sRTF_DPSHADY,		RTF_DPSHADY},
{sRTF_DPTXBX,		RTF_DPTXBX},
{sRTF_DPTXBXMAR,		RTF_DPTXBXMAR},
{sRTF_DPTXBXTEXT,	RTF_DPTXBXTEXT},
{sRTF_DPX,			RTF_DPX},
{sRTF_DPXSIZE,		RTF_DPXSIZE},
{sRTF_DPY,			RTF_DPY},
{sRTF_DPYSIZE,		RTF_DPYSIZE},
{sRTF_DS,			RTF_DS},
{sRTF_EMSPACE,		RTF_EMSPACE},
{sRTF_ENSPACE,		RTF_ENSPACE},
{sRTF_FBIDI,			RTF_FBIDI},
{sRTF_FET,			RTF_FET},
{sRTF_FID,			RTF_FID},
{sRTF_FILE,			RTF_FILE},
{sRTF_FILETBL,		RTF_FILETBL},
{sRTF_FLDALT,		RTF_FLDALT},
{sRTF_FNETWORK,		RTF_FNETWORK},
{sRTF_FONTEMB,		RTF_FONTEMB},
{sRTF_FONTFILE,		RTF_FONTFILE},
{sRTF_FORMDISP,		RTF_FORMDISP},
{sRTF_FORMPROT,		RTF_FORMPROT},
{sRTF_FORMSHADE,		RTF_FORMSHADE},
{sRTF_FOSNUM,		RTF_FOSNUM},
{sRTF_FRELATIVE,		RTF_FRELATIVE},
{sRTF_FTNALT,		RTF_FTNALT},
{sRTF_FTNIL,			RTF_FTNIL},
{sRTF_FTNNALC,		RTF_FTNNALC},
{sRTF_FTNNAR,		RTF_FTNNAR},
{sRTF_FTNNAUC,		RTF_FTNNAUC},
{sRTF_FTNNCHI,		RTF_FTNNCHI},
{sRTF_FTNNRLC,		RTF_FTNNRLC},
{sRTF_FTNNRUC,		RTF_FTNNRUC},
{sRTF_FTNRSTCONT,	RTF_FTNRSTCONT},
{sRTF_FTNRSTPG,		RTF_FTNRSTPG},
{sRTF_FTTRUETYPE,	RTF_FTTRUETYPE},
{sRTF_FVALIDDOS,		RTF_FVALIDDOS},
{sRTF_FVALIDHPFS,	RTF_FVALIDHPFS},
{sRTF_FVALIDMAC,		RTF_FVALIDMAC},
{sRTF_FVALIDNTFS,	RTF_FVALIDNTFS},
{sRTF_HYPHAUTO,		RTF_HYPHAUTO},
{sRTF_HYPHCAPS,		RTF_HYPHCAPS},
{sRTF_HYPHCONSEC,	RTF_HYPHCONSEC},
{sRTF_HYPHPAR,		RTF_HYPHPAR},
{sRTF_LINKSELF,		RTF_LINKSELF},
{sRTF_LINKSTYLES,	RTF_LINKSTYLES},
{sRTF_LTRCH,			RTF_LTRCH},
{sRTF_LTRDOC,		RTF_LTRDOC},
{sRTF_LTRMARK,		RTF_LTRMARK},
{sRTF_LTRPAR,		RTF_LTRPAR},
{sRTF_LTRROW,		RTF_LTRROW},
{sRTF_LTRSECT,		RTF_LTRSECT},
{sRTF_NOCOLBAL,		RTF_NOCOLBAL},
{sRTF_NOEXTRASPRL,	RTF_NOEXTRASPRL},
{sRTF_NOTABIND,		RTF_NOTABIND},
{sRTF_NOWIDCTLPAR,	RTF_NOWIDCTLPAR},
{sRTF_OBJALIAS,		RTF_OBJALIAS},
{sRTF_OBJALIGN,		RTF_OBJALIGN},
{sRTF_OBJAUTLINK,	RTF_OBJAUTLINK},
{sRTF_OBJCLASS,		RTF_OBJCLASS},
{sRTF_OBJCROPB,		RTF_OBJCROPB},
{sRTF_OBJCROPL,		RTF_OBJCROPL},
{sRTF_OBJCROPR,		RTF_OBJCROPR},
{sRTF_OBJCROPT,		RTF_OBJCROPT},
{sRTF_OBJDATA,		RTF_OBJDATA},
{sRTF_OBJECT,		RTF_OBJECT},
{sRTF_OBJEMB,		RTF_OBJEMB},
{sRTF_OBJH,			RTF_OBJH},
{sRTF_OBJICEMB,		RTF_OBJICEMB},
{sRTF_OBJLINK,		RTF_OBJLINK},
{sRTF_OBJLOCK,		RTF_OBJLOCK},
{sRTF_OBJNAME,		RTF_OBJNAME},
{sRTF_OBJPUB,		RTF_OBJPUB},
{sRTF_OBJSCALEX,		RTF_OBJSCALEX},
{sRTF_OBJSCALEY,		RTF_OBJSCALEY},
{sRTF_OBJSECT,		RTF_OBJSECT},
{sRTF_OBJSETSIZE,	RTF_OBJSETSIZE},
{sRTF_OBJSUB,		RTF_OBJSUB},
{sRTF_OBJTIME,		RTF_OBJTIME},
{sRTF_OBJTRANSY,		RTF_OBJTRANSY},
{sRTF_OBJUPDATE,		RTF_OBJUPDATE},
{sRTF_OBJW,			RTF_OBJW},
{sRTF_OTBLRUL,		RTF_OTBLRUL},
{sRTF_PGNHN,			RTF_PGNHN},
{sRTF_PGNHNSC,		RTF_PGNHNSC},
{sRTF_PGNHNSH,		RTF_PGNHNSH},
{sRTF_PGNHNSM,		RTF_PGNHNSM},
{sRTF_PGNHNSN,		RTF_PGNHNSN},
{sRTF_PGNHNSP,		RTF_PGNHNSP},
{sRTF_PICBMP,		RTF_PICBMP},
{sRTF_PICBPP,		RTF_PICBPP},
{sRTF_PN,			RTF_PN},
{sRTF_PNACROSS,		RTF_PNACROSS},
{sRTF_PNB,			RTF_PNB},
{sRTF_PNCAPS,		RTF_PNCAPS},
{sRTF_PNCARD,		RTF_PNCARD},
{sRTF_PNCF,			RTF_PNCF},
{sRTF_PNDEC,			RTF_PNDEC},
{sRTF_PNF,			RTF_PNF},
{sRTF_PNFS,			RTF_PNFS},
{sRTF_PNHANG,		RTF_PNHANG},
{sRTF_PNI,			RTF_PNI},
{sRTF_PNINDENT,		RTF_PNINDENT},
{sRTF_PNLCLTR,		RTF_PNLCLTR},
{sRTF_PNLCRM,		RTF_PNLCRM},
{sRTF_PNLVL,			RTF_PNLVL},
{sRTF_PNLVLBLT,		RTF_PNLVLBLT},
{sRTF_PNLVLBODY,		RTF_PNLVLBODY},
{sRTF_PNLVLCONT,		RTF_PNLVLCONT},
{sRTF_PNNUMONCE,		RTF_PNNUMONCE},
{sRTF_PNORD,			RTF_PNORD},
{sRTF_PNORDT,		RTF_PNORDT},
{sRTF_PNPREV,		RTF_PNPREV},
{sRTF_PNQC,			RTF_PNQC},
{sRTF_PNQL,			RTF_PNQL},
{sRTF_PNQR,			RTF_PNQR},
{sRTF_PNRESTART,		RTF_PNRESTART},
{sRTF_PNSCAPS,		RTF_PNSCAPS},
{sRTF_PNSECLVL,		RTF_PNSECLVL},
{sRTF_PNSP,			RTF_PNSP},
{sRTF_PNSTART,		RTF_PNSTART},
{sRTF_PNSTRIKE,		RTF_PNSTRIKE},
{sRTF_PNTEXT,		RTF_PNTEXT},
{sRTF_PNTXTA,		RTF_PNTXTA},
{sRTF_PNTXTB,		RTF_PNTXTB},
{sRTF_PNUCLTR,		RTF_PNUCLTR},
{sRTF_PNUCRM,		RTF_PNUCRM},
{sRTF_PNUL,			RTF_PNUL},
{sRTF_PNULD,			RTF_PNULD},
{sRTF_PNULDB,		RTF_PNULDB},
{sRTF_PNULNONE,		RTF_PNULNONE},
{sRTF_PNULW,			RTF_PNULW},
{sRTF_PRCOLBL,		RTF_PRCOLBL},
{sRTF_PRINTDATA,		RTF_PRINTDATA},
{sRTF_PSZ,			RTF_PSZ},
{sRTF_PUBAUTO,		RTF_PUBAUTO},
{sRTF_RESULT,		RTF_RESULT},
{sRTF_REVAUTH,		RTF_REVAUTH},
{sRTF_REVDTTM,		RTF_REVDTTM},
{sRTF_REVPROT,		RTF_REVPROT},
{sRTF_REVTBL,		RTF_REVTBL},
{sRTF_RSLTBMP,		RTF_RSLTBMP},
{sRTF_RSLTMERGE,		RTF_RSLTMERGE},
{sRTF_RSLTPICT,		RTF_RSLTPICT},
{sRTF_RSLTRTF,		RTF_RSLTRTF},
{sRTF_RSLTTXT,		RTF_RSLTTXT},
{sRTF_RTLCH,			RTF_RTLCH},
{sRTF_RTLDOC,		RTF_RTLDOC},
{sRTF_RTLMARK,		RTF_RTLMARK},
{sRTF_RTLPAR,		RTF_RTLPAR},
{sRTF_RTLROW,		RTF_RTLROW},
{sRTF_RTLSECT,		RTF_RTLSECT},
{sRTF_SEC,			RTF_SEC},
{sRTF_SECTNUM,		RTF_SECTNUM},
{sRTF_SECTUNLOCKED,	RTF_SECTUNLOCKED},
{sRTF_SLMULT,		RTF_SLMULT},
{sRTF_SOFTCOL,		RTF_SOFTCOL},
{sRTF_SOFTLHEIGHT,	RTF_SOFTLHEIGHT},
{sRTF_SOFTLINE,		RTF_SOFTLINE},
{sRTF_SOFTPAGE,		RTF_SOFTPAGE},
{sRTF_SPRSSPBF,		RTF_SPRSSPBF},
{sRTF_SPRSTSP,		RTF_SPRSTSP},
{sRTF_SUBDOCUMENT,	RTF_SUBDOCUMENT},
{sRTF_SWPBDR,		RTF_SWPBDR},
{sRTF_TCN,			RTF_TCN},
{sRTF_TRANSMF,		RTF_TRANSMF},
{sRTF_TRBRDRB,		RTF_TRBRDRB},
{sRTF_TRBRDRH,		RTF_TRBRDRH},
{sRTF_TRBRDRL,		RTF_TRBRDRL},
{sRTF_TRBRDRR,		RTF_TRBRDRR},
{sRTF_TRBRDRT,		RTF_TRBRDRT},
{sRTF_TRBRDRV,		RTF_TRBRDRV},
{sRTF_TRHDR,			RTF_TRHDR},
{sRTF_TRKEEP,		RTF_TRKEEP},
{sRTF_TRPADDB,      RTF_TRPADDB},
{sRTF_TRPADDL,      RTF_TRPADDL},
{sRTF_TRPADDR,      RTF_TRPADDR},
{sRTF_TRPADDT,      RTF_TRPADDT},
{sRTF_TRPADDFB,      RTF_TRPADDFB},
{sRTF_TRPADDFL,      RTF_TRPADDFL},
{sRTF_TRPADDFR,      RTF_TRPADDFR},
{sRTF_TRPADDFT,      RTF_TRPADDFT},


{sRTF_WRAPTRSP,		RTF_WRAPTRSP},
{sRTF_XEF,			RTF_XEF},
{sRTF_ZWJ,			RTF_ZWJ},
{sRTF_ZWNJ,			RTF_ZWNJ},


{sRTF_ABSLOCK,		RTF_ABSLOCK},
{sRTF_ADJUSTRIGHT,	RTF_ADJUSTRIGHT},
{sRTF_AFTNNCHOSUNG,	RTF_AFTNNCHOSUNG},
{sRTF_AFTNNCNUM,		RTF_AFTNNCNUM},
{sRTF_AFTNNDBAR,		RTF_AFTNNDBAR},
{sRTF_AFTNNDBNUM,	RTF_AFTNNDBNUM},
{sRTF_AFTNNDBNUMD,	RTF_AFTNNDBNUMD},
{sRTF_AFTNNDBNUMK,	RTF_AFTNNDBNUMK},
{sRTF_AFTNNDBNUMT,	RTF_AFTNNDBNUMT},
{sRTF_AFTNNGANADA,	RTF_AFTNNGANADA},
{sRTF_AFTNNGBNUM,	RTF_AFTNNGBNUM},
{sRTF_AFTNNGBNUMD,	RTF_AFTNNGBNUMD},
{sRTF_AFTNNGBNUMK,	RTF_AFTNNGBNUMK},
{sRTF_AFTNNGBNUML,	RTF_AFTNNGBNUML},
{sRTF_AFTNNZODIAC,	RTF_AFTNNZODIAC},
{sRTF_AFTNNZODIACD,	RTF_AFTNNZODIACD},
{sRTF_AFTNNZODIACL,	RTF_AFTNNZODIACL},
{sRTF_ANIMTEXT,		RTF_ANIMTEXT},
{sRTF_ANSICPG,		RTF_ANSICPG},
{sRTF_BACKGROUND,	RTF_BACKGROUND},
{sRTF_BDBFHDR,		RTF_BDBFHDR},
{sRTF_BLIPTAG,		RTF_BLIPTAG},
{sRTF_BLIPUID,		RTF_BLIPUID},
{sRTF_BLIPUPI,		RTF_BLIPUPI},
{sRTF_BRDRART,		RTF_BRDRART},
{sRTF_BRDRDASHD,		RTF_BRDRDASHD},
{sRTF_BRDRDASHDD,	RTF_BRDRDASHDD},
{sRTF_BRDRDASHDOTSTR,RTF_BRDRDASHDOTSTR},
{sRTF_BRDRDASHSM,	RTF_BRDRDASHSM},
{sRTF_BRDREMBOSS,	RTF_BRDREMBOSS},
{sRTF_BRDRENGRAVE,	RTF_BRDRENGRAVE},
{sRTF_BRDRFRAME,		RTF_BRDRFRAME},
{sRTF_BRDRTHTNLG,	RTF_BRDRTHTNLG},
{sRTF_BRDRTHTNMG,	RTF_BRDRTHTNMG},
{sRTF_BRDRTHTNSG,	RTF_BRDRTHTNSG},
{sRTF_BRDRTNTHLG,	RTF_BRDRTNTHLG},
{sRTF_BRDRTNTHMG,	RTF_BRDRTNTHMG},
{sRTF_BRDRTNTHSG,	RTF_BRDRTNTHSG},
{sRTF_BRDRTNTHTNLG,	RTF_BRDRTNTHTNLG},
{sRTF_BRDRTNTHTNMG,	RTF_BRDRTNTHTNMG},
{sRTF_BRDRTNTHTNSG,	RTF_BRDRTNTHTNSG},
{sRTF_BRDRTRIPLE,	RTF_BRDRTRIPLE},
{sRTF_BRDRWAVY,		RTF_BRDRWAVY},
{sRTF_BRDRWAVYDB,	RTF_BRDRWAVYDB},
{sRTF_CATEGORY,		RTF_CATEGORY},
{sRTF_CGRID,			RTF_CGRID},
{sRTF_CHARSCALEX,	RTF_CHARSCALEX},
{sRTF_CHBGBDIAG,		RTF_CHBGBDIAG},
{sRTF_CHBGCROSS,		RTF_CHBGCROSS},
{sRTF_CHBGDCROSS,	RTF_CHBGDCROSS},
{sRTF_CHBGDKBDIAG,	RTF_CHBGDKBDIAG},
{sRTF_CHBGDKCROSS,	RTF_CHBGDKCROSS},
{sRTF_CHBGDKDCROSS,	RTF_CHBGDKDCROSS},
{sRTF_CHBGDKFDIAG,	RTF_CHBGDKFDIAG},
{sRTF_CHBGDKHORIZ,	RTF_CHBGDKHORIZ},
{sRTF_CHBGDKVERT,	RTF_CHBGDKVERT},
{sRTF_CHBGFDIAG,		RTF_CHBGFDIAG},
{sRTF_CHBGHORIZ,		RTF_CHBGHORIZ},
{sRTF_CHBGVERT,		RTF_CHBGVERT},
{sRTF_CHBRDR,		RTF_CHBRDR},
{sRTF_CHCBPAT,		RTF_CHCBPAT},
{sRTF_CHCFPAT,		RTF_CHCFPAT},
{sRTF_CHSHDNG,		RTF_CHSHDNG},
{sRTF_CLTXLRTB,		RTF_CLTXLRTB},
{sRTF_CLTXTBRL,		RTF_CLTXTBRL},
{sRTF_CLVERTALB,		RTF_CLVERTALB},
{sRTF_CLVERTALC,		RTF_CLVERTALC},
{sRTF_CLVERTALT,		RTF_CLVERTALT},
{sRTF_CLVMGF,		RTF_CLVMGF},
{sRTF_CLVMRG,		RTF_CLVMRG},
{sRTF_CLTXTBRLV, 	RTF_CLTXTBRLV},
{sRTF_CLTXBTLR, 		RTF_CLTXBTLR},
{sRTF_CLTXLRTBV,		RTF_CLTXLRTBV},
{sRTF_COMPANY,		RTF_COMPANY},
{sRTF_CRAUTH,		RTF_CRAUTH},
{sRTF_CRDATE,		RTF_CRDATE},
{sRTF_DATE,			RTF_DATE},
{sRTF_DEFLANGFE,		RTF_DEFLANGFE},
{sRTF_DFRAUTH,		RTF_DFRAUTH},
{sRTF_DFRDATE,		RTF_DFRDATE},
{sRTF_DFRSTART,		RTF_DFRSTART},
{sRTF_DFRSTOP,		RTF_DFRSTOP},
{sRTF_DFRXST,		RTF_DFRXST},
{sRTF_DGMARGIN,		RTF_DGMARGIN},
{sRTF_DNTBLNSBDB,	RTF_DNTBLNSBDB},
{sRTF_DOCTYPE,		RTF_DOCTYPE},
{sRTF_DOCVAR,		RTF_DOCVAR},
{sRTF_DPCODESCENT,	RTF_DPCODESCENT},
{sRTF_EMBO,			RTF_EMBO},
{sRTF_EMFBLIP,		RTF_EMFBLIP},
{sRTF_EXPSHRTN,		RTF_EXPSHRTN},
{sRTF_FAAUTO,		RTF_FAAUTO},
{sRTF_FBIAS,			RTF_FBIAS},
{sRTF_FFDEFRES,		RTF_FFDEFRES},
{sRTF_FFDEFTEXT,		RTF_FFDEFTEXT},
{sRTF_FFENTRYMCR,	RTF_FFENTRYMCR},
{sRTF_FFEXITMCR,		RTF_FFEXITMCR},
{sRTF_FFFORMAT,		RTF_FFFORMAT},
{sRTF_FFHASLISTBOX,	RTF_FFHASLISTBOX},
{sRTF_FFHELPTEXT,	RTF_FFHELPTEXT},
{sRTF_FFHPS,			RTF_FFHPS},
{sRTF_FFL,			RTF_FFL},
{sRTF_FFMAXLEN,		RTF_FFMAXLEN},
{sRTF_FFNAME,		RTF_FFNAME},
{sRTF_FFOWNHELP,		RTF_FFOWNHELP},
{sRTF_FFOWNSTAT,		RTF_FFOWNSTAT},
{sRTF_FFPROT,		RTF_FFPROT},
{sRTF_FFRECALC,		RTF_FFRECALC},
{sRTF_FFRES,			RTF_FFRES},
{sRTF_FFSIZE,		RTF_FFSIZE},
{sRTF_FFSTATTEXT,	RTF_FFSTATTEXT},
{sRTF_FFTYPE,		RTF_FFTYPE},
{sRTF_FFTYPETXT,		RTF_FFTYPETXT},
{sRTF_FLDTYPE,		RTF_FLDTYPE},
{sRTF_FNAME,			RTF_FNAME},
{sRTF_FORMFIELD,		RTF_FORMFIELD},
{sRTF_FROMTEXT,		RTF_FROMTEXT},
{sRTF_FTNNCHOSUNG,	RTF_FTNNCHOSUNG},
{sRTF_FTNNCNUM,		RTF_FTNNCNUM},
{sRTF_FTNNDBAR,		RTF_FTNNDBAR},
{sRTF_FTNNDBNUM,		RTF_FTNNDBNUM},
{sRTF_FTNNDBNUMD,	RTF_FTNNDBNUMD},
{sRTF_FTNNDBNUMK,	RTF_FTNNDBNUMK},
{sRTF_FTNNDBNUMT,	RTF_FTNNDBNUMT},
{sRTF_FTNNGANADA,	RTF_FTNNGANADA},
{sRTF_FTNNGBNUM,		RTF_FTNNGBNUM},
{sRTF_FTNNGBNUMD,	RTF_FTNNGBNUMD},
{sRTF_FTNNGBNUMK,	RTF_FTNNGBNUMK},
{sRTF_FTNNGBNUML,	RTF_FTNNGBNUML},
{sRTF_FTNNZODIAC,	RTF_FTNNZODIAC},
{sRTF_FTNNZODIACD,	RTF_FTNNZODIACD},
{sRTF_FTNNZODIACL,	RTF_FTNNZODIACL},
{sRTF_G,				RTF_G},
{sRTF_GCW,			RTF_GCW},
{sRTF_GRIDTBL,		RTF_GRIDTBL},
{sRTF_HIGHLIGHT,		RTF_HIGHLIGHT},
{sRTF_HLFR,			RTF_HLFR},
{sRTF_HLINKBASE,		RTF_HLINKBASE},
{sRTF_HLLOC,			RTF_HLLOC},
{sRTF_HLSRC,			RTF_HLSRC},
{sRTF_ILVL,			RTF_ILVL},
{sRTF_IMPR,			RTF_IMPR},
{sRTF_JPEGBLIP,		RTF_JPEGBLIP},
{sRTF_LEVELFOLLOW,	RTF_LEVELFOLLOW},
{sRTF_LEVELINDENT,	RTF_LEVELINDENT},
{sRTF_LEVELJC,		RTF_LEVELJC},
{sRTF_LEVELLEGAL,	RTF_LEVELLEGAL},
{sRTF_LEVELNFC,		RTF_LEVELNFC},
{sRTF_LEVELNORESTART,RTF_LEVELNORESTART},
{sRTF_LEVELNUMBERS,	RTF_LEVELNUMBERS},
{sRTF_LEVELOLD,		RTF_LEVELOLD},
{sRTF_LEVELPREV,		RTF_LEVELPREV},
{sRTF_LEVELPREVSPACE,RTF_LEVELPREVSPACE},
{sRTF_LEVELSPACE,	RTF_LEVELSPACE},
{sRTF_LEVELSTARTAT,	RTF_LEVELSTARTAT},
{sRTF_LEVELTEXT,		RTF_LEVELTEXT},
{sRTF_LINKVAL,		RTF_LINKVAL},
{sRTF_LIST,			RTF_LIST},
{sRTF_LISTID,		RTF_LISTID},
{sRTF_LISTLEVEL,     RTF_LISTLEVEL},
{sRTF_LISTNAME,		RTF_LISTNAME},
{sRTF_LISTOVERRIDE,	RTF_LISTOVERRIDE},
{sRTF_LISTOVERRIDECOUNT,		RTF_LISTOVERRIDECOUNT},
{sRTF_LISTOVERRIDEFORMAT,	RTF_LISTOVERRIDEFORMAT},
{sRTF_LISTOVERRIDESTART,		RTF_LISTOVERRIDESTART},
{sRTF_LISTOVERRIDETABLE,		RTF_LISTOVERRIDETABLE},
{sRTF_LISTRESTARTHDN,RTF_LISTRESTARTHDN},
{sRTF_LISTSIMPLE,	RTF_LISTSIMPLE},
{sRTF_LISTTABLE,		RTF_LISTTABLE},
{sRTF_LISTTEMPLATEID,RTF_LISTTEMPLATEID},
{sRTF_LISTTEXT,		RTF_LISTTEXT},
{sRTF_LS,			RTF_LS},
{sRTF_LYTEXCTTP,		RTF_LYTEXCTTP},
{sRTF_LYTPRTMET,		RTF_LYTPRTMET},
{sRTF_MANAGER,		RTF_MANAGER},
{sRTF_MSMCAP,		RTF_MSMCAP},
{sRTF_NOFCHARSWS,	RTF_NOFCHARSWS},
{sRTF_NOLEAD,		RTF_NOLEAD},
{sRTF_NONSHPPICT,	RTF_NONSHPPICT},
{sRTF_NOSECTEXPAND,	RTF_NOSECTEXPAND},
{sRTF_NOSNAPLINEGRID,RTF_NOSNAPLINEGRID},
{sRTF_NOSPACEFORUL,	RTF_NOSPACEFORUL},
{sRTF_NOULTRLSPC,	RTF_NOULTRLSPC},
{sRTF_NOXLATTOYEN,	RTF_NOXLATTOYEN},
{sRTF_OBJATTPH,		RTF_OBJATTPH},
{sRTF_OBJHTML,		RTF_OBJHTML},
{sRTF_OBJOCX,		RTF_OBJOCX},
{sRTF_OLDLINEWRAP,	RTF_OLDLINEWRAP},
{sRTF_OUTLINELEVEL,	RTF_OUTLINELEVEL},
{sRTF_OVERLAY,		RTF_OVERLAY},
{sRTF_PANOSE,		RTF_PANOSE},
{sRTF_PGBRDRB,		RTF_PGBRDRB},
{sRTF_PGBRDRFOOT,	RTF_PGBRDRFOOT},
{sRTF_PGBRDRHEAD,	RTF_PGBRDRHEAD},
{sRTF_PGBRDRL,		RTF_PGBRDRL},
{sRTF_PGBRDROPT,		RTF_PGBRDROPT},
{sRTF_PGBRDRR,		RTF_PGBRDRR},
{sRTF_PGBRDRSNAP,	RTF_PGBRDRSNAP},
{sRTF_PGBRDRT,		RTF_PGBRDRT},
{sRTF_PGNCHOSUNG,	RTF_PGNCHOSUNG},
{sRTF_PGNCNUM,		RTF_PGNCNUM},
{sRTF_PGNDBNUMK,		RTF_PGNDBNUMK},
{sRTF_PGNDBNUMT,		RTF_PGNDBNUMT},
{sRTF_PGNGANADA,		RTF_PGNGANADA},
{sRTF_PGNGBNUM,		RTF_PGNGBNUM},
{sRTF_PGNGBNUMD,		RTF_PGNGBNUMD},
{sRTF_PGNGBNUMK,		RTF_PGNGBNUMK},
{sRTF_PGNGBNUML,		RTF_PGNGBNUML},
{sRTF_PGNZODIAC,		RTF_PGNZODIAC},
{sRTF_PGNZODIACD,	RTF_PGNZODIACD},
{sRTF_PGNZODIACL,	RTF_PGNZODIACL},
{sRTF_PICPROP,		RTF_PICPROP},
{sRTF_PNAIUEO,		RTF_PNAIUEO},
{sRTF_PNAIUEOD,		RTF_PNAIUEOD},
{sRTF_PNCHOSUNG,		RTF_PNCHOSUNG},
{sRTF_PNDBNUMD,		RTF_PNDBNUMD},
{sRTF_PNDBNUMK,		RTF_PNDBNUMK},
{sRTF_PNDBNUML,		RTF_PNDBNUML},
{sRTF_PNDBNUMT,		RTF_PNDBNUMT},
{sRTF_PNGANADA,		RTF_PNGANADA},
{sRTF_PNGBLIP,		RTF_PNGBLIP},
{sRTF_PNGBNUM,		RTF_PNGBNUM},
{sRTF_PNGBNUMD,		RTF_PNGBNUMD},
{sRTF_PNGBNUMK,		RTF_PNGBNUMK},
{sRTF_PNGBNUML,		RTF_PNGBNUML},
{sRTF_PNRAUTH,		RTF_PNRAUTH},
{sRTF_PNRDATE,		RTF_PNRDATE},
{sRTF_PNRNFC,		RTF_PNRNFC},
{sRTF_PNRNOT,		RTF_PNRNOT},
{sRTF_PNRPNBR,		RTF_PNRPNBR},
{sRTF_PNRRGB,		RTF_PNRRGB},
{sRTF_PNRSTART,		RTF_PNRSTART},
{sRTF_PNRSTOP,		RTF_PNRSTOP},
{sRTF_PNRXST,		RTF_PNRXST},
{sRTF_PNZODIAC,		RTF_PNZODIAC},
{sRTF_PNZODIACD,		RTF_PNZODIACD},
{sRTF_PNZODIACL,		RTF_PNZODIACL},
{sRTF_LFOLEVEL,		RTF_LFOLEVEL},
{sRTF_POSYIN,		RTF_POSYIN},
{sRTF_POSYOUT,		RTF_POSYOUT},
{sRTF_PRIVATE,		RTF_PRIVATE},
{sRTF_PROPNAME,		RTF_PROPNAME},
{sRTF_PROPTYPE,		RTF_PROPTYPE},
{sRTF_REVAUTHDEL,	RTF_REVAUTHDEL},
{sRTF_REVDTTMDEL,	RTF_REVDTTMDEL},
{sRTF_SAUTOUPD,		RTF_SAUTOUPD},
{sRTF_SECTDEFAULTCL,	RTF_SECTDEFAULTCL},
{sRTF_SECTEXPAND,	RTF_SECTEXPAND},
{sRTF_SECTLINEGRID,	RTF_SECTLINEGRID},
{sRTF_SECTSPECIFYCL,	RTF_SECTSPECIFYCL},
{sRTF_SECTSPECIFYL,	RTF_SECTSPECIFYL},
{sRTF_SHIDDEN,		RTF_SHIDDEN},
{sRTF_SHPBOTTOM,		RTF_SHPBOTTOM},
{sRTF_SHPBXCOLUMN,	RTF_SHPBXCOLUMN},
{sRTF_SHPBXMARGIN,	RTF_SHPBXMARGIN},
{sRTF_SHPBXPAGE,		RTF_SHPBXPAGE},
{sRTF_SHPBYMARGIN,	RTF_SHPBYMARGIN},
{sRTF_SHPBYPAGE,		RTF_SHPBYPAGE},
{sRTF_SHPBYPARA,		RTF_SHPBYPARA},
{sRTF_SHPFBLWTXT,	RTF_SHPFBLWTXT},
{sRTF_SHPFHDR,		RTF_SHPFHDR},
{sRTF_SHPGRP,		RTF_SHPGRP},
{sRTF_SHPLEFT,		RTF_SHPLEFT},
{sRTF_SHPLID,		RTF_SHPLID},
{sRTF_SHPLOCKANCHOR,	RTF_SHPLOCKANCHOR},
{sRTF_SHPPICT,		RTF_SHPPICT},
{sRTF_SHPRIGHT,		RTF_SHPRIGHT},
{sRTF_SHPRSLT,		RTF_SHPRSLT},
{sRTF_SHPTOP,		RTF_SHPTOP},
{sRTF_SHPTXT,		RTF_SHPTXT},
{sRTF_SHPWRK,		RTF_SHPWRK},
{sRTF_SHPWR,			RTF_SHPWR},
{sRTF_SHPZ,			RTF_SHPZ},
{sRTF_SPRSBSP,		RTF_SPRSBSP},
{sRTF_SPRSLNSP,		RTF_SPRSLNSP},
{sRTF_SPRSTSM,		RTF_SPRSTSM},
{sRTF_STATICVAL,		RTF_STATICVAL},
{sRTF_STEXTFLOW,		RTF_STEXTFLOW},
{sRTF_STRIKED,		RTF_STRIKED},
{sRTF_SUBFONTBYSIZE,	RTF_SUBFONTBYSIZE},
{sRTF_TCELLD,		RTF_TCELLD},
{sRTF_TIME,			RTF_TIME},
{sRTF_TRUNCATEFONTHEIGHT,	RTF_TRUNCATEFONTHEIGHT},
{sRTF_UC,			RTF_UC},
{sRTF_UD,			RTF_UD},
{sRTF_ULDASH,		RTF_ULDASH},
{sRTF_ULDASHD,		RTF_ULDASHD},
{sRTF_ULDASHDD,		RTF_ULDASHDD},
{sRTF_ULTH,			RTF_ULTH},
{sRTF_ULWAVE,		RTF_ULWAVE},
{sRTF_ULC,			RTF_ULC},
{sRTF_U,				RTF_U},
{sRTF_UPR,			RTF_UPR},
{sRTF_USERPROPS,		RTF_USERPROPS},
{sRTF_VIEWKIND,		RTF_VIEWKIND},
{sRTF_VIEWSCALE,		RTF_VIEWSCALE},
{sRTF_VIEWZK,		RTF_VIEWZK},
{sRTF_WIDCTLPAR,		RTF_WIDCTLPAR},
{sRTF_WINDOWCAPTION,	RTF_WINDOWCAPTION},
{sRTF_WPEQN,			RTF_WPEQN},
{sRTF_WPJST,			RTF_WPJST},
{sRTF_WPSP,			RTF_WPSP},
{sRTF_YXE,			RTF_YXE},
{sRTF_FRMTXLRTB,    RTF_FRMTXLRTB},
{sRTF_FRMTXTBRL,    RTF_FRMTXTBRL},
{sRTF_FRMTXBTLR,    RTF_FRMTXBTLR},
{sRTF_FRMTXLRTBV,   RTF_FRMTXLRTBV},
{sRTF_FRMTXTBRLV,   RTF_FRMTXTBRLV},

// MS-2000 Tokens
		{{sRTF_ULTHD},         RTF_ULTHD},
		{{sRTF_ULTHDASH},      RTF_ULTHDASH},
		{{sRTF_ULLDASH},       RTF_ULLDASH},
		{{sRTF_ULTHLDASH},     RTF_ULTHLDASH},
		{{sRTF_ULTHDASHD},     RTF_ULTHDASHD},
		{{sRTF_ULTHDASHDD},    RTF_ULTHDASHDD},
		{{sRTF_ULHWAVE},       RTF_ULHWAVE},
		{{sRTF_ULULDBWAVE},    RTF_ULULDBWAVE},

		{{sRTF_LOCH},    		RTF_LOCH},
		{{sRTF_HICH},    		RTF_HICH},
		{{sRTF_DBCH},    		RTF_DBCH},
		{{sRTF_LANGFE},    	RTF_LANGFE},
		{{sRTF_ADEFLANG},		RTF_ADEFLANG},
		{{sRTF_ADEFF},			RTF_ADEFF},
		{{sRTF_ACCNONE},		RTF_ACCNONE},
		{{sRTF_ACCDOT},		RTF_ACCDOT},
		{{sRTF_ACCCOMMA},		RTF_ACCCOMMA},
		{{sRTF_TWOINONE},		RTF_TWOINONE},
		{{sRTF_HORZVERT},		RTF_HORZVERT},
		{{sRTF_FAHANG},		RTF_FAHANG},
		{{sRTF_FAVAR},			RTF_FAVAR},
		{{sRTF_FACENTER},		RTF_FACENTER},
		{{sRTF_FAROMAN},		RTF_FAROMAN},
		{{sRTF_FAFIXED},		RTF_FAFIXED},
		{{sRTF_NOCWRAP},       RTF_NOCWRAP},
		{{sRTF_NOOVERFLOW},    RTF_NOOVERFLOW},
		{{sRTF_ASPALPHA},      RTF_ASPALPHA},

// SWG spezifische Attribute
		{{sRTF_GRFALIGNV},     RTF_GRF_ALIGNV},
		{{sRTF_GRFALIGNH},     RTF_GRF_ALIGNH},
		{{sRTF_GRFMIRROR},     RTF_GRF_MIRROR},
		{{sRTF_HEADERYB},      RTF_HEADER_YB},
		{{sRTF_HEADERXL},      RTF_HEADER_XL},
		{{sRTF_HEADERXR},      RTF_HEADER_XR},
		{{sRTF_FOOTERYT},      RTF_FOOTER_YT},
		{{sRTF_FOOTERXL},      RTF_FOOTER_XL},
		{{sRTF_FOOTERXR},      RTF_FOOTER_XR},
		{{sRTF_HEADERYH},      RTF_HEADER_YH},
		{{sRTF_FOOTERYH},      RTF_FOOTER_YH},
		{{sRTF_BALANCEDCOLUMN},RTF_BALANCED_COLUMN},
		{{sRTF_UPDNPROP},      RTF_SWG_ESCPROP},
		{{sRTF_PRTDATA},       RTF_SWG_PRTDATA},
		{{sRTF_BKMKKEY},       RTF_BKMK_KEY},

// Attribute fuer die freifliegenden Rahmen
		{{sRTF_FLYPRINT},      RTF_FLYPRINT},
		{{sRTF_FLYOPAQUE},     RTF_FLYOPAQUE},
		{{sRTF_FLYPRTCTD},     RTF_FLYPRTCTD},
		{{sRTF_FLYMAINCNT},    RTF_FLYMAINCNT},
		{{sRTF_FLYVERT},       RTF_FLYVERT},
		{{sRTF_FLYHORZ},       RTF_FLYHORZ},
		{{sRTF_DFRMTXTL},      RTF_FLYOUTLEFT},
		{{sRTF_DFRMTXTR},      RTF_FLYOUTRIGHT},
		{{sRTF_DFRMTXTU},      RTF_FLYOUTUPPER},
		{{sRTF_DFRMTXTW},      RTF_FLYOUTLOWER},
		{{sRTF_FLYANCHOR},     RTF_FLYANCHOR},
		{{sRTF_FLYCNTNT},      RTF_FLY_CNTNT},
		{{sRTF_FLYCOLUMN},     RTF_FLY_COLUMN},
		{{sRTF_FLYPAGE},       RTF_FLY_PAGE},

		{{sRTF_BRDBOX},        RTF_BRDBOX},
		{{sRTF_BRDLNCOL},      RTF_BRDLINE_COL},
		{{sRTF_BRDLNIN},       RTF_BRDLINE_IN},
		{{sRTF_BRDLNOUT},      RTF_BRDLINE_OUT},
		{{sRTF_BRDLNDIST},     RTF_BRDLINE_DIST},

		{{sRTF_SHADOW},        RTF_SHADOW},
		{{sRTF_SHDWDIST},      RTF_SHDW_DIST},
		{{sRTF_SHDWSTYLE},     RTF_SHDW_STYLE},
		{{sRTF_SHDWCOL},       RTF_SHDW_COL},
		{{sRTF_SHDWFCOL},      RTF_SHDW_FCOL},

		{{sRTF_FLYINPARA},     RTF_FLY_INPARA},

		{{sRTF_PGDSCTBL},      RTF_PGDSCTBL},
		{{sRTF_PGDSC},         RTF_PGDSC},
		{{sRTF_PGDSCUSE},      RTF_PGDSCUSE},
		{{sRTF_PGDSCNXT},      RTF_PGDSCNXT},

		{{sRTF_HYPHEN},        RTF_HYPHEN},
		{{sRTF_HYPHLEAD},      RTF_HYPHLEAD},
		{{sRTF_HYPHTRAIL},     RTF_HYPHTRAIL},
		{{sRTF_HYPHMAX},       RTF_HYPHMAX},

		{{sRTF_TLSWG},         RTF_TLSWG},
		{{sRTF_PGBRK},         RTF_PGBRK},

		{{sRTF_PGDSCNO},       RTF_PGDSCNO},
		{{sRTF_SOUTLVL},       RTF_SOUTLVL},

		{{sRTF_SHP},       RTF_SHP},
		/*
		{{sRTF_SHPLEFT},       RTF_SHPLEFT}
		{{sRTF_SHPTOP},       RTF_SHPTOP}
		{{sRTF_SHPBOTTOM},       RTF_SHPBOTTOM}
		{{sRTF_SHPRIGHT},       RTF_SHPRIGHT}
		*/
		{{sRTF_SN},       RTF_SN},
		{{sRTF_SV},       RTF_SV}
};



static int
#if defined( WNT )
 __cdecl
#endif
#if defined( ICC ) && defined( OS2 )
_Optlink
#endif
	RTFKeyCompare( const void *pFirst, const void *pSecond)
{
    int nRet = 0;
    if( -1 == ((RTF_TokenEntry*)pFirst)->nToken )
    {
        if( -1 == ((RTF_TokenEntry*)pSecond)->nToken )
            nRet = ((RTF_TokenEntry*)pFirst)->pUToken->CompareTo(
                            *((RTF_TokenEntry*)pSecond)->pUToken );
        else
            nRet = ((RTF_TokenEntry*)pFirst)->pUToken->CompareToAscii(
                            ((RTF_TokenEntry*)pSecond)->sToken );
    }
    else
    {
        if( -1 == ((RTF_TokenEntry*)pSecond)->nToken )
            nRet = -1 * ((RTF_TokenEntry*)pSecond)->pUToken->CompareToAscii(
                            ((RTF_TokenEntry*)pFirst)->sToken );
        else
            nRet = strcmp( ((RTF_TokenEntry*)pFirst)->sToken,
                            ((RTF_TokenEntry*)pSecond)->sToken );
    }

    return nRet;
}

int GetRTFToken( const String& rSearch )
{
	if( !bSortKeyWords )
	{
		qsort( (void*) aRTFTokenTab,
				sizeof( aRTFTokenTab ) / sizeof( RTF_TokenEntry ),
				sizeof( RTF_TokenEntry ),
				RTFKeyCompare );
		bSortKeyWords = TRUE;
	}

	int nRet = 0;
	void* pFound;
	RTF_TokenEntry aSrch;
	aSrch.pUToken = &rSearch;
	aSrch.nToken = -1;

	if( 0 != ( pFound = bsearch( (char *) &aSrch,
						(void*) aRTFTokenTab,
						sizeof( aRTFTokenTab ) / sizeof( RTF_TokenEntry ),
						sizeof( RTF_TokenEntry ),
						RTFKeyCompare )))
		nRet = ((RTF_TokenEntry*)pFound)->nToken;
	return nRet;
}

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
