#!/bin/sh
#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: create-package.sh,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: rt $ $Date: 2005/10/17 13:57:39 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************
# 
# Notes: It may be necessary to do a little more generalization/work with variables in the future

if [ "x${SRC_ROOT}x" == "xx" ]; then
	echo "Please make sure to source the environment variable script!"
	exit 1
fi

OS_LOW=`uname -s | tr A-Z a-z`
OOOVERSION=2.0
CPU_LOW=`echo $CPUNAME | tr A-Z a-z`
KERNELVER=`uname -r | sed 's/\([0-9]\.[0-9]\).*/\1/'`
PACKDIR="${OS_LOW}-${KERNELVER}-${CPU_LOW}"
BUNDLENAME="OpenOffice.org 2.0.app"


if [ "x${1}x" == "xx" ]; then
	echo "No language argument present. Exiting."
	exit 3
fi

LANG=$1

PKGNAME="OpenOffice.org-${OOOVERSION}_${LANG}"

if [ "x${2}x" == "xx" ]; then
	echo "No destination directory argument present. Exiting."
	exit 4
fi

DESTDIR=$2/${LANG}
INSTALLTEMPDIR="${DESTDIR}_temp"

if [ ! -d ${DESTDIR} ]; then
	echo "Destination directory: ${DESTDIR} does not exist! Exiting."
	exit 2
fi

if [ "x${3}x" == "xx" ]; then
	echo "No solverbindir argument present. Exiting."
	exit 5
fi

SOLARBINDIR=$3

#install the packages to the temporary folder
cd ${DESTDIR}
rm -rf ${INSTALLTEMPDIR}
mkdir -p ${INSTALLTEMPDIR}
for Package in `ls $DESTDIR/$PACKDIR/*sw`; do
	echo "Installing ${Package}"
	tar -C "${INSTALLTEMPDIR}" -xf ${Package}
done

#copy the launcher app to the disk image, rename it and move things around
echo "Installing launcher from ${SOLARBINDIR}"
tar -C "${INSTALLTEMPDIR}" -xf ${SOLARBINDIR}/OpenOffice.org.app.tar
mv "${INSTALLTEMPDIR}/OpenOffice.org.app" "${INSTALLTEMPDIR}/${BUNDLENAME}"
mv "${INSTALLTEMPDIR}/Applications/openoffice.org${OOOVERSION}" "${INSTALLTEMPDIR}/${BUNDLENAME}/Contents"
pushd "${INSTALLTEMPDIR}/${BUNDLENAME}/Contents" > /dev/null
ln -s openoffice.org${OOOVERSION} openoffice.org
popd > /dev/null

## Creating dmg
echo "Creating image ${PKGNAME} from ${INSTALLTEMPDIR}/${BUNDLENAME}"
hdiutil create -srcfolder "${INSTALLTEMPDIR}/${BUNDLENAME}" -ov -o ${PKGNAME}
rm -rf ${INSTALLTEMPDIR}

echo "Packaging finished for language ${LANG}"

