/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: gconfinetlayer.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:47:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef GCONFINETLAYER_HXX_
#include "gconfinetlayer.hxx"
#endif 

#ifndef _COM_SUN_STAR_CONFIGURATION_BACKEND_PROPERTYINFO_HPP_
#include <com/sun/star/configuration/backend/PropertyInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_CONFIGURATION_BACKEND_XLAYERCONTENTDESCIBER_HPP_
#include <com/sun/star/configuration/backend/XLayerContentDescriber.hpp>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif // _RTL_USTRBUF_HXX_

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#include <stdio.h>

#include <gconf/gconf-client.h>
#include <rtl/strbuf.hxx>

//==============================================================================

GconfInetLayer::GconfInetLayer(const uno::Reference<uno::XComponentContext>& xContext)
{
    //Create instance of LayerContentDescriber Service
    rtl::OUString const k_sLayerDescriberService(RTL_CONSTASCII_USTRINGPARAM(
        "com.sun.star.comp.configuration.backend.LayerDescriber"));

    typedef uno::Reference<backend::XLayerContentDescriber> LayerDescriber; 
    uno::Reference< lang::XMultiComponentFactory > xServiceManager = xContext->getServiceManager();
    if( xServiceManager.is() )
    {
        m_xLayerContentDescriber = LayerDescriber::query(
            xServiceManager->createInstanceWithContext(k_sLayerDescriberService, xContext));
    }
    else
    {
        OSL_TRACE("Could not retrieve ServiceManager");
    }
}

//------------------------------------------------------------------------------

void SAL_CALL GconfInetLayer::readData( const uno::Reference<backend::XLayerHandler>& xHandler) 
    throw ( backend::MalformedDataException, lang::NullPointerException, 
            lang::WrappedTargetException, uno::RuntimeException)
{
    if( ! m_xLayerContentDescriber.is() )
    {
        throw uno::RuntimeException( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
            "Could not create com.sun.star.configuration.backend.LayerContentDescriber Service"
        ) ), static_cast < backend::XLayer * > (this) );
    }
    
    uno::Sequence<backend::PropertyInfo> aPropInfoList(5);
    sal_Int32 nProperties = 0;
    
    GError* aError;
    GConfClient* aClient = GconfBackend::getGconfClient();
    GConfValue* aGconfValue;
    
    aError = NULL;
    aGconfValue = gconf_client_get(aClient, "/system/proxy/mode" , &aError);
        
    if( aError == NULL && aGconfValue != NULL )
    {
        rtl::OString aMode(gconf_value_get_string(aGconfValue));
        
        if( aMode.equals("manual") )
        {            
            aPropInfoList[nProperties].Name = rtl::OUString(
                RTL_CONSTASCII_USTRINGPARAM( "org.openoffice.Inet/Settings/ooInetProxyType") );
            aPropInfoList[nProperties].Type = rtl::OUString( 
                RTL_CONSTASCII_USTRINGPARAM( "int" ) );
            aPropInfoList[nProperties].Protected = sal_False;
            aPropInfoList[nProperties++].Value = uno::makeAny( (sal_Int32) 1 );
            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/http_proxy/host" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aPropInfoList[nProperties].Name = rtl::OUString(
                    RTL_CONSTASCII_USTRINGPARAM( "org.openoffice.Inet/Settings/ooInetHTTPProxyName") );
                aPropInfoList[nProperties].Type = rtl::OUString( 
                    RTL_CONSTASCII_USTRINGPARAM( "string" ) );
                aPropInfoList[nProperties].Protected = sal_False;
                aPropInfoList[nProperties++].Value = uno::makeAny( OStringToOUString( 
                    rtl::OString( gconf_value_get_string(aGconfValue) ),
                    RTL_TEXTENCODING_UTF8 ) );
            }
            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/http_proxy/port" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aPropInfoList[nProperties].Name = rtl::OUString(
                    RTL_CONSTASCII_USTRINGPARAM( "org.openoffice.Inet/Settings/ooInetHTTPProxyPort") );
                aPropInfoList[nProperties].Type = rtl::OUString( 
                    RTL_CONSTASCII_USTRINGPARAM( "int" ) );
                aPropInfoList[nProperties].Protected = sal_False;
                aPropInfoList[nProperties++].Value = uno::makeAny( 
                    (sal_Int32) gconf_value_get_int(aGconfValue) );
            }
            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/proxy/ftp_host" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aPropInfoList[nProperties].Name = rtl::OUString(
                    RTL_CONSTASCII_USTRINGPARAM( "org.openoffice.Inet/Settings/ooInetFTPProxyName") );
                aPropInfoList[nProperties].Type = rtl::OUString( 
                    RTL_CONSTASCII_USTRINGPARAM( "string" ) );
                aPropInfoList[nProperties].Protected = sal_False;
                aPropInfoList[nProperties++].Value = uno::makeAny( OStringToOUString( 
                    rtl::OString( gconf_value_get_string(aGconfValue) ),
                    RTL_TEXTENCODING_UTF8 ) );
            }
            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/proxy/ftp_port" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aPropInfoList[nProperties].Name = rtl::OUString(
                    RTL_CONSTASCII_USTRINGPARAM( "org.openoffice.Inet/Settings/ooInetFTPProxyPort") );
                aPropInfoList[nProperties].Type = rtl::OUString( 
                    RTL_CONSTASCII_USTRINGPARAM( "int" ) );
                aPropInfoList[nProperties].Protected = sal_False;
                aPropInfoList[nProperties++].Value = uno::makeAny( 
                    (sal_Int32) gconf_value_get_int(aGconfValue) );
            }
        }
        else if( aMode.equals("none") )
        {
            aPropInfoList[nProperties].Name = rtl::OUString(
                RTL_CONSTASCII_USTRINGPARAM( "org.openoffice.Inet/Settings/ooInetProxyType") );
            aPropInfoList[nProperties].Type = rtl::OUString( 
                RTL_CONSTASCII_USTRINGPARAM( "int" ) );
            aPropInfoList[nProperties].Protected = sal_False;
            aPropInfoList[nProperties++].Value = uno::makeAny( (sal_Int32) 0 );
        }
    }

    if( nProperties > 0 )
    {
      aPropInfoList.realloc(nProperties);
      m_xLayerContentDescriber->describeLayer(xHandler, aPropInfoList);
    }
}

//------------------------------------------------------------------------------

rtl::OUString SAL_CALL GconfInetLayer::getTimestamp(void) 
    throw (uno::RuntimeException)
{
    // Return a hash of the values as timestamp to avoid regenerating 
    // the binary cache on each office launch.
    
    rtl::OStringBuffer aTimeStamp;
    
    GError* aError;
    GConfClient* aClient = GconfBackend::getGconfClient();
    GConfValue* aGconfValue;
    
    aError = NULL;
    aGconfValue = gconf_client_get(aClient, "/system/proxy/mode" , &aError);
    
    if( aError == NULL && aGconfValue != NULL )
    {
        rtl::OString aMode(gconf_value_get_string(aGconfValue));
        
        aTimeStamp.append(aMode);
        
        if( aMode.equals("manual") )
        {            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/http_proxy/host" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aTimeStamp.append( gconf_value_get_string(aGconfValue) );
            }
            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/http_proxy/port" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aTimeStamp.append( rtl::OString::valueOf( 
                    (sal_Int32) gconf_value_get_int(aGconfValue) ) );
            }
            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/proxy/ftp_host" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aTimeStamp.append( gconf_value_get_string(aGconfValue) );
            }
            
            aError = NULL;
            aGconfValue = gconf_client_get(aClient, "/system/proxy/ftp_port" , &aError);
            
            if( aError == NULL && aGconfValue != NULL ) {
                aTimeStamp.append( rtl::OString::valueOf( 
                    (sal_Int32) gconf_value_get_int(aGconfValue) ) );
            }
        }
    }
    
    return rtl::OUString::valueOf( aTimeStamp.makeStringAndClear().hashCode() );
}
