/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CallDBTypeWizDlgSetup.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:45:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DBU_REGHELPER_HXX_
#include "dbu_reghelper.hxx"
#endif
#ifndef DBAUI_DBTYPEWIZDLGSETUP_HXX
#include "DBTypeWizDlgSetup.hxx"
#endif
#ifndef DBAUI_CALLDBTYPEWIZDLGSETUP_HXX
#include "CallDBTypeWizDlgSetup.hxx"
#endif
#ifndef _COM_SUN_STAR_AWT_XDIALOG_HPP_
#include <com/sun/star/awt/XDialog.hpp>
#endif

#ifndef DBAUI_DBWIZSETUP_HXX
#include "dbwizsetup.hxx"
#endif

using namespace dbaui;

extern "C" void SAL_CALL createRegistryInfo_OCallDBTypeWizDialogSetup()
{
	static OMultiInstanceAutoRegistration< OCallDBTypeWizDialogSetup > aAutoRegistration;
}

//.........................................................................
namespace dbaui
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::beans;
    using namespace ::com::sun::star::task;
    using namespace ::com::sun::star::ui::dialogs;
//=========================================================================
//-------------------------------------------------------------------------


OCallDBTypeWizDialogSetup::OCallDBTypeWizDialogSetup(const Reference< XMultiServiceFactory >& _rxORB)
	:ODialogJobExecutor_BASE()
{
    m_xORB = _rxORB;
}

//-------------------------------------------------------------------------
Reference< XInterface > SAL_CALL OCallDBTypeWizDialogSetup::Create(const Reference< XMultiServiceFactory >& _rxFactory)
{
//    return *(new OCallDBTypeWizDialogSetup(_rxFactory));
	OCallDBTypeWizDialogSetup* pdbt = new OCallDBTypeWizDialogSetup(_rxFactory);
    pdbt->trigger(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("start")));
    return *pdbt;
}

//-------------------------------------------------------------------------
::comphelper::StringSequence OCallDBTypeWizDialogSetup::getSupportedServiceNames_Static() throw(RuntimeException)
{
	::comphelper::StringSequence aSupported(1);
	aSupported.getArray()[0] = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.sdb.CallDatabaseWizardDialog"));
	return aSupported;
}

//-------------------------------------------------------------------------
::rtl::OUString OCallDBTypeWizDialogSetup::getImplementationName_Static() throw(RuntimeException)
{
	return ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("org.openoffice.comp.dbu.OCallDBTypeWizDialogSetup"));
}


//------------------------------------------------------------------------------
void SAL_CALL OCallDBTypeWizDialogSetup::trigger( const ::rtl::OUString& _rEvent ) throw (::com::sun::star::uno::RuntimeException)
{
    Reference < XInterface > xDBContext = m_xORB->createInstance(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.sdb.OfficeDatabaseDocument")));
   	Sequence<Any> aSequence(1);
	PropertyValue aPropertyValue;
    Any aTmp;
    aTmp <<= xDBContext;
    aPropertyValue.Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("InitialSelection"));
    aPropertyValue.Value = aTmp;
	aSequence[0] <<= aPropertyValue;
    Reference < XInitialization > xDBWizard(m_xORB->createInstance(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.sdb.DatabaseWizardDialog"))), UNO_QUERY);
    xDBWizard->initialize(aSequence);
    Reference <com::sun::star::ui::dialogs::XExecutableDialog> xDBWizardExecute( xDBWizard, UNO_QUERY );
    xDBWizardExecute->execute();
}


//.........................................................................
}	// namespace dbaui
//.........................................................................

