/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: uidldisp.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:28:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ADC_UIDLDISP_HXX
#define ADC_UIDLDISP_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS

namespace ary
{
namespace info
{
class CodeInformation;
}   // namespace info
}   // namespace ary

namespace ary
{
namespace uidl
{
class CeNamespace;
}   // namespace uidl
}   // namespace ary


namespace display
{
class CorporateFrame;
}

namespace csi
{
namespace uidl
{

class Module;
class Service;
class Interface;
class Struct;
class Exception;
class Enum;
class Typedef;
class ConstantsGroup;

class Constant;
class Property;
class Function;
class Attribute;
class StructElement;
class EnumValue;


using ary::info::CodeInformation;



class Display
{
  public:
	virtual				~Display() {}

	virtual void		WriteGlobalIndices() = 0;

	virtual void	 	InitModule(
							const char *		i_sModule,
							const char *		i_sPath,
							uintt				i_nDepth ) = 0;

	virtual void	  	Display_Module(
							const ary::uidl::CeNamespace &
												i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Service(
							const Service &		i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Interface(
							const Interface & 	i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Struct(
							const Struct &		i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Exception(
							const Exception &	i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Enum(
							const Enum &		i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Typedef(
							const Typedef &		i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_ConstantsGroup(
							const ConstantsGroup &
												i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Constant(
							const Constant & 	i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Property(
							const Property & 	i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Function(
							const Function &	i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_Attribute(
							const Attribute &	i_rData,
							const CodeInformation *
												i_rDocu ) = 0;
	virtual void	  	Display_StructElement(
							const StructElement &
												i_rData,
							const CodeInformation *
												i_rDocu  ) = 0;
	virtual void	  	Display_EnumValue(
							const EnumValue &	i_rData,
							const CodeInformation *
												i_rDocu  ) = 0;
};

DYN Display *		Create_HtmlDisplay_(
						const udmstri &		i_sOutputDirectory,
						const display::CorporateFrame &
											i_rFrame );
}   // namespace uidl
}   // namespace csi

#endif

