/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: l_rwgate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:22:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_LOC_L_RWGATE_HXX
#define ARY_LOC_L_RWGATE_HXX


#include <ary/ids.hxx>


namespace csv
{
    namespace ploc
    {
        class Path;
        class DirectoryChain;
    }
}

namespace ary
{
namespace loc
{
    class LocationRoot;
    class SourceCodeFile;

class RwGate
{
  public:
	// LIFECYCLE
	virtual             ~RwGate() {}

    // OPERATIONS
    ary::loc::LocationRoot &
                        CheckIn_Root(
                            const csv::ploc::Path &
                                                i_rPath );
    ary::loc::SourceCodeFile &
                        CheckIn_File(
                            const udmstri &     i_sFileName,
                            const csv::ploc::DirectoryChain &
                                                i_rFileSubPath,
                            Lid                 i_nRootDir );
  private:
    virtual ary::loc::LocationRoot &
                        do_CheckIn_Root(
                            const csv::ploc::Path &
                                                i_rPath ) = 0;
    virtual ary::loc::SourceCodeFile &
                        do_CheckIn_File(
                            const udmstri &     i_sFileName,
                            const csv::ploc::DirectoryChain &
                                                i_rFileSubPath,
                            Lid                 i_nRootDir ) = 0;
};


// IMPLEMENTATION
inline ary::loc::LocationRoot &
RwGate::CheckIn_Root( const csv::ploc::Path & i_rPath )
    { return do_CheckIn_Root(i_rPath); }
inline ary::loc::SourceCodeFile &
RwGate::CheckIn_File( const udmstri &                     i_sFileName,
                      const csv::ploc::DirectoryChain &   i_rFileSubPath,
                      Lid                                 i_nRootDir )
    { return do_CheckIn_File( i_sFileName, i_rFileSubPath, i_nRootDir ); }



} // namespace loc
} // namespace ary



#endif

