/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_imgmgr.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: kz $ $Date: 2006/01/05 17:51:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>

// auto strip #ifndef _STREAM_HXX //autogen
// auto strip #include <tools/stream.hxx>
// auto strip #endif
// auto strip #ifndef _SV_WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _SV_BITMAP_HXX
// auto strip #include <vcl/bitmap.hxx>
// auto strip #endif

// auto strip #include <tools/link.hxx>
// auto strip #include <tools/list.hxx>
// auto strip #include <tools/urlobj.hxx>
// auto strip #include <unotools/ucbstreamhelper.hxx>
#include <svtools/miscopt.hxx>
// auto strip #include <framework/imagesconfiguration.hxx>

#pragma hdrstop

// auto strip #include "imgmgr.hxx"
#include "sfx.hrc"
// auto strip #include "app.hxx"
// auto strip #include "sfxresid.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
// auto strip #include "bindings.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "statcach.hxx"
// auto strip #include "module.hxx"
#include "sfxtypes.hxx"
#include "viewfrm.hxx"
#include "objsh.hxx"
#include "cfgmgr.hxx"
// auto strip #include "macrconf.hxx"
namespace binfilter {

static const USHORT nVersion = 5;
/*?*/ DECLARE_LIST( LinkList, Link * )//STRIP008 ;

/*?*/ class SfxToolBoxArr_Impl;
/*?*/ struct SfxImageManagerData_Impl
/*?*/ {
/*?*/     sal_Int16       nOutStyle;
/*?*/     sal_Int16       nSet;
/*?*/     SfxToolBoxArr_Impl* pToolBoxList;
/*?*/     SfxObjectShell* pDoc;
/*?*/ };

/*?*/ class SfxBitmapList_Impl;
/*?*/ class SfxImageManager_Impl : public SfxConfigItem
/*?*/ {
/*?*/ public:
/*?*/     LinkList			m_aList;
/*?*/     SvtMiscOptions		m_aOpt;
/*?*/ 	SfxBitmapList_Impl* m_pUserDefList;
/*?*/ 	ImageList*			m_pUserImageList;
/*?*/ 	ImageList*			m_pHCUserImageList;
/*?*/ 	int					m_nUserRef;
/*?*/ 
/*?*/ 	void            MakeDefaultImageList( BOOL bHiContrast = FALSE );
/*?*/ 	void 			MakeUserList();
/*?*/ 	void			RebuildUserList();
/*?*/ 	Image           GetImage( USHORT nId, SfxModule*, BOOL bBig, BOOL bHiContrast ) const;
/*?*/ 	Image           SeekImage(USHORT nId, SfxModule* pModule, BOOL bHiContrast ) const;
/*?*/ 	Image           GetDefaultImage( USHORT nId, SfxModule*, BOOL bBig, BOOL bHiContrast ) const;
/*?*/ 
/*?*/     virtual BOOL    ReInitialize();
/*?*/ 	int 			Load( SvStream& );
/*?*/ 	BOOL			Store( SvStream& );
/*?*/ 	virtual	void	UseDefault();
/*?*/     virtual String  GetStreamName() const;
/*?*/ 	virtual int 	Load(SotStorage&);
/*?*/ 	virtual BOOL	Store(SotStorage&);
/*?*/     void            AddLink( const Link& );
/*?*/     void            RemoveLink( const Link& );
/*?*/     void            LoadBitmap( Bitmap&, SotStorage&, const String& );
/*?*/ 
/*?*/                     SfxImageManager_Impl( SfxConfigManager* pCfg );
/*?*/ 					~SfxImageManager_Impl();
/*?*/ };

// elements common to all ImageManager instances
static ImageList* pImageListSmall=0;
static ImageList* pImageListBig=0;
static ImageList* pImageListHiSmall=0;
static ImageList* pImageListHiBig=0;
//static ImageList* pOffImageList;
//static ImageList* pOffHiImageList;
static ImageList* pImageList;
static ImageList* pHiImageList;
static SfxImageManager_Impl* pGlobalConfig=NULL;
static int nRef=0;
static int nGlobalRef=0;

// we need a static list of all pImp instances, so all operations that should change all instances can be performed
// which operations ?!

/*N*/ ImageList* GetImageList( BOOL bBig, BOOL bHiContrast = FALSE )
/*N*/ {
/*N*/ 	// Has to be changed if we know how the IDs are named!!!
/*N*/ 	ImageList*& rpList = bBig ? ( bHiContrast ? pImageListHiBig : pImageListBig ) :
/*N*/ 								( bHiContrast ? pImageListHiSmall : pImageListSmall );
/*N*/     if ( !rpList )
/*N*/     {
/*N*/         ResMgr *pResMgr = Resource::GetResManager();
/*N*/         ResId aResId( bBig ? ( bHiContrast ? RID_DEFAULTIMAGELIST_LCH : RID_DEFAULTIMAGELIST_LC ) :
/*N*/ 							 ( bHiContrast ? RID_DEFAULTIMAGELIST_SCH : RID_DEFAULTIMAGELIST_SC ));
/*N*/ 
/*N*/ 		aResId.SetRT( RSC_IMAGELIST );
/*N*/ 
// #i30187# ImageList is not needed for binfilter/*N*/         DBG_ASSERT( pResMgr->IsAvailable(aResId), "No default ImageList!" );
/*N*/ 
/*N*/         if ( pResMgr->IsAvailable(aResId) )
/*N*/             rpList = new ImageList( aResId );
/*N*/         else
/*?*/             rpList = new ImageList();
/*N*/ 	}
/*N*/ 
/*N*/     return rpList;
/*N*/ }

//=========================================================================

/*N*/ sal_Int16 SfxImageManager::GetCurrentSymbolsSize()
/*N*/ {
/*N*/     return SvtMiscOptions().GetCurrentSymbolsSize();
/*N*/ }

//=========================================================================

// Enth"alt eine Kombination aus Bitmap und zugeordneter SlotId
/*?*/ struct ToolboxBitmap_Impl
/*?*/ {
/*?*/ 	USHORT	nId;
/*?*/ 	Bitmap*	pBitmap;
/*?*/ 
/*?*/ 	ToolboxBitmap_Impl( USHORT n, const Bitmap& rBmp ) : nId( n )
/*?*/ 	{
/*?*/ 		pBitmap = new Bitmap( rBmp );
/*?*/ 	}
/*?*/ 
/*?*/ 	~ToolboxBitmap_Impl() { delete pBitmap; }
/*?*/ };

// Enth"alt einen Ptr auf eine registrierte Toolbox und Flags f"ur die
// Ereignisse, bei denen die Toolbox upgedatet werden soll
/*?*/ struct ToolBoxInf_Impl
/*?*/ {
/*?*/ 	SfxToolBoxManager*	pMgr;
/*?*/ 	SfxModule*	pModule;
/*?*/ 	ToolBox *pToolBox;
/*?*/ 	USHORT	nFlags;
/*?*/ };

//-------------------------------------------------------------------------

/*?*/ DECL_PTRARRAY( SfxBitmapArr_Impl, ToolboxBitmap_Impl*, 4, 4 )//STRIP008 ;
/*?*/ DECL_PTRARRAY( SfxToolBoxArr_Impl, ToolBoxInf_Impl*, 4, 4 )//STRIP008 ;

//-------------------------------------------------------------------------

// Liste der geladenen Userdef-Bitmaps
/*?*/ class SfxBitmapList_Impl
/*?*/ {
/*?*/ 	SfxBitmapArr_Impl*	pList;
/*?*/ 
/*?*/ public:
/*?*/ friend SvStream& operator >> (SvStream& rStream, SfxBitmapList_Impl& rList);
/*?*/ friend SvStream& operator << (SvStream& rStream, const SfxBitmapList_Impl& rList);
/*?*/ 
/*?*/ 	SfxBitmapList_Impl()
/*?*/ 			{ pList = new SfxBitmapArr_Impl; }
/*?*/ 
/*?*/ 	~SfxBitmapList_Impl()
/*?*/ 			{
/*?*/ 				for (USHORT n=0; n<pList->Count(); n++)
/*?*/ 					delete (*pList)[n];
/*?*/ 				delete pList;
/*?*/ 			}
/*?*/ 
/*?*/ 	USHORT	GetBitmapCount() const
/*?*/ 			{ return pList->Count(); }
/*?*/ 
/*?*/ 	USHORT	GetBitmapId(USHORT n) const
/*?*/ 			{ return (*pList)[n]->nId; }
/*?*/ 
/*?*/ 	USHORT  GetBitmapPos(USHORT nId) const;
/*?*/ 	Bitmap* GetBitmap(USHORT nId) const;
/*?*/ 	void	AddBitmap (USHORT nId, const Bitmap& rpBmp);
/*?*/ 	void	ReplaceBitmap (USHORT nId, const Bitmap& rpBmp);
/*?*/ 	void	RemoveBitmap (USHORT nId);
/*?*/ };

//=========================================================================

/*  [Beschreibung]

	Liefert die Position einer Bitmap in der internen Bitmapliste
*/

/*?*/ USHORT SfxBitmapList_Impl::GetBitmapPos( USHORT nId ) const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 /*?*/ 	USHORT nPos;
//STRIP001 /*?*/ 	for ( nPos=0; nPos<pList->Count(); nPos++ )
//STRIP001 /*?*/ 		if ( (*pList)[nPos]->nId == nId ) break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	if ( nPos < pList->Count() )
//STRIP001 /*?*/ 		return nPos;
//STRIP001 /*?*/ 	else
//STRIP001 /*?*/ 		return USHRT_MAX;
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Liefert die Bitmap an der "uebergebenen Position der internen Bitmapliste
*/

/*?*/ Bitmap* SfxBitmapList_Impl::GetBitmap(USHORT nId) const
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001 	for ( nPos=0; nPos<pList->Count(); nPos++ )
//STRIP001 		if ( (*pList)[nPos]->nId == nId ) break;
//STRIP001 
//STRIP001 	if ( nPos < pList->Count() )
//STRIP001 		return (*pList)[nPos]->pBitmap;
//STRIP001 	else
//STRIP001 		return 0;
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	F"ugt der internen Bitmapliste eine Bitmap hinzu, die f"ur die "ubergebene
	SlotId registriert wird. Die Bitmap geht in den Besitz des ImageManagers
	"uber.
*/

/*?*/ void SfxBitmapList_Impl::AddBitmap( USHORT nId, const Bitmap& rBmp )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	for ( USHORT nPos=0; nPos<pList->Count(); nPos++ )
//STRIP001 		if ( (*pList)[nPos]->nId == nId ) break;
//STRIP001 
//STRIP001 	DBG_ASSERT( nPos>=pList->Count(), "Bitmap mit dieser Id schon vorhanden!" );
//STRIP001 
//STRIP001 	ToolboxBitmap_Impl *pTbBmp = new ToolboxBitmap_Impl( nId, rBmp );
//STRIP001 	pList->Append( pTbBmp );
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Ersetzt die Bitmap in der internen Bitmapliste, die f"ur die "ubergebene
	SlotId registriert ist, durch die "ubergebene Bitmap.
	Die Bitmap geht in den Besitz des ImageManagers	"uber.
*/

/*?*/ void SfxBitmapList_Impl::ReplaceBitmap( USHORT nId, const Bitmap& rBmp )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	RemoveBitmap( nId );
//STRIP001 	AddBitmap( nId, rBmp );
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Entfernt die Bitmap in der internen Bitmapliste, die f"ur die "ubergebene
	SlotId registriert ist.
	Da die Bitmap dem ImageManagers	geh"ort, wird sie zerst"ort.
*/

/*?*/ void SfxBitmapList_Impl::RemoveBitmap( USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001 	for (nPos=0; nPos<pList->Count(); nPos++)
//STRIP001 		if ((*pList)[nPos]->nId == nId) break;
//STRIP001 
//STRIP001 	DBG_ASSERT(nPos<pList->Count(), "Bitmap mit dieser Id unbekannt!");
//STRIP001 
//STRIP001 	if (nPos<pList->Count())
//STRIP001 	{
//STRIP001 		delete (*pList)[nPos];
//STRIP001 		pList->Remove(nPos);
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Liest die interne Bitmapliste aus einem Stream.
*/

/*?*/ SvStream& operator >> (SvStream& rStream, SfxBitmapList_Impl& rList)
/*?*/ {
/*?*/ 	USHORT nCount, nId;
/*?*/ 	rStream >> nCount;
/*?*/ 	for (USHORT n=0; n<nCount; n++)
/*?*/ 	{
/*?*/ 		Bitmap aBmp;
/*?*/ 		rStream >> nId >> aBmp;
/*?*/ 		rList.AddBitmap(nId, aBmp);
/*?*/ 	}
/*?*/ 
/*?*/ 	return rStream;
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Speichert die interne Bitmapliste in einem Stream,
*/

/*?*/ SvStream& operator << (SvStream& rStream, const SfxBitmapList_Impl& rList)
/*?*/ {
/*?*/ 	rStream << rList.GetBitmapCount();
/*?*/ 	for (USHORT n=0; n<rList.GetBitmapCount(); n++)
/*?*/ 		rStream << (*rList.pList)[n]->nId << *((*rList.pList)[n]->pBitmap);
/*?*/ 
/*?*/ 	return rStream;
/*?*/ }

/*N*/ SfxImageManager_Impl::SfxImageManager_Impl( SfxConfigManager* pCfgMgr )
/*N*/ 	: SfxConfigItem( SFX_ITEMTYPE_IMAGELIST, pCfgMgr )
/*N*/ 	, m_pUserDefList( 0 )
/*N*/ 	, m_pUserImageList( 0 )
/*N*/ 	, m_pHCUserImageList( 0 )
/*N*/ {
/*N*/ //    SetInternal( TRUE );
/*N*/     Initialize();
/*N*/ }

/*N*/ SfxImageManager_Impl::~SfxImageManager_Impl()
/*N*/ {
/*N*/ 	delete m_pUserDefList;
/*N*/ 	delete m_pUserImageList;
/*N*/ 	delete m_pHCUserImageList;
/*N*/ 
/*N*/ 	if ( this == pGlobalConfig )
/*N*/ 		pGlobalConfig = NULL;
/*N*/ }

/*N*/ void SfxImageManager_Impl::AddLink( const Link& rLink )
/*N*/ {
/*N*/     m_aList.Insert( new Link( rLink ) );
/*N*/ }

/*N*/ void SfxImageManager_Impl::RemoveLink( const Link& rLink )
/*N*/ {
/*N*/     for ( USHORT n=0; n<m_aList.Count(); n++ )
/*N*/     {
/*N*/         if ( (*m_aList.GetObject(n) ) == rLink )
/*N*/         {
/*N*/             delete m_aList.Remove(n);
/*N*/             break;
/*N*/         }
/*N*/     }
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxImageManager_Impl::LoadBitmap( Bitmap& rBmp, SotStorage& rStorage, const String& rURL )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     // locate and open bitmap for ImageList
//STRIP001     SotStorageStreamRef xBitmapStream;
//STRIP001     SvStream* pStream = NULL;
//STRIP001 
//STRIP001     // bitmap may be internal (relative URL) or external (absolute URL)
//STRIP001     INetURLObject aObj( rURL );
//STRIP001     if ( aObj.GetProtocol() != INET_PROT_NOT_VALID )
//STRIP001     {
//STRIP001         // get external stream for bitmap
//STRIP001         pStream = ::utl::UcbStreamHelper::CreateStream( aObj.GetMainURL( INetURLObject::NO_DECODE ), STREAM_STD_READ );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // find internal stream by parsing URL, starting in the root of rStorage
//STRIP001         SotStorageRef xBitmapStorage = &rStorage;
//STRIP001 
//STRIP001         // every string followed by a slash is a directory
//STRIP001         USHORT nTokenCount = rURL.GetTokenCount( '/' );
//STRIP001 
//STRIP001         // open directories
//STRIP001         for ( USHORT nToken=0; nToken<nTokenCount-1; nToken++ )
//STRIP001             xBitmapStorage = xBitmapStorage->OpenSotStorage( rURL.GetToken( nToken, '/' ), STREAM_STD_READ );
//STRIP001 
//STRIP001         // now get the stream
//STRIP001         xBitmapStream = xBitmapStorage->OpenSotStream( rURL.GetToken( nToken, '/' ), STREAM_STD_READ );
//STRIP001         pStream = xBitmapStream;
//STRIP001     }
//STRIP001 
//STRIP001     *pStream >> rBmp;
//STRIP001     if ( !xBitmapStream.Is() )
//STRIP001         DELETEZ( pStream );
/*?*/ }

/*?*/ int SfxImageManager_Impl::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	SotStorageStreamRef xStream =
//STRIP001             rStorage.OpenSotStream( GetStreamName(), STREAM_STD_READ );
//STRIP001 	if ( xStream->GetError() )
//STRIP001 		return ERR_READ;
//STRIP001     else
//STRIP001     {
//STRIP001         SfxMacroConfig* pCfg = SfxMacroConfig::GetOrCreate();
//STRIP001         ::framework::ImageListsDescriptor aDescriptor;
//STRIP001         if ( !::framework::ImagesConfiguration::LoadImages( *xStream, aDescriptor ) )
//STRIP001             return ERR_READ;
//STRIP001 
//STRIP001         if ( !aDescriptor.pImageList || !aDescriptor.pImageList->Count() )
//STRIP001             return ERR_READ;
//STRIP001 
//STRIP001         ::framework::ImageListItemDescriptor* pList = aDescriptor.pImageList->GetObject(0);
//STRIP001         USHORT nCount = pList->pImageItemList->Count();
//STRIP001         if ( !nCount )
//STRIP001             return ERR_READ;
//STRIP001 
//STRIP001         Bitmap aBmp;
//STRIP001 		Bitmap aHCBmp;
//STRIP001         LoadBitmap( aBmp, rStorage, pList->aURL );
//STRIP001 
//STRIP001 		if ( pList->aHighContrastURL.Len() == 0 )
//STRIP001 		{
//STRIP001 			// Use normal images for high contrast mode as we need the same number of images
//STRIP001 			// for the high contrast image list!! The normal case for 6.1 should be that both
//STRIP001 			// lists are filled, so this document was created by 6.0.
//STRIP001 			// #98979#
//STRIP001 			LoadBitmap( aHCBmp, rStorage, pList->aURL );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			LoadBitmap( aHCBmp, rStorage, pList->aHighContrastURL );
//STRIP001 
//STRIP001         // get the Ids of the ImageList
//STRIP001         USHORT* pIds = new USHORT[nCount];
//STRIP001         for ( USHORT i=0; i<nCount; i++ )
//STRIP001         {
//STRIP001             const ::framework::ImageItemDescriptor* pItem = pList->pImageItemList->GetObject(i);
//STRIP001             if ( pItem->aCommandURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
//STRIP001             {
//STRIP001                 pIds[i] = (USHORT) pItem->aCommandURL.Copy( 5 ).ToInt32();
//STRIP001             }
//STRIP001             else if ( pItem->aCommandURL.Len() )
//STRIP001             //else if ( pItem->aCommandURL.CompareToAscii("macro:",6) == COMPARE_EQUAL )
//STRIP001             {
//STRIP001                 SfxMacroInfo aInfo( pItem->aCommandURL );
//STRIP001                 pCfg->GetSlotId( &aInfo );
//STRIP001                 pIds[i] = aInfo.GetSlotId();
//STRIP001             }
//STRIP001         }

//STRIP001         delete m_pUserImageList;
//STRIP001 		delete m_pHCUserImageList;
//STRIP001 
//STRIP001 		if ( pList->nMaskMode = ::framework::ImageMaskMode_Color )
//STRIP001         {
//STRIP001 			m_pUserImageList = new ImageList( aBmp, pList->aMaskColor, nCount, pIds );
//STRIP001 			m_pHCUserImageList = new ImageList( aHCBmp, pList->aMaskColor, nCount, pIds );
//STRIP001 		}
//STRIP001         else
//STRIP001         {
//STRIP001             Bitmap aMask;
//STRIP001             LoadBitmap( aMask, rStorage, pList->aMaskURL );
//STRIP001             m_pUserImageList = new ImageList( aBmp, aMask, nCount, pIds );
//STRIP001 
//STRIP001 			if ( pList->aHighContrastMaskURL.Len() == 0 )
//STRIP001 			{
//STRIP001 				// Use normal mask images for high contrast mode as we need the same number of images
//STRIP001 				// for the high contrast image list!! The normal case for 6.1 should be that both
//STRIP001 				// lists are filled, so this document was created by 6.0.
//STRIP001 				// #98979#
//STRIP001 				LoadBitmap( aMask, rStorage, pList->aMaskURL );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				LoadBitmap( aMask, rStorage, pList->aHighContrastMaskURL );
//STRIP001 
//STRIP001 			m_pHCUserImageList = new ImageList( aHCBmp, aMask, nCount, pIds );
//STRIP001         }
//STRIP001 
//STRIP001         DELETEZ( pIds );
//STRIP001         m_pUserDefList = new SfxBitmapList_Impl;
//STRIP001 
//STRIP001         nCount = aDescriptor.pExternalImageList ? aDescriptor.pExternalImageList->Count() : 0;
//STRIP001         for ( USHORT n=0; n<nCount; n++ )
//STRIP001         {
//STRIP001             ::framework::ExternalImageItemDescriptor* pItem = aDescriptor.pExternalImageList->GetObject(n);
//STRIP001             USHORT nId = 0;
//STRIP001             if ( pItem->aCommandURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
//STRIP001             {
//STRIP001                 nId = (USHORT) pItem->aCommandURL.Copy( 5 ).ToInt32();
//STRIP001             }
//STRIP001             else if ( pItem->aCommandURL.Len() )
//STRIP001             //else if ( pItem->aCommandURL.CompareToAscii("macro:",6) == COMPARE_EQUAL )
//STRIP001             {
//STRIP001                 SfxMacroInfo aInfo( pItem->aCommandURL );
//STRIP001                 pCfg->GetSlotId( &aInfo );
//STRIP001                 nId = aInfo.GetSlotId();
//STRIP001             }
//STRIP001 
//STRIP001             Bitmap aBmp;
//STRIP001             LoadBitmap( aBmp, rStorage, pItem->aURL );
//STRIP001             m_pUserDefList->AddBitmap( nId, aBmp );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     MakeDefaultImageList();
//STRIP001     SetDefault( FALSE );
//STRIP001     return ERR_OK;
/*?*/ }

/*?*/ BOOL SfxImageManager_Impl::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxImageManager_Impl::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return FALSE;
//STRIP001     else
//STRIP001     {
//STRIP001         // create a descriptor
//STRIP001         SfxMacroConfig* pCfg = SfxMacroConfig::GetOrCreate();
//STRIP001         ::framework::ImageListsDescriptor aDescriptor;
//STRIP001         aDescriptor.pImageList = new ::framework::ImageListDescriptor;
//STRIP001 
//STRIP001         // insert userimagelist as one and only list (more is not supported currently, default lists remain in resource)
//STRIP001         ::framework::ImageListItemDescriptor* pList = new ::framework::ImageListItemDescriptor;
//STRIP001         aDescriptor.pImageList->Insert( pList, 0 );
//STRIP001 
//STRIP001         // bitmaps are stored in an internal bitmap directory
//STRIP001         SotStorageRef xBitmapStorage = rStorage.OpenSotStorage( String::CreateFromAscii("Bitmaps"), STREAM_STD_READWRITE );
//STRIP001 
//STRIP001         if ( m_pUserImageList->HasMaskColor() )
//STRIP001         {
//STRIP001             // mask color
//STRIP001             pList->nMaskMode = ::framework::ImageMaskMode_Color;
//STRIP001             pList->aMaskColor = m_pUserImageList->GetMaskColor();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // masking is done by a mask bitmap, store bitmap and set URL
//STRIP001             pList->nMaskMode = ::framework::ImageMaskMode_Bitmap;
//STRIP001 
//STRIP001             pList->aMaskURL = String::CreateFromAscii("Bitmaps/");
//STRIP001             String aStreamName = String::CreateFromAscii("userimagesmask.bmp");
//STRIP001             pList->aMaskURL += aStreamName;
//STRIP001 
//STRIP001             // store bitmap
//STRIP001             SotStorageStreamRef xBitmapStream = xBitmapStorage->OpenSotStream( aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001             *xBitmapStream << m_pUserImageList->GetMaskBitmap();
//STRIP001 
//STRIP001 			pList->aHighContrastMaskURL = String::CreateFromAscii( "Bitmaps/" );
//STRIP001 			aStreamName = String::CreateFromAscii( "hcuserimagesmask.bmp" );
//STRIP001 			pList->aHighContrastMaskURL += aStreamName;
//STRIP001 
//STRIP001             // store bitmap
//STRIP001             xBitmapStream = xBitmapStorage->OpenSotStream( aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001             *xBitmapStream << m_pHCUserImageList->GetMaskBitmap();
//STRIP001         }
//STRIP001 
//STRIP001         // a modified list always contains a userlist
//STRIP001         pList->pImageItemList = new ::framework::ImageItemListDescriptor;
//STRIP001         for ( USHORT i=0; i<m_pUserImageList->GetImageCount(); i++ )
//STRIP001         {
//STRIP001             ::framework::ImageItemDescriptor* pItem = new ::framework::ImageItemDescriptor;
//STRIP001 
//STRIP001             pItem->nIndex = i;
//STRIP001             USHORT nId = m_pUserImageList->GetImageId(i);
//STRIP001             if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001             {
//STRIP001                 const SfxMacroInfo* pInfo = pCfg->GetMacroInfo( nId );
//STRIP001                 pItem->aCommandURL = pInfo->GetURL();
//STRIP001             }
//STRIP001             else if ( nId )
//STRIP001             {
//STRIP001                 pItem->aCommandURL = String::CreateFromAscii("slot:");
//STRIP001                 pItem->aCommandURL += String::CreateFromInt32( nId );
//STRIP001             }
//STRIP001 
//STRIP001             pList->pImageItemList->Insert( pItem, pList->pImageItemList->Count() );
//STRIP001         }
//STRIP001 
//STRIP001         // store URL of bitmap relative to configuration storage; name is "BitmapXXX.bmp", where XXX is an index
//STRIP001         pList->aURL = String::CreateFromAscii("Bitmaps/");
//STRIP001         String aStreamName = String::CreateFromAscii("userimages.bmp");
//STRIP001         pList->aURL += aStreamName;
//STRIP001 
//STRIP001         // store bitmap
//STRIP001         SotStorageStreamRef xBitmapStream = xBitmapStorage->OpenSotStream( aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001         *xBitmapStream << m_pUserImageList->GetBitmap();
//STRIP001 
//STRIP001         // store high contrast URL of bitmap relative to configuration storage; name is "BitmapXXX.bmp", where XXX is an index
//STRIP001         pList->aHighContrastURL = String::CreateFromAscii("Bitmaps/");
//STRIP001         aStreamName = String::CreateFromAscii("hcuserimages.bmp");
//STRIP001         pList->aHighContrastURL += aStreamName;
//STRIP001 
//STRIP001         // store high contrast bitmap
//STRIP001         xBitmapStream = xBitmapStorage->OpenSotStream( aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001         *xBitmapStream << m_pHCUserImageList->GetBitmap();
//STRIP001 
//STRIP001         // collect all external bitmaps
//STRIP001         USHORT nCount = m_pUserDefList->GetBitmapCount();
//STRIP001         if ( nCount )
//STRIP001         {
//STRIP001             aDescriptor.pExternalImageList = new ::framework::ExternalImageItemListDescriptor;
//STRIP001             for ( USHORT i=0; i<nCount; i++ )
//STRIP001             {
//STRIP001                 ::framework::ExternalImageItemDescriptor* pItem = new ::framework::ExternalImageItemDescriptor;
//STRIP001                 USHORT nId = m_pUserDefList->GetBitmapId(i);
//STRIP001                 if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001                 {
//STRIP001                     const SfxMacroInfo* pInfo = pCfg->GetMacroInfo( nId );
//STRIP001                     pItem->aCommandURL = pInfo->GetURL();
//STRIP001                 }
//STRIP001                 else if ( nId )
//STRIP001                 {
//STRIP001                     pItem->aCommandURL = String::CreateFromAscii("slot:");
//STRIP001                     pItem->aCommandURL += String::CreateFromInt32( nId );
//STRIP001                 }
//STRIP001 
//STRIP001                 // store URL of bitmap relative to configuration storage; name is "BitmapXXX.bmp", where XXX is an index
//STRIP001                 pItem->aURL = String::CreateFromAscii("Bitmaps/");
//STRIP001                 String aStreamName = String::CreateFromAscii("image");
//STRIP001                 aStreamName += String::CreateFromInt32(i);
//STRIP001                 aStreamName += String::CreateFromAscii(".bmp");
//STRIP001                 pItem->aURL += aStreamName;
//STRIP001 
//STRIP001                 aDescriptor.pExternalImageList->Insert( pItem, aDescriptor.pExternalImageList->Count() );
//STRIP001 
//STRIP001                 // store bitmap
//STRIP001                 SotStorageStreamRef xBitmapStream = xBitmapStorage->OpenSotStream( aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001                 *xBitmapStream << *m_pUserDefList->GetBitmap( nId );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // store configuration
//STRIP001         xBitmapStorage->Commit();
//STRIP001         return ::framework::ImagesConfiguration::StoreImages( *xStream, aDescriptor );
//STRIP001     }
/*?*/ }


/*?*/ int SfxImageManager_Impl::Load(SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
//STRIP001 	USHORT 	nFileVersion, nSymbolsSize;
//STRIP001     ULONG   nColorCount = Application::GetDefaultDevice()->GetColorCount();
//STRIP001 
//STRIP001 	rStream >> nFileVersion;
//STRIP001 	if ( nFileVersion < nVersion)
//STRIP001 		return SfxConfigItem::WARNING_VERSION;
//STRIP001 
//STRIP001 	rStream >> nSymbolsSize 		// ignore !
//STRIP001 			>> nColorCount;		// evaluate for possible rebuild of userlist
//STRIP001 
//STRIP001 	MakeUserList();
//STRIP001 
//STRIP001 	// Userdef-Listen einlesen
//STRIP001 	rStream >> *m_pUserImageList;
//STRIP001 	rStream >> *m_pUserDefList;
//STRIP001 
//STRIP001 	if ( nColorCount != Application::GetDefaultDevice()->GetColorCount() )
//STRIP001 		RebuildUserList();
//STRIP001 
//STRIP001 //	SvFileStream aBitmapStream( String("d:\\INPUT.BMP"), STREAM_STD_WRITE);
//STRIP001 //	aBitmapStream << pUserImageList->GetBitmap();
//STRIP001 
//STRIP001     SetDefault( FALSE );
//STRIP001     return SfxConfigItem::ERR_OK;
/*?*/ }

/*?*/ BOOL SfxImageManager_Impl::ReInitialize()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001     BOOL bRet = SfxConfigItem::ReInitialize();
//STRIP001     if ( bRet )
//STRIP001         for ( USHORT n=0; n<m_aList.Count(); n++ )
//STRIP001             m_aList.GetObject(n)->Call( this );
//STRIP001     return bRet;
/*?*/ }

//-------------------------------------------------------------------------


/*?*/ BOOL SfxImageManager_Impl::Store(SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 //	SvFileStream aBitmapStream(String("d:\\OUTPUT.BMP"), STREAM_STD_WRITE);
//STRIP001 //	aBitmapStream << pUserImageList->GetBitmap();
//STRIP001 
//STRIP001     rStream << nVersion
//STRIP001             << SfxImageManager::GetCurrentSymbolsSize()
//STRIP001             << Application::GetDefaultDevice()->GetColorCount();
//STRIP001 
//STRIP001 	rStream << *m_pUserImageList;
//STRIP001 	rStream << *m_pUserDefList;
//STRIP001 
//STRIP001 	return TRUE;
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxImageManager_Impl::UseDefault()
/*N*/ {
/*N*/ 	MakeDefaultImageList();
/*N*/ 	MakeUserList();
/*N*/     SetDefault( TRUE );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ String SfxImageManager_Impl::GetStreamName() const
/*N*/ {
/*N*/     return SfxConfigItem::GetStreamName( GetType() );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxImageManager_Impl::MakeUserList()
/*N*/ {
/*N*/ 	if ( m_pUserImageList )
/*N*/ 	{
/*?*/ 		DELETEZ( m_pUserImageList );
/*?*/ 		DELETEZ( m_pHCUserImageList );
/*?*/ 		DELETEZ( m_pUserDefList );
/*N*/ 	}
/*N*/ 
/*N*/     m_pUserDefList = new SfxBitmapList_Impl;
/*N*/     m_pUserImageList = new ImageList;
/*N*/ 	m_pHCUserImageList = new ImageList;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxImageManager_Impl::MakeDefaultImageList( BOOL bHiContrast )
/*N*/ {
/*N*/ 	USHORT nType=0;
/*N*/ 	{
/*N*/ 		switch ( SfxImageManager::GetCurrentSymbolsSize() )
/*N*/ 		{
/*N*/ 			case SFX_SYMBOLS_SIZE_SMALL:
/*N*/ 				if ( bHiContrast )
/*?*/ 					pHiImageList = GetImageList( FALSE, TRUE );
/*N*/ 				else
/*N*/ 					pImageList = GetImageList( FALSE, FALSE );
/*N*/ 				break;
/*N*/ 			case SFX_SYMBOLS_SIZE_LARGE:
/*?*/ 				if ( bHiContrast )
/*?*/ 					pHiImageList = GetImageList( TRUE, TRUE );
/*?*/ 				else
/*?*/ 					pImageList = GetImageList( TRUE, FALSE );
/*N*/ 				break;
/*N*/ 			default:
/*?*/ 				DBG_ERROR("Unknown Symboltype!");
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxImageManager::ExchangeItemImage_Impl( USHORT nId, const Image& rImage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     for ( USHORT n=0; n<pData->pToolBoxList->Count(); n++ )
//STRIP001 	{
//STRIP001         ToolBox *pBox = (*pData->pToolBoxList)[n]->pToolBox;
//STRIP001 		pBox->SetItemImage( nId, rImage );
//STRIP001 	}
/*?*/ }

/*?*/ void SfxImageManager_Impl::RebuildUserList()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Userliste neu aufbauen
//STRIP001 	Color aColor (0xC0, 0xC0, 0xC0);
//STRIP001 	VirtualDevice aDev;
//STRIP001 	Size aNewSize = pImageList->GetImageSize();
//STRIP001 	aDev.SetOutputSizePixel(aNewSize);
//STRIP001 
//STRIP001 	ImageList *pOldList = m_pUserImageList;
//STRIP001 	ImageList *pOldHCList = m_pHCUserImageList;
//STRIP001 	m_pUserImageList = new ImageList( pOldList->GetImageCount() );
//STRIP001 	m_pHCUserImageList = new ImageList( pOldHCList->GetImageCount() );
//STRIP001 
//STRIP001 	for ( USHORT i=0; i<pOldList->GetImageCount(); i++ )
//STRIP001 	{
//STRIP001 		USHORT nId = pOldList->GetImageId( i );
//STRIP001 		Image aImage;
//STRIP001 
//STRIP001 		// Image benutzerdefiniert ?
//STRIP001 		if ( m_pUserDefList->GetBitmapPos(nId) != USHRT_MAX )
//STRIP001 		{
//STRIP001 			Bitmap *pBmp = m_pUserDefList->GetBitmap( nId );
//STRIP001 			if ( pBmp->GetSizePixel() != aNewSize )
//STRIP001 			{
//STRIP001 				aDev.DrawBitmap( Point(), aNewSize, *pBmp );
//STRIP001 				aImage = Image( aDev.GetBitmap(Point(), aNewSize), aColor );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aImage = Image( *pBmp, aColor );
//STRIP001 
//STRIP001 			if ( aImage.GetSizePixel() == aNewSize )
//STRIP001 			{
//STRIP001 				m_pUserImageList->AddImage( nId, aImage );
//STRIP001 				m_pHCUserImageList->AddImage( nId, aImage ); // user images are always used as non high contrast
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aImage = SeekImage( nId, NULL, FALSE ); // look for non high contrast mode image
//STRIP001 			m_pUserImageList->AddImage( nId, aImage );
//STRIP001 			aImage = SeekImage( nId, NULL, TRUE ); // look for high contrast mode image
//STRIP001 			m_pHCUserImageList->AddImage( nId, aImage );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pOldList;
//STRIP001 	delete pOldHCList;
/*?*/ }

/*N*/ Image SfxImageManager_Impl::GetImage( USHORT nId, SfxModule *pModule, BOOL bBig, BOOL bHiContrast ) const
/*N*/ {
/*N*/ 	if ( !pModule )
/*N*/ 		pModule = SFX_APP()->GetActiveModule();
/*N*/ 	ImageList *pList=0;
/*N*/ 	if ( pModule )
/*N*/         pList = pModule->GetImageList_Impl( bBig, bHiContrast );
/*N*/ 
/*N*/ 	if ( bHiContrast )
/*N*/ 	{
/*?*/ 		if ( m_pHCUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pHCUserImageList->GetImage( nId );
/*?*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return pList->GetImage( nId );
/*?*/ 		else
/*?*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( m_pUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pUserImageList->GetImage( nId );
/*N*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 			return pList->GetImage( nId );
/*N*/ 		else
/*N*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ }

/*?*/ Image SfxImageManager_Impl::GetDefaultImage(USHORT nId, SfxModule* pMod, BOOL bBig, BOOL bHiContrast ) const
/*?*/ {
/*?*/ 	if ( !pMod )
/*?*/ 		pMod = SFX_APP()->GetActiveModule();
/*?*/ 	ImageList *pList=0;
/*?*/ 	if ( pMod )
/*?*/         pList = pMod->GetImageList_Impl( bBig, bHiContrast );
/*?*/ 
/*?*/ 	if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 		return pList->GetImage( nId );
/*?*/ 	else
/*?*/ 		return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*?*/ }

/*N*/ Image SfxImageManager_Impl::SeekImage( USHORT nId, SfxModule *pModule, BOOL bHiContrast ) const
/*N*/ {
/*N*/ 	BOOL bBig = ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE );
/*N*/ 
/*N*/ 	if ( !pModule )
/*?*/ 		pModule = SFX_APP()->GetActiveModule();
/*N*/ 	ImageList *pList=0;
/*N*/ 	if ( pModule )
/*N*/         pList = pModule->GetImageList_Impl( bBig, bHiContrast );
/*N*/ 
/*N*/ 	if ( bHiContrast )
/*N*/ 	{
/*?*/ 		if ( m_pHCUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pHCUserImageList->GetImage( nId );
/*?*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return pList->GetImage( nId );
/*?*/ 		else
/*?*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( m_pUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*?*/ 			return m_pUserImageList->GetImage( nId );
/*N*/ 		else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 			return pList->GetImage( nId );
/*N*/ 		else
/*?*/ 			return GetImageList( bBig, bHiContrast )->GetImage( nId );
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxImageManager::SfxImageManager( SfxObjectShell* pDoc )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/     // every ImageManager has its own list of toolboxes, so even if it gets a new configuration, the list
/*N*/     // remains the same!
/*N*/     pData = new SfxImageManagerData_Impl;
/*N*/     pData->pToolBoxList = new SfxToolBoxArr_Impl;
/*N*/     pData->pDoc = pDoc;
/*N*/ 
/*N*/ 	if ( pDoc && pDoc->GetConfigManager() && pDoc->GetConfigManager()->HasConfigItem(SFX_ITEMTYPE_IMAGELIST) )
/*N*/ 	{
/*?*/ 		pImp = new SfxImageManager_Impl( pDoc->GetConfigManager() );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( !pGlobalConfig )
/*N*/             pGlobalConfig = new SfxImageManager_Impl( SFX_APP()->GetConfigManager_Impl() );
/*N*/ 		pImp = pGlobalConfig;
/*N*/         nGlobalRef++;
/*N*/ 	}
/*N*/ 
/*N*/     // internal cached data for comparision in callback
/*N*/     pData->nSet = SfxImageManager::GetCurrentSymbolsSize();
/*N*/     pData->nOutStyle = pImp->m_aOpt.GetToolboxStyle();
/*N*/ 
/*N*/     // register callback for changes of SymbolsSize or ToolboxStyle
/*N*/     pImp->m_aOpt.AddListener( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/     Application::AddEventListener( LINK( this, SfxImageManager, SettingsChanged_Impl ) );
/*N*/ 
/*N*/ //    SetInternal( TRUE );
/*N*/     nRef++;
/*N*/     pImp->AddLink( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxImageManager::~SfxImageManager()
/*N*/ {
/*N*/     pImp->RemoveLink( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/ 
/*N*/     if ( !--nRef )
/*N*/     {
/*N*/         DELETEZ( pImageListSmall );
/*N*/         DELETEZ( pImageListBig );
/*N*/ 		DELETEZ( pImageListHiSmall );
/*N*/ 		DELETEZ( pImageListHiBig );
/*N*/     }
/*N*/ 
/*N*/     DELETEZ( pData->pToolBoxList );
/*N*/     pImp->m_aOpt.RemoveListener( LINK( this, SfxImageManager, OptionsChanged_Impl ) );
/*N*/     Application::RemoveEventListener( LINK( this, SfxImageManager, SettingsChanged_Impl ) );
/*N*/     if ( pImp != pGlobalConfig || !--nGlobalRef )
/*N*/ 		delete pImp;
/*N*/     delete pData;
/*N*/ }

//STRIP001 SfxConfigManager* SfxImageManager::GetConfigManager()
//STRIP001 {
//STRIP001 	return pImp->GetConfigManager();
//STRIP001 }

//STRIP001 USHORT SfxImageManager::GetType() const
//STRIP001 {
//STRIP001 	return pImp->GetType();
//STRIP001 }

/*?*/ BOOL SfxImageManager::Import( SvStream& rInStream, SotStorage& rOutStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	SfxImageManager_Impl aImpl( NULL );
//STRIP001     if ( aImpl.Load( rInStream ) == SfxConfigItem::ERR_OK )
//STRIP001         return aImpl.Store( rOutStorage );
//STRIP001     return FALSE;
/*?*/ }

/*?*/ BOOL SfxImageManager::Export( SotStorage& rInStorage, SvStream& rOutStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	SfxImageManager_Impl aImpl( NULL );
//STRIP001     if ( aImpl.Load( rInStorage ) == SfxConfigItem::ERR_OK )
//STRIP001         return aImpl.Store( rOutStream );
//STRIP001     return FALSE;
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Nimmt eine Referenz auf ein Image auf und erweitert die aktuelle ImageList
	ggf. um ein weiteres Image. Der Zweck dieser Methode ist, da\s verhindert
	werden mu\s, da\s die Toolbox "uber das Image eine Referenz auf die
	Quell-Liste diese am Leben erh"alt.
*/

/*?*/ void SfxImageManager::LockImage( USHORT nId, ToolBox *pBox )
/*?*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	LockImage( nId, pBox, FALSE );
/*?*/ }

/*?*/ void SfxImageManager::LockImage( USHORT nId, ToolBox *pBox, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Das Image mu\s die richtige Gr"o\e haben
//STRIP001 	if ( pBox->GetItemImage(nId).GetSizePixel() == pImageList->GetImageSize() )
//STRIP001 	{
//STRIP001 		// Ist das Image schon vorhanden ?
//STRIP001 		ImageList *pUserImageList = pImp->m_pUserImageList;
//STRIP001 		ImageList *pHCUserImageList = pImp->m_pHCUserImageList;
//STRIP001 		if ( pUserImageList->GetImagePos( nId ) == IMAGELIST_IMAGE_NOTFOUND )
//STRIP001 		{
//STRIP001 			// Eine physikalische Kopie des Images in der User-Listen machen
//STRIP001 			pUserImageList->AddImage( nId, pBox->GetItemImage( nId ) );
//STRIP001             pHCUserImageList->AddImage( nId, pBox->GetItemImage( nId ) );
//STRIP001 
//STRIP001 			if ( SfxMacroConfig::IsMacroSlot(nId) )
//STRIP001                 SfxMacroConfig::GetOrCreate()->RegisterSlotId( nId );
//STRIP001 
//STRIP001             pImp->SetDefault( FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Toolbox should use image from the user image list so that the reference to
//STRIP001 		// the source image list will be released!
//STRIP001 		if ( bHiContrast )
//STRIP001 			pBox->SetItemImage( nId, pHCUserImageList->GetImage( nId ) );
//STRIP001 		else
//STRIP001 			pBox->SetItemImage( nId, pUserImageList->GetImage( nId ) );
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ Image SfxImageManager::MakeUserImage( USHORT nId, Image& aImage, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Das Image mu\s die richtige Gr"o\e haben
//STRIP001 	if ( aImage.GetSizePixel() == pImageList->GetImageSize() )
//STRIP001 	{
//STRIP001 		// Ist das Image schon vorhanden ?
//STRIP001 		ImageList *pUserImageList = pImp->m_pUserImageList;
//STRIP001 		ImageList *pHCUserImageList = pImp->m_pHCUserImageList;
//STRIP001 
//STRIP001 		if ( pUserImageList->GetImagePos( nId ) == IMAGELIST_IMAGE_NOTFOUND )
//STRIP001 		{
//STRIP001 			// Eine physikalische Kopie des Images in den User-Listen machen
//STRIP001 			pUserImageList->AddImage( nId, aImage );
//STRIP001 			pHCUserImageList->AddImage( nId, aImage );
//STRIP001 
//STRIP001 			if ( SfxMacroConfig::IsMacroSlot(nId) )
//STRIP001                 SfxMacroConfig::GetOrCreate()->RegisterSlotId( nId );
//STRIP001 
//STRIP001             pImp->SetDefault( FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Return image from the user image list so that the reference to
//STRIP001 		// the source image list will be released!
//STRIP001 		if ( bHiContrast )
//STRIP001 			return pHCUserImageList->GetImage( nId );
//STRIP001 		else
//STRIP001 			return pUserImageList->GetImage( nId );
//STRIP001 	}
//STRIP001 
/*?*/ 	return Image();
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxImageManager::SetSymbolsSize_Impl( sal_Int16 nNewSet )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if ( nNewSet != pData->nSet && pImageList )
//STRIP001 	{
//STRIP001         pData->nSet = nNewSet;
//STRIP001 		Size aOldSize = pImageList->GetImageSize();
//STRIP001 
//STRIP001 		// neue DefaultList erzeugen
//STRIP001         pImageList = NULL;
//STRIP001 		pImp->MakeDefaultImageList();
//STRIP001 		Size aNewSize = pImageList->GetImageSize();
//STRIP001 
//STRIP001         if ( !pImp->IsDefault() )
//STRIP001 			pImp->RebuildUserList();
//STRIP001 
//STRIP001         for ( USHORT n=0; n<pData->pToolBoxList->Count(); n++ )
//STRIP001 		{
//STRIP001             ToolBoxInf_Impl *pInf = (*pData->pToolBoxList)[n];
//STRIP001 			if ( pInf->nFlags & SFX_TOOLBOX_CHANGESYMBOLSET )
//STRIP001 			{
//STRIP001 				ToolBox *pBox = pInf->pToolBox;
//STRIP001 				SfxToolBoxManager* pMgr = pInf->pMgr;
//STRIP001 
//STRIP001 				if ( pMgr )
//STRIP001 				{
//STRIP001 					pMgr->RefreshImages_Impl();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					USHORT nCount = pBox->GetItemCount();
//STRIP001 					for ( USHORT nPos=0; nPos<nCount; nPos++ )
//STRIP001 					{
//STRIP001 						USHORT nId = pBox->GetItemId( nPos );
//STRIP001 						if ( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON )
//STRIP001 						{
//STRIP001 							pBox->SetItemImage( nId, GetImage( nId, pInf->pModule ) );
//STRIP001                             SfxStateCache *pCache = SfxViewFrame::Current()->GetBindings().GetStateCache( nId );
//STRIP001 							if ( pCache )
//STRIP001 								pCache->SetCachedState();
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( !pBox->IsFloatingMode() )
//STRIP001 				{
//STRIP001 					Size aActSize( pBox->GetSizePixel() );
//STRIP001 					Size aSize( pBox->CalcWindowSizePixel() );
//STRIP001 					if ( pBox->IsHorizontal() )
//STRIP001 						aSize.Width() = aActSize.Width();
//STRIP001 					else
//STRIP001 						aSize.Height() = aActSize.Height();
//STRIP001 
//STRIP001 					pBox->SetSizePixel( aSize );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------
/* Retrieves the default image for an ID. The search order is
   Module-Imagelist (if existing), Defaultlist
*/

/*?*/ Image SfxImageManager::GetDefaultImage(USHORT nId, SfxModule* pMod, BOOL bBig, BOOL bHiContrast ) const
/*?*/ {
/*?*/ 	return pImp->GetDefaultImage( nId, pMod, bBig, bHiContrast );
/*?*/ }

//-------------------------------------------------------------------------
/*  [Beschreibung]

	Sucht das Image der uebergebenen Id. Suchreihenfolge:

	UserDefListe, Modul-Imageliste( sofern vorhanden ), Default-Liste,
	Officeliste( sofern vorhanden ).
*/

/*?*/ Image SfxImageManager::SeekImage( USHORT nId, SfxModule *pModule ) const
/*?*/ {
/*?*/ 	return SeekImage( nId, FALSE, pModule );
/*?*/ }

/*N*/ Image SfxImageManager::SeekImage( USHORT nId, BOOL bHiContrast, SfxModule *pModule ) const
/*N*/ {
/*N*/ 	return pImp->SeekImage( nId, pModule, bHiContrast );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Sucht das Image der uebergebenen Id genauso wie SeekImage, allerdings
	wird die Office-liste nicht durchsucht, d.h. es werden nur die aktuell
	konfigurierten Images ber"ucksichtigt.
*/
/*?*/ Image SfxImageManager::GetImage( USHORT nId, SfxModule *pModule ) const
/*?*/ {
/*?*/ 	return GetImage( nId, FALSE, pModule );
/*?*/ }

/*N*/ Image SfxImageManager::GetImage( USHORT nId, BOOL bHiContrast, SfxModule *pModule ) const
/*N*/ {
/*N*/     return pImp->GetImage( nId, pModule, ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE ), bHiContrast );
/*N*/ }

/*?*/ Image SfxImageManager::GetImage(USHORT nId, SfxModule* pMod, BOOL bBig ) const
/*?*/ {
/*?*/ 	return GetImage( nId, pMod, bBig, FALSE );
/*?*/ }

/*?*/ Image SfxImageManager::GetImage( USHORT nId, SfxModule *pModule, BOOL bBig, BOOL bHiContrast ) const
/*?*/ {
/*?*/     return pImp->GetImage( nId, pModule, bBig, bHiContrast );
/*?*/ }

/*?*/ Image SfxImageManager::GetImageFromModule_Impl( USHORT nId, SfxModule *pModule )
/*?*/ {
/*?*/ 	return GetImageFromModule_Impl( nId, pModule, FALSE );
/*?*/ }

/*?*/ Image SfxImageManager::GetImageFromModule_Impl( USHORT nId, SfxModule *pModule, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pModule )
//STRIP001 	{
//STRIP001         ImageList *pList = pModule->GetImageList_Impl(( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE ), bHiContrast );
//STRIP001 		if ( pList )
//STRIP001 			return pList->GetImage( nId );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( bHiContrast )
//STRIP001 			return pImageList->GetImage( nId );
//STRIP001 		else
//STRIP001 			return pHiImageList->GetImage( nId );
//STRIP001 	}
//STRIP001 
/*?*/ 	return Image();
/*?*/ }

/*?*/ Image SfxImageManager::GetAndLockImage_Impl( USHORT nId, SfxModule *pModule )
/*?*/ {
/*?*/ 	return GetAndLockImage_Impl( nId, FALSE, pModule );
/*?*/ }

/*?*/ Image SfxImageManager::GetAndLockImage_Impl( USHORT nId, BOOL bHiContrast, SfxModule *pModule )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return Image();//STRIP001 
//STRIP001 	BOOL bBig = ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE );
//STRIP001 	ImageList *pUserImageList = pImp->m_pUserImageList;
//STRIP001 	ImageList *pHCUserImageList = pImp->m_pHCUserImageList;
//STRIP001 
//STRIP001 	// Zuerst in der UserImagelist suchen
//STRIP001 	if ( bHiContrast )
//STRIP001 	{
//STRIP001 		if ( pHCUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
//STRIP001 			return pHCUserImageList->GetImage( nId );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
//STRIP001 			return pUserImageList->GetImage( nId );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pModule )
//STRIP001 		return GetImage( nId, pModule, bBig, bHiContrast );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pModule = SFX_APP()->GetActiveModule();
//STRIP001 
//STRIP001 		// Wenn das Image nicht in der default-Liste steht, das Image aber
//STRIP001 		// f"ur diese Liste angefordert wird
//STRIP001 		if ( pModule && pImageList->GetImagePos( nId ) == IMAGELIST_IMAGE_NOTFOUND )
//STRIP001 		{
//STRIP001 			// Dann in der Liste des aktiven Moduls suchen
//STRIP001             ImageList *pList = pModule->GetImageList_Impl( bBig, bHiContrast );
//STRIP001 			if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
//STRIP001 			{
//STRIP001 				// Das Image in die UserImageList "ubertragen
//STRIP001 				if ( bHiContrast )
//STRIP001 				{
//STRIP001 					// Add it to the high contrast user image list
//STRIP001 					pHCUserImageList->AddImage( nId, pList->GetImage( nId ) );
//STRIP001 
//STRIP001 					// Do it for the NON high contrast user image list, too!!
//STRIP001 					ImageList *pNonList = pModule->GetImageList_Impl( bBig, FALSE );
//STRIP001 					if ( pNonList )
//STRIP001 						pUserImageList->AddImage( nId, pNonList->GetImage( nId ) );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Add it to the user image list
//STRIP001 					pUserImageList->AddImage( nId, pList->GetImage( nId ) );
//STRIP001 
//STRIP001 					// Do it for the high contrast user image list, too!!
//STRIP001 					ImageList *pHiList = pModule->GetImageList_Impl( bBig, TRUE );
//STRIP001 					if ( pHiList )
//STRIP001 						pHCUserImageList->AddImage( nId, pHiList->GetImage( nId ) );
//STRIP001 				}
//STRIP001 
//STRIP001                 if ( SfxMacroConfig::IsMacroSlot(nId) )
//STRIP001                     SfxMacroConfig::GetOrCreate()->RegisterSlotId( nId );
//STRIP001                 pImp->SetDefault( FALSE );
//STRIP001 
//STRIP001 				if ( bHiContrast )
//STRIP001 					return pHCUserImageList->GetImage( nId );
//STRIP001 				else
//STRIP001 					return pUserImageList->GetImage( nId );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return pImageList->GetImage( nId );
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Erzeugt die Office-Liste, die f"ur das Konfigurieren ben"otigt wird.
*/

/*N*/ void SfxImageManager::StartCustomize()
/*N*/ {
/*N*/ 	// no more office list
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Entfernt die nachgeladenen ImageLists wieder aus dem Speicher.
*/

/*N*/ void SfxImageManager::EndCustomize()
/*N*/ {
/*N*/ 	// no more office list
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Ersetzt das Image f"ur die "ubergebene Id durch die "ubergebene Bitmap
	bzw. entfernt die Bindung an eine Bitmap.
*/

/*N*/ void SfxImageManager::ReplaceImage( USHORT nId, Bitmap* pBmp )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	ImageList *pUserImageList = pImp->m_pUserImageList;
//STRIP001 	ImageList *pHCUserImageList = pImp->m_pHCUserImageList;
//STRIP001 
//STRIP001 	SfxBitmapList_Impl* pUserDefList = pImp->m_pUserDefList;
//STRIP001 	BOOL bReplaced = FALSE;
//STRIP001 	if ( !pBmp && GetImage( nId ).GetSizePixel().Width() )
//STRIP001 	{
//STRIP001 		// Auf default zuruecksetzen; zuerst das Userdef-Image entfernen
//STRIP001 		pUserImageList->RemoveImage( nId );
//STRIP001 		pHCUserImageList->RemoveImage( nId );
//STRIP001 
//STRIP001 		// Falls zu der "ubergebenen Id eine UserBitmap vorliegt, wird sie
//STRIP001 		// jetzt wieder entfernt
//STRIP001 		for ( USHORT i=0; i<pUserDefList->GetBitmapCount(); i++ )
//STRIP001 			if ( pUserDefList->GetBitmapId(i) == nId )
//STRIP001 				pUserDefList->RemoveBitmap( nId );
//STRIP001 
//STRIP001 		Image aImage = GetImage( nId );
//STRIP001 
//STRIP001 		// Release slot id if we have no default image and this is a macro
//STRIP001 		if ( !aImage.GetSizePixel().Width() && SfxMacroConfig::IsMacroSlot(nId) )
//STRIP001             SfxMacroConfig::GetOrCreate()->ReleaseSlotId( nId );
//STRIP001 
//STRIP001 		bReplaced = TRUE;
//STRIP001 	}
//STRIP001 	else if ( pBmp )
//STRIP001 	{
//STRIP001 		// Eine neue Bitmap aufnehmen
//STRIP001 		Size aSize = pBmp->GetSizePixel();
//STRIP001 		BOOL bBitmapCreated = FALSE;
//STRIP001 		if ( aSize.Width() > 208 || aSize.Height() > 208 )
//STRIP001 		{
//STRIP001 			// Use size that fits both toolbar image size (16x16/26x26)
//STRIP001 			Size aSz( 208, 208 );
//STRIP001 			pBmp = new Bitmap( *pBmp );
//STRIP001 			pBmp->Scale( aSz, BMP_SCALE_INTERPOLATE );
//STRIP001 			bBitmapCreated = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pUserDefList->GetBitmapPos( nId ) == USHRT_MAX )
//STRIP001 			pUserDefList->AddBitmap( nId, *pBmp );
//STRIP001 		else
//STRIP001 			pUserDefList->ReplaceBitmap( nId, *pBmp );
//STRIP001 
//STRIP001 		Color aColor( GetMaskColor() );
//STRIP001 		Image aImage( *pBmp, aColor );
//STRIP001 		if ( pBmp->GetSizePixel() != pImageList->GetImageSize() )
//STRIP001 		{
//STRIP001 			// Scale bitmap to fit current toolbar image size
//STRIP001 			Size aSize = pImageList->GetImageSize();
//STRIP001 			pBmp->Scale( aSize, BMP_SCALE_INTERPOLATE );
//STRIP001 			aImage = Image( *pBmp, aColor );
//STRIP001 		}
//STRIP001 
//STRIP001 		// In die User-Liste aufnehmen
//STRIP001 		if ( pUserImageList->GetImagePos( nId ) == IMAGELIST_IMAGE_NOTFOUND )
//STRIP001 		{
//STRIP001 			pUserImageList->AddImage( nId, aImage );
//STRIP001 			pHCUserImageList->AddImage( nId, aImage );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pUserImageList->ReplaceImage( nId, aImage );
//STRIP001 			pHCUserImageList->ReplaceImage( nId, aImage );
//STRIP001 		}
//STRIP001 
//STRIP001         if ( SfxMacroConfig::IsMacroSlot(nId) )
//STRIP001             SfxMacroConfig::GetOrCreate()->RegisterSlotId( nId );
//STRIP001 		
//STRIP001 		bReplaced = TRUE;
//STRIP001 		if ( bBitmapCreated )
//STRIP001 			delete pBmp; // Delete temporary bitmap again!
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bReplaced )
//STRIP001 	{
//STRIP001 		// Alle registrierten Toolboxen auf den Stand bringen
//STRIP001         ExchangeItemImage_Impl( nId, GetImage( nId ) );
//STRIP001 
//STRIP001 		if ( pUserImageList->GetImageCount() )
//STRIP001             pImp->SetDefault( FALSE );
//STRIP001 		else
//STRIP001             pImp->SetDefault( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 //	SvFileStream aBitmapStream(String("d:\\REPLACE.BMP"), STREAM_STD_WRITE);
//STRIP001 //	aBitmapStream << pUserImageList->GetBitmap();
/*?*/ }

/*  [Beschreibung]

	Meldet eine Toolbox an, damit sie (je nach Flags) bei "Anderungen von
	Symbolset oder OutStyle benachrichtigt werden kann.
*/

/*N*/ void SfxImageManager::RegisterToolBox( ToolBox *pBox, USHORT nFlags )
/*N*/ {
/*N*/ 	ToolBoxInf_Impl *pInf = new ToolBoxInf_Impl;
/*N*/ 	pInf->pToolBox = pBox;
/*N*/ 	pInf->pMgr = NULL;
/*N*/ 	pInf->nFlags = nFlags;
/*N*/ 	pInf->pModule = NULL;
/*N*/     pData->pToolBoxList->Append( pInf );
/*N*/     pBox->SetOutStyle( pImp->m_aOpt.GetToolboxStyle() );
/*N*/ }

/*N*/ void SfxImageManager::RegisterToolBox( ToolBox *pBox, SfxModule* pModule, USHORT nFlags )
/*N*/ {
/*N*/ 	ToolBoxInf_Impl *pInf = new ToolBoxInf_Impl;
/*N*/ 	pInf->pToolBox = pBox;
/*N*/ 	pInf->pMgr = NULL;
/*N*/ 	pInf->nFlags = nFlags;
/*N*/ 	pInf->pModule = pModule;
/*N*/     pData->pToolBoxList->Append( pInf );
/*N*/     pBox->SetOutStyle( pImp->m_aOpt.GetToolboxStyle() );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Meldet eine Toolbox wieder ab.
*/

/*N*/ void SfxImageManager::ReleaseToolBox( ToolBox *pBox )
/*N*/ {
/*N*/     for ( USHORT n=0; n<pData->pToolBoxList->Count(); n++ )
/*N*/ 	{
/*N*/         if ( (*pData->pToolBoxList)[n]->pToolBox == pBox )
/*N*/ 		{
/*N*/             delete (*pData->pToolBoxList)[n];
/*N*/             pData->pToolBoxList->Remove( n );
/*N*/ 			return;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void SfxImageManager::RegisterToolBoxManager( SfxToolBoxManager *pMgr, USHORT nFlags )
/*N*/ {
/*N*/ 	ToolBoxInf_Impl *pInf = new ToolBoxInf_Impl;
/*N*/ 	pInf->pToolBox = &pMgr->GetToolBox();
/*N*/ 	pInf->pMgr = pMgr;
/*N*/ 	pInf->nFlags = nFlags;
/*N*/     pData->pToolBoxList->Append( pInf );
/*N*/     pInf->pToolBox->SetOutStyle( pImp->m_aOpt.GetToolboxStyle() );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Meldet eine Toolbox wieder ab.
*/

/*?*/ void SfxImageManager::ReleaseToolBoxManager( SfxToolBoxManager *pMgr )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     for ( USHORT n=0; n<pData->pToolBoxList->Count(); n++ )
//STRIP001 	{
//STRIP001         if ( (*pData->pToolBoxList)[n]->pMgr == pMgr )
//STRIP001 		{
//STRIP001             delete (*pData->pToolBoxList)[n];
//STRIP001             pData->pToolBoxList->Remove( n );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Gibt die Color zu"ruck, die als Maskenfarbe verwendet wird.
*/

/*?*/ Color SfxImageManager::GetMaskColor() const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pImageList->HasMaskColor() )
//STRIP001 		return pImageList->GetMaskColor();
//STRIP001 	else
/*?*/ 		return Color( COL_LIGHTMAGENTA );
/*?*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Versorgt die "ubergebene Toolbox mit allen Images, die f"ur die enthaltenen
	Ids konfiguriert sind.
	Es wird ( genauso wie bei GetImage ) nicht in der Office-Liste gesucht.
*/

/*N*/ void SfxImageManager::SetImages( ToolBox& rToolBox, SfxModule *pModule )
/*N*/ {
/*N*/ 	SetImages( rToolBox, pModule, FALSE );
/*N*/ }

/*N*/ void SfxImageManager::SetImages( ToolBox& rToolBox, SfxModule *pModule, BOOL bHiContrast )
/*N*/ {
/*N*/ 	BOOL bBig = ( pData->nSet == SFX_SYMBOLS_SIZE_LARGE );
/*N*/ 
/*N*/ 	if ( !pModule )
/*N*/ 		pModule = SFX_APP()->GetActiveModule();
/*N*/ 	ImageList *pList=0;
/*N*/ 	if ( pModule )
/*N*/         pList = pModule->GetImageList_Impl( bBig, bHiContrast );
/*N*/ 
/*N*/ 	ImageList *pUserImageList	= bHiContrast ? pImp->m_pHCUserImageList : pImp->m_pUserImageList;
/*N*/ 	ImageList *pWorkImageList	= GetImageList( bBig, bHiContrast );
/*N*/ 	USHORT nCount = rToolBox.GetItemCount();
/*N*/ 	for (USHORT n=0; n<nCount; n++)
/*N*/ 	{
/*N*/ 		USHORT nId = rToolBox.GetItemId(n);
/*N*/ 		switch ( rToolBox.GetItemType(n) )
/*N*/ 		{
/*N*/ 			case TOOLBOXITEM_BUTTON:
/*N*/ 			{
/*N*/ 				if ( pUserImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 					rToolBox.SetItemImage(nId, pUserImageList->GetImage(nId));
/*N*/ 				else if ( pList && pList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 					rToolBox.SetItemImage(nId, pList->GetImage(nId));
/*N*/ 				else if ( pWorkImageList->GetImagePos( nId ) != IMAGELIST_IMAGE_NOTFOUND )
/*N*/ 					rToolBox.SetItemImage(nId, pWorkImageList->GetImage(nId));
/*N*/ 			}
/*N*/ 
/*N*/ 			case TOOLBOXITEM_SEPARATOR:
/*N*/ 			case TOOLBOXITEM_SPACE:
/*N*/ 			case TOOLBOXITEM_BREAK:
/*N*/ 				break;
/*N*/ 
/*N*/ 			default:
/*N*/ 				DBG_ERROR( "invalid item-type in toolbox config" );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Gibt zur"uck, ob f"ur die angegebene Id eine Bitmap konfiguriert wurde.
*/

/*N*/ BOOL SfxImageManager::IsUserDef_Impl(USHORT nId) const
/*N*/ {
/*N*/ 	return ( pImp->m_pUserDefList->GetBitmapPos(nId) != USHRT_MAX );
/*N*/ }

//-------------------------------------------------------------------------

/*  [Beschreibung]

	Gibt die konfigurierte Bitmap f"ur die angegebene Id zur"uck. Wichtig:
	vorher mu\s mit IsUserDef_Impl "uberpr"uft werden, ob es auch eine gibt.
*/

/*?*/ const Bitmap& SfxImageManager::GetUserDefBitmap_Impl( USHORT nId ) const
/*?*/ {
/*?*/ 	SfxBitmapList_Impl* pUserDefList = pImp->m_pUserDefList;
/*?*/ 	USHORT nPos = pUserDefList->GetBitmapPos( nId );
/*?*/ 	DBG_ASSERT( nPos != USHRT_MAX, "Bitmap nicht vorhanden!" );
/*?*/ 	return ( *pUserDefList->GetBitmap(nId) );
/*?*/ }

/*?*/ void SfxImageManager::SetOutStyle_Impl( sal_Int16 nNewStyle )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if ( pData->nOutStyle != nNewStyle )
//STRIP001 	{
//STRIP001         pData->nOutStyle = nNewStyle;
//STRIP001         for ( USHORT n=0; n<pData->pToolBoxList->Count(); n++ )
//STRIP001 		{
//STRIP001             ToolBoxInf_Impl *pInf = (*pData->pToolBoxList)[n];
//STRIP001 			if ( pInf->nFlags & SFX_TOOLBOX_CHANGEOUTSTYLE )
//STRIP001 			{
//STRIP001 				ToolBox *pBox = pInf->pToolBox;
//STRIP001                 pBox->SetOutStyle( nNewStyle );
//STRIP001 				if ( !pBox->IsFloatingMode() )
//STRIP001 				{
//STRIP001 					Size aActSize( pBox->GetSizePixel() );
//STRIP001 					Size aSize( pBox->CalcWindowSizePixel() );
//STRIP001 					if ( pBox->IsHorizontal() )
//STRIP001 						aSize.Width() = aActSize.Width();
//STRIP001 					else
//STRIP001 						aSize.Height() = aActSize.Height();
//STRIP001 
//STRIP001 					pBox->SetSizePixel( aSize );
//STRIP001 				}
//STRIP001 				pBox->Invalidate();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
/*?*/ }

/*?*/ Size SfxImageManager::GetImageSize() const
/*?*/ {
/*?*/ 	return pImageList->GetImageSize();
/*?*/ }

/*?*/ IMPL_LINK( SfxImageManager, OptionsChanged_Impl, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SetOutStyle_Impl( pImp->m_aOpt.GetToolboxStyle() );
//STRIP001     SetSymbolsSize_Impl( SfxImageManager::GetCurrentSymbolsSize() );
//STRIP001 
/*?*/     return 0L;
/*?*/ }

/*?*/ Image SfxImageManager::GetGlobalImage( USHORT nId, BOOL bBig )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return Image(); //STRIP001 
//STRIP001     if ( !pGlobalConfig )
//STRIP001         return Image();
//STRIP001     return pGlobalConfig->GetImage( nId, NULL, bBig, FALSE );
/*?*/ }

/*?*/ Image SfxImageManager::GetGlobalImage( USHORT nId, BOOL bBig, BOOL bHiContrast )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return Image();//STRIP001 
//STRIP001     if ( !pGlobalConfig )
//STRIP001         return Image();
//STRIP001     return pGlobalConfig->GetImage( nId, NULL, bBig, bHiContrast );
/*?*/ }

//STRIP001 ImageList* SfxImageManager::GetGlobalDefaultImageList( BOOL bBig, BOOL bHiContrast )
//STRIP001 {
//STRIP001 	return GetImageList( bBig, bHiContrast );
//STRIP001 }

/*N*/ IMPL_LINK( SfxImageManager, SettingsChanged_Impl, void*, pVoid )
/*N*/ {
/*N*/     // Check if toolbar button size have changed and we have to use system settings
/*N*/     sal_Int16 nSymbolsSize = SfxImageManager::GetCurrentSymbolsSize();
/*N*/     if ( pData->nSet != nSymbolsSize )
/*?*/         SetSymbolsSize_Impl( nSymbolsSize );
/*N*/     
/*N*/     return 0L;
/*N*/ }

/*?*/ IMPL_LINK( SfxImageManager, ConfigChanged_Impl, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	BOOL bHiContrast = FALSE;
//STRIP001 
//STRIP001 	if ( pData->pToolBoxList->Count() > 0 )
//STRIP001 	{
//STRIP001 		// Check whether toolbox is in high contrast mode or not!
//STRIP001 		ToolBox *pBox = (*pData->pToolBoxList)[0]->pToolBox;
//STRIP001 		Color	aBackColor = pBox->GetBackground().GetColor();
//STRIP001 		if ( aBackColor.IsDark() )
//STRIP001 			bHiContrast = TRUE;
//STRIP001     }
//STRIP001 
//STRIP001 	for ( USHORT i=0; i<pImageList->GetImageCount(); i++ )
//STRIP001 	{
//STRIP001         USHORT nId = pImageList->GetImageId(i);
//STRIP001         ExchangeItemImage_Impl( nId, pImp->GetImage( nId,
//STRIP001 										pData->pDoc->GetModule(),
//STRIP001 										( pData->nSet == SFX_SYMBOLS_SIZE_LARGE ),
//STRIP001 										bHiContrast ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
/*?*/ }

/*?*/ BOOL SfxImageManager::CopyConfiguration_Impl( SfxConfigManager& rSource, SfxConfigManager& rDest )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001     SfxImageManager_Impl aTmp( &rDest );
//STRIP001     aTmp.ReConnect( &rSource );
//STRIP001     return rDest.StoreConfigItem( aTmp );
/*?*/ }
}
