/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdview.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:43:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
#ifndef _E3D_OBJ3D_HXX
#include <bf_svx/obj3d.hxx>
#endif
// auto strip #ifndef _SVX_FMVIEW_HXX
// auto strip #include <bf_svx/fmview.hxx>
// auto strip #endif
// auto strip #ifndef _OUTLINER_HXX //autogen
// auto strip #include <bf_svx/outliner.hxx>
// auto strip #endif
#ifndef _SVX_SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SVDOGRAF_HXX
#include <bf_svx/svdograf.hxx>
#endif
// auto strip #ifndef _SVDOOLE2_HXX
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #endif
// auto strip #ifndef _SVDUNDO_HXX
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _IPENV_HXX //autogen
// auto strip #include <so3/ipenv.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOUTL_HXX //autogen
// auto strip #include <bf_svx/svdoutl.hxx>
// auto strip #endif

#include <bf_svx/dialogs.hrc>

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"
// auto strip #include "sdwindow.hxx"
#include "sdview.hxx"
// auto strip #include "sdclient.hxx"
#include "drawdoc.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "app.hxx"
// auto strip #include "sdpage.hxx"
#include "glob.hrc"
#include "sdresid.hxx"
// auto strip #include "drviewsh.hxx"
// auto strip #include "graphpro.hxx"
//STRIP001#include "futext.hxx"
// auto strip #include "fuinsfil.hxx"
// auto strip #include "fuslshow.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "frmview.hxx"
namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif

TYPEINIT1( SdView, FmFormView );

/*************************************************************************
|*
|* Ctor
|*
\************************************************************************/

/*N*/ SdView::SdView(SdDrawDocument* pDrawDoc, OutputDevice* pOutDev,
/*N*/ 			   SdViewShell* pViewShell)
/*N*/   : FmFormView(pDrawDoc, pOutDev),
/*N*/ 	pDoc(pDrawDoc),
/*N*/ 	pDocSh( pDrawDoc->GetDocSh() ),
/*N*/ 	pViewSh(pViewShell),
/*N*/ 	pDragSrcMarkList(NULL),
/*N*/ 	nDragSrcPgNum(SDRPAGE_NOTFOUND),
/*N*/ 	pDropMarkerObj(NULL),
/*N*/ 	pDropMarker(NULL),
/*N*/ 	pLockedRedraws(NULL),
/*N*/ 	nLockRedrawSmph(0),
/*N*/ 	nAction(DND_ACTION_NONE),
/*N*/ 	bIsDropAllowed(TRUE)
/*N*/ {
/*N*/ 	EnableExtendedKeyInputDispatcher(FALSE);
/*N*/ 	EnableExtendedMouseEventDispatcher(FALSE);
/*N*/ 	EnableExtendedCommandEventDispatcher(FALSE);
/*N*/ 
/*N*/ 	SetUseIncompatiblePathCreateInterface(FALSE);
/*N*/ 	SetMarkHdlWhenTextEdit(TRUE);
/*N*/ 	EnableTextEditOnObjectsWithoutTextIfTextTool(TRUE);
/*N*/ 
/*N*/ 	SetMinMoveDistancePixel(2);
/*N*/ 	SetHitTolerancePixel(2);
/*N*/ 	SetMeasureLayer(String(SdResId(STR_LAYER_MEASURELINES)));
/*N*/ 
/*N*/ 	// Timer fuer verzoegertes Drop (muss fuer MAC sein)
/*N*/ 	aDropErrorTimer.SetTimeoutHdl( LINK(this, SdView, DropErrorHdl) );
/*N*/ 	aDropErrorTimer.SetTimeout(50);
/*N*/ 	aDropInsertFileTimer.SetTimeoutHdl( LINK(this, SdView, DropInsertFileHdl) );
/*N*/ 	aDropInsertFileTimer.SetTimeout(50);
/*N*/ }

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

/*N*/ SdView::~SdView()
/*N*/ {
/*N*/ 	// release content of selection clipboard, if we own the content
/*N*/     UpdateSelectionClipboard( TRUE );
/*N*/ 
/*N*/ 	aDropErrorTimer.Stop();
/*N*/ 	aDropInsertFileTimer.Stop();
/*N*/ 
/*N*/ 	delete pDropMarker;
/*N*/ 
/*N*/ 	while (GetWin(0))
/*N*/ 	{
/*N*/ 		// Alle angemeldeten OutDevs entfernen
/*N*/ 		DelWin(GetWin(0));
/*N*/ 	}

	// gespeicherte Redraws loeschen
/*N*/ 	if (pLockedRedraws)
/*N*/ 	{
/*?*/ 		SdViewRedrawRec* pRec = (SdViewRedrawRec*)pLockedRedraws->First();
/*?*/ 		while (pRec)
/*?*/ 		{
/*?*/ 			delete pRec;
/*?*/ 			pRec = (SdViewRedrawRec*)pLockedRedraws->Next();
/*?*/ 		}
/*?*/ 		delete pLockedRedraws;
/*?*/ 	}
/*N*/ }


/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird an die View weitergeleitet
|*
\************************************************************************/

//STRIP001 void SdView::InitRedraw(OutputDevice* pOutDev, const Region& rReg)
//STRIP001 {
//STRIP001 	// ausfuehren ??
//STRIP001 	if (nLockRedrawSmph == 0)
//STRIP001 	{
//STRIP001 		SdrPageView* pPgView = GetPageViewPvNum(0);
//STRIP001 
//STRIP001 		if (pPgView)
//STRIP001 		{
//STRIP001 			SdPage* pPage = (SdPage*) pPgView->GetPage();
//STRIP001 			if( pPage )
//STRIP001 			{
//STRIP001 				SdrOutliner& rOutl=pDoc->GetDrawOutliner(NULL);
//STRIP001 				rOutl.SetBackgroundColor( pPage->GetBackgroundColor(pPgView) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		FmFormView::InitRedraw(pOutDev, rReg);
//STRIP001 
//STRIP001 		USHORT nDemoKind =	SFX_APP()->GetDemoKind();
//STRIP001 
//STRIP001 		if ( (nDemoKind == SFX_DEMOKIND_DEMO || nDemoKind == SFX_DEMOKIND_INVALID)
//STRIP001 			 && pOutDev->GetOutDevType() == OUTDEV_PRINTER )
//STRIP001 		{
//STRIP001 			SdrPageView* pPgView = GetPageViewPvNum(0);
//STRIP001 
//STRIP001 			if (pPgView)
//STRIP001 			{
//STRIP001 				SdPage* pPage = (SdPage*) pPgView->GetPage();
//STRIP001 
//STRIP001 				if (pPage)
//STRIP001 				{
//STRIP001 					Rectangle aPageRect ( Point(0, 0), pPage->GetSize() );
//STRIP001 					SFX_APP()->SpoilDemoOutput(*pOutDev, aPageRect);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// oder speichern?
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (!pLockedRedraws)
//STRIP001 			pLockedRedraws = new List;
//STRIP001 
//STRIP001 		SdViewRedrawRec* pRec = new SdViewRedrawRec;
//STRIP001 		pRec->pOut	= pOutDev;
//STRIP001 		pRec->aRect = rReg.GetBoundRect();
//STRIP001 		pLockedRedraws->Insert(pRec, LIST_APPEND);
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Selektion hat sich geaendert
|*
\************************************************************************/

/*N*/ void SdView::MarkListHasChanged()
/*N*/ {
/*N*/ 	FmFormView::MarkListHasChanged();
/*N*/ }


/*************************************************************************
|*
|* Attribute setzen
|*
\************************************************************************/

//STRIP001 BOOL SdView::SetAttributes(const SfxItemSet& rSet, BOOL bReplaceAll)
//STRIP001 {
//STRIP001 	BOOL bOk = FmFormView::SetAttributes(rSet, bReplaceAll);
//STRIP001 	return (bOk);
//STRIP001 }


/*************************************************************************
|*
|* Attribute holen
|*
\************************************************************************/

//STRIP001 BOOL SdView::GetAttributes( SfxItemSet& rTargetSet, BOOL bOnlyHardAttr ) const
//STRIP001 {
//STRIP001 	return( FmFormView::GetAttributes( rTargetSet, bOnlyHardAttr ) );
//STRIP001 }


/*************************************************************************
|*
|* Ist ein Praesentationsobjekt selektiert?
|*
\************************************************************************/

//STRIP001 BOOL SdView::IsPresObjSelected(BOOL bOnPage, BOOL bOnMasterPage, BOOL bCheckPresObjListOnly) const
//STRIP001 {
//STRIP001 	/**************************************************************************
//STRIP001 	* Ist ein Presentationsobjekt selektiert?
//STRIP001 	**************************************************************************/
//STRIP001 	SdrMarkList* pMarkList;
//STRIP001 
//STRIP001 	if (nDragSrcPgNum != SDRPAGE_NOTFOUND &&
//STRIP001 		nDragSrcPgNum != GetPageViewPvNum(0)->GetPage()->GetPageNum())
//STRIP001 	{
//STRIP001 		// Es laeuft gerade Drag&Drop
//STRIP001 		// Source- und Destination-Page unterschiedlich:
//STRIP001 		// es wird die gemerkte MarkList verwendet
//STRIP001 		pMarkList = pDragSrcMarkList;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Es wird die aktuelle MarkList verwendet
//STRIP001 		pMarkList = new SdrMarkList(aMark);
//STRIP001 	}
//STRIP001 
//STRIP001 	SdrMark* pMark;
//STRIP001 	SdPage* pPage;
//STRIP001 	SdrObject* pObj;
//STRIP001 
//STRIP001 	BOOL bSelected = FALSE;
//STRIP001 	BOOL bMasterPage = FALSE;
//STRIP001 	long nMark;
//STRIP001 	long nMarkMax = pMarkList->GetMarkCount() - 1;
//STRIP001 
//STRIP001 	for (nMark = nMarkMax; nMark >= 0; nMark--)
//STRIP001 	{
//STRIP001 		// Rueckwaerts durch die Marklist
//STRIP001 		pMark = pMarkList->GetMark(nMark);
//STRIP001 		pObj = pMark->GetObj();
//STRIP001 
//STRIP001 		if ( pObj && ( bCheckPresObjListOnly || pObj->IsEmptyPresObj() || pObj->GetUserCall() ) )
//STRIP001 		{
//STRIP001 			pPage = (SdPage*) pObj->GetPage();
//STRIP001 			bMasterPage = pPage->IsMasterPage();
//STRIP001 
//STRIP001 			if (bMasterPage && bOnMasterPage || !bMasterPage && bOnPage)
//STRIP001 			{
//STRIP001 				if ( pPage && pPage->GetPresObjList()->GetPos(pObj) != LIST_ENTRY_NOTFOUND )
//STRIP001 				{
//STRIP001 					bSelected = TRUE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pMarkList != pDragSrcMarkList)
//STRIP001 	{
//STRIP001 	   delete pMarkList;
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bSelected);
//STRIP001 }

/*************************************************************************
|*
|* Alles selektieren
|*
\************************************************************************/

//STRIP001 void SdView::SelectAll()
//STRIP001 {
//STRIP001 	if ( IsTextEdit() )
//STRIP001 	{
//STRIP001 		OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 		const Outliner* pOutliner = GetTextEditOutliner();
//STRIP001 		pOLV->SelectRange( 0, (USHORT) pOutliner->GetParagraphCount() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		MarkAll();
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Dokument hat sich geaendert
|*
\************************************************************************/

/*N*/ void SdView::ModelHasChanged()
/*N*/ {
/*N*/ 	// Erst SdrView benachrichtigen
/*N*/ 	FmFormView::ModelHasChanged();
/*N*/ }

/*************************************************************************
|*
|* StyleSheet setzen
|*
\************************************************************************/

//STRIP001 BOOL SdView::SetStyleSheet(SfxStyleSheet* pStyleSheet, BOOL bDontRemoveHardAttr)
//STRIP001 {
//STRIP001 	// weiter an SdrView
//STRIP001 	return FmFormView::SetStyleSheet(pStyleSheet, bDontRemoveHardAttr);
//STRIP001 }


/*************************************************************************
|*
|* Texteingabe beginnen
|*
\************************************************************************/

//STRIP001 BOOL SdView::BegTextEdit(SdrObject* pObj, SdrPageView* pPV, Window* pWin,
//STRIP001 						 BOOL bIsNewObj, SdrOutliner* pGivenOutliner,
//STRIP001 						 OutlinerView* pGivenOutlinerView, BOOL bDontDeleteOutliner,
//STRIP001 						 BOOL bOnlyOneView)
//STRIP001 {
//STRIP001 	BOOL bReturn = FmFormView::BegTextEdit(pObj, pPV, pWin, bIsNewObj, pGivenOutliner,
//STRIP001 										pGivenOutlinerView, bDontDeleteOutliner,
//STRIP001 										bOnlyOneView);
//STRIP001 
//STRIP001 	if (bReturn)
//STRIP001 	{
//STRIP001 		// UndoManager an der obersten Shell (SdDrawTextObjectBar) setzen
//STRIP001 		Outliner* pOL = GetTextEditOutliner();
//STRIP001 
//STRIP001 		if( pObj && pObj->GetPage() )
//STRIP001 			pOL->SetBackgroundColor( pObj->GetPage()->GetBackgroundColor(pPV) );
//STRIP001 
//STRIP001 		SfxUndoManager& rUndoMgr = pOL->GetUndoManager();
//STRIP001 		rUndoMgr.Clear();
//STRIP001 		SdViewShell* pViewShell = pDocSh->GetViewShell();
//STRIP001 		DBG_ASSERT(pViewShell, "ViewShell nicht gefunden");
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 				GetShell(0)->SetUndoManager(&rUndoMgr);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }

/*************************************************************************
|*
|* Texteingabe beenden
|*
\************************************************************************/

//STRIP001 SdrEndTextEditKind SdView::EndTextEdit(BOOL bDontDeleteReally)
//STRIP001 {
//STRIP001 	BOOL bIsTextEdit = IsTextEdit();
//STRIP001 
//STRIP001 	SdrEndTextEditKind eKind;
//STRIP001 
//STRIP001 	SdViewShell* pViewShell= pDocSh->GetViewShell();
//STRIP001 
//STRIP001 	if ( pViewShell && pViewShell->ISA(SdDrawViewShell) )
//STRIP001 	{
//STRIP001 		FuPoor* pFunc = ( (SdDrawViewShell*) pViewShell)->GetActualFunction();
//STRIP001 
//STRIP001 		if ( !pFunc || !pFunc->ISA(FuText) )
//STRIP001 			pFunc = ( (SdDrawViewShell*) pViewShell)->GetOldFunction();
//STRIP001 
//STRIP001 		if ( pFunc && pFunc->ISA(FuText) )
//STRIP001 		{
//STRIP001 			SdrTextObj* pTextObj = ( (FuText*) pFunc)->GetTextObj();
//STRIP001 			BOOL bDefaultTextRestored = ( (FuText*) pFunc)->RestoreDefaultText();
//STRIP001 			eKind = FmFormView::EndTextEdit(bDontDeleteReally);
//STRIP001 
//STRIP001 			if( bDefaultTextRestored )
//STRIP001 				pTextObj->SetEmptyPresObj( TRUE );
//STRIP001 
//STRIP001 			pTextObj = ( (FuText*) pFunc)->GetTextObj();
//STRIP001 
//STRIP001 			if ( pTextObj && pViewShell )
//STRIP001 			{
//STRIP001 				FuSlideShow* pFuSlideShow = pViewShell->GetSlideShow();
//STRIP001 				if (pFuSlideShow)
//STRIP001 					pFuSlideShow->EndTextEdit(pTextObj);
//STRIP001 			}
//STRIP001 
//STRIP001 			if (eKind == SDRENDTEXTEDIT_CHANGED && !bDefaultTextRestored)
//STRIP001 				( (FuText*) pFunc)->ObjectChanged();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			eKind = FmFormView::EndTextEdit(bDontDeleteReally);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		eKind = FmFormView::EndTextEdit(bDontDeleteReally);
//STRIP001 
//STRIP001 	if (bIsTextEdit)
//STRIP001 	{
//STRIP001 		// UndoManager an der obersten Shell setzen
//STRIP001 		SfxUndoManager* pUndoMgr = pDocSh->GetUndoManager();
//STRIP001 		SdViewShell* pViewShell = pDocSh->GetViewShell();
//STRIP001 		DBG_ASSERT(pViewShell, "ViewShell nicht gefunden");
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 				GetShell(0)->SetUndoManager(pUndoMgr);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(eKind);
//STRIP001 }


/*************************************************************************
|*
|* Originalgroesse der markierten Objekte setzen
|*
\************************************************************************/

//STRIP001 void SdView::SetMarkedOriginalSize()
//STRIP001 {
//STRIP001 	SdrUndoGroup*   pUndoGroup = new SdrUndoGroup(*pDoc);
//STRIP001 	ULONG           nCount = aMark.GetMarkCount();
//STRIP001 	BOOL            bOK = FALSE;
//STRIP001 
//STRIP001 	for( sal_uInt32 i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		SdrObject* pObj = aMark.GetMark(i)->GetObj();
//STRIP001 
//STRIP001 		if( pObj->GetObjInventor() == SdrInventor )
//STRIP001 		{
//STRIP001 			if( pObj->GetObjIdentifier() == OBJ_OLE2 )
//STRIP001 			{
//STRIP001 				SvInPlaceObjectRef xIPObj = ((SdrOle2Obj*)pObj)->GetObjRef();
//STRIP001 				
//STRIP001 				if( xIPObj.Is() )
//STRIP001 				{
//STRIP001 					Size        aOleSize( OutputDevice::LogicToLogic( xIPObj->GetVisArea().GetSize(), xIPObj->GetMapUnit(), MAP_100TH_MM) );
//STRIP001 					Rectangle   aDrawRect( pObj->GetLogicRect() );
//STRIP001 
//STRIP001 					pUndoGroup->AddAction( new SdrUndoGeoObj( *pObj ) );
//STRIP001 					pObj->Resize( aDrawRect.TopLeft(), Fraction( aOleSize.Width(), aDrawRect.GetWidth() ),
//STRIP001 													   Fraction( aOleSize.Height(), aDrawRect.GetHeight() ) );
//STRIP001 					
//STRIP001                     bOK = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if( pObj->GetObjIdentifier() == OBJ_GRAF )
//STRIP001 			{
//STRIP001 				const MapMode   aMap100( MAP_100TH_MM );
//STRIP001 				Size            aSize;
//STRIP001 
//STRIP001 			    if ( static_cast< SdrGrafObj* >( pObj )->GetGrafPrefMapMode().GetMapUnit() == MAP_PIXEL )
//STRIP001 				    aSize = Application::GetDefaultDevice()->PixelToLogic( static_cast< SdrGrafObj* >( pObj )->GetGrafPrefSize(), aMap100 );
//STRIP001 			    else
//STRIP001 			    {
//STRIP001 				    aSize = OutputDevice::LogicToLogic( static_cast< SdrGrafObj* >( pObj )->GetGrafPrefSize(),
//STRIP001 														static_cast< SdrGrafObj* >( pObj )->GetGrafPrefMapMode(), 
//STRIP001 														aMap100 );
//STRIP001 				}
//STRIP001 				
//STRIP001 				pUndoGroup->AddAction( new SdrUndoGeoObj( *pObj ) );
//STRIP001 				Rectangle aRect( pObj->GetLogicRect() );
//STRIP001 				aRect.SetSize( aSize );
//STRIP001 				pObj->SetLogicRect( aRect );
//STRIP001 
//STRIP001 				bOK = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bOK )
//STRIP001 	{
//STRIP001 		pUndoGroup->SetComment( String(SdResId(STR_UNDO_ORIGINALSIZE)) );
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(pUndoGroup);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		delete pUndoGroup;
//STRIP001 }

/*************************************************************************
|*
|* virt. Device mit Seiteninhalt erzeugen, Device gehoert dem Caller
|*
\************************************************************************/

//STRIP001 VirtualDevice* SdView::CreatePageVDev(USHORT nSdPage, PageKind ePageKind,
//STRIP001 									  ULONG nWidthPixel)
//STRIP001 {
//STRIP001 	SdViewShell*	pViewShell = pDocSh->GetViewShell();
//STRIP001 	SdWindow*		pWin = pViewShell->GetActiveWindow();
//STRIP001 	VirtualDevice*	pVDev = new VirtualDevice( *pWin );
//STRIP001 	MapMode			aMM( MAP_100TH_MM );
//STRIP001 
//STRIP001 	SdPage* pPage = pDoc->GetSdPage(nSdPage, ePageKind);
//STRIP001 	DBG_ASSERT(pPage, "Seite nicht gefunden");
//STRIP001 
//STRIP001 	Size aPageSize(pPage->GetSize());
//STRIP001 	aPageSize.Width()  -= pPage->GetLftBorder();
//STRIP001 	aPageSize.Width()  -= pPage->GetRgtBorder();
//STRIP001 	aPageSize.Height() -= pPage->GetUppBorder();
//STRIP001 	aPageSize.Height() -= pPage->GetLwrBorder();
//STRIP001 
//STRIP001 	// use scaling?
//STRIP001 	if( nWidthPixel )
//STRIP001 	{
//STRIP001 		const Fraction aFrac( (long) nWidthPixel, pVDev->LogicToPixel( aPageSize, aMM ).Width() );
//STRIP001 
//STRIP001 		aMM.SetScaleX( aFrac );
//STRIP001 		aMM.SetScaleY( aFrac );
//STRIP001 	}
//STRIP001 
//STRIP001 	pVDev->SetMapMode( aMM );
//STRIP001 	BOOL bAbort = !pVDev->SetOutputSize(aPageSize);
//STRIP001 	DBG_ASSERT(!bAbort, "virt. Device nicht korrekt erzeugt");
//STRIP001 
//STRIP001 	SdrView* pView = new SdrView(pDoc, pVDev);
//STRIP001     pView->SetPageVisible( FALSE );
//STRIP001 	pView->SetBordVisible( FALSE );
//STRIP001 	pView->SetGridVisible( FALSE );
//STRIP001 	pView->SetHlplVisible( FALSE );
//STRIP001 	pView->SetGlueVisible( FALSE );
//STRIP001 	pView->ShowPage(pPage, Point(-pPage->GetLftBorder(), -pPage->GetUppBorder()));
//STRIP001 	SdrPageView* pPageView	= pView->GetPageView(pPage);
//STRIP001 	DBG_ASSERT(pViewShell, "ViewShell nicht gefunden");
//STRIP001 	FrameView* pFrameView	= pViewShell->GetFrameView();
//STRIP001 	pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
//STRIP001 	pPageView->SetLockedLayers( pFrameView->GetLockedLayers() );
//STRIP001 	pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
//STRIP001 
    /* #103186# following change undone:

      revision 1.168 (old cvs)
      date: 1996/02/27 17:57:10;  author: SB;  state: Exp;  lines: +14 -5
      CreatePageVDev(): Einschraenkung auf Seitengrenzen

      reason:

      > SdrPageView:
      > // rReg bezieht sich auf's OutDev, nicht auf die Page
      > void InitRedraw( ... );
    */

    // temporary for gcc
//STRIP001     Point aPoint( 0, 0 );
//STRIP001 	Region aRegion (Rectangle( aPoint, aPageSize ) );
//STRIP001 	pView->InitRedraw(pVDev, aRegion);
//STRIP001 	delete pView;
//STRIP001 	return pVDev;
//STRIP001 }



/*************************************************************************
|*
|* OLE-Obj am Client connecten
|*
\************************************************************************/

//STRIP001 void SdView::DoConnect(SdrOle2Obj* pObj)
//STRIP001 {
//STRIP001 	if (pViewSh)
//STRIP001 	{
//STRIP001 		const SvInPlaceObjectRef& rIPObjRef = pObj->GetObjRef();
//STRIP001 
//STRIP001 		if( rIPObjRef.Is() )
//STRIP001 		{
//STRIP001 			SfxInPlaceClientRef pSdClient = (SdClient*) rIPObjRef->GetIPClient();
//STRIP001 
//STRIP001 			if ( !pSdClient.Is() )
//STRIP001 			{
//STRIP001 				SdWindow* pWindow = pViewSh->GetActiveWindow();
//STRIP001 				pSdClient = new SdClient(pObj, pViewSh, pWindow);
//STRIP001 
//STRIP001 				rIPObjRef->DoConnect(pSdClient);
//STRIP001 				Rectangle aRect = pObj->GetLogicRect();
//STRIP001 				SvClientData* pClientData = pSdClient->GetEnv();
//STRIP001 
//STRIP001 				if (pClientData)
//STRIP001 				{
//STRIP001 					Size aDrawSize = aRect.GetSize();
//STRIP001 					Size aObjAreaSize = rIPObjRef->GetVisArea().GetSize();
//STRIP001 					aObjAreaSize = OutputDevice::LogicToLogic( aObjAreaSize,
//STRIP001 														   rIPObjRef->GetMapUnit(),
//STRIP001 														   pDoc->GetScaleUnit() );
//STRIP001 
//STRIP001 					// sichtbarer Ausschnitt wird nur inplace veraendert!
//STRIP001 					aRect.SetSize(aObjAreaSize);
//STRIP001 					pClientData->SetObjArea(aRect);
//STRIP001 
//STRIP001 					Fraction aScaleWidth (aDrawSize.Width(),  aObjAreaSize.Width() );
//STRIP001 					Fraction aScaleHeight(aDrawSize.Height(), aObjAreaSize.Height() );
//STRIP001 					aScaleWidth.ReduceInaccurate(10);		// kompatibel zum SdrOle2Obj
//STRIP001 					aScaleHeight.ReduceInaccurate(10);
//STRIP001 					pClientData->SetSizeScale(aScaleWidth, aScaleHeight);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ BOOL SdView::IsMorphingAllowed() const
/*N*/ {
/*N*/ 	const SdrMarkList&	rMarkList = GetMarkList();
/*N*/ 	BOOL				bRet = FALSE;
/*N*/ 
/*N*/ 	if ( rMarkList.GetMarkCount() == 2 )
/*N*/ 	{
/*?*/ 		const SdrObject*	pObj1 = rMarkList.GetMark( 0 )->GetObj();
/*?*/ 		const SdrObject*	pObj2 = rMarkList.GetMark( 1 )->GetObj();
/*?*/ 		const UINT16		nKind1 = pObj1->GetObjIdentifier();
/*?*/ 		const UINT16		nKind2 = pObj2->GetObjIdentifier();
/*?*/ 
/*?*/ 		if ( ( nKind1 != OBJ_TEXT && nKind2 != OBJ_TEXT ) &&
/*?*/ 			 ( nKind1 != OBJ_TITLETEXT && nKind2 != OBJ_TITLETEXT ) &&
/*?*/ 			 ( nKind1 != OBJ_OUTLINETEXT && nKind2 != OBJ_OUTLINETEXT ) &&
/*?*/ 			 ( nKind1 != OBJ_GRUP && nKind2 != OBJ_GRUP ) &&
/*?*/ 			 ( nKind1 != OBJ_LINE && nKind2 != OBJ_LINE ) &&
/*?*/ 			 ( nKind1 != OBJ_PLIN && nKind2 != OBJ_PLIN ) &&
/*?*/ 			 ( nKind1 != OBJ_PATHLINE && nKind2 != OBJ_PATHLINE ) &&
/*?*/ 			 ( nKind1 != OBJ_FREELINE && nKind2 != OBJ_FREELINE ) &&
/*?*/ 			 ( nKind1 != OBJ_PATHPLIN && nKind2 != OBJ_PATHPLIN ) &&
/*?*/ 			 ( nKind1 != OBJ_MEASURE && nKind2 != OBJ_MEASURE ) &&
/*?*/ 			 ( nKind1 != OBJ_EDGE && nKind2 != OBJ_EDGE ) &&
/*?*/ 			 ( nKind1 != OBJ_GRAF && nKind2 != OBJ_GRAF ) &&
/*?*/ 			 ( nKind1 != OBJ_OLE2 && nKind2 != OBJ_OLE2 ) &&
/*?*/ 			 ( nKind1 != OBJ_CAPTION && nKind2 !=  OBJ_CAPTION ) &&
/*?*/ 			 !pObj1->ISA( E3dObject) && !pObj2->ISA( E3dObject) )
/*?*/ 		{
/*?*/ 			SfxItemSet		aSet1( pDoc->GetPool(), XATTR_FILLSTYLE, XATTR_FILLSTYLE );
/*?*/ 			SfxItemSet		aSet2( pDoc->GetPool(), XATTR_FILLSTYLE, XATTR_FILLSTYLE );
/*?*/ 
/*?*/ //-/			pObj1->TakeAttributes( aSet1, TRUE, FALSE );
/*?*/ 			aSet1.Put(pObj1->GetItemSet());
/*?*/ 
/*?*/ //-/			pObj2->TakeAttributes( aSet2, TRUE, FALSE );
/*?*/ 			aSet2.Put(pObj2->GetItemSet());
/*?*/ 
/*?*/ 			const XFillStyle	eFillStyle1 = ( (const XFillStyleItem&) aSet1.Get( XATTR_FILLSTYLE ) ).GetValue();
/*?*/ 			const XFillStyle	eFillStyle2 = ( (const XFillStyleItem&) aSet2.Get( XATTR_FILLSTYLE ) ).GetValue();
/*?*/ 
/*?*/ 			if( ( eFillStyle1 == XFILL_NONE || eFillStyle1 == XFILL_SOLID ) &&
/*?*/ 				( eFillStyle2 == XFILL_NONE || eFillStyle2 == XFILL_SOLID ) )
/*?*/ 				bRet = TRUE;
/*?*/ 		}
/*?*/ 	}
/*?*/ 
/*N*/ 	return bRet;
/*N*/ }

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ BOOL SdView::IsVectorizeAllowed() const
/*N*/ {
/*N*/ 	const SdrMarkList&	rMarkList = GetMarkList();
/*N*/ 	BOOL				bRet = FALSE;
/*N*/ 
/*N*/ 	if( rMarkList.GetMarkCount() == 1 )
/*N*/ 	{
/*?*/ 		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
/*?*/ 
/*?*/ 		if( pObj->ISA( SdrGrafObj ) && ( (SdrGrafObj*) pObj )->GetGraphicType() == GRAPHIC_BITMAP )
/*?*/ 			bRet = TRUE;
/*?*/ 	}
/*N*/ 
/*N*/ 	return bRet;
/*N*/ }

//STRIP001 void SdView::onAccessibilityOptionsChanged()
//STRIP001 {
//STRIP001 	if( pViewSh )
//STRIP001 	{
//STRIP001 		SdWindow* pWindow = pViewSh->GetActiveWindow();
//STRIP001 		if( pWindow )
//STRIP001 		{
//STRIP001 			const StyleSettings& rStyleSettings = pWindow->GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 			USHORT nOutputSlot, nPreviewSlot;
//STRIP001             
//STRIP001 			SvtAccessibilityOptions& aAccOptions = getAccessibilityOptions();
//STRIP001 
//STRIP001 			if( pViewSh->GetViewFrame() && pViewSh->GetViewFrame()->GetDispatcher() )
//STRIP001 			{
//STRIP001 				if( rStyleSettings.GetHighContrastMode() )
//STRIP001 				{
//STRIP001 					nOutputSlot = SID_OUTPUT_QUALITY_CONTRAST;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nOutputSlot = SID_OUTPUT_QUALITY_COLOR;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( rStyleSettings.GetHighContrastMode() && aAccOptions.GetIsForPagePreviews() )
//STRIP001 				{
//STRIP001 					nPreviewSlot = SID_PREVIEW_QUALITY_CONTRAST;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nPreviewSlot = SID_PREVIEW_QUALITY_COLOR;
//STRIP001 				}
//STRIP001 
//STRIP001 				pViewSh->GetViewFrame()->GetDispatcher()->Execute( nOutputSlot, SFX_CALLMODE_ASYNCHRON );
//STRIP001 				pViewSh->GetViewFrame()->GetDispatcher()->Execute( nPreviewSlot, SFX_CALLMODE_ASYNCHRON );
//STRIP001 			}
//STRIP001 
//STRIP001 			pViewSh->Invalidate();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
}
