/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fuslshw3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:19:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#define FUSLIDESHOW_INTERN
// auto strip #include "fuslshow.hxx"

// auto strip #include <vos/process.hxx>
// auto strip #include <tools/urlobj.hxx>
// auto strip #include <svtools/urihelper.hxx>
// auto strip #include <unotools/localfilehelper.hxx>
// auto strip #include <bf_svx/xoutx.hxx>
// auto strip #include <bf_svx/outliner.hxx>

#ifndef _XDEF_HXX
#include <bf_svx/xdef.hxx>
#endif

// auto strip #include <bf_svx/xfillit.hxx>
// auto strip #include <bf_svx/xfltrit.hxx>
// auto strip #include <bf_svx/xlntrit.hxx>
// auto strip #ifndef _SV_METRIC_HXX //autogen
// auto strip #include <vcl/metric.hxx>
// auto strip #endif
// auto strip #ifndef _SVDITER_HXX //autogen
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOATTR_HXX //autogen
// auto strip #include <bf_svx/svdoattr.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGE_HXX //autogen
// auto strip #include <bf_svx/svdpage.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _SB_SBSTAR_HXX //autogen
// auto strip #include <basic/sbstar.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SV_GRAPH_HXX //autogen
// auto strip #include <vcl/graph.hxx>
// auto strip #endif
// auto strip #ifndef _SVDORECT_HXX //autogen
// auto strip #include <bf_svx/svdorect.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOTEXT_HXX //autogen
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOATTR_HXX //autogen
// auto strip #include <bf_svx/svdoattr.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGE_HXX //autogen
// auto strip #include <bf_svx/svdpage.hxx>
// auto strip #endif
// auto strip #ifndef _E3D_POLYSC3D_HXX //autogen
// auto strip #include <bf_svx/polysc3d.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif

// auto strip #include "sdview.hxx"
// auto strip #include "drawdoc.hxx"
#include "sdpage.hxx"
#include "app.hrc"
// auto strip #include "anminfo.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "cusshow.hxx"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::com::sun::star;

/*************************************************************************
|*
|* Hat das Objekt eine Aktion?
|*
\************************************************************************/

//STRIP001 BOOL FuSlideShow::HasAction(SdrObject* pObject)
//STRIP001 {
//STRIP001 	BOOL				bResult = FALSE;
//STRIP001 	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 
//STRIP001 	if (pInfo)
//STRIP001 	{
//STRIP001 		if (pInfo->eClickAction == presentation::ClickAction_DOCUMENT)
//STRIP001             bResult = TRUE;
//STRIP001 		else if( pInfo->eClickAction == presentation::ClickAction_BOOKMARK )
//STRIP001 		{
//STRIP001 			bResult = TRUE;
//STRIP001 
//STRIP001 			// keine Spruenge auf 'unerlaubte' Seiten erlauben
//STRIP001 			for( USHORT nPage = 0, nPageCount = pDoc->GetPageCount();
//STRIP001 				nPage < nPageCount; nPage++ )
//STRIP001 			{
//STRIP001 				SdPage* pPage = (SdPage*) pDoc->GetPage( nPage );
//STRIP001 
//STRIP001 				if( pPage->GetPageKind() != PK_STANDARD && pPage->GetName() == pInfo->aBookmark )
//STRIP001 				{
//STRIP001 					bResult = FALSE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bResult )
//STRIP001 			{
//STRIP001 				// Masterpages testen => keine Spruenge erlaubt
//STRIP001 				for( USHORT nMasterPage = 0, nMasterPageCount = pDoc->GetMasterPageCount();
//STRIP001 					 nMasterPage < nMasterPageCount; nMasterPage++ )
//STRIP001 				{
//STRIP001 					if( ( (SdPage*) pDoc->GetMasterPage( nMasterPage ) )->GetName() == pInfo->aBookmark )
//STRIP001 					{
//STRIP001 						bResult = FALSE;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (pInfo->eClickAction != presentation::ClickAction_NONE)
//STRIP001 			bResult = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Liegt die Position (in Weltkoordinaten) ueber einem Objekt?
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdrObject* FuSlideShow::OverObject(const Point& rPos)
//STRIP001 {
//STRIP001 	SdrObject* pResult = NULL;
//STRIP001 
//STRIP001 	// Position umrechnen vom ShowWindow auf Seitenkoordinaten
//STRIP001 	Point aPosOnPage = rPos - aPageOrigin;
//STRIP001 	SdPage* pPage = pDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 	aPosOnPage.X() += pPage->GetLftBorder();
//STRIP001 	aPosOnPage.Y() += pPage->GetUppBorder();
//STRIP001 
//STRIP001 	SdrPageView* pDummy = NULL;
//STRIP001 	pView->PickObj(aPosOnPage, pResult, pDummy, SDRSEARCH_ALSOONMASTER);
//STRIP001 
//STRIP001 	// wenn die DrawingEngine ihr OK gibt, muss noch der Sichtbarkeitsstatus
//STRIP001 	// in der Show getestet werden
//STRIP001 	if (pResult)
//STRIP001 	{
//STRIP001 		SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pResult);
//STRIP001 
//STRIP001 		if (!pInfo && (pResult->ISA(SdrObjGroup) || pResult->ISA(E3dPolyScene)))
//STRIP001 		{
//STRIP001 			// In die Gruppe hineinschauen
//STRIP001 			if ( pView->PickObj(aPosOnPage, pResult, pDummy, SDRSEARCH_ALSOONMASTER | SDRSEARCH_DEEP) )
//STRIP001 				pInfo = pDoc->GetAnimationInfo(pResult);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pInfo && !pInfo->bIsShown)
//STRIP001 			pResult = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Aktion eines Objekts ausfuehren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::PerformAction(SdrObject* pActionObject)
//STRIP001 {
//STRIP001 	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo(pActionObject);
//STRIP001 	BOOL				bResult = TRUE;
//STRIP001 
//STRIP001 	switch( pInfo->eClickAction )
//STRIP001 	{
//STRIP001 		case presentation::ClickAction_PREVPAGE:
//STRIP001 			JumpToPage( aAnimPageList.CalcNextPageNum( FALSE ) );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_NEXTPAGE:
//STRIP001 			JumpToPage( aAnimPageList.CalcNextPageNum( TRUE ) );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_FIRSTPAGE:
//STRIP001 			JumpToPage( aAnimPageList.GetFirstPageNum() );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_LASTPAGE:
//STRIP001 			JumpToPage( aAnimPageList.GetLastPageNum() );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_SOUND:
//STRIP001 			StartSound(pInfo->aBookmark);
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_BOOKMARK:
//STRIP001 		{
//STRIP001 			SfxStringItem aItem( SID_NAVIGATOR_OBJECT, pInfo->aBookmark );
//STRIP001 
//STRIP001 			( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->
//STRIP001               Execute(SID_NAVIGATOR_OBJECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case presentation::ClickAction_DOCUMENT:
//STRIP001         {
//STRIP001             SfxStringItem   aStrItem( SID_FILE_NAME, pInfo->aBookmark );
//STRIP001             SfxStringItem   aReferer( SID_REFERER, pDocSh->GetMedium()->GetName() );
//STRIP001             SfxBoolItem     aBrowseItem( SID_BROWSE, TRUE );
//STRIP001 
//STRIP001             ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->
//STRIP001               Execute(SID_OPENDOC, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aStrItem, &aBrowseItem, &aReferer, 0L );
//STRIP001         }
//STRIP001         break;

//STRIP001 		case presentation::ClickAction_INVISIBLE:
//STRIP001 		case presentation::ClickAction_VANISH:
//STRIP001 			HideOrVanishObject( pActionObject, presentation::ClickAction_INVISIBLE == pInfo->eClickAction );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_VERB:
//STRIP001 			DoVerb( pActionObject, pDoc->GetAnimationInfo(pActionObject)->nVerb );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_PROGRAM:
//STRIP001 		{
//STRIP001 		    INetURLObject aURL( so3::StaticBaseUrl::SmartRelToAbs( pInfo->aBookmark, FALSE, INetURLObject::WAS_ENCODED, INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 
//STRIP001 			if( INET_PROT_FILE == aURL.GetProtocol() )
//STRIP001 		    {
//STRIP001 				::vos::OProcess                 aApp( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 				::vos::OArgumentList	        aParameters;
//STRIP001 				::vos::OProcess::TProcessError  eError = aApp.execute( (::vos::OProcess::TProcessOption) ( ::vos::OProcess::TOption_SearchPath |
//STRIP001 																										   ::vos::OProcess::TOption_Detached ),
//STRIP001 																	   aParameters );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_MACRO:
//STRIP001 		{
//STRIP001 			// Makro ausfuehren
//STRIP001 			String aMacro = pInfo->aBookmark;
//STRIP001 
//STRIP001 			// aMacro liegt in folgender Form vor:
//STRIP001 			// "Macroname.Modulname.Libname.Dokumentname" oder
//STRIP001 			// "Macroname.Modulname.Libname.Applikationsname"
//STRIP001 			String aMacroName = aMacro.GetToken(0, sal_Unicode('.'));
//STRIP001 			String aModulName = aMacro.GetToken(1, sal_Unicode('.'));
//STRIP001 			String aLibName   = aMacro.GetToken(2, sal_Unicode('.'));
//STRIP001 			String aDocName   = aMacro.GetToken(3, sal_Unicode('.'));
//STRIP001 
//STRIP001 			// Z.Z. kann die Call-Methode nur
//STRIP001 			// Modulname+Macroname aufloesen
//STRIP001 			String aExecMacro(aModulName);
//STRIP001 			aExecMacro.Append( sal_Unicode('.') );
//STRIP001 			aExecMacro.Append( aMacroName );
//STRIP001 			pDocSh->GetBasic()->Call(aExecMacro);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case presentation::ClickAction_STOPPRESENTATION:
//STRIP001 			JumpToPage( PAGE_NO_END );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Animation eines Objekts ausfuehren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::AnimateNamedObject(const String& rObjectName)
//STRIP001 {
//STRIP001 	SdrObject*	pObject = pDoc->GetObj(rObjectName);
//STRIP001 	BOOL		bResult = FALSE;
//STRIP001 
//STRIP001 	if ( pObject )
//STRIP001 	{
//STRIP001 		SdrPage* pPage = pObject->GetPage();
//STRIP001 		if ( pPage->IsMasterPage() &&
//STRIP001 			 pObject->GetObjInventor() == SdrInventor &&
//STRIP001 			 (pObject->GetObjIdentifier() == OBJ_TITLETEXT ||
//STRIP001 			  pObject->GetObjIdentifier() == OBJ_OUTLINETEXT))
//STRIP001 			return bResult;
//STRIP001 
//STRIP001 		// ist es ein Animationsobjekt?
//STRIP001 		SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pObject );
//STRIP001 
//STRIP001 		if ( pInfo && ( pInfo->eEffect != presentation::AnimationEffect_NONE ) )
//STRIP001 		{
//STRIP001 			// anstehende Gliederungsanimationen und Abblendungen werden bei
//STRIP001 			// Animation eines Objektes verworfen
//STRIP001 			pCurAnmList->Remove( pLayoutText );
//STRIP001 			pDimObject = pHideObject = NULL;
//STRIP001 
//STRIP001 			// das Objekt in der Liste nach vorn schieben und Animation starten
//STRIP001 			pCurAnmList->Remove( pObject );
//STRIP001 			pCurAnmList->Insert( pObject, (ULONG) 0 );
//STRIP001 			pInfo->bShow = TRUE;
//STRIP001 			bResult = AnimateObject();
//STRIP001 			pInfo->bIsShown = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( AffectsOwnPage( pObject ) )
//STRIP001 			nVisibleAffectingObjects++;
//STRIP001 	}
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Sprung zu einem Bookmark
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FuSlideShow::JumpToBookmark(const String& rBookmark)
//STRIP001 {
//STRIP001 	// Ist das Bookmark eine Seite?
//STRIP001 	BOOL        bIsMasterPage;
//STRIP001     USHORT	    nPgNum = pDoc->GetPageByName( rBookmark, bIsMasterPage );
//STRIP001 	SdrObject*  pObj   = NULL;
//STRIP001 
//STRIP001 	if( nPgNum == SDRPAGE_NOTFOUND )
//STRIP001 	{
//STRIP001 		// Ist das Bookmark ein Objekt?
//STRIP001 		pObj = pDoc->GetObj( rBookmark );
//STRIP001 
//STRIP001 		if( pObj )
//STRIP001 			nPgNum = pObj->GetPage()->GetPageNum();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( nPgNum != SDRPAGE_NOTFOUND )
//STRIP001 	{
//STRIP001 		nPgNum = ( nPgNum - 1 ) / 2;
//STRIP001 
//STRIP001 //		if( aAnimPageList.IsPageNumIncluded( nPgNum ) )
//STRIP001 			JumpToPage( nPgNum );
//STRIP001 
//STRIP001 		// wenn es ein Objekt ist: im Show-Modus ggfs. Objektanimation
//STRIP001 		// ausfuehren, im Zeichenmodus das Objekt selektieren, sofern es
//STRIP001 		// kein Animationsobjekt (d.h. noch unsichtbar) ist
//STRIP001 		if( pObj )
//STRIP001 		{
//STRIP001 			if( bNativeMode )
//STRIP001 				AnimateNamedObject(rBookmark);
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if( pCurAnmList->GetPos(pObj) == LIST_ENTRY_NOTFOUND )
//STRIP001 				{
//STRIP001 					pView->UnmarkAll();
//STRIP001 					pView->MarkObj(pObj, pView->GetPageViewPvNum(0), FALSE);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* alle SlowObjRecords loeschen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FuSlideShow::ClearSlowObjList()
//STRIP001 {
//STRIP001 	if ( pSlowObjList )
//STRIP001 	{
//STRIP001 		for( void* pEntry = pSlowObjList->First(); pEntry; pEntry = pSlowObjList->Next() )
//STRIP001 			delete (SdSlowObjRecord*) pEntry;
//STRIP001 
//STRIP001 		pSlowObjList->Clear();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SlowObjRecord finden, NULL wenn's keinen gibt
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdSlowObjRecord* FuSlideShow::GetSlowObjRecord( SdrAttrObj* pObject )
//STRIP001 {
//STRIP001 	SdSlowObjRecord* pResult = NULL;
//STRIP001 
//STRIP001 	if ( pSlowObjList )
//STRIP001 	{
//STRIP001 		for( void* pEntry = pSlowObjList->First(); pEntry; pEntry = pSlowObjList->Next() )
//STRIP001 		{
//STRIP001 			if ( ( (SdSlowObjRecord*) pEntry )->pObject == pObject )
//STRIP001 			{
//STRIP001 				pResult = (SdSlowObjRecord*) pEntry;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ist ein Objekt zu langsam?
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::IsSlowObj( SdrAttrObj* pObject ) const
//STRIP001 {
//STRIP001 	BOOL bResult = FALSE;
//STRIP001 
//STRIP001 	if( !IsAlphaObj( pObject ) )
//STRIP001 	{
//STRIP001 		// Attributierung untersuchen
//STRIP001 		const SfxItemSet& rSet = pObject->GetItemSet();
//STRIP001 		// Fuellstil untersuchen
//STRIP001 		const XFillStyleItem& rFillStyle = (const XFillStyleItem&) rSet.Get( XATTR_FILLSTYLE );
//STRIP001 
//STRIP001 		// Farbverlaufe sind zu langsam
//STRIP001 		if( rFillStyle.GetValue() == XFILL_GRADIENT )
//STRIP001 			bResult = TRUE;
//STRIP001 
//STRIP001 		// Metafile-Objekte koennen sehr komplexe Grafiken enthalten (sind also
//STRIP001 		// potentiell langsam) und kommen ausserdem an der falschen Stelle raus,
//STRIP001 		// wenn sie auf einem anderen MapMode-Origin abgespielt werden
//STRIP001 		if( !bResult && pObject->ISA( SdrGrafObj) && ( (SdrGrafObj*) pObject )->GetGraphicType() == GRAPHIC_GDIMETAFILE )
//STRIP001 			bResult = TRUE;
//STRIP001 
//STRIP001 		// abgeblendete Objekte mit Text sind zu langsam, um waehrend eines
//STRIP001 		// Effektes gezeichnet zu werden
//STRIP001 		if (!bResult)
//STRIP001 		{
//STRIP001 			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 
//STRIP001 			if ( pInfo && pInfo->bDimmed && pObject->GetOutlinerParaObject() )
//STRIP001 				bResult = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Is object a alpha object
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::IsAlphaObj( SdrAttrObj* pObject ) const
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( pObject->ISA( SdrObjGroup ) )
//STRIP001 	{
//STRIP001 		SdrObjListIter aIter( *pObject->GetSubList(), IM_DEEPWITHGROUPS );
//STRIP001 		
//STRIP001 		for( SdrObject*	pO = aIter.Next(); pO && !bRet; pO = aIter.Next() )
//STRIP001 		{
//STRIP001 			if( !pO->ISA( SdrObjGroup ) )
//STRIP001 			{
//STRIP001 				const SfxItemSet& rSet = pO->GetItemSet();
//STRIP001 
//STRIP001 				if( ( ( (const XFillTransparenceItem&) rSet.Get( XATTR_FILLTRANSPARENCE ) ).GetValue() ||
//STRIP001 					  ( (const XLineTransparenceItem&) rSet.Get( XATTR_LINETRANSPARENCE ) ).GetValue()	) ||
//STRIP001 					( ( rSet.GetItemState( XATTR_FILLFLOATTRANSPARENCE ) == SFX_ITEM_SET ) &&
//STRIP001 					  ( (const XFillFloatTransparenceItem&) rSet.Get( XATTR_FILLFLOATTRANSPARENCE ) ).IsEnabled() ) )
//STRIP001 				{
//STRIP001 					bRet = TRUE;
//STRIP001 				}
//STRIP001 				else if( pO->ISA( SdrGrafObj ) )
//STRIP001 				{
//STRIP001 					SdrGrafObj* pGrafObj = (SdrGrafObj*) pO;
//STRIP001 
//STRIP001 					if( ( pGrafObj->GetGraphicType() == GRAPHIC_BITMAP && pGrafObj->GetGraphic().GetBitmapEx().IsAlpha() ) ||
//STRIP001 						( (const SdrGrafTransparenceItem&) rSet.Get( SDRATTR_GRAFTRANSPARENCE ) ).GetValue() )
//STRIP001 					{
//STRIP001 						bRet = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const SfxItemSet& rSet = pObject->GetItemSet();
//STRIP001 
//STRIP001 		if( ( ( (const XFillTransparenceItem&) rSet.Get( XATTR_FILLTRANSPARENCE ) ).GetValue() ||
//STRIP001 			  ( (const XLineTransparenceItem&) rSet.Get( XATTR_LINETRANSPARENCE ) ).GetValue()	) ||
//STRIP001 			( ( rSet.GetItemState( XATTR_FILLFLOATTRANSPARENCE ) == SFX_ITEM_SET ) &&
//STRIP001 			  ( (const XFillFloatTransparenceItem&) rSet.Get( XATTR_FILLFLOATTRANSPARENCE ) ).IsEnabled() ) )
//STRIP001 		{
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 		else if( pObject->ISA( SdrGrafObj ) )
//STRIP001 		{
//STRIP001 			SdrGrafObj* pGrafObj = (SdrGrafObj*) pObject;
//STRIP001 
//STRIP001 			if( ( pGrafObj->GetGraphicType() == GRAPHIC_BITMAP && pGrafObj->GetGraphic().GetBitmapEx().IsAlpha() ) ||
//STRIP001 				( (const SdrGrafTransparenceItem&) rSet.Get( SDRATTR_GRAFTRANSPARENCE ) ).GetValue() )
//STRIP001 			{
//STRIP001 				bRet = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Einen SlowObjRecord fuer ein Zeichenobjekt erstellen und in die Liste
//STRIP001 |* stellen.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::CreateSlowObjRecord( SdrAttrObj* pObject )
//STRIP001 {
//STRIP001 	Rectangle	aObjectRect( pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( pObject->GetBoundRect() ) ) );
//STRIP001 	Size		aPixelSize( pShowWindow->PixelToLogic( Size( 1, 1 ) ) );
//STRIP001 
//STRIP001 	aObjectRect.Right() += aPixelSize.Width();
//STRIP001 	aObjectRect.Bottom() += aPixelSize.Height();
//STRIP001 
//STRIP001 	SdSlowObjRecord*	pRec = new SdSlowObjRecord( pObject, aObjectRect.TopLeft() );
//STRIP001 	Point				aNegObjectPos( - pRec->aPos.X(), -pRec->aPos.Y() );
//STRIP001 	VirtualDevice*		pDev = new VirtualDevice( *pShowWindow );
//STRIP001 	MapMode				aMapMode( pShowWindow->GetMapMode() );
//STRIP001 	Color				aBackground( COL_WHITE );
//STRIP001 	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 	
//STRIP001 	aMapMode.SetOrigin( aNegObjectPos );
//STRIP001 	pDev->SetMapMode(aMapMode);
//STRIP001 	pAnmVDev->SetBackground( aBackground );
//STRIP001 	BOOL bOk = pDev->SetOutputSize( aObjectRect.GetSize() );
//STRIP001 
//STRIP001 	ExtOutputDevice aOut( pDev );
//STRIP001 	SdrPaintInfoRec aPaintInfoRec;
//STRIP001 	SetPaintModes( (SdrView*) pView, NULL, &aOut, &aPaintInfoRec );
//STRIP001 	pDev->SetDrawMode( pShowWindow->GetDrawMode() );
//STRIP001 
//STRIP001 	if( pInfo && pInfo->bDimmed )
//STRIP001 	{
//STRIP001 		if( pObject == pLayoutText )
//STRIP001 			PaintLayoutClone( pDev );
//STRIP001 		else
//STRIP001 			PaintDimmedObject( pObject, pDev, pInfo->aDimColor, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// falls es sich um ein animiertes Textobjekt handelt,
//STRIP001 		// das nicht animiert dargestellt werden soll, muessen
//STRIP001 		// wir ein nicht animiertes Clone-Objekt im Mtf aufzeichnen
//STRIP001 		if( !bAnimationAllowed && OBJIS_TEXTANIM( pObject ) )
//STRIP001 		{
//STRIP001 			// nicht animierten Clone zeichnen
//STRIP001 			SfxItemSet	aTempAttr( pDoc->GetPool(), SDRATTR_TEXT_ANIKIND, SDRATTR_TEXT_ANIKIND );
//STRIP001 			SdrObject*	pClone = pObject->Clone();
//STRIP001 
//STRIP001 			aTempAttr.Set(pClone->GetItemSet());
//STRIP001 
//STRIP001 			aTempAttr.Put( SdrTextAniKindItem() );
//STRIP001 
//STRIP001 			pClone->SetItemSet(aTempAttr);
//STRIP001 			
//STRIP001 			pClone->Paint( aOut, aPaintInfoRec );
//STRIP001 			delete pClone;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pObject->Paint( aOut, aPaintInfoRec );
//STRIP001 	}
//STRIP001 
//STRIP001 	Bitmap aObjectBitmap( pDev->GetBitmap(pRec->aPos, aObjectRect.GetSize() ) );
//STRIP001 
//STRIP001 	// Maske erzeugen
//STRIP001 	PaintDimmedObject( pObject, pDev, Color( COL_BLACK ), TRUE );
//STRIP001 	pDev->SetDrawMode( DRAWMODE_DEFAULT );
//STRIP001 	Bitmap aMaskBitmap( pDev->GetBitmap( pRec->aPos, aObjectRect.GetSize() ) );
//STRIP001 
//STRIP001 	if( !!aObjectBitmap && !!aMaskBitmap )
//STRIP001 	{
//STRIP001 		if( !pSlowObjList )
//STRIP001 			pSlowObjList = new List;
//STRIP001 
//STRIP001 		if( pSlowObjList->Count() >= 64 )
//STRIP001 		{
//STRIP001 			aObjectBitmap.ReleaseAccess( aObjectBitmap.AcquireReadAccess() );
//STRIP001 			aMaskBitmap.ReleaseAccess( aMaskBitmap.AcquireReadAccess() );
//STRIP001 			pRec->pBmpEx = new BitmapEx( aObjectBitmap, aMaskBitmap );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pRec->pImage = new Image( aObjectBitmap, aMaskBitmap );
//STRIP001 
//STRIP001 		pSlowObjList->Insert( pRec, LIST_APPEND );
//STRIP001 	} 
//STRIP001 	else
//STRIP001 		delete pRec, pRec = NULL;
//STRIP001 
//STRIP001 	delete pDev;
//STRIP001 
//STRIP001 	return( pRec != NULL );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ursprung des virtuellen Device nach links oben auf ein Vielfaches
//STRIP001 |* der BrushSize (relativ zum Ursprung des ShowWindows) setzen. Dies ist
//STRIP001 |* noetig, damit bei Benutzung von transparenten Farben die Farbmaske
//STRIP001 |* (relativ zu den logischen Koordinaten) an der gleichen Position beginnt
//STRIP001 |* wie im ShowWindow. Der MapMode-Origin des virtuellen Device wird
//STRIP001 |* entsprechend angepasst, so dass die rechte untere Ecke des Device auf
//STRIP001 |* den gleichen logischen Koordinaten verbleibt.
//STRIP001 |*
//STRIP001 |* Der Inhalt des virtuellen Device wird geloescht.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::AdjustAnmVDev( const Rectangle& rObjRect, const Color& rBackColor )
//STRIP001 {
//STRIP001 	MapMode		aMap( pShowWindow->GetMapMode() );
//STRIP001 	const Point	aTL( pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( rObjRect.TopLeft() ) ) );
//STRIP001 	Point		aOrg( pShowWindow->LogicToPixel( aTL ) );
//STRIP001 	Size		aSize( pShowWindow->LogicToPixel( rObjRect.GetSize() ) );
//STRIP001 
//STRIP001 	aOrg.X() -= VDEV_TOLERANCE;
//STRIP001 	aOrg.Y() -= VDEV_TOLERANCE;
//STRIP001 	aOrg = pShowWindow->PixelToLogic( aOrg );
//STRIP001 	aMap.SetOrigin( Point( -aOrg.X(), -aOrg.Y() ) );
//STRIP001 	aSize.Width() += ( VDEV_TOLERANCE << 1 );
//STRIP001 	aSize.Height() += ( VDEV_TOLERANCE << 1 );
//STRIP001 	pAnmVDev->SetBackground( rBackColor );
//STRIP001 	pAnmVDev->SetMapMode( aMap );
//STRIP001 
//STRIP001 	return pAnmVDev->SetOutputSizePixel( aSize );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Hat ein Objekt eine ClickAction, die bei ihrer Ausfuehrung in der
//STRIP001 |* Praesentation die Seite des Objekts veraendert?
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::AffectsOwnPage(SdrObject* pObject)
//STRIP001 {
//STRIP001 	BOOL bResult = FALSE;
//STRIP001 	SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 
//STRIP001 	if (pInfo)
//STRIP001 	{
//STRIP001 		// wenn das Objekt verschwinden kann
//STRIP001 		if ( pInfo->eClickAction == presentation::ClickAction_INVISIBLE || pInfo->eClickAction == presentation::ClickAction_VANISH )
//STRIP001 			bResult = TRUE;
//STRIP001 
//STRIP001 		// wenn das Objekt zu einem Objekt auf der gleichen Seite fuehrt
//STRIP001 		if (pInfo->eClickAction == presentation::ClickAction_BOOKMARK)
//STRIP001 		{
//STRIP001 			BOOL        bIsMasterPage;
//STRIP001             USHORT      nPgNum = pDoc->GetPageByName( pInfo->aBookmark, bIsMasterPage );
//STRIP001 			SdrObject*  pObj   = NULL;
//STRIP001 			
//STRIP001             if (nPgNum == SDRPAGE_NOTFOUND)
//STRIP001 			{
//STRIP001 				// Ist das Bookmark ein Objekt?
//STRIP001 				pObj = pDoc->GetObj(pInfo->aBookmark);
//STRIP001 
//STRIP001 				if (pObj)
//STRIP001 					nPgNum = pObj->GetPage()->GetPageNum();
//STRIP001 			}
//STRIP001 			if (nPgNum == pObject->GetPage()->GetPageNum())
//STRIP001 				bResult = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* nach dem Editieren des Gliederungstextes den Clone neu erstellen
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FuSlideShow::EndTextEdit(SdrTextObj* pTextObj)
//STRIP001 {
//STRIP001 	if (pTextObj == pLayoutText)
//STRIP001 	{
//STRIP001 		CreateLayoutClone();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* den Clone des Gliederungstextes neu erstellen
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FuSlideShow::CreateLayoutClone()
//STRIP001 {
//STRIP001 	if (pLayoutText)
//STRIP001 	{
//STRIP001 		delete pLayoutClone;
//STRIP001 		pLayoutClone = (SdrRectObj*)pLayoutText->Clone();
//STRIP001 		if (nDimPos > 0)
//STRIP001 			DimParas(pLayoutClone, 0, nDimPos - 1);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Resize ( ruft asynchron den Resize-Handler )
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::Resize( const Size& rNewSize )
//STRIP001 {
//STRIP001 	aPresSize = rNewSize;
//STRIP001 
//STRIP001 	// evtl. schon vorhandenes Event herausnehmen
//STRIP001 	if( nResizeEvt )
//STRIP001 		Application::RemoveUserEvent( nResizeEvt );
//STRIP001 
//STRIP001 	// neues Event erzeugen und merken
//STRIP001 	nResizeEvt = Application::PostUserEvent( LINK( this, FuSlideShow, ResizeHdl ) );
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Resize-Handler
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( FuSlideShow, ResizeHdl, void*, p )
//STRIP001 {
//STRIP001 	// Event wird abgearbeitet
//STRIP001 	nResizeEvt = 0UL;
//STRIP001 
//STRIP001 	if( nMagic != SLIDESHOW_MAGIC )
//STRIP001 		return 0L;
//STRIP001 
//STRIP001 	SdPage* pP = pDoc->GetSdPage( 0, PK_STANDARD );
//STRIP001     Size    aWinSize;
//STRIP001     MapMode aMapMode( MAP_100TH_MM ); 
//STRIP001 	
//STRIP001     aPageSize.Width() = pP->GetSize().Width() - pP->GetRgtBorder() - pP->GetLftBorder() - 2;
//STRIP001 	aPageSize.Height() = pP->GetSize().Height() - pP->GetUppBorder() - pP->GetLwrBorder() - 2;
//STRIP001 
//STRIP001     if( ANIMATIONMODE_VIEW != eAnimationMode )
//STRIP001     {
//STRIP001 	    const Size aOldSize( pShowWindow->GetSizePixel() );
//STRIP001 
//STRIP001 	    pShowWindow->SetSizePixel( aPresSize );
//STRIP001 	    pShowWindow->Show();
//STRIP001 
//STRIP001         // Call ToTop() to bring the window to top if
//STRIP001         // a) the old size is not degenerate (then the window will be closed
//STRIP001         // soon) and
//STRIP001         // b) the animation mode is not that of a preview (on the one hand
//STRIP001         // this leaves the old behaviour for the slide show mode unmodified
//STRIP001         // and on the other hand does not move the focus from the document
//STRIP001         // to the (preview) window; the ToTop() seems not to be necessary at
//STRIP001         // least for the preview).
//STRIP001         if( !aOldSize.Width() && !aOldSize.Height() )
//STRIP001             if (eAnimationMode != ANIMATIONMODE_PREVIEW)
//STRIP001                 pShowWindow->ToTop();           
//STRIP001 
//STRIP001 	    // Zoom-Faktor bestimmen
//STRIP001         pShowWindow->SetMapMode( aMapMode );
//STRIP001 	    aWinSize = pShowWindow->PixelToLogic( pShowWindow->GetOutputSizePixel() );
//STRIP001 	    Fraction aZoom( Min( aWinSize.Width()  * 1000 / aPageSize.Width(), aWinSize.Height() * 1000 / aPageSize.Height() ), 1000 );
//STRIP001 
//STRIP001 	    // MapMode bestimmen
//STRIP001 	    aMapMode = pShowWindow->GetMapMode();
//STRIP001 	    aMapMode.SetScaleX( aZoom );
//STRIP001 	    aMapMode.SetScaleY( aZoom );
//STRIP001 	    pShowWindow->SetMapMode( aMapMode );
//STRIP001     }
//STRIP001     else
//STRIP001 	    aMapMode = pShowWindow->GetMapMode();
//STRIP001 
//STRIP001 	// durch Zoomen veraendert
//STRIP001 	// durch Zoomen veraendert
//STRIP001     aWinSize = pShowWindow->GetOutputSizePixel();
//STRIP001 
//STRIP001     if( aWinSize.Width() > 0 && aWinSize.Height() > 0 )
//STRIP001         aWinSize = pShowWindow->PixelToLogic( aWinSize );
//STRIP001     else
//STRIP001     {
//STRIP001         aMapMode = MapMode( MAP_100TH_MM );
//STRIP001         aWinSize.Width() = aWinSize.Height() = 0;
//STRIP001     }
//STRIP001 
//STRIP001 	// Ursprung des sichtbaren Seitenbereichs im Fenster
//STRIP001 	aPageOrigin.X() = ( aWinSize.Width() - aPageSize.Width() ) >> 1;
//STRIP001 	aPageOrigin.Y() = ( aWinSize.Height() - aPageSize.Height() ) >> 1;
//STRIP001 
//STRIP001 	// MapMode-Origin so berechnen, dass das Seiteninnere richtig liegt,
//STRIP001 	// wenn die Seite bei (0,0) dargestellt wird
//STRIP001 	Point aMMOrigin( aPageOrigin.X() - pP->GetLftBorder(), aPageOrigin.Y() - pP->GetUppBorder() );
//STRIP001 	aMMOrigin = pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( aMMOrigin ) );
//STRIP001 
//STRIP001 	// muss nach MapMode-Verschiebung neu berechnet werden
//STRIP001 	aPageOrigin.X() = pP->GetLftBorder();
//STRIP001 	aPageOrigin.Y() = pP->GetUppBorder();
//STRIP001 
//STRIP001 	// Groesse des virtuellen Device bestimmen: die Grenzen sollen mit drauf
//STRIP001 	Point   aTopLeft( pShowWindow->LogicToPixel( Point( pP->GetLftBorder(), pP->GetUppBorder() ) ) );
//STRIP001 	Point   aBotRight( pShowWindow->LogicToPixel( Point( pP->GetLftBorder() + aPageSize.Width() - 2, pP->GetUppBorder() + aPageSize.Height() - 2 ) ) );
//STRIP001 	Size    aVDevSizePix( aBotRight.X() - aTopLeft.X() + 1, aBotRight.Y() - aTopLeft.Y() + 1 );
//STRIP001 
//STRIP001 	aMapMode.SetOrigin ( aMMOrigin );
//STRIP001 
//STRIP001 	pVDev->SetMapMode( aMapMode );
//STRIP001 
//STRIP001     if( ANIMATIONMODE_VIEW != eAnimationMode )
//STRIP001 	    pShowWindow->SetMapMode( aMapMode );
//STRIP001 
//STRIP001 	// Origin setzen; vorher auf Pixelkoordinaten runden
//STRIP001 	aMMOrigin = Point( -pP->GetLftBorder(), -pP->GetUppBorder() );
//STRIP001 	aMMOrigin = pVDev->PixelToLogic( pVDev->LogicToPixel( aMMOrigin ) );
//STRIP001 	aMapMode.SetOrigin( aMMOrigin );
//STRIP001 	pVDev->SetMapMode( aMapMode ); 
//STRIP001 
//STRIP001 	pVDev->SetBackground( pShowWindow->GetBackground() );
//STRIP001 	pVDev->SetFillColor( pShowWindow->GetFillColor() );
//STRIP001 	pVDev->SetLineColor( pShowWindow->GetLineColor() );
//STRIP001 
//STRIP001 	BOOL bAbort = !pVDev->SetOutputSizePixel( aVDevSizePix );
//STRIP001 
//STRIP001 	// wenn die aktuelle Seite bereits gesetzt ist - dieser Aufruf also
//STRIP001 	// nicht aus StartShow() heraus erfolgt -, muessen virtuelles Device,
//STRIP001 	// das Metafile, Caches, Animationslisten usw. neu aufgebaut werden.
//STRIP001 	// Im VDev ist jetzt nicht mehr die naechste Seite vorbereitet.
//STRIP001 	if( pActualPage )
//STRIP001 	{
//STRIP001 		PrepareForPage( pActualPage, FALSE );
//STRIP001 
//STRIP001 		if( pCurAnmList->Count() > 0 )
//STRIP001 			RepaintVDev( pActualPage, TRUE );
//STRIP001 
//STRIP001 		bVDevEmpty = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Verteiler fuer Animationen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::Animate()
//STRIP001 {
//STRIP001 	BOOL bResult = TRUE;
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Preview-Mode setzen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FuSlideShow::SetAnimationMode(AnimationMode eMode, SdShowWindow* pWindow)
//STRIP001 {
//STRIP001 	eAnimationMode = eMode;
//STRIP001 	bFullScreen = FALSE;
//STRIP001 	pShowWindow = pWindow;
//STRIP001 
//STRIP001 	if( eAnimationMode != ANIMATIONMODE_SHOW )
//STRIP001 	{
//STRIP001 		pShowWindow->Push();
//STRIP001 		nPushCount++;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* alle Animationsobjekte der Seite animieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::AnimatePage()
//STRIP001 {
//STRIP001 	SdPage*		pPage = pDoc->GetSdPage( aAnimPageList.GetCurrentPageNum(), PK_STANDARD );
//STRIP001 	ULONG		nObjectCount = pPage->GetObjCount();
//STRIP001 	SdrObject*	pObject = NULL;
//STRIP001 	BOOL		bAbort = FALSE;
//STRIP001 
//STRIP001 	bVDevEmpty = TRUE;
//STRIP001 
//STRIP001 	// das Fenster schwarz machen, falls man den Effekt sonst nicht sehen koennte
//STRIP001 	switch( pPage->GetFadeEffect() )
//STRIP001 	{
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_LEFT ):
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_UPPERLEFT ):
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_TOP ):
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_UPPERRIGHT ):
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_RIGHT ):
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_LOWERRIGHT ):
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_BOTTOM ):
//STRIP001 		case( presentation::FadeEffect_MOVE_FROM_LOWERLEFT ):
//STRIP001 		case( presentation::FadeEffect_ROLL_FROM_LEFT ):
//STRIP001 		case( presentation::FadeEffect_ROLL_FROM_TOP ):
//STRIP001 		case( presentation::FadeEffect_ROLL_FROM_RIGHT ):
//STRIP001 		case( presentation::FadeEffect_ROLL_FROM_BOTTOM ):
//STRIP001 		case( presentation::FadeEffect_STRETCH_FROM_LEFT ):
//STRIP001 		case( presentation::FadeEffect_STRETCH_FROM_TOP ):
//STRIP001 		case( presentation::FadeEffect_STRETCH_FROM_RIGHT ):
//STRIP001 		case( presentation::FadeEffect_STRETCH_FROM_BOTTOM ):
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		{
//STRIP001 			const ULONG nOldDrawMode = pShowWindow->GetDrawMode();
//STRIP001 			pShowWindow->SetDrawMode( DRAWMODE_DEFAULT );
//STRIP001 			pShowWindow->SetFillColor( Color( COL_BLACK ) );
//STRIP001 			pShowWindow->DrawRect( Rectangle( pShowWindow->PixelToLogic( Point() ), pShowWindow->GetOutputSize() ) );
//STRIP001 			pShowWindow->SetDrawMode( nOldDrawMode );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// in der Preview muessen wir zunaechst einmal alle
//STRIP001 	// Text- oder Grafikanimation stoppen, damit nicht
//STRIP001 	// immer mehr Animation auf einem OutDev gestartet werden
//STRIP001 	if ( ANIMATIONMODE_PREVIEW == eAnimationMode )
//STRIP001 	{
//STRIP001 		for ( ULONG nObject = 0; nObject < nObjectCount; nObject++ )
//STRIP001 		{
//STRIP001 			pObject	= pPage->GetObj(nObject);
//STRIP001 
//STRIP001 			if ( pObject->IsInserted() )
//STRIP001 			{
//STRIP001 				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pObject );
//STRIP001 
//STRIP001 				if ( !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) )
//STRIP001 					StopTextOrGraphicAnimation( pObject, TRUE );
//STRIP001 
//STRIP001 				// auch animierte Grafiken innerhalb von Gruppen sollen gestartet werden
//STRIP001 				if ( pObject->GetObjInventor() == SdrInventor && pObject->GetObjIdentifier() == OBJ_GRUP )
//STRIP001 				{
//STRIP001 					SdrObjList*		pSubList = pObject->GetSubList();
//STRIP001 					SdrObjListIter	aIter(*pSubList, IM_DEEPWITHGROUPS);
//STRIP001 
//STRIP001 					for( SdrObject* pGrpObj = aIter.Next(); pGrpObj; pGrpObj = aIter.Next() )
//STRIP001 						if ( !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) )
//STRIP001 							StopTextOrGraphicAnimation( pGrpObj, TRUE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	DoPageFade();
//STRIP001 
//STRIP001 	// Key-Events simulieren bis nichts mehr zu animieren oder abzublenden ist
//STRIP001 	// (oder bis die Show im Reschedule eines Effekts zerstoert wurde)
//STRIP001 	const KeyEvent aKEvt( 32, KeyCode( KEY_SPACE ) );
//STRIP001 
//STRIP001 	while( nMagic == SLIDESHOW_MAGIC && ( pCurAnmList->Count() || pDimObject ) )
//STRIP001 		KeyInput( aKEvt );
//STRIP001 
//STRIP001 	return bAbort;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Effekt mit getrennter Grafik- und Textanimation
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuSlideShow::CompoundEffect()
//STRIP001 {
//STRIP001 	BOOL bAbort = FALSE;
//STRIP001 
//STRIP001 	SdrObject*		pAnmObject = (SdrObject*)pCurAnmList->First();
//STRIP001 	SdrRectObj*		pBckgndClone = (SdrRectObj*)pAnmObject->Clone();
//STRIP001 	const Rectangle aLogicRect( pBckgndClone->GetLogicRect() );
//STRIP001 	const BOOL		bAnimTxtObj = OBJIS_TEXTANIM( pAnmObject );
//STRIP001 
//STRIP001 	// dessen Text loeschen
//STRIP001 	pBckgndClone->NbcSetOutlinerParaObject(NULL);
//STRIP001 	pBckgndClone->NbcSetLogicRect( aLogicRect );
//STRIP001 
//STRIP001 	// die Animationsinfo des Clones patchen: ohne Text hat der Texteffekt
//STRIP001 	// keinen Sinn
//STRIP001 	SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pBckgndClone );
//STRIP001 	presentation::AnimationEffect eTextEffect(pInfo->eTextEffect);
//STRIP001 	pInfo->eTextEffect = presentation::AnimationEffect_NONE;
//STRIP001 
//STRIP001 	// animieren; statt des Originalobjektes den Clone benutzen
//STRIP001 	const BOOL bSoundOn = pInfo->bSoundOn;
//STRIP001 
//STRIP001 	if( presentation::AnimationEffect_NONE == pInfo->eEffect )
//STRIP001 		pInfo->bSoundOn = FALSE;
//STRIP001 
//STRIP001 	bAbort = !AnimateObject( pBckgndClone );
//STRIP001 	pInfo->bSoundOn = bSoundOn;
//STRIP001 
//STRIP001 	/*******************************************************************
//STRIP001 	|* jetzt der Text, wenn es kein Lauftext ist
//STRIP001 	\******************************************************************/
//STRIP001 	if( ( SLIDESHOW_MAGIC == nMagic ) && pAnmObject->GetOutlinerParaObject() && !bAnimTxtObj )
//STRIP001 	{
//STRIP001 		switch( eTextEffect )
//STRIP001 		{
//STRIP001 			case presentation::AnimationEffect_APPEAR:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_LEFT:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_UPPERLEFT:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_TOP:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_UPPERRIGHT:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_RIGHT:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_LOWERRIGHT:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_BOTTOM:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_LOWERLEFT:
//STRIP001 			case presentation::AnimationEffect_FADE_TO_CENTER:
//STRIP001 			case presentation::AnimationEffect_FADE_FROM_CENTER:
//STRIP001 			case presentation::AnimationEffect_VERTICAL_STRIPES:
//STRIP001 			case presentation::AnimationEffect_HORIZONTAL_STRIPES:
//STRIP001 			case presentation::AnimationEffect_VERTICAL_LINES:
//STRIP001 			case presentation::AnimationEffect_HORIZONTAL_LINES:
//STRIP001 			case presentation::AnimationEffect_VERTICAL_CHECKERBOARD:
//STRIP001 			case presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD:
//STRIP001 			case presentation::AnimationEffect_CLOCKWISE:
//STRIP001 			case presentation::AnimationEffect_COUNTERCLOCKWISE:
//STRIP001 			case presentation::AnimationEffect_CLOSE_VERTICAL:
//STRIP001 			case presentation::AnimationEffect_CLOSE_HORIZONTAL:
//STRIP001 			case presentation::AnimationEffect_OPEN_VERTICAL:
//STRIP001 			case presentation::AnimationEffect_OPEN_HORIZONTAL:
//STRIP001 			case presentation::AnimationEffect_SPIRALIN_LEFT:
//STRIP001 			case presentation::AnimationEffect_SPIRALIN_RIGHT:
//STRIP001 			case presentation::AnimationEffect_SPIRALOUT_LEFT:
//STRIP001 			case presentation::AnimationEffect_SPIRALOUT_RIGHT:
//STRIP001 			case presentation::AnimationEffect_DISSOLVE:
//STRIP001 			case presentation::AnimationEffect_WAVYLINE_FROM_LEFT:
//STRIP001 			case presentation::AnimationEffect_WAVYLINE_FROM_TOP:
//STRIP001 			case presentation::AnimationEffect_WAVYLINE_FROM_RIGHT:
//STRIP001 			case presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM:
//STRIP001 			case presentation::AnimationEffect_HIDE:
//STRIP001 
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_LEFT:
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_TOP:
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_RIGHT:
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
//STRIP001 			case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:
//STRIP001 
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
//STRIP001 			case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:
//STRIP001 
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_LEFT:
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_TOP:
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
//STRIP001 			case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:
//STRIP001 
//STRIP001 			case presentation::AnimationEffect_HORIZONTAL_STRETCH:
//STRIP001 			case presentation::AnimationEffect_VERTICAL_STRETCH:
//STRIP001 
//STRIP001 			case presentation::AnimationEffect_HORIZONTAL_ROTATE:
//STRIP001 			case presentation::AnimationEffect_VERTICAL_ROTATE:
//STRIP001 
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_LEFT:
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_TOP:
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_RIGHT:
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_BOTTOM:
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:
//STRIP001 			case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:
//STRIP001 			{
//STRIP001 				// der hier erzeugte Clone wird innerhalb
//STRIP001 				// von AnimateLayoutText an pLayoutClone
//STRIP001 				// gesetzt und somit wieder automatisch zerstoert
//STRIP001 				delete pLayoutClone;
//STRIP001 				pLayoutClone = NULL;
//STRIP001 				pLayoutText = NULL;
//STRIP001 				pCompoundText = (SdrRectObj*) pAnmObject->Clone();
//STRIP001 				pInfo = pDoc->GetAnimationInfo( pCompoundText );
//STRIP001 				pInfo->eEffect = eTextEffect;
//STRIP001 				pInfo->eTextEffect = presentation::AnimationEffect_NONE;
//STRIP001 
//STRIP001 				// da das Object nach dem obigen AnimateObject
//STRIP001 				// entfernt wurde, jetzt noch einmal einfuegen
//STRIP001 				pCurAnmList->Insert( pAnmObject, (ULONG) 0 );
//STRIP001 				bAbort = !AnimateObject();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ASSERT(FALSE, "verbotener Effekt als Texteffekt");
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pBckgndClone;
//STRIP001 
//STRIP001 	return !bAbort;
//STRIP001 }

}
