/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_schdrgmt.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:16:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// header for SdrPageView
// auto strip #ifndef _SVDPAGV_HXX
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// header for SdrDragView
// auto strip #ifndef _SVDDRGV_HXX
// auto strip #include <bf_svx/svddrgv.hxx>
// auto strip #endif
// header for Vector2D
// auto strip #ifndef _VECTOR2D_HXX
// auto strip #include <tools/vector2d.hxx>
// auto strip #endif
// header for ExtOutputDevice
// auto strip #ifndef _XOUTX_HXX
// auto strip #include <bf_svx/xoutx.hxx>
// auto strip #endif
// header for SdrPathObj
// auto strip #ifndef _SVDOPATH_HXX
// auto strip #include <bf_svx/svdopath.hxx>
// auto strip #endif

// auto strip #include "chtmodel.hxx"
// auto strip #include "datapoin.hxx"
// auto strip #include "schview.hxx"
// auto strip #include "schdrgmt.hxx"
// auto strip #include "schresid.hxx"
#include "strings.hrc"
namespace binfilter {

//************************************************************
//   SchDragConstrainedToVector
//************************************************************

//STRIP001 TYPEINIT1(SchDragConstrainedToVector,SdrDragMethod);

//STRIP001 SchDragConstrainedToVector::SchDragConstrainedToVector( SdrDragView& rNewView,
//STRIP001 														Vector2D aConstraint, double fCurrPercent ) :
//STRIP001 		SdrDragMethod( rNewView ),
//STRIP001 		aConstraintVector( aConstraint ),
//STRIP001 		fStartShift( fCurrPercent/100.0 ),
//STRIP001 		fRadiusPercent( 0.0 )
//STRIP001 {
//STRIP001 	fConstraintVecScalar = aConstraint.Scalar( aConstraint );
//STRIP001 }

//STRIP001 void SchDragConstrainedToVector::TakeComment( String& rStr ) const
//STRIP001 {
//STRIP001 	rStr = String( SchResId( STR_PIE_SEGMENT_EXPLODED ) );
//STRIP001 	rStr.SearchAndReplaceAscii( "$(PERCENT)", String::CreateFromInt32( (long)fRadiusPercent ));
//STRIP001 }

//STRIP001 FASTBOOL SchDragConstrainedToVector::Beg()
//STRIP001 {
//STRIP001 	aTranslationVector = Vector2D( SAL_STATIC_CAST( Pair, DragStat().GetStart() ) );
//STRIP001 	DragStat().SetActionRect( GetMarkedRect() );
//STRIP001 
//STRIP001 	SdrPageView* pPV = rView.GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 	if( pPV )
//STRIP001 	{
//STRIP001 		SdrObject* pObj = rView.GetMarkList().GetMark( 0 )->GetObj();
//STRIP001 		if( pObj )
//STRIP001 		{
//STRIP001 			pObj->TakeXorPoly( pPV->DragPoly0(), TRUE );
//STRIP001 			pPV->DragPoly() = pPV->DragPoly0();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Show();
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 void SchDragConstrainedToVector::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	if( DragStat().CheckMinMoved( rPnt ) )
//STRIP001 	{
//STRIP001 		Vector2D aShiftVector(( Vector2D( SAL_STATIC_CAST( Pair, rPnt )) - aTranslationVector ));
//STRIP001 		double fShift = aConstraintVector.Scalar( aShiftVector ) / fConstraintVecScalar;	// projection
//STRIP001 
//STRIP001 		if( fShift )
//STRIP001 		{
//STRIP001 			if( fShift < -fStartShift )
//STRIP001 				fShift = -fStartShift;
//STRIP001 			else if( fShift > 1.0 - fStartShift )
//STRIP001 				fShift = 1.0 - fStartShift;
//STRIP001 
//STRIP001 			fRadiusPercent = fShift * 100.0;
//STRIP001 
//STRIP001 			Vector2D aNewPosVect = aTranslationVector + (aConstraintVector * fShift);
//STRIP001 			Point aNewPos = Point( (long)(aNewPosVect.X()), (long)(aNewPosVect.Y()) );
//STRIP001 			if( aNewPos != DragStat().GetNow() )
//STRIP001 			{
//STRIP001 				DragStat().NextMove( aNewPos );
//STRIP001 				Hide();
//STRIP001 				SdrPageView* pPV = rView.GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 				if( pPV->HasMarkedObj() )
//STRIP001 				{
//STRIP001 					pPV->DragPoly() = pPV->DragPoly0();
//STRIP001 					pPV->DragPoly().Move( DragStat().GetDX(), DragStat().GetDY() );
//STRIP001 				}
//STRIP001 				Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 FASTBOOL SchDragConstrainedToVector::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 //  	rView.MoveMarkedObj( Size( DragStat().GetDX(), DragStat().GetDY() ), bCopy );
//STRIP001 	Hide();
//STRIP001 
//STRIP001 	// this is done to transfer the result to the chart objects
//STRIP001 	// If sometimes the pies are more specific objects than SdrCircObjs
//STRIP001 	// they will get a method for the transfer
//STRIP001 	ChartModel& rModel = SAL_STATIC_CAST( SchView&, rView ).GetDoc();
//STRIP001 
//STRIP001 	SdrObject*  pObj = rView.GetMarkList().GetMark(0)->GetObj();
//STRIP001 
//STRIP001 	SchDataPoint* pPoint = GetDataPoint( *pObj );
//STRIP001 	DBG_ASSERT( pPoint, "Pie has no data point user data" );
//STRIP001 
//STRIP001 	if( pPoint )
//STRIP001 		rModel.SetPieSegOfs( pPoint->GetCol(),
//STRIP001                              rModel.PieSegOfs( pPoint->GetCol())
//STRIP001                              + (long)fRadiusPercent );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 Pointer SchDragConstrainedToVector::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_MOVE);
//STRIP001 }

//STRIP001 FASTBOOL SchDragConstrainedToVector::IsMoveOnly() const
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }

}
