/*************************************************************************
 *
 *  $RCSfile: vsound.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/04 11:24:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _VCL_VSOUND_HXX
#define _VCL_VSOUND_HXX

#if defined(LINUX) || defined(FREEBSD)
#define USE_OSS
#endif

#ifdef SOLARIS
#define USE_DEVAUDIO
#endif

#if defined (LINUX) || defined(FREEBSD) || defined (SOLARIS)
#define USE_NAS
#endif

#if STLPORT_VERSION>=321
#include <cstdarg>
#endif

#include <sys/stat.h>

#include <tools/string.hxx>

class SalSound;

#ifdef _USE_NAMESPACE
namespace vcl_sal {
#endif
	class VSound
	{
	protected:
		VSound( ::SalSound* pSound ) : m_pSalSound( pSound ), m_pBuffer( NULL ) {}

		// instance data
		::SalSound*			m_pSalSound;
		// pointer to mmaped file
		char*		m_pBuffer;
		struct stat m_aStat;

		void initBuffer();
		void releaseBuffer();

		virtual BOOL isValid() = 0;
	public:
		virtual ~VSound() {}

		virtual void play() = 0;
		virtual void stop() = 0;
		virtual void pause() = 0;
		virtual void cont() = 0;

		static VSound* createVSound( SalSound* );
	};

	// a class to convert bytestreams from one codec to another
	class AudioConverter
	{
	public:
		virtual ~AudioConverter();

		virtual void reset() = 0;
		// the returned memory should be deleted by user
		virtual char* convert( char* pBuffer, int nBytesIn, int& nBytesOut ) = 0;

		// conversion from G721 encoded data
		// input is G721 conforming byte buffer (actually nibble buffer)
		// output is uLaw encoded byte buffer
		static AudioConverter* createG721ToULawConverter();

		static AudioConverter* createINT8ToUINT16Converter();
		static AudioConverter* createSwapINT16Converter();
	};

#ifdef _USE_NAMESPACE
}
#endif

#if OSL_DEBUG_LEVEL > 1
#include <stdarg.h>
#include <stdio.h>
inline void SalDbgAssert( const char* pFmt, ... )
{
	va_list ap;
	va_start( ap, &pFmt );
	vfprintf( stderr, pFmt, ap );
	va_end( ap );
}
#else
inline void SalDbgAssert( const char* pFmt, ... )
{
}
#endif

#endif
