/*************************************************************************
 *
 *  $RCSfile: dbdefobj.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 15:31:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SBA_DBDEFOBJ_HXX
#define _SBA_DBDEFOBJ_HXX

#include "dbobj.hxx"

#ifndef _SBA_DBOBJENU_HXX
#include "dbobjenu.hxx"
#endif

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#ifndef _SDB_SDBSTOR_HXX //autogen
#include <sdb/sdbstor.hxx>
#endif

#define EXPLORER_EXCHANGE	0x0001
#define RTF_EXCHANGE		0x0002
#define HTML_EXCHANGE		0x0003

class SbaDataExchObj;
class SbaExplorerExchObj;
class SfxPoolItem;

//==================================================================
// SbaDBDef
//==================================================================
class SbaDBDef : public SbaDBObj, public SfxListener
{
	friend class SbaDatabase;
	friend class SbaDBDataDefDocSh;
	friend class SbaFileDefDocSh;

protected:
	DBObject				edbObj;
	unsigned char			aLockCounter;	// Object zu schreiben gesperrt
	SdbStorageRef			aDBStor;

public:
	TYPEINFO();
	SbaDBDef(SbaDatabase* pDB,
			 const String& rName,
			 DBObject eObj,
			 BOOL _bNew = TRUE,
			 BOOL _bShow = TRUE);

	virtual	~SbaDBDef();

	// Zugriff auf den Vater, geht nur wenn Objekt geoeffnet
	virtual SbaDatabase* GetDatabase() const;

	// Ist das Object bereits zum Update (Aendern der Definition) geffnet worden?
	BOOL    IsLocked() const {return (aLockCounter > 0);}
	virtual BOOL SetLock(BOOL _bLocked);
	inline 	BOOL Lock() {return SetLock(TRUE);}
	inline  BOOL UnLock() {return SetLock(FALSE);}

	DBObject GetKind()		const {return edbObj;}

	virtual BOOL OpenDoc(BOOL bReadOnly, const SfxPoolItem *pArg1, ... );
	virtual BOOL Drop();
	virtual BOOL Rename(const String& rNewName);
	virtual String ToURL() const;
	virtual SbaDataExchObj* CreateDataExchObj( USHORT nType, const String& rExchStr = String() );

	// reversibles Loeschen
	virtual BOOL DropReversible();
		// Loeschen mit Hilfe des DeleteObject an der Datenbank

	// kann die Definition freigegeben werden
	virtual BOOL CanRelease();

	static String ToURL(const String& rDBName, DBObject eKind, const String& rName);
	static SbaDataExchObj* CreateDataExchObj(USHORT nType, SbaDatabase* pDB, DBObject eKind,
		const String& rName);

protected:
	virtual void SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
							const SfxHint& rHint, const TypeId& rHintType);

	virtual void Close();
	virtual void OnCreate();
	virtual BOOL DropImpl() = 0;
	virtual BOOL RenameImpl(const String& rNewName) = 0;
	virtual BOOL Compare(const SdbObj&) const;

	virtual BOOL DropReversibleImpl();

	// Zugriff auf die SDB-Datenbank
	BOOL BeginTrans(BOOL bForStore);
	BOOL EndTrans(BOOL bCommit = FALSE);
	BOOL Commit() {return EndTrans(TRUE);}
	BOOL Rollback(){return EndTrans(FALSE);}

	static ULONG CopyTo(SvStream& rTarget, SvStream& rDest);
};

SV_DECL_IMPL_REF(SbaDBDef);

#if _SOLAR__PRIVATE

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

#include "sbadb.hxx"

class SbaDBDefItem : public SfxPoolItem
{
	SbaDatabaseRef	xDatabase;
	SbaDBDefRef		xDBDef;

public:
	TYPEINFO();
	SbaDBDefItem( USHORT nWhich ):SfxPoolItem(nWhich){}
	SbaDBDefItem( USHORT nWhich, SbaDBDef* pDef = NULL, SbaDatabase* pDB = NULL)
		:SfxPoolItem(nWhich),xDBDef(pDef),xDatabase(pDB){};
	SbaDatabase* GetDatabase() const {return &xDatabase;}
	SbaDBDef* GetDBDef() const {return &xDBDef;}
	virtual int operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0) const;
};

#endif

#endif

