/*************************************************************************
 *
 *  $RCSfile: MappingWrapper.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kr $ $Date: 2001/05/04 11:58:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.uno;


/**
 * This class wraps an <code>IBridge</code> to be a <code>Mapping</code>.
 * <p>
 * @version 	$Revision: 1.3 $ $ $Date: 2001/05/04 11:58:23 $
 * @author 	    Kay Ramme
 * @see         com.sun.star.uno.IBridge
 * @see         com.sun.star.uno.Mapping
 * @since       UDK1.0
 */
class MappingWrapper implements IMapping {
	protected IBridge _iBridge;

	/**
	 * Constructs a <code>Mapping</code> from an <code>IBridge</code>.
	 * <p>
	 * @param  iBridge   the <code>IBridge</code> which is to be wrapped
	 */
	MappingWrapper(IBridge iBridge) {
		_iBridge = iBridge;
	}

	/**
	 * Maps an interface from one environment to another.
	 * Implements the <code>Mapping</code>
	 * <p>
	 * @return   the object mapped to the destination environment
	 * @param    object		source object that is to be mapped
	 * @param    zInterface description of the interface that is to be mapped
	 */
	public Object mapInterface(Object object, Type type) {
		return _iBridge.mapInterfaceTo(object, type);
	}
}

