/*************************************************************************
 *
 *  $RCSfile: collator_cjk.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 11:06:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <collator_cjk.hxx>
#include <com/sun/star/i18n/CollatorOptions.hpp>
#include <i18nutil/casefolding.hxx>

using namespace com::sun::star::lang;
using namespace com::sun::star::uno;
using namespace rtl;

namespace com { namespace sun { namespace star { namespace i18n {

Collator_CJK::Collator_CJK(sal_uInt16* index, sal_uInt16* weight) : collate_index(index), collate_weight(weight)
{
}

sal_Int32 SAL_CALL
Collator_CJK::compareSubstring( const OUString& str1, sal_Int32 off1, sal_Int32 len1, 
    	const OUString& str2, sal_Int32 off2, sal_Int32 len2) throw (RuntimeException)
{
	const sal_Unicode *uniStr1 = str1.getStr() + off1;
	const sal_Unicode *uniStr2 = str2.getStr() + off2;

	MappingElement e1, e2;
	sal_Int32 idx1, idx2;

	idx1 = idx2 = 0;
	while (idx1 < len1 && idx2 < len2) {
	    sal_uInt16 w1, w2, i1, i2;
	    sal_Unicode c1, c2;

	    if (tranModules != TransliterationModules_END_OF_MODULE) {
		c1 = casefolding::getNextChar(uniStr1, idx1, len1, e1, aLocale, MappingTypeFullFolding, tranModules);
		c2 = casefolding::getNextChar(uniStr2, idx2, len2, e2, aLocale, MappingTypeFullFolding, tranModules);
	    } else {
		c1 = uniStr1[idx1++];
		c2 = uniStr2[idx2++];
	    }

	    i1 = collate_index[c1 >> 8];
	    i2 = collate_index[c2 >> 8];

	    w1 = (i1 == 0xFFFE) ? 0x0000 : ((i1 == 0xFFFF) ? 0xFFFF : collate_weight[i1 + (c1 & 0xFF)]);
	    w2 = (i2 == 0xFFFE) ? 0x0000 : ((i2 == 0xFFFF) ? 0xFFFF : collate_weight[i2 + (c2 & 0xFF)]);

	    if (w1 != w2)
		return w1 < w2 ? -1 : 1;
	    else if ((w1 == 0x0000 || w1 == 0xFFFF) && c1 != c2) 
		return c1 < c2 ? -1 : 1;
	}
	return idx1 == len1 && idx2 == len2 ? 0 : (idx1 == len1 ? -1 : 1);
}

sal_Int32 SAL_CALL
Collator_CJK::compareString( const OUString& str1, const OUString& str2) throw(RuntimeException)
{
	return compareSubstring(str1, 0, str1.getLength(), str2, 0, str2.getLength());
}

} } } }
