/*************************************************************************
 *
 *  $RCSfile: soffice.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: th $ $Date: 2001/05/11 10:06:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include "inetset.hxx"

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif

using namespace ::rtl;

OUString _popName, _smtpName, _nntpServer, _userPopName, _userDir, _cacheDir;
DirEntry _src, _srcConfig, _srcStore, _dst, _dstConfig, _dstStore;

void scanDirectoryForSCC(Directory *user, const DirEntry &current,
                         Directory *mailBox, Directory *newsBox,
                         DirEntry &relName, Directory *imapBox) {
    USHORT i, nDirEntryCount;
    Dir aFiles(current, FSYS_KIND_FILE);
    nDirEntryCount = aFiles.Count(TRUE);
    for (i = 0; i < nDirEntryCount; i++) {
        DirEntry d = aFiles[i];
        if (d.IsValid()) {
            OUString ext = d.GetExtension();
            if (ext.toAsciiUpperCase().compareToAscii("SCC") ==  0) { // .scc-file
                String fullPath = d.GetFull();
                DirEntry fp(fullPath, FSYS_STYLE_HOST);
                CntViewStorageFile aViewStorage(fp.GetFull());
                if (aViewStorage.isValid()) {
#if ( SUPD >= 568 )
                    OUString aReferedURL = aViewStorage.getReferredURL();
                    if (aReferedURL.compareToAscii("out:", 4) == 0)
#else
                    OUString aContentTypeString = aViewStorage.getContentType();
                    if (aContentTypeString == CONTENT_TYPE_STR_X_CNT_OUTBOX)
#endif
                    { // outbox
                        Directory *outbox = new Directory(FALSE);
                        outbox->insert(createNum("typ", mtStarOffice));
                        outbox->insert(createNum("ServerTyp", stSMTP));
                        outbox->insert(createData("ServerName",
                                                  OUString(_smtpName)));
                        Directory *files = new Directory(FALSE);
                        Directory *scc = new Directory(FALSE);
                        DirEntry source = _src;
                        source += relName;
                        source += d.GetName();
                        DirEntry dest = _dst;
                        dest += relName;
                        dest += d.GetName();
                        scc->insert(createData("quelle", source.GetFull()));
                        scc->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("scc", scc));
                        Directory *user = new Directory(FALSE);
                        source = _srcStore;
                        source += aViewStorage.getUserStorageFileName();
                        dest = _dstStore;
                        dest += aViewStorage.getUserStorageFileName();
                        user->insert(createData("quelle", source.GetFull()));
                        user->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("user", user));
                        source = _srcConfig;
                        source += aViewStorage.getCacheStorageFileName();
                        dest = _dstConfig;
                        dest += aViewStorage.getCacheStorageFileName();
                        Directory *cache = new Directory(FALSE);
                        cache->insert(createData("quelle", source.GetFull()));
                        cache->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("cache", cache));
                        outbox->insert(createSub("dateien", files));
                        if (!outbox->hasElements()) delete outbox;
                        mailBox->insert(createSub(d.GetBase(), outbox));
                    } else if
#if ( SUPD >= 568 )
                    (aReferedURL.compareToAscii("imap:", 5) == 0)
#else
                    (aContentTypeString == CONTENT_TYPE_STR_X_CNT_IMAPBOX)
#endif
                    { // IMAP
                        Directory *imap = new Directory(FALSE);
                        imap->insert(createNum("typ", mtStarOffice));
                        imap->insert(createNum("ServerTyp", stIMAP));
                        if (_popName.getLength() > 0) imap->insert(
                          createData("ServerName", OUString(_popName)));
                        Directory *files = new Directory(FALSE);
                        Directory *scc = new Directory(FALSE);
                        DirEntry source = _src;
                        source += relName;
                        source += d.GetName();
                        DirEntry dest = _dst;
                        dest += relName;
                        dest += d.GetName();
                        scc->insert(createData("quelle", source.GetFull()));
                        scc->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("scc", scc));
                        Directory *user = new Directory(FALSE);
                        source = _srcStore;
                        source += aViewStorage.getUserStorageFileName();
                        dest = _dstStore;
                        dest += aViewStorage.getUserStorageFileName();
                        user->insert(createData("quelle", source.GetFull()));
                        user->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("user", user));
                        Directory *cache = new Directory(FALSE);
                        source = _srcConfig;
                        source += aViewStorage.getCacheStorageFileName();
                        dest = _dstConfig;
                        dest += aViewStorage.getCacheStorageFileName();
                        cache->insert(createData("quelle", source.GetFull()));
                        cache->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("cache", cache));
                        imap->insert(createSub("dateien", files));
                        if (!imap->hasElements()) delete imap;
                        mailBox->insert(createSub(d.GetBase(), imap));
                    } else if
#if ( SUPD >= 568 )
                    (aReferedURL.compareToAscii("pop3:", 5) == 0)
#else
                    (aContentTypeString == CONTENT_TYPE_STR_X_CNT_POP3BOX)
#endif
                    { // popbox
                        Directory *popbox = new Directory(FALSE);
                        popbox->insert(createNum("typ", mtStarOffice));
                        popbox->insert(createNum("ServerTyp", stPOP));
                        popbox->insert(createData("ServerName",
                          OUString(_popName)));
                        popbox->insert(createData("MailUserName",
                          OUString(_userPopName)));
                        Directory *files = new Directory(FALSE);
                        Directory *scc = new Directory(FALSE);
                        DirEntry source = _src;
                        source += relName;
                        source += d.GetName();
                        DirEntry dest = _dst;
                        dest += relName;
                        dest += d.GetName();
                        scc->insert(createData("quelle", source.GetFull()));
                        scc->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("scc", scc));
                        Directory *user = new Directory(FALSE);
                        source = _srcStore;
                        source += aViewStorage.getUserStorageFileName();
                        dest = _dstStore;
                        dest += aViewStorage.getUserStorageFileName();
                        user->insert(createData("quelle", source.GetFull()));
                        user->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("user", user));
                        source = _srcConfig;
                        source += aViewStorage.getCacheStorageFileName();
                        dest = _dstConfig;
                        dest += aViewStorage.getCacheStorageFileName();
                        Directory *cache = new Directory(FALSE);
                        cache->insert(createData("quelle", source.GetFull()));
                        cache->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("cache", cache));
                        popbox->insert(createSub("dateien", files));
                        if (!popbox->hasElements()) delete popbox;
                        mailBox->insert(createSub(d.GetBase(), popbox));
                    } else if
#if ( SUPD >= 568 )
                    (aReferedURL.compareToAscii("news:", 5) == 0)
#else
                    (aContentTypeString == CONTENT_TYPE_STR_X_CNT_NEWSBOX)
#endif
                    { // NEWS
                        Directory *newsbox = new Directory(FALSE);
                        if (_nntpServer.getLength() > 0) newsbox->insert(
                          createData("NNTPServer", _nntpServer));
                        Directory *files = new Directory(FALSE);
                        Directory *scc = new Directory(FALSE);
                        DirEntry source = _src;
                        source += relName;
                        source += d.GetName();
                        DirEntry dest = _dst;
                        dest += relName;
                        dest += d.GetName();
                        scc->insert(createData("quelle", source.GetFull()));
                        scc->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("scc", scc));
                        Directory *user = new Directory(FALSE);
                        source = _srcStore;
                        source += aViewStorage.getUserStorageFileName();
                        dest = _dstStore;
                        dest += aViewStorage.getUserStorageFileName();
                        user->insert(createData("quelle", source.GetFull()));
                        user->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("cache", user));
                        Directory *cache = new Directory(FALSE);
                        source = _srcConfig;
                        source += aViewStorage.getCacheStorageFileName();
                        dest = _dstConfig;
                        dest += aViewStorage.getCacheStorageFileName();
                        cache->insert(createData("quelle", source.GetFull()));
                        cache->insert(createData("ziel", dest.GetFull()));
                        files->insert(createSub("user", cache));
                        newsbox->insert(createSub("dateien", files));
                        if (!newsbox->hasElements()) delete newsbox;
                        newsBox->insert(createSub(d.GetBase(), newsbox));
                    }
                }
            }
        }
    }
    Dir aDirs(current, FSYS_KIND_DIR);
    nDirEntryCount = aDirs.Count(TRUE);
    for (i = 0; i < nDirEntryCount; i++) {
        DirEntry d = aDirs[i];
        if (d.IsValid() && (d.GetFlag() == FSYS_FLAG_NORMAL)) {
            DirEntry relSub = relName;
            relSub += d.GetName();
            scanDirectoryForSCC(user, d, mailBox, newsBox, relSub, imapBox);
        }
    }
}

void readSOfficeINI(Config &config, Directory *root,
                    OString OfficeVersionName, const OUString &instPath) {
    OString browserStrEntries[] = { "HomePage", "HTTPProxyName",
    "FTPProxyName", "SecurityProxyName", "SocksProxyName", "NoProxy" };
#define browserStrEntryCount (sizeof(browserStrEntries) / \
    sizeof(browserStrEntries[0]))
    OString browserNumEntries[] = { "HTTPProxyPort", "FTPProxyPort",
      "SecurityProxyPort", "SocksProxyPort" };
#define browserNumEntryCount (sizeof(browserNumEntries) / \
    sizeof(browserNumEntries[0]))
    OString browserNum16Entries[] = { "ProxyType" };
#define browserNum16EntryCount (sizeof(browserNum16Entries) / \
    sizeof(browserNum16Entries[0]))
    OString mailStrEntries[] = { "SMTPServer", "POPServer", "MailUserName"};
#define mailStrEntryCount (sizeof(mailStrEntries) / sizeof(mailStrEntries[0]))
    OString dirs = "Directories";
    if (config.HasGroup(dirs)) {
        config.SetGroup(dirs);
        OString configDir = config.ReadKey("Config-Dir");
        if (configDir.getLength() == 0) return;
        OString storeDir = config.ReadKey("Storage-Dir");
        if (storeDir.getLength() == 0) {
            storeDir = config.ReadKey("Cache-Dir"); // SOffice 4.0 SP2
            if (storeDir.getLength() == 0) return;
        }
        if (configDir.getStr()[0] == '$') {
            if (configDir.compareTo("$(user)", 7) != COMPARE_EQUAL) return;
            _srcConfig = _src;
            _srcConfig += DirEntry(OUString::createFromAscii(
              configDir.copy(8)));
        } else _srcConfig = DirEntry(OUString::createFromAscii(
          configDir));
        if (storeDir.getStr()[0] == '$') {
            if (storeDir.compareTo("$(user)", 7) != COMPARE_EQUAL) return;
            _srcStore = _src;
            _srcStore += DirEntry(OUString::createFromAscii(
              storeDir.copy(8)));
        } else _srcStore = DirEntry(OUString::createFromAscii(
          storeDir));
    }
    OString user = "User";
    if (config.HasGroup(user)) {
        config.SetGroup(user);
        OString firstName = config.ReadKey("User-FirstName");
        OString lastName = config.ReadKey("User-Name");
        OString userName = "*";
        userName += firstName;
        if (lastName.getLength() > 0) {
            userName += " ";
            userName += lastName;
        }
        if (userName.getLength() > 2) {               // at least one of the names
            OString inet = "INet";           // (first/last) is not empty
            if (config.HasGroup(inet)) {
                int i;
                OString browser = "browser";
                browser += "/";
                browser += OfficeVersionName;
                config.SetGroup(inet);
                for (i = 0; i < browserStrEntryCount; i++) {
                    OString key = config.ReadKey(browserStrEntries[i]);
                    if (key.getLength() > 0) root->insert(createData(
                      browserStrEntries[i], key), browser);
                }
                for (i = 0; i < browserNumEntryCount; i++) {
                    OString key = config.ReadKey(browserNumEntries[i]);
                    if (key.getLength() > 0) root->insert(createNumData(
                      browserNumEntries[i], key), browser);
                }
                for (i = 0; i < browserNum16EntryCount; i++) {
                    OString key = config.ReadKey(browserNum16Entries[i]);
                    if (key.getLength() > 0) root->insert(createNum16Data(
                      browserNum16Entries[i], key), browser);
                }
                Directory *office = new Directory(FALSE);
                Directory *user = new Directory(FALSE);
                for (i = 0; i < mailStrEntryCount; i++) {
                    OString key = config.ReadKey(mailStrEntries[i]);
                    if (key.getLength() > 0) user->insert(createData(
                      mailStrEntries[i], key));
                }
                _userPopName = OUString::createFromAscii(
                  config.ReadKey("MailUserName").GetBuffer());
                _popName = OUString::createFromAscii(
                  config.ReadKey("POPServer").GetBuffer());
                _smtpName = OUString::createFromAscii(
                  config.ReadKey("SMTPServer").GetBuffer());
                _nntpServer = OUString::createFromAscii(
                  config.ReadKey("NNTPServer").GetBuffer());
                Directory *mailBox = new Directory(FALSE);
                Directory *newsBox = new Directory(FALSE);
                Directory *imapBox = new Directory(FALSE);
                // search the Explorer-Subdir for *.scc-files
                DirEntry Explorer(instPath);
                Explorer += DirEntry(OUString::createFromAscii("Explorer"));
                DirEntry relName(OUString::createFromAscii("Explorer"));
                scanDirectoryForSCC(user, Explorer, mailBox,
                                    newsBox, relName, imapBox);
                //  search the config/groups-Subdir for *.scc-files
                Explorer = DirEntry(instPath); // DirEntry = OUString missing
                Explorer += DirEntry(OUString::createFromAscii("config"));
                Explorer += DirEntry(OUString::createFromAscii("groups"));
                relName = DirEntry(OUString::createFromAscii("config"));
                relName += DirEntry(OUString::createFromAscii("groups"));
                scanDirectoryForSCC(user, Explorer, mailBox,
                                    newsBox, relName, imapBox);
                // mail & imap
                if (!mailBox->hasElements()) delete mailBox;
                else user->insert(createSub("box", mailBox));
                if (!imapBox->hasElements()) delete imapBox;
                else user->insert(createSub("box", imapBox));
                if (!user->hasElements()) delete user;
                else office->insert(createSub(userName, user));
                if (!office->hasElements()) delete office;
                else root->insert(createSub(
                  OfficeVersionName, office), "mail");
                if (!newsBox->hasElements()) delete newsBox;
                else {
                    char c[1024];
                    sprintf(c, "news/%s", OfficeVersionName.getStr());
                    root->insert(createSub(userName, newsBox),
                      OUString::createFromAscii(c));
                }
            }
        }
    }
}

void readStarOfficeFromConfig(Directory *root, const OUString &aSVersionName) {
    OString versions[] = {"StarOffice 4.0 SP3", "StarOffice 5.0",
      "StarOffice 5.1"};
#define versionCount (sizeof(versions) / sizeof(versions[0]))
    Config sversion(aSVersionName);
    OString Versions = "Versions";
    if (!sversion.HasGroup(Versions)) return;
    sversion.SetGroup(Versions);

//  SfxIniManager *pIniMan = SfxIniManager::Get();
//   OUString aMyPath = pIniMan->SubstPathVars(
//      OUString::createFromAscii("$(user)"));

    OUString aMyPath = SvtPathOptions().SubstituteVariable( OUString::createFromAscii("$(user)") );

    if ((aMyPath.getLength() == 0) ||
        (aMyPath.compareToAscii("$(user)") == 0)) return;
    _dst = DirEntry(DirEntry(aMyPath).GetFull());
    _dstConfig = _dst;
    _dstConfig += DirEntry(OUString::createFromAscii("config"));
    _dstStore = _dst;
    _dstStore += DirEntry(OUString::createFromAscii("store"));
    for (int i = 0; i < versionCount; i++) {
        OString officeInstPath = sversion.ReadKey(versions[i]);
        if (officeInstPath.getLength() > 0) {
            DirEntry sofficeName(Config::GetConfigName(
              OUString::createFromAscii(officeInstPath),
              OUString::createFromAscii("soffice")));
            if (sofficeName.Exists()) {
                _src = DirEntry(OUString::createFromAscii(officeInstPath.getStr()));
                Config sofficeIni(sofficeName.GetFull());
                readSOfficeINI(sofficeIni, root, versions[i],
                  OUString::createFromAscii(officeInstPath));
            }
        }
    }
}

void readStarOffice40_50(Directory *root) {
    OUString aPath, aVersion, aLocation;
    aVersion = OUString::createFromAscii("sversion");
#if (defined SAL_W32)
    aLocation = OUString::createFromAscii("?$");
#endif
    if (NAMESPACE_VOS(OProfile)::getProfileName(aPath, aVersion, aLocation)) {
        DirEntry sversionIni(aPath);
        if (!sversionIni.Exists()) return;
        readStarOfficeFromConfig(root, sversionIni.GetFull());
    }
}

void readStarOffice51(Directory *root) {
    OUString aPath, aVersion, aLocation;
    aVersion = OUString::createFromAscii("sversion");
#if (defined SAL_W32)
    aLocation = OUString::createFromAscii("?^");
#endif
    if (NAMESPACE_VOS(OProfile)::getProfileName(aPath, aVersion, aLocation)) {
        String sversionName(aPath);
        DirEntry sversionIni = DirEntry(sversionName);
        if (!sversionIni.Exists()) return;
        readStarOfficeFromConfig(root, sversionIni.GetFull());
    }
}

void readStarOffice(Directory *root) {
    readStarOffice40_50(root);
#ifdef SAL_W32
    readStarOffice51(root);
#endif
}

