/*************************************************************************
 *
 *  $RCSfile: frameset.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_FRAMESET_HXX
#define _ADR_FRAMESET_HXX

#ifndef _SV_DOCKWIN_HXX
#include <vcl/dockwin.hxx>
#endif

class Wallpaper;
struct ImplSplitSet;
struct ImplSplitItem;
// -----------------------
// - AdrFrameSetItemBits -
// -----------------------

typedef USHORT AdrFrameSetItemBits;

// -------------------------------
// - Bits fuer AdrFrameSet-Items -
// -------------------------------

#define AFSIB_FIXED					((AdrFrameSetItemBits)0x0001)
#define AFSIB_RELATIVESIZE			((AdrFrameSetItemBits)0x0002)
#define AFSIB_PERCENTSIZE			((AdrFrameSetItemBits)0x0004)
#define AFSIB_COLSET 				((AdrFrameSetItemBits)0x0008)
#define AFSIB_INVISIBLE				((AdrFrameSetItemBits)0x0010)

// ---------------------
// - AdrFrameSet-Types -
// ---------------------

#define ADR_FRAMESET_APPEND			((USHORT)0xFFFF)
#define ADR_FRAMESET_ITEM_NOTFOUND	((USHORT)0xFFFF)

// ---------------
// - AdrFrameSet -
// ---------------

class AdrFrameSet
{
private:
	Window*				mpParent;
	ImplSplitSet*		mpMainSet;
	ImplSplitSet*		mpBaseSet;
	ImplSplitSet*		mpSplitSet;
	long*				mpLastSizes;
	Rectangle			maDragRect;
	Size				maOriginalSize;
	
	long				mnDX;
	long				mnDY;
	long				mnLeftBorder;
	long				mnTopBorder;
	long				mnRightBorder;
	long				mnBottomBorder;
	long				mnMaxSize;
	long				mnMouseOff;
	long				mnMStartPos;
	long				mnMSplitPos;
	WindowAlign 		meAlign;
	USHORT				mnSplitTest;
	USHORT				mnSplitPos;
	USHORT				mnMouseModifier;
	BOOL				mbDragFull:1,
						mbHorz:1,
						mbBottomRight:1,
						mbCalc:1,
						mbRecalc:1,
						mbInvalidate:1,
						mbSizeable:1,
						mbBorder:1,
						mbAutoHide:1,
						mbFadeIn:1,
						mbFadeOut:1,
						mbAutoHideIn:1,
						mbAutoHideDown:1,
						mbFadeInDown:1,
						mbFadeOutDown:1,
						mbAutoHidePressed:1,
						mbFadeInPressed:1,
						mbFadeOutPressed:1,
						mbFadeNoButtonMode:1,
						mbNoAlign:1,
						mbDummy2:1,
						mbDummy3:1,
						mbDummy4:1;

	void				ImplInit();
	void				ImplCalcLayout();
	void				ImplUpdate();
	void				ImplUpdateSet( ImplSplitSet* pSet );
	void				ImplNewAlign();

	ImplSplitSet*		ImplFindSet( ImplSplitSet* pSet, USHORT nId ) const;
	ImplSplitSet*		ImplFindItem( ImplSplitSet* pSet, USHORT nId, USHORT& rPos ) const;
	USHORT				ImplFindItem( ImplSplitSet* pSet, Window* pWindow ) const;
	USHORT				ImplFindItem( ImplSplitSet* pSet, const Point& rPos,
										BOOL bRows, BOOL bDown = TRUE ) const;
	void				ImplDeleteSet( ImplSplitSet* pSet );
	void				ImplSetSplitSize( ImplSplitSet* pSet, long nNewSize );

	void				ImplCalcSet( ImplSplitSet* pSet, ImplSplitSet* pOldSet,
									 long nSetLeft, long nSetTop,
									 long nSetWidth, long nSetHeight,
									 BOOL bRows, BOOL bDown = TRUE );

	void				ImplCalcSet2( ImplSplitSet* pSet, BOOL bHide,
									  BOOL bRows, BOOL bDown = TRUE );

	void				ImplCalcLogSize( ImplSplitItem* pItems, USHORT nItems );

protected:

	USHORT				GetLinePos(Window *pField);
	USHORT				GetColPos(Window *pField, USHORT nLine);
	USHORT				GetLineID(USHORT nPos);
	USHORT 				InsertLine(USHORT nPos,USHORT nCount=1);
	USHORT				GetNextFieldID(USHORT nSetId);
	
	long				GetMaxFixPart();
	long				GetFixLinePart(USHORT nID);

	virtual void		MakeLayout();
	virtual void		InitLayout();
	Point				FindPos(Window *pField);
	void				InsertWindow(Point aPos, Window *pField);
	
	virtual BOOL		IsFieldResizable(Window* pField);
	virtual void		SetFieldBackground(Window* pField);

public:
						AdrFrameSet();
						~AdrFrameSet();
 
	void				SetSizePixel(const Size &aSize);
	Size				GetSizePixel();

	void				InsertItem( USHORT nId, Window* pWindow, long nSize,
									USHORT nPos = ADR_FRAMESET_APPEND, USHORT nSetId = 0,
									AdrFrameSetItemBits nBits = 0 );
	void				InsertItem( USHORT nId, long nSize,
									USHORT nPos = ADR_FRAMESET_APPEND, USHORT nSetId = 0,
									AdrFrameSetItemBits nBits = 0 );
	void				MoveItem( USHORT nId, USHORT nNewPos, USHORT nNewSetId = 0 );
	void				RemoveItem( USHORT nId, BOOL bHide = TRUE );
	void				Clear();

	void				SetBaseSet( USHORT nSetId = 0 );
	USHORT				GetBaseSet() const;

	void				SetSplitSize( USHORT nSetId, long nSplitSize,
									  BOOL bWithChilds = FALSE );
	long				GetSplitSize( USHORT nSetId ) const;
	
	void				SplitItem( USHORT nId, long nNewSize,
								   BOOL bPropSmall = FALSE,
								   BOOL bPropGreat = FALSE );
	void				SetItemSize( USHORT nId, long nNewSize );
	long				GetItemSize( USHORT nId ) const;
	long				GetItemSize( USHORT nId, AdrFrameSetItemBits nBits ) const;
	void				SetItemBits( USHORT nId, AdrFrameSetItemBits nNewBits );
	AdrFrameSetItemBits GetItemBits( USHORT nId ) const;
	Window*				GetItemWindow( USHORT nId ) const;
	USHORT				GetSet( USHORT nId ) const;
	BOOL				GetSet( USHORT nId, USHORT& rSetId, USHORT& rPos ) const;
	USHORT				GetItemId( Window* pWindow ) const;
	USHORT				GetItemId( const Point& rPos ) const;
	USHORT				GetItemPos( USHORT nId, USHORT nSetId = 0 ) const;

	void				SetOriginalItemPos(const Point&, USHORT nPos, USHORT nSetId = 0 );
	void				SetOriginalItemSize(const Size&, USHORT nPos, USHORT nSetId = 0 );

	Point				GetOriginalItemPos( USHORT nPos, USHORT nSetId = 0 ) const;
	Size				GetOriginalItemSize( USHORT nPos, USHORT nSetId = 0 ) const;

	BOOL				SetOriginalItemPosSize(const Point&, const Size&, USHORT nPos, USHORT nSetId = 0 );
	BOOL				GetOriginalItemPosSize(Point&, Size&,  USHORT nPos, USHORT nSetId = 0 ) const;

	USHORT				GetItemId( USHORT nPos, USHORT nSetId = 0 ) const;
	USHORT				GetItemCount( USHORT nSetId = 0 ) const;
	BOOL				IsItemValid( USHORT nId ) const;

	void				SetNoAlign( BOOL bNoAlign );
	BOOL				IsNoAlign() const { return mbNoAlign; }
	void				SetAlign( WindowAlign eNewAlign = WINDOWALIGN_TOP );
	WindowAlign 		GetAlign() const { return meAlign; }
	BOOL				IsHorizontal() const { return mbHorz; }

	void				SetMaxSizePixel( long nNewMaxSize ) { mnMaxSize = nNewMaxSize; }
	long				GetMaxSizePixel() const { return mnMaxSize; }
			
	virtual void		InitPage(Window *pParent,Size *pSize=NULL);

	long				GetMaxFixTextWidth();
	void				SetFixTextWidth(long nWidth);

};


#endif	// _ADR_FRAMESET_HXX
