/*************************************************************************
 *
 *  $RCSfile: String.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/24 13:22:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CONNECTIVITY_JAVA_LANG_STRING_HXX_
#include "java/lang/String.hxx"
#endif
#ifndef _CONNECTIVITY_JAVA_TOOLS_HXX_
#include "java/tools.hxx"
#endif
using namespace connectivity;
//**************************************************************
//************ Class: java.lang.String
//**************************************************************

jclass java_lang_String::theClass = 0;

java_lang_String::~java_lang_String()
{}

jclass java_lang_String::getMyClass()
{
	// die Klasse muss nur einmal geholt werden, daher statisch
	if( !theClass ){
		SDBThreadAttach t;
		if( !t.pEnv ) return (jclass)NULL;
		jclass tempClass = t.pEnv->FindClass("java/lang/String"); 
		OSL_ENSURE(tempClass,"Java : FindClass nicht erfolgreich!");
		jclass globClass = (jclass)t.pEnv->NewGlobalRef( tempClass );
		t.pEnv->DeleteLocalRef( tempClass );
		saveClassRef( globClass );
	}
	return theClass;
}

//--------------------------------------------------------------------------
void java_lang_String::saveClassRef( jclass pClass )
{
	if( pClass==NULL  )
		return;
	// der uebergebe Klassen-Handle ist schon global, daher einfach speichern
	theClass = pClass;
}
//--------------------------------------------------------------------------
java_lang_String::java_lang_String( const ::rtl::OUString& _par0 ): java_lang_Object( NULL, (jobject)NULL )
{
	SDBThreadAttach t;
	if( !t.pEnv )
		return;
	jvalue args[1];
	// Parameter konvertieren
	args[0].l = convertwchar_tToJavaString(t.pEnv,_par0);
	// Java-Call fuer den Konstruktor absetzen
	// temporaere Variable initialisieren
	char * cSignature = "(Ljava/lang/String;)V";
	jobject tempObj;
	jmethodID mID = t.pEnv->GetMethodID( getMyClass(), "<init>", cSignature );OSL_ENSURE(mID,"Unknown method id!");
	tempObj = t.pEnv->NewObjectA( getMyClass(), mID, args );
	saveRef( t.pEnv, tempObj );
	t.pEnv->DeleteLocalRef( tempObj );
	t.pEnv->DeleteLocalRef((jstring)args[0].l);
}
//--------------------------------------------------------------------------
java_lang_String::operator ::rtl::OUString()
{
	SDBThreadAttach t;
	if(!t.pEnv)
		return ::rtl::OUString();
	return JavaString2String(t.pEnv,(jstring)object);
}

