/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FormulaHelper;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class DefinedName
implements BIFFRecord {
    private byte[] grbit = new byte[2];
    private byte cch;
    private byte[] cce = new byte[2];
    private byte[] ixals = new byte[2];
    private byte[] rgch;
    private byte[] rgce;
    private FormulaHelper fh = new FormulaHelper();
    private String definition = new String("");
    private Workbook wb;

    public DefinedName(InputStream inputStream, Workbook workbook) throws IOException {
        this.read(inputStream);
        this.fh.setWorkbook(workbook);
        this.wb = workbook;
    }

    public DefinedName(NameDefinition nameDefinition, Workbook workbook) throws IOException {
        this.fh.setWorkbook(workbook);
        this.wb = workbook;
        String string = nameDefinition.getName();
        this.definition = "=" + nameDefinition.getDefinition();
        this.cch = (byte)string.length();
        this.rgch = new byte[this.cch * 2];
        this.rgch = string.getBytes("UTF-16LE");
        this.grbit = EndianConverter.writeShort((short)0);
        this.ixals[0] = -1;
        this.ixals[1] = -1;
    }

    public short getBiffType() {
        return 24;
    }

    private String getDefinition() {
        if (EndianConverter.readShort((byte[])this.cce) != 0) {
            this.definition = this.fh.convertPXLToCalc(this.rgce);
            this.definition = this.definition.substring(1);
            this.definition = this.definition.replace(',', ';');
        }
        return this.definition;
    }

    public String getName() {
        String string;
        try {
            string = new String(this.rgch, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "unknown";
        }
        return string;
    }

    public NameDefinition getNameDefinition() {
        this.getDefinition();
        String string = "$" + this.wb.getSheetName(0) + ".A1";
        NameDefinition nameDefinition = new NameDefinition(this.getName(), this.definition, string, this.isRangeType(), this.isExpressionType());
        return nameDefinition;
    }

    private boolean isExpressionType() {
        return this.fh.isExpressionType();
    }

    private boolean isRangeType() {
        return this.fh.isRangeType();
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.grbit);
        this.cch = (byte)inputStream.read();
        ++n;
        n += inputStream.read(this.cce);
        n += inputStream.read(this.ixals);
        this.rgch = new byte[this.cch * 2];
        inputStream.read(this.rgch, 0, this.cch * 2);
        this.rgce = new byte[EndianConverter.readShort((byte[])this.cce)];
        inputStream.read(this.rgce, 0, EndianConverter.readShort((byte[])this.cce));
        Debug.log((int)4, (String)("\tgrbit : " + EndianConverter.readShort((byte[])this.grbit) + " cch : " + this.cch + " cce : " + EndianConverter.readShort((byte[])this.cce) + " ixals : " + EndianConverter.readShort((byte[])this.ixals) + "\n\trgch : " + this.rgch + " rgce : " + this.rgce));
        return n;
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            Debug.log((int)4, (String)("Writing out " + this.definition));
            this.rgce = this.fh.convertCalcToPXL(this.definition);
            this.cce = EndianConverter.writeShort((short)((short)this.rgce.length));
        }
        catch (Exception exception) {
            Debug.log((int)4, (String)"Error in Parsing Name Definition");
            this.cce = EndianConverter.writeShort((short)0);
        }
        outputStream.write(this.getBiffType());
        outputStream.write(this.grbit);
        outputStream.write(this.cch);
        outputStream.write(this.cce);
        outputStream.write(this.ixals);
        outputStream.write(this.rgch);
        if (this.rgce.length != 0) {
            outputStream.write(this.rgce);
        }
        Debug.log((int)4, (String)"Writing DefinedName record");
    }
}

