/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpURLConnectionWithJars.java,v $
 *
 *  $Revision: 1.6.44.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/16 08:17:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import java.net.*;
import java.io.*;
import java.util.*;
import java.util.jar.*;

import com.sleepycat.db.*;
import org.xml.sax.*;
import com.sun.star.ucb.*;


public class HelpURLConnectionWithJars extends URLConnection
{
	private byte[] _doc;
	private URL _helpURL;

	public HelpURLConnectionWithJars( URL url,byte[] doc )
	{
		super( url );
		setDoInput(true);
		connected = true;
		_helpURL = url;
  		_doc = doc;
	}

	public void connect() throws IOException
	{
		System.out.println("trying to connect to help");
	}


	public InputStream getInputStream()
	{
		if( _doc != null )
			return new ByteArrayInputStream( _doc );
		
		HelpURLParameter aParameter = null;
		try
		{
			aParameter = new HelpURLParameter( _helpURL );
		}
		catch( IllegalIdentifierException e )
		{
		}
		
		return aParameter.getInputFromJarFile();
	}
}



