/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: edtab.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 21:07:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#define ITEMID_BOXINFO      SID_ATTR_BORDER_INNER
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#define _SVSTDARR_ULONGS
#include <svtools/svstdarr.hxx>

#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SVX_BOXITEM_HXX //autogen
#include <svx/boxitem.hxx>
#endif

#ifndef _SWWAIT_HXX
#include <swwait.hxx>
#endif
#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif
#ifndef _EDITSH_HXX
#include <editsh.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _CNTFRM_HXX
#include <cntfrm.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>
#endif
#ifndef _SWTABLE_HXX
#include <swtable.hxx>
#endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>
#endif
#ifndef _TBLSEL_HXX
#include <tblsel.hxx>
#endif
#ifndef _EDIMP_HXX
#include <edimp.hxx>
#endif
#ifndef _TABFRM_HXX
#include <tabfrm.hxx>
#endif
#ifndef _CELLFRM_HXX
#include <cellfrm.hxx>
#endif
#ifndef _CELLATR_HXX
#include <cellatr.hxx>
#endif
#ifndef _SWTBLFMT_HXX
#include <swtblfmt.hxx>
#endif
#ifndef _SWDDETBL_HXX
#include <swddetbl.hxx>
#endif
#ifndef _MDIEXP_HXX
#include <mdiexp.hxx>
#endif

extern void ClearFEShellTabCols();

const SwTable& SwEditShell::InsertTable( const SwInsertTableOptions& rInsTblOpts,
                                         USHORT nRows, USHORT nCols,
                                         SwHoriOrient eAdj,
                                         const SwTableAutoFmt* pTAFmt )
{
	StartAllAction();
	SwPosition* pPos = GetCrsr()->GetPoint();

	BOOL bEndUndo = 0 != pPos->nContent.GetIndex();
	if( bEndUndo )
	{
		StartUndo( UNDO_START );
		GetDoc()->SplitNode( *pPos, false );
	}

    /* #109161# If called from a shell the adjust item is propagated
        from pPos to the new content nodes in the table.
     */
    const SwTable *pTable = GetDoc()->InsertTable( rInsTblOpts, *pPos,
                                                   nRows, nCols,
                                                   eAdj, pTAFmt,
                                                   0, TRUE );
	if( bEndUndo )
		EndUndo( UNDO_END );

	EndAllAction();
	return *pTable;
}

BOOL SwEditShell::TextToTable( const SwInsertTableOptions& rInsTblOpts,
                               sal_Unicode cCh,
                               SwHoriOrient eAdj,
                               const SwTableAutoFmt* pTAFmt )
{
	SwWait aWait( *GetDoc()->GetDocShell(), TRUE );
	BOOL bRet = FALSE;
	StartAllAction();
	FOREACHPAM_START(this)
		if( PCURCRSR->HasMark() )
            bRet |= 0 != GetDoc()->TextToTable( rInsTblOpts, *PCURCRSR, cCh,
                                                eAdj, pTAFmt );
	FOREACHPAM_END()
	EndAllAction();
	return bRet;
}

BOOL SwEditShell::TableToText( sal_Unicode cCh )
{
	SwWait aWait( *GetDoc()->GetDocShell(), TRUE );
	BOOL bRet = FALSE;
	SwPaM* pCrsr = GetCrsr();
	const SwTableNode* pTblNd =
			GetDoc()->IsIdxInTbl( pCrsr->GetPoint()->nNode );
	if( IsTableMode() )
	{
		ClearMark();
		pCrsr = GetCrsr();
	}
	else if( !pTblNd || pCrsr->GetNext() != pCrsr )
		return bRet;

	StartAllAction();

	// verschiebe den akt. Cursor aus dem Tabellen Bereich
	// angemeldet ist
	SwNodeIndex aTabIdx( *pTblNd );
	pCrsr->DeleteMark();
	pCrsr->GetPoint()->nNode = *pTblNd->EndOfSectionNode();
	pCrsr->GetPoint()->nContent.Assign( 0, 0 );
	// SPoint und Mark aus dem Bereich verschieben !!!
	pCrsr->SetMark();
	pCrsr->DeleteMark();

	bRet = GetDoc()->TableToText( pTblNd, cCh );
	pCrsr->GetPoint()->nNode = aTabIdx;

	SwCntntNode* pCNd = pCrsr->GetCntntNode();
	if( !pCNd )
		pCrsr->Move( fnMoveForward, fnGoCntnt );
	else
		pCrsr->GetPoint()->nContent.Assign( pCNd, 0 );

	EndAllAction();
	return bRet;
}

FASTBOOL SwEditShell::IsTextToTableAvailable() const
{
	FASTBOOL bOnlyText = FALSE;
	FOREACHPAM_START(this)
		if( PCURCRSR->HasMark() && *PCURCRSR->GetPoint() != *PCURCRSR->GetMark() )
		{
			bOnlyText = TRUE;

			// pruefe ob in der Selection eine Tabelle liegt
			ULONG nStt = PCURCRSR->GetMark()->nNode.GetIndex(),
				  nEnd = PCURCRSR->GetPoint()->nNode.GetIndex();
			if( nStt > nEnd )	{ ULONG n = nStt; nStt = nEnd; nEnd = n; }

			for( ; nStt <= nEnd; ++nStt )
				if( !GetDoc()->GetNodes()[ nStt ]->IsTxtNode() )
				{
					bOnlyText = FALSE;
					break;
				}

			if( !bOnlyText )
				break;
		}
	FOREACHPAM_END()

	return bOnlyText;
}

void SwEditShell::InsertDDETable( const SwInsertTableOptions& rInsTblOpts,
                                  SwDDEFieldType* pDDEType,
                                  USHORT nRows, USHORT nCols,
                                  SwHoriOrient eAdj )
{
	SwPosition* pPos = GetCrsr()->GetPoint();

	StartAllAction();

	BOOL bEndUndo = 0 != pPos->nContent.GetIndex();
	if( bEndUndo )
	{
		StartUndo( UNDO_START );
		GetDoc()->SplitNode( *pPos, false );
	}

    const SwInsertTableOptions aInsTblOpts( rInsTblOpts.mnInsMode | tabopts::DEFAULT_BORDER,
                                            rInsTblOpts.mnRowsToRepeat );
    SwTable* pTbl = (SwTable*)GetDoc()->InsertTable( aInsTblOpts, *pPos,
                                                     nRows, nCols, eAdj );

    SwTableNode* pTblNode = (SwTableNode*)pTbl->GetTabSortBoxes()[ 0 ]->
												GetSttNd()->FindTableNode();
	SwDDETable* pDDETbl = new SwDDETable( *pTbl, pDDEType );
	pTblNode->SetNewTable( pDDETbl );		// setze die DDE-Tabelle

	if( bEndUndo )
		EndUndo( UNDO_END );

	EndAllAction();
}

/*--------------------------------------------------------------------
	Beschreibung: Tabellenfelder einer Tabelle updaten
 --------------------------------------------------------------------*/
void SwEditShell::UpdateTable()
{
	const SwTableNode* pTblNd = IsCrsrInTbl();

	// Keine Arme keine Kekse
	if( pTblNd )
	{
		StartAllAction();
		StartUndo();
		EndAllTblBoxEdit();
		SwTableFmlUpdate aTblUpdate( (SwTable*)&pTblNd->GetTable() );
		GetDoc()->UpdateTblFlds( &aTblUpdate );
		EndUndo();
		EndAllAction();
	}
}

	// Change Modus erfragen/setzen
USHORT SwEditShell::GetTblChgMode() const
{
	USHORT nMode;
	const SwTableNode* pTblNd = IsCrsrInTbl();
	if( pTblNd )
		nMode = pTblNd->GetTable().GetTblChgMode();
	else
		nMode = GetTblChgDefaultMode();
	return nMode;
}

void SwEditShell::SetTblChgMode( USHORT eMode )
{
	const SwTableNode* pTblNd = IsCrsrInTbl();

	// Keine Arme keine Kekse
	if( pTblNd )
	{
		((SwTable&)pTblNd->GetTable()).SetTblChgMode( (TblChgMode)eMode );
		if( !GetDoc()->IsModified() )	// Bug 57028
			GetDoc()->SetUndoNoResetModified();
		GetDoc()->SetModified();
	}
}

BOOL SwEditShell::GetTblBoxFormulaAttrs( SfxItemSet& rSet ) const
{
	SwSelBoxes aBoxes;
	if( IsTableMode() )
		::GetTblSelCrs( *this, aBoxes );
	else
	{
        do {
			SwFrm *pFrm = GetCurrFrm();
			do {
				pFrm = pFrm->GetUpper();
			} while ( pFrm && !pFrm->IsCellFrm() );
			if ( pFrm )
			{
				SwTableBox *pBox = (SwTableBox*)((SwCellFrm*)pFrm)->GetTabBox();
				aBoxes.Insert( pBox );
			}
        } while( FALSE );
    }

	for( USHORT n = 0; n < aBoxes.Count(); ++n )
	{
		const SwTableBox* pSelBox = aBoxes[ n ];
		const SwTableBoxFmt* pTblFmt = (SwTableBoxFmt*)pSelBox->GetFrmFmt();
		if( !n )
		{
			// Formeln in die externe Darstellung bringen!
			const SwTable& rTbl = pSelBox->GetSttNd()->FindTableNode()->GetTable();

			SwTableFmlUpdate aTblUpdate( (SwTable*)&rTbl );
			aTblUpdate.eFlags = TBL_BOXNAME;
			((SwDoc*)GetDoc())->UpdateTblFlds( &aTblUpdate );

			rSet.Put( pTblFmt->GetAttrSet() );
		}
		else
			rSet.MergeValues( pTblFmt->GetAttrSet() );
	}
	return 0 != rSet.Count();
}

void SwEditShell::SetTblBoxFormulaAttrs( const SfxItemSet& rSet )
{
	SET_CURR_SHELL( this );
	SwSelBoxes aBoxes;
	if( IsTableMode() )
		::GetTblSelCrs( *this, aBoxes );
	else
	{
        do {
			SwFrm *pFrm = GetCurrFrm();
			do {
				pFrm = pFrm->GetUpper();
			} while ( pFrm && !pFrm->IsCellFrm() );
			if ( pFrm )
			{
				SwTableBox *pBox = (SwTableBox*)((SwCellFrm*)pFrm)->GetTabBox();
				aBoxes.Insert( pBox );
			}
        } while( FALSE );
    }

	// beim setzen einer Formel keine Ueberpruefung mehr vornehmen!
	if( SFX_ITEM_SET == rSet.GetItemState( RES_BOXATR_FORMULA ))
		ClearTblBoxCntnt();

	StartAllAction();
	GetDoc()->StartUndo( UNDO_START, NULL );
	for( USHORT n = 0; n < aBoxes.Count(); ++n )
		GetDoc()->SetTblBoxFormulaAttrs( *aBoxes[ n ], rSet );
	GetDoc()->EndUndo( UNDO_END, NULL );
	EndAllAction();
}

BOOL SwEditShell::IsTableBoxTextFormat() const
{
	if( IsTableMode() )
		return FALSE;

	SwTableBox *pBox = 0;
    {
		SwFrm *pFrm = GetCurrFrm();
		do {
			pFrm = pFrm->GetUpper();
		} while ( pFrm && !pFrm->IsCellFrm() );
		if ( pFrm )
			pBox = (SwTableBox*)((SwCellFrm*)pFrm)->GetTabBox();
	}

	if( !pBox )
		return FALSE;

	sal_uInt32 nFmt;
	const SfxPoolItem* pItem;
	if( SFX_ITEM_SET == pBox->GetFrmFmt()->GetAttrSet().GetItemState(
		RES_BOXATR_FORMAT, TRUE, &pItem ))
	{
		nFmt = ((SwTblBoxNumFormat*)pItem)->GetValue();
		return GetDoc()->GetNumberFormatter()->IsTextFormat( nFmt ) ||
				NUMBERFORMAT_TEXT == nFmt;
	}

	ULONG nNd = pBox->IsValidNumTxtNd();
	if( ULONG_MAX == nNd )
		return TRUE;

	const String& rTxt = GetDoc()->GetNodes()[ nNd ]->GetTxtNode()->GetTxt();
	if( !rTxt.Len() )
		return FALSE;

	double fVal;
	return !GetDoc()->GetNumberFormatter()->IsNumberFormat( rTxt, nFmt, fVal );
}

String SwEditShell::GetTableBoxText() const
{
	String sRet;
	if( !IsTableMode() )
	{
		SwTableBox *pBox = 0;
        {
			SwFrm *pFrm = GetCurrFrm();
			do {
				pFrm = pFrm->GetUpper();
			} while ( pFrm && !pFrm->IsCellFrm() );
			if ( pFrm )
				pBox = (SwTableBox*)((SwCellFrm*)pFrm)->GetTabBox();
		}

		ULONG nNd;
		if( pBox && ULONG_MAX != ( nNd = pBox->IsValidNumTxtNd() ) )
			sRet = GetDoc()->GetNodes()[ nNd ]->GetTxtNode()->GetTxt();
	}
	return sRet;
}

BOOL SwEditShell::SplitTable( USHORT eMode )
{
	BOOL bRet = FALSE;
	SwPaM *pCrsr = GetCrsr();
	if( pCrsr->GetNode()->FindTableNode() )
	{
		StartAllAction();
		GetDoc()->StartUndo(0, NULL);

		bRet = GetDoc()->SplitTable( *pCrsr->GetPoint(), eMode, TRUE );

		GetDoc()->EndUndo(0, NULL);
		ClearFEShellTabCols();
		EndAllAction();
	}
	return bRet;
}

BOOL SwEditShell::MergeTable( BOOL bWithPrev, USHORT nMode )
{
	BOOL bRet = FALSE;
	SwPaM *pCrsr = GetCrsr();
	if( pCrsr->GetNode()->FindTableNode() )
	{
		StartAllAction();
		GetDoc()->StartUndo(0, NULL);

		bRet = GetDoc()->MergeTable( *pCrsr->GetPoint(), bWithPrev, nMode );

		GetDoc()->EndUndo(0, NULL);
		ClearFEShellTabCols();
		EndAllAction();
	}
	return bRet;
}

BOOL SwEditShell::CanMergeTable( BOOL bWithPrev, BOOL* pChkNxtPrv ) const
{
	BOOL bRet = FALSE;
	const SwPaM *pCrsr = GetCrsr();
	const SwTableNode* pTblNd = pCrsr->GetNode()->FindTableNode();
	if( pTblNd && !pTblNd->GetTable().ISA( SwDDETable ))
	{
		const SwNodes& rNds = GetDoc()->GetNodes();
		if( pChkNxtPrv )
		{
            const SwTableNode* pChkNd = rNds[ pTblNd->GetIndex() - 1 ]->FindTableNode();
			if( pChkNd && !pChkNd->GetTable().ISA( SwDDETable ) &&
                // --> FME 2004-09-17 #117418# Consider table in table case
                pChkNd->EndOfSectionIndex() == pTblNd->GetIndex() - 1 )
                // <--
				*pChkNxtPrv = TRUE, bRet = TRUE;		// mit Prev ist moeglich
			else
			{
				pChkNd = rNds[ pTblNd->EndOfSectionIndex() + 1 ]->GetTableNode();
				if( pChkNd && !pChkNd->GetTable().ISA( SwDDETable ) )
					*pChkNxtPrv = FALSE, bRet = TRUE;		// mit Next ist moeglich
			}
		}
		else
		{
            const SwTableNode* pTmpTblNd = 0;

            if( bWithPrev )
            {
                pTmpTblNd = rNds[ pTblNd->GetIndex() - 1 ]->FindTableNode();
                // --> FME 2004-09-17 #117418# Consider table in table case
                if ( pTmpTblNd && pTmpTblNd->EndOfSectionIndex() != pTblNd->GetIndex() - 1 )
                    pTmpTblNd = 0;
                // <--
            }
            else
                pTmpTblNd = rNds[ pTblNd->EndOfSectionIndex() + 1 ]->GetTableNode();

            bRet = pTmpTblNd && !pTmpTblNd->GetTable().ISA( SwDDETable );
		}
	}
	return bRet;
}

		// setze das InsertDB als Tabelle Undo auf:
void SwEditShell::AppendUndoForInsertFromDB( BOOL bIsTable )
{
	GetDoc()->AppendUndoForInsertFromDB( *GetCrsr(), bIsTable );
}

