/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: transfrm.cxx,v $
 *
 *  $Revision: 1.25.88.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/19 16:26:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifdef SVX_DLLIMPLEMENTATION
#undef SVX_DLLIMPLEMENTATION
#endif

// include ---------------------------------------------------------------

#define ITEMID_SIZE	0

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif

#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif

#ifndef _SVDVIEW_HXX //autogen
#include "svdview.hxx"
#endif
#ifndef _SVDOBJ_HXX //autogen
#include "svdobj.hxx"
#endif
#ifndef _SVDPAGV_HXX //autogen
#include "svdpagv.hxx"
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include "svdotext.hxx"
#endif
#ifndef _SDERITM_HXX //autogen
#include "sderitm.hxx"
#endif

#include <svxids.hrc>
#include "dialogs.hrc"
#include "transfrm.hrc"
#include "sizeitem.hxx"

#include "transfrm.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
#include "svxenum.hxx"
#include "anchorid.hxx"

#ifndef _SFXMODULE_HXX
#include <sfx2/module.hxx>
#endif

#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SVX_SWPOSSIZETABPAGE_HXX
#include <swpossizetabpage.hxx>
#endif

// Toleranz fuer WorkingArea
#define DIFF 1000

// static ----------------------------------------------------------------

static USHORT pPosSizeRanges[] =
{
	SID_ATTR_TRANSFORM_POS_X,
	SID_ATTR_TRANSFORM_POS_Y,
	SID_ATTR_TRANSFORM_PROTECT_POS,
	SID_ATTR_TRANSFORM_PROTECT_POS,
	SID_ATTR_TRANSFORM_INTERN,
	SID_ATTR_TRANSFORM_INTERN,
	SID_ATTR_TRANSFORM_ANCHOR,
	SID_ATTR_TRANSFORM_VERT_ORIENT,
	SID_ATTR_TRANSFORM_WIDTH,
	SID_ATTR_TRANSFORM_SIZE_POINT,
	SID_ATTR_TRANSFORM_PROTECT_POS,
	SID_ATTR_TRANSFORM_INTERN,
	SID_ATTR_TRANSFORM_AUTOWIDTH,
	SID_ATTR_TRANSFORM_AUTOHEIGHT,
	0
};

static USHORT pAngleRanges[] =
{
	SID_ATTR_TRANSFORM_ROT_X,
	SID_ATTR_TRANSFORM_ANGLE,
	SID_ATTR_TRANSFORM_INTERN,
	SID_ATTR_TRANSFORM_INTERN,
	0
};

static USHORT pSlantRanges[] =
{
	SDRATTR_ECKENRADIUS,
	SDRATTR_ECKENRADIUS,
	SID_ATTR_TRANSFORM_SHEAR,
	SID_ATTR_TRANSFORM_SHEAR_VERTICAL,
	SID_ATTR_TRANSFORM_INTERN,
	SID_ATTR_TRANSFORM_INTERN,
	0
};


// Funktion ConvertRect
Rectangle lcl_ConvertRect( const Rectangle& rInRect, USHORT nDigits, MapUnit ePoolUnit, FieldUnit eDlgUnit )
{
	Rectangle aRect;
	aRect.Left()   = static_cast<long>(MetricField::ConvertValue( rInRect.Left(), nDigits, ePoolUnit, eDlgUnit ));
	aRect.Right()  = static_cast<long>(MetricField::ConvertValue( rInRect.Right(), nDigits, ePoolUnit, eDlgUnit ));
	aRect.Top()    = static_cast<long>(MetricField::ConvertValue( rInRect.Top(), nDigits, ePoolUnit, eDlgUnit ));
	aRect.Bottom() = static_cast<long>(MetricField::ConvertValue( rInRect.Bottom(), nDigits, ePoolUnit, eDlgUnit ));
	return( aRect );
}

// Funktion ConvertPoint
Point lcl_ConvertPoint( Point aInPt, USHORT nDigits, MapUnit ePoolUnit, FieldUnit eDlgUnit )
{
	Point aPt;
	aPt.X() = static_cast<long>(MetricField::ConvertValue( aInPt.X(), nDigits, ePoolUnit, eDlgUnit ));
	aPt.Y() = static_cast<long>(MetricField::ConvertValue( aInPt.Y(), nDigits, ePoolUnit, eDlgUnit ));
	return( aPt );
}

// Funktion ScaleRect (Beruecksichtigung des Massstabes)
void lcl_ScaleRect( Rectangle& aRect, Fraction aUIScale )
{
	aRect.Left()      = Fraction( aRect.Left() )   / aUIScale;
	aRect.Right()     = Fraction( aRect.Right() )  / aUIScale;
	aRect.Top()       = Fraction( aRect.Top() )    / aUIScale;
	aRect.Bottom()    = Fraction( aRect.Bottom() ) / aUIScale;
}

// Funktion ScalePoint (Beruecksichtigung des Massstabes)
void lcl_ScalePoint( Point& aPt, Fraction aUIScale )
{
	aPt.X() = Fraction( aPt.X() ) / aUIScale;
	aPt.Y() = Fraction( aPt.Y() ) / aUIScale;
}

/*************************************************************************
|*
|* Konstruktor des Tab-Dialogs: Fuegt die Seiten zum Dialog hinzu
|*
\************************************************************************/

SvxTransformTabDialog::SvxTransformTabDialog( Window* pParent, const SfxItemSet* pAttr,
								const SdrView* pSdrView, USHORT nAnchorTypes ) :
	SfxTabDialog( pParent, ResId( RID_SVXDLG_TRANSFORM, DIALOG_MGR() ), pAttr ),
	pView       ( pSdrView ),
	nAnchorCtrls(nAnchorTypes)
{
	FreeResource();

	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );

    //different positioning page in Writer
    if(nAnchorCtrls & 0x00ff )
    {        
        AddTabPage( RID_SVXPAGE_SWPOSSIZE, SvxSwPosSizeTabPage::Create, 
                           SvxSwPosSizeTabPage::GetRanges );
        RemoveTabPage( RID_SVXPAGE_POSITION_SIZE);
    }
    else
    {        
        AddTabPage( RID_SVXPAGE_POSITION_SIZE, SvxPositionSizeTabPage::Create,
							SvxPositionSizeTabPage::GetRanges );
        RemoveTabPage( RID_SVXPAGE_SWPOSSIZE );
    }
	AddTabPage( RID_SVXPAGE_ANGLE, SvxAngleTabPage::Create,
							SvxAngleTabPage::GetRanges );
	AddTabPage( RID_SVXPAGE_SLANT, SvxSlantTabPage::Create,
							SvxSlantTabPage::GetRanges );
}

// -----------------------------------------------------------------------

SvxTransformTabDialog::~SvxTransformTabDialog()
{
}

// -----------------------------------------------------------------------

void SvxTransformTabDialog::PageCreated( USHORT nId, SfxTabPage &rPage )
{
	switch( nId )
	{
		case RID_SVXPAGE_POSITION_SIZE:
			( (SvxPositionSizeTabPage&) rPage ).SetView( pView );
			( (SvxPositionSizeTabPage&) rPage ).Construct();
          if( nAnchorCtrls & SVX_OBJ_NORESIZE )
              ( (SvxPositionSizeTabPage&) rPage ).DisableResize();
          if( nAnchorCtrls & SVX_OBJ_NOPROTECT )
              ( (SvxPositionSizeTabPage&) rPage ).DisableProtect();
			( (SvxPositionSizeTabPage&) rPage ).UpdateControlStates();
		break;
        case RID_SVXPAGE_SWPOSSIZE :
        {
            SvxSwPosSizeTabPage& rSwPos =  static_cast<SvxSwPosSizeTabPage&>(rPage);
            rSwPos.EnableAnchorTypes(nAnchorCtrls);
            rSwPos.SetValidateFramePosLink( aValidateLink );
            rSwPos.SetView( pView );
        }
        break;

		case RID_SVXPAGE_ANGLE:
			( (SvxAngleTabPage&) rPage ).SetView( pView );
			( (SvxAngleTabPage&) rPage ).Construct();
		break;

		case RID_SVXPAGE_SLANT:
			( (SvxSlantTabPage&) rPage ).SetView( pView );
			( (SvxSlantTabPage&) rPage ).Construct();
		break;
	}
}

/*-- 05.03.2004 11:47:36---------------------------------------------------
    link for the Writer to validate positions 
  -----------------------------------------------------------------------*/
void SvxTransformTabDialog::SetValidateFramePosLink( const Link& rLink )
{
    aValidateLink = rLink;
}            

/*************************************************************************
|*
|*      Dialog zum Aendern der Position des Drehwinkels und des Drehwinkels
|*      der Grafikobjekte
|*
\************************************************************************/

SvxAngleTabPage::SvxAngleTabPage( Window* pParent, const SfxItemSet& rInAttrs  ) :
	SvxTabPage              ( pParent, ResId( RID_SVXPAGE_ANGLE, DIALOG_MGR() ), rInAttrs ),
	aFlPosition				( this, ResId( FL_POSITION ) ),
	aFtPosX                 ( this, ResId( FT_POS_X ) ),
	aMtrPosX                ( this, ResId( MTR_FLD_POS_X ) ),
	aFtPosY                 ( this, ResId( FT_POS_Y ) ),
	aMtrPosY                ( this, ResId( MTR_FLD_POS_Y ) ),
	aFtPosPresets			( this, ResId(FT_POSPRESETS) ),	
	aCtlRect                ( this, ResId( CTL_RECT ) ),
	
	aFlAngle                ( this, ResId( FL_ANGLE ) ),
	aFtAngle                ( this, ResId( FT_ANGLE ) ),
	aMtrAngle               ( this, ResId( MTR_FLD_ANGLE ) ),
	aFtAnglePresets			( this, ResId(FT_ANGLEPRESETS) ),	
	aCtlAngle               ( this, ResId( CTL_ANGLE ),
								RP_RB, 200, 80, CS_ANGLE ),
	rOutAttrs               ( rInAttrs )
{
	FreeResource();

	// diese Page braucht ExchangeSupport
//!     SetExchangeSupport(); noch nicht

	// PoolUnit ermitteln
	SfxItemPool* pPool = rOutAttrs.GetPool();
	DBG_ASSERT( pPool, "Wo ist der Pool" );
	ePoolUnit = pPool->GetMetric( SID_ATTR_TRANSFORM_POS_X );

	aMtrAngle.SetModifyHdl( LINK( this, SvxAngleTabPage, ModifiedHdl ) );
}

// -----------------------------------------------------------------------

void SvxAngleTabPage::Construct()
{
	// Setzen des Rechtecks
	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
	eDlgUnit = GetModuleFieldUnit( &GetItemSet() );
	SetFieldUnit( aMtrPosX, eDlgUnit, TRUE );
	SetFieldUnit( aMtrPosY, eDlgUnit, TRUE );

	if( eDlgUnit == FUNIT_MILE ||
		eDlgUnit == FUNIT_KM )
	{
		aMtrPosX.SetDecimalDigits( 3 );
		aMtrPosY.SetDecimalDigits( 3 );
	}

	aRect = pView->GetAllMarkedRect();
	pView->GetSdrPageView()->LogicToPagePos( aRect );

	// Ankerposition beachten (Writer)
	const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
	if( rMarkList.GetMarkCount() >= 1 )
	{
		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetMarkedSdrObj();
		aAnchorPos = pObj->GetAnchorPos();

		if( aAnchorPos != Point( 0, 0 ) ) // -> Writer
		{
			aRect.Left() -= aAnchorPos.X();
			aRect.Right() -= aAnchorPos.X();
			aRect.Top() -= aAnchorPos.Y();
			aRect.Bottom() -= aAnchorPos.Y();
		}
	}

	// Massstab
	Fraction aUIScale = pView->GetModel()->GetUIScale();
	lcl_ScaleRect( aRect, aUIScale );

	// Umrechnung auf UI-Unit
	USHORT nDigits = aMtrPosX.GetDecimalDigits();
	aRect = lcl_ConvertRect( aRect, nDigits, (MapUnit) ePoolUnit, eDlgUnit );

	if( !pView->IsRotateAllowed() )
	{
		aFlPosition.Disable();
		aFtPosX.Disable();
		aMtrPosX.Disable();
		aFtPosY.Disable();
		aMtrPosY.Disable();
		aFtPosPresets.Disable();
		aCtlRect.Disable();
		aFlAngle.Disable();
		aFtAngle.Disable();
		aMtrAngle.Disable();
		aFtAnglePresets.Disable();
		aCtlAngle.Disable();
	}
}

// -----------------------------------------------------------------------

BOOL SvxAngleTabPage::FillItemSet( SfxItemSet& rSet )
{
	BOOL bModified = FALSE;

	if(aMtrAngle.IsValueModified()
		|| aMtrPosX.IsValueModified()
		|| aMtrPosY.IsValueModified())
	{
        rSet.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_ANGLE ),
						static_cast<INT32>(aMtrAngle.GetValue()) ) );

		Fraction aUIScale = pView->GetModel()->GetUIScale();
		long nTmp = GetCoreValue( aMtrPosX, ePoolUnit );
		nTmp += aAnchorPos.X();
		nTmp = Fraction( nTmp ) * aUIScale;
        rSet.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_ROT_X ), nTmp ) );

		nTmp = GetCoreValue( aMtrPosY, ePoolUnit );
		nTmp += aAnchorPos.Y();
		nTmp = Fraction( nTmp ) * aUIScale;
        rSet.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_ROT_Y ), nTmp ) );

		bModified |= TRUE;
	}
	return bModified;
}

// -----------------------------------------------------------------------

void SvxAngleTabPage::Reset( const SfxItemSet& rAttrs )
{
	const SfxPoolItem* pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_ROT_X );

	Fraction aUIScale = pView->GetModel()->GetUIScale();
	if ( pItem )
	{
		long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - aAnchorPos.X();;
		nTmp = Fraction( nTmp ) / aUIScale;
		SetMetricValue( aMtrPosX, nTmp, ePoolUnit );
	}
	else
		aMtrPosX.SetText( String() );

	pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_ROT_Y );
	if ( pItem )
	{
		long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - aAnchorPos.Y();;
		nTmp = Fraction( nTmp ) / aUIScale;
		SetMetricValue( aMtrPosY, nTmp, ePoolUnit );
	}
	else
		aMtrPosX.SetText( String() );
	pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_ANGLE );

	if ( pItem )
		aMtrAngle.SetValue( ( (const SfxInt32Item*)pItem )->GetValue() );
	else
		aMtrAngle.SetText( String() );
	aMtrAngle.SaveValue();

	ModifiedHdl( this );
}

// -----------------------------------------------------------------------

SfxTabPage* SvxAngleTabPage::Create( Window* pWindow,
                                     const SfxItemSet& rSet )
{
    return( new SvxAngleTabPage( pWindow, rSet ) );
}

//------------------------------------------------------------------------

USHORT* SvxAngleTabPage::GetRanges()
{
	return( pAngleRanges );
}

// -----------------------------------------------------------------------

void SvxAngleTabPage::ActivatePage( const SfxItemSet& )
{
}

// -----------------------------------------------------------------------

int SvxAngleTabPage::DeactivatePage( SfxItemSet* _pSet )
{
    if( _pSet )
        FillItemSet( *_pSet );

	return( LEAVE_PAGE );
}

//------------------------------------------------------------------------

void SvxAngleTabPage::PointChanged( Window* pWindow, RECT_POINT eRP )
{
	if( pWindow == &aCtlRect )
	{
		switch( eRP )
		{
			case RP_LT:
				aMtrPosX.SetUserValue( aRect.Left(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Top(), FUNIT_NONE );
				break;
			case RP_MT:
				aMtrPosX.SetUserValue( aRect.Center().X(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Top(), FUNIT_NONE );
				break;
			case RP_RT:
				aMtrPosX.SetUserValue( aRect.Right(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Top(), FUNIT_NONE );
				break;
			case RP_LM:
				aMtrPosX.SetUserValue( aRect.Left(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Center().Y(), FUNIT_NONE );
				break;
			case RP_MM:
				aMtrPosX.SetUserValue( aRect.Center().X(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Center().Y(), FUNIT_NONE );
				break;
			case RP_RM:
				aMtrPosX.SetUserValue( aRect.Right(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Center().Y(), FUNIT_NONE );
				break;
			case RP_LB:
				aMtrPosX.SetUserValue( aRect.Left(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Bottom(), FUNIT_NONE );
				break;
			case RP_MB:
				aMtrPosX.SetUserValue( aRect.Center().X(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Bottom(), FUNIT_NONE );
				break;
			case RP_RB:
				aMtrPosX.SetUserValue( aRect.Right(), FUNIT_NONE );
				aMtrPosY.SetUserValue( aRect.Bottom(), FUNIT_NONE );
				break;
		}
	}
	else if( pWindow == &aCtlAngle )
	{
		switch( eRP )
		{
			case RP_LT: aMtrAngle.SetUserValue( 13500, FUNIT_NONE ); break;
			case RP_MT: aMtrAngle.SetUserValue(  9000, FUNIT_NONE ); break;
			case RP_RT: aMtrAngle.SetUserValue(  4500, FUNIT_NONE ); break;
			case RP_LM: aMtrAngle.SetUserValue( 18000, FUNIT_NONE ); break;
			case RP_RM: aMtrAngle.SetUserValue(     0, FUNIT_NONE ); break;
			case RP_LB: aMtrAngle.SetUserValue( 22500, FUNIT_NONE ); break;
			case RP_MB: aMtrAngle.SetUserValue( 27000, FUNIT_NONE ); break;
			case RP_RB: aMtrAngle.SetUserValue( 31500, FUNIT_NONE ); break;
            case RP_MM: break;
        }
	}
}

//------------------------------------------------------------------------

IMPL_LINK( SvxAngleTabPage, ModifiedHdl, void *, EMPTYARG )
{
	// Setzen des Winkels im AngleControl
	switch( aMtrAngle.GetValue() )
	{
		case 13500: aCtlAngle.SetActualRP( RP_LT ); break;
		case  9000: aCtlAngle.SetActualRP( RP_MT ); break;
		case  4500: aCtlAngle.SetActualRP( RP_RT ); break;
		case 18000: aCtlAngle.SetActualRP( RP_LM ); break;
		case     0: aCtlAngle.SetActualRP( RP_RM ); break;
		case 22500: aCtlAngle.SetActualRP( RP_LB ); break;
		case 27000: aCtlAngle.SetActualRP( RP_MB ); break;
		case 31500: aCtlAngle.SetActualRP( RP_RB ); break;
		default:    aCtlAngle.SetActualRP( RP_MM ); break;
	}

	return( 0L );
}

/*************************************************************************
|*
|*      Dialog zum Aendern des Eckenradius und zum Schraegstellen
|*
\************************************************************************/

SvxSlantTabPage::SvxSlantTabPage( Window* pParent, const SfxItemSet& rInAttrs  ) :
	SvxTabPage              ( pParent, ResId( RID_SVXPAGE_SLANT, DIALOG_MGR() ), rInAttrs ),

	aFlRadius               ( this, ResId( FL_RADIUS ) ),
	aFtRadius               ( this, ResId( FT_RADIUS ) ),
	aMtrRadius              ( this, ResId( MTR_FLD_RADIUS ) ),
	aFlAngle                ( this, ResId( FL_SLANT ) ),
	aFtAngle                ( this, ResId( FT_ANGLE ) ),
	aMtrAngle               ( this, ResId( MTR_FLD_ANGLE ) ),
	rOutAttrs               ( rInAttrs )
{
	FreeResource();

	// diese Page braucht ExchangeSupport
	SetExchangeSupport();

	// PoolUnit ermitteln
	SfxItemPool* pPool = rOutAttrs.GetPool();
	DBG_ASSERT( pPool, "Wo ist der Pool" );
	ePoolUnit = pPool->GetMetric( SID_ATTR_TRANSFORM_POS_X );
}

// -----------------------------------------------------------------------

void SvxSlantTabPage::Construct()
{
	// Setzen des Rechtecks
	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
	eDlgUnit = GetModuleFieldUnit( &GetItemSet() );
	SetFieldUnit( aMtrRadius, eDlgUnit, TRUE );

	aRect = pView->GetAllMarkedRect();
	pView->GetSdrPageView()->LogicToPagePos( aRect );
}

// -----------------------------------------------------------------------

BOOL SvxSlantTabPage::FillItemSet( SfxItemSet& rAttrs )
{
	BOOL  bModified = FALSE;
	INT32 nValue = 0L;

	String aStr = aMtrRadius.GetText();
	if( aStr != aMtrRadius.GetSavedValue() )
	{
		Fraction aUIScale = pView->GetModel()->GetUIScale();
		long nTmp = GetCoreValue( aMtrRadius, ePoolUnit );
		nTmp = Fraction( nTmp ) * aUIScale;

		rAttrs.Put( SdrEckenradiusItem( nTmp ) );
		bModified = TRUE;
	}

	aStr = aMtrAngle.GetText();
	if( aStr != aMtrAngle.GetSavedValue() )
	{
		nValue = static_cast<INT32>(aMtrAngle.GetValue());
		rAttrs.Put( SfxInt32Item( SID_ATTR_TRANSFORM_SHEAR, nValue ) );
		bModified = TRUE;
	}

	if( bModified )
	{
		// Referenzpunkt setzen
		// #75897#
		Rectangle aObjectRect(pView->GetAllMarkedRect());
		pView->GetSdrPageView()->LogicToPagePos(aObjectRect);
		Point aPt = aObjectRect.Center();

		rAttrs.Put(SfxInt32Item(SID_ATTR_TRANSFORM_SHEAR_X, aPt.X()));
		rAttrs.Put(SfxInt32Item(SID_ATTR_TRANSFORM_SHEAR_Y, aPt.Y()));
		
		// Referenzpunkt setzen
//		Point aPt = aRect.Center();
//		rAttrs.Put( SfxInt32Item( SID_ATTR_TRANSFORM_SHEAR_X, aPt.X() ) );
//	rAttrs.Put( SfxInt32Item( SID_ATTR_TRANSFORM_SHEAR_Y, aPt.Y() ) );

		rAttrs.Put( SfxBoolItem( SID_ATTR_TRANSFORM_SHEAR_VERTICAL, FALSE ) );
	}
	return( bModified );
}

// -----------------------------------------------------------------------

void SvxSlantTabPage::Reset( const SfxItemSet& rAttrs )
{
	// Wenn die View selektierte Objekte besitzt, muessen entspr. Items,
	// die SFX_ITEM_DEFAULT sind, disabled werden
	const SfxPoolItem* pItem;

	// Eckenradius
//A	if( bMarkedObj && SFX_ITEM_DEFAULT == rAttrs.GetItemState( SDRATTR_ECKENRADIUS ) )
//A	{
	if( !pView->IsEdgeRadiusAllowed() )
	{
		aFlRadius.Disable();
		aFtRadius.Disable();
		aMtrRadius.Disable();
		aMtrRadius.SetText( String() );
	}
	else
	{
		pItem = GetItem( rAttrs, SDRATTR_ECKENRADIUS );

		if( pItem )
		{
			Fraction aUIScale = pView->GetModel()->GetUIScale();
			long nTmp = ( (const SdrEckenradiusItem*)pItem )->GetValue();
			nTmp = Fraction( nTmp ) / aUIScale;
			SetMetricValue( aMtrRadius, nTmp, ePoolUnit );
		}
		else
			aMtrRadius.SetText( String() );
	}
	aMtrRadius.SaveValue();

	// Schraegstellen: Winkel
	//SfxItemState eState = rAttrs.GetItemState( SID_ATTR_TRANSFORM_SHEAR );
	//if( ( bMarkedObj && SFX_ITEM_DEFAULT == eState ) ||
	if( !pView->IsShearAllowed() )
	{
		aFlAngle.Disable();
		aFtAngle.Disable();
		aMtrAngle.Disable();
		aMtrAngle.SetText( String() );
	}
	else
	{
		pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_SHEAR );

		if( pItem )
			aMtrAngle.SetValue( ( (const SfxInt32Item*)pItem )->GetValue() );
		else
			aMtrAngle.SetText( String() );
	}
	aMtrAngle.SaveValue();

}

// -----------------------------------------------------------------------

SfxTabPage* SvxSlantTabPage::Create( Window* pWindow,
				const SfxItemSet& rOutAttrs )
{
	return( new SvxSlantTabPage( pWindow, rOutAttrs ) );
}

//------------------------------------------------------------------------

USHORT* SvxSlantTabPage::GetRanges()
{
	return( pSlantRanges );
}

// -----------------------------------------------------------------------

void SvxSlantTabPage::ActivatePage( const SfxItemSet& rSet )
{
	SfxRectangleItem* pRectItem = NULL;

	if( SFX_ITEM_SET == rSet.GetItemState( GetWhich( SID_ATTR_TRANSFORM_INTERN ) , FALSE,
									(const SfxPoolItem**) &pRectItem ) )
	{
		aRect = pRectItem->GetValue();
	}
}

// -----------------------------------------------------------------------

int SvxSlantTabPage::DeactivatePage( SfxItemSet* _pSet )
{
    if( _pSet )
        FillItemSet( *_pSet );

	return( LEAVE_PAGE );
}

//------------------------------------------------------------------------

void SvxSlantTabPage::PointChanged( Window* , RECT_POINT  )
{
}


/*************************************************************************
|*
|*      Dialog for changing position and size of graphic objects
|*
\************************************************************************/

SvxPositionSizeTabPage::SvxPositionSizeTabPage( Window* pParent, const SfxItemSet& rInAttrs  ) :
	SvxTabPage      ( pParent, ResId( RID_SVXPAGE_POSITION_SIZE, DIALOG_MGR() ), rInAttrs ),
	maFlPosition		( this, ResId( FL_POSITION ) ),
	maFtPosX			( this, ResId( FT_POS_X ) ),
	maMtrPosX			( this, ResId( MTR_FLD_POS_X ) ),
	maFtPosY			( this, ResId( FT_POS_Y ) ),
	maMtrPosY			( this, ResId( MTR_FLD_POS_Y ) ),
    maFtPosReference    ( this, ResId( FT_POSREFERENCE ) ),
    maCtlPos            ( this, ResId( CTL_POSRECT ), RP_LT ),
    
    maFlSize                         ( this, ResId( FL_SIZE ) ),
	maFtWidth                        ( this, ResId( FT_WIDTH ) ),
	maMtrWidth                       ( this, ResId( MTR_FLD_WIDTH ) ),
	maFtHeight                       ( this, ResId( FT_HEIGHT ) ),
	maMtrHeight                      ( this, ResId( MTR_FLD_HEIGHT ) ),
	maCbxScale                       ( this, ResId( CBX_SCALE ) ),
    maFtSizeReference                ( this, ResId( FT_SIZEREFERENCE) ),       
    maCtlSize                        ( this, ResId( CTL_SIZERECT ), RP_LT ),
    
    maFlProtect         ( this, ResId( FL_PROTECT) ),
    maTsbPosProtect     ( this, ResId( TSB_POSPROTECT ) ),
    maTsbSizeProtect                 ( this, ResId( TSB_SIZEPROTECT ) ),
    

    maFlAdjust                       ( this, ResId( FL_ADJUST ) ),
	maTsbAutoGrowWidth				( this, ResId( TSB_AUTOGROW_WIDTH ) ),
	maTsbAutoGrowHeight				( this, ResId( TSB_AUTOGROW_HEIGHT ) ),

	maFlDivider						(this, ResId( FL_DIVIDER ) ),
    
    mrOutAttrs       ( rInAttrs ),
    mnProtectSizeState( STATE_NOCHECK ),
    mbPageDisabled   ( FALSE ),
    mbProtectDisabled( false ),
    mbSizeDisabled( false )
{
	FreeResource();

	// diese Page braucht ExchangeSupport
	SetExchangeSupport();

	// PoolUnit ermitteln
	SfxItemPool* pPool = mrOutAttrs.GetPool();
	DBG_ASSERT( pPool, "Wo ist der Pool" );
	mePoolUnit = pPool->GetMetric( SID_ATTR_TRANSFORM_POS_X );

	meRP = RP_LT; // s.o.

	maMtrWidth.SetModifyHdl( LINK( this, SvxPositionSizeTabPage, ChangeWidthHdl ) );
	maMtrHeight.SetModifyHdl( LINK( this, SvxPositionSizeTabPage, ChangeHeightHdl ) );

	maCbxScale.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ClickAutoHdl ) );

	maTsbAutoGrowWidth.Disable();
	maTsbAutoGrowHeight.Disable();
	maFlAdjust.Disable();

	// #i2379# disable controls when protected
	maTsbPosProtect.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ChangePosProtectHdl ) );
	maTsbSizeProtect.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ChangeSizeProtectHdl ) );

}

// -----------------------------------------------------------------------

void SvxPositionSizeTabPage::Construct()
{
	// Setzen des Rechtecks und der Workingarea
	DBG_ASSERT( mpView, "Keine gueltige View Uebergeben!" );
	meDlgUnit = GetModuleFieldUnit( &GetItemSet() );
	SetFieldUnit( maMtrPosX, meDlgUnit, TRUE );
	SetFieldUnit( maMtrPosY, meDlgUnit, TRUE );
	SetFieldUnit( maMtrWidth, meDlgUnit, TRUE );
	SetFieldUnit( maMtrHeight, meDlgUnit, TRUE );

	if( meDlgUnit == FUNIT_MILE ||
		meDlgUnit == FUNIT_KM )
	{
		maMtrPosX.SetDecimalDigits( 3 );
		maMtrPosY.SetDecimalDigits( 3 );
		maMtrWidth.SetDecimalDigits( 3 );
		maMtrHeight.SetDecimalDigits( 3 );

	}

	maRect = mpView->GetAllMarkedRect();
	mpView->GetSdrPageView()->LogicToPagePos( maRect );

	// WorkArea holen und umrechnen:
	maWorkArea = mpView->GetWorkArea();

	// Beruecksichtigung Ankerposition (bei Writer)
	const SdrMarkList& rMarkList = mpView->GetMarkedObjectList();
	if( rMarkList.GetMarkCount() >= 1 )
	{
		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetMarkedSdrObj();
		maAnchorPos = pObj->GetAnchorPos();

		if( maAnchorPos != Point(0,0) ) // -> Writer
		{
			for( USHORT i = 1; i < rMarkList.GetMarkCount(); i++ )
			{
				pObj = rMarkList.GetMark( i )->GetMarkedSdrObj();
				if( maAnchorPos != pObj->GetAnchorPos() )
				{
					// Unterschiedliche Ankerpositionen
					maMtrPosX.SetText( String() );
					maMtrPosY.SetText( String() );
					mbPageDisabled = TRUE;
					return;
				}
			}
		}
		Point aPt = maAnchorPos * -1;
		Point aPt2 = aPt;

		aPt += maWorkArea.TopLeft();
		maWorkArea.SetPos( aPt );

		aPt2 += maRect.TopLeft();
		maRect.SetPos( aPt2 );
	}

	// this should happen via SID_ATTR_TRANSFORM_AUTOSIZE 
	if( rMarkList.GetMarkCount() == 1 )
	{
		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetMarkedSdrObj();
		SdrObjKind eKind = (SdrObjKind) pObj->GetObjIdentifier();
		if( ( pObj->GetObjInventor() == SdrInventor ) &&
			( eKind==OBJ_TEXT || eKind==OBJ_TITLETEXT || eKind==OBJ_OUTLINETEXT) &&
			( (SdrTextObj*) pObj )->HasText() )
		{
			maFlAdjust.Enable();
			maTsbAutoGrowWidth.Enable();
			maTsbAutoGrowHeight.Enable();
			maTsbAutoGrowWidth.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ClickSizeProtectHdl ) );
			maTsbAutoGrowHeight.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ClickSizeProtectHdl ) );

			// Wird als Flag benutzt, um zu ermitteln, ob anwaehlbar ist
			maTsbAutoGrowWidth.EnableTriState( FALSE );
			maTsbAutoGrowHeight.EnableTriState( FALSE );
		}
	}


	// use page offset and recalculate
	Point aPt( mpView->GetSdrPageView()->GetPageOrigin() );

	// Massstab
	Fraction aUIScale = mpView->GetModel()->GetUIScale();

	lcl_ScaleRect( maWorkArea, aUIScale );
	lcl_ScaleRect( maRect, aUIScale );
	lcl_ScalePoint( aPt, aUIScale );

	// Metrik konvertieren
	USHORT nDigits = maMtrPosX.GetDecimalDigits();

	aPt = lcl_ConvertPoint( aPt, nDigits, (MapUnit) mePoolUnit, meDlgUnit );
	maWorkArea = lcl_ConvertRect( maWorkArea, nDigits, (MapUnit) mePoolUnit, meDlgUnit );
	maRect = lcl_ConvertRect( maRect, nDigits, (MapUnit) mePoolUnit, meDlgUnit );

	// use page offset
	aPt *= -1;
	aPt += maWorkArea.TopLeft();
	maWorkArea.SetPos( aPt );

	SetMinMaxPosition();
}

// -----------------------------------------------------------------------

BOOL SvxPositionSizeTabPage::FillItemSet( SfxItemSet& rOutAttrs )
{
	if ( maMtrWidth.HasFocus() )
		ChangeWidthHdl( this );
	if ( maMtrHeight.HasFocus() )
		ChangeHeightHdl( this );

	BOOL bModified = FALSE;
	if( !mbPageDisabled )
	{
		if ( maMtrPosX.IsValueModified() || maMtrPosY.IsValueModified() )
		{
			long lX = GetCoreValue( maMtrPosX, mePoolUnit );
			long lY = GetCoreValue( maMtrPosY, mePoolUnit );

			// Altes Rechteck mit CoreUnit
			maRect = mpView->GetAllMarkedRect();
			mpView->GetSdrPageView()->LogicToPagePos( maRect );

			Fraction aUIScale = mpView->GetModel()->GetUIScale();
			lX += maAnchorPos.X();
			lX = Fraction( lX ) * aUIScale;
			lY += maAnchorPos.Y();
			lY = Fraction( lY ) * aUIScale;
			
			// #101581# GetTopLeftPosition(...) needs coordinates
			// after UI scaling, in real PagePositions.
			GetTopLeftPosition( lX, lY, maRect );

			rOutAttrs.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_POS_X ), (INT32) lX ) );
			rOutAttrs.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_POS_Y ), (INT32) lY ) );

			bModified |= TRUE;
		}

		if ( maTsbPosProtect.GetState() != maTsbPosProtect.GetSavedValue() )
		{
			if( maTsbPosProtect.GetState() == STATE_DONTKNOW )
				rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_PROTECT_POS );
			else
				rOutAttrs.Put(
					SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_PROTECT_POS ),
					maTsbPosProtect.GetState() == STATE_CHECK ? TRUE : FALSE ) );
			bModified |= TRUE;
		}
/*      if(maAnchorBox.IsVisible()) //nur fuer den Writer
		{
			if(maDdLbAnchor.GetSavedValue() != maDdLbAnchor.GetSelectEntryPos())
			{
				bModified |= TRUE;
				rOutAttrs.Put(SfxUInt16Item(
						SID_ATTR_TRANSFORM_ANCHOR, (USHORT)(ULONG)maDdLbAnchor.GetEntryData(maDdLbAnchor.GetSelectEntryPos())));
			}
			if(maDdLbOrient.GetSavedValue() != maDdLbOrient.GetSelectEntryPos())
			{
				bModified |= TRUE;
				rOutAttrs.Put(SfxUInt16Item(
						SID_ATTR_TRANSFORM_VERT_ORIENT, maDdLbOrient.GetSelectEntryPos()));
			}
		}
*/  }

	if ( maMtrWidth.IsValueModified() || maMtrHeight.IsValueModified() )
	{
		Fraction aUIScale = mpView->GetModel()->GetUIScale();

		// get Width
		double nWidth = static_cast<double>(maMtrWidth.GetValue( meDlgUnit ));
		nWidth = MetricField::ConvertDoubleValue( nWidth, maMtrWidth.GetBaseValue(), maMtrWidth.GetDecimalDigits(), meDlgUnit, FUNIT_100TH_MM );
        long lWidth = long(nWidth * (double)aUIScale);
		lWidth = OutputDevice::LogicToLogic( lWidth, MAP_100TH_MM, (MapUnit)mePoolUnit );
		lWidth = static_cast<long>(maMtrWidth.Denormalize( lWidth ));

		// get Height
		double nHeight = static_cast<double>(maMtrHeight.GetValue( meDlgUnit ));
		nHeight = MetricField::ConvertDoubleValue( nHeight, maMtrHeight.GetBaseValue(), maMtrHeight.GetDecimalDigits(), meDlgUnit, FUNIT_100TH_MM );
        long lHeight = long(nHeight * (double)aUIScale);
		lHeight = OutputDevice::LogicToLogic( lHeight, MAP_100TH_MM, (MapUnit)mePoolUnit );
		lHeight = static_cast<long>(maMtrWidth.Denormalize( lHeight ));

		// put Width & Height to itemset
		rOutAttrs.Put( SfxUInt32Item( GetWhich( SID_ATTR_TRANSFORM_WIDTH ),
						(UINT32) lWidth ) );
		rOutAttrs.Put( SfxUInt32Item( GetWhich( SID_ATTR_TRANSFORM_HEIGHT ),
						(UINT32) lHeight ) );
		rOutAttrs.Put( SfxAllEnumItem( GetWhich( SID_ATTR_TRANSFORM_SIZE_POINT ), sal::static_int_cast< USHORT >( meRP ) ) );
		bModified |= TRUE;
	}

	if ( maTsbSizeProtect.GetState() != maTsbSizeProtect.GetSavedValue() )
	{
		if ( maTsbSizeProtect.GetState() == STATE_DONTKNOW )
			rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_PROTECT_SIZE );
		else
			rOutAttrs.Put(
				SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_PROTECT_SIZE ),
				maTsbSizeProtect.GetState() == STATE_CHECK ? TRUE : FALSE ) );
		bModified |= TRUE;
	}

	if ( maTsbAutoGrowWidth.GetState() != maTsbAutoGrowWidth.GetSavedValue() )
	{
		if ( !maTsbAutoGrowWidth.IsTriStateEnabled() )
		{
			if( maTsbAutoGrowWidth.GetState() == STATE_DONTKNOW )
				rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_AUTOWIDTH );
			else
				rOutAttrs.Put(
					SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_AUTOWIDTH ),
					maTsbAutoGrowWidth.GetState() == STATE_CHECK ? TRUE : FALSE ) );
		}
		bModified |= TRUE;
	}

	if ( maTsbAutoGrowHeight.GetState() != maTsbAutoGrowHeight.GetSavedValue() )
	{
		if ( !maTsbAutoGrowHeight.IsTriStateEnabled() )
		{
			if( maTsbAutoGrowHeight.GetState() == STATE_DONTKNOW )
				rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_AUTOHEIGHT );
			else
				rOutAttrs.Put(
					SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_AUTOHEIGHT ),
					maTsbAutoGrowHeight.GetState() == STATE_CHECK ? TRUE : FALSE ) );
		}
		bModified |= TRUE;
	}


	return bModified;
}

// -----------------------------------------------------------------------

void SvxPositionSizeTabPage::Reset( const SfxItemSet&  )
{
	const SfxPoolItem* pItem;

	if ( !mbPageDisabled )
	{
		pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_POS_X );

		Fraction aUIScale = mpView->GetModel()->GetUIScale();
		if ( pItem )
		{
			long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - maAnchorPos.X();
			nTmp = Fraction( nTmp ) / aUIScale;

			SetMetricValue( maMtrPosX, nTmp, mePoolUnit );
		}

		pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_POS_Y );
		if ( pItem )
		{
			long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - maAnchorPos.Y();
			nTmp = Fraction( nTmp ) / aUIScale;

			SetMetricValue( maMtrPosY, nTmp, mePoolUnit );
		}

		pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_PROTECT_POS );
		if ( pItem )
		{
			sal_Bool bProtected = ( ( const SfxBoolItem* )pItem )->GetValue();
			maTsbPosProtect.SetState( bProtected ? STATE_CHECK : STATE_NOCHECK );
			maTsbPosProtect.EnableTriState( FALSE );
		}
		else
		{
			maTsbPosProtect.SetState( STATE_DONTKNOW );
		}

		maTsbPosProtect.SaveValue();
		maCtlPos.Reset();

        // #i2379# Disable controls for protected objects
        ChangePosProtectHdl( this );

	}

	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_WIDTH );
	mlOldWidth = Max( pItem ? ( (const SfxUInt32Item*)pItem )->GetValue() : 0, (UINT32)1 );

	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_HEIGHT );
	mlOldHeight = Max( pItem ? ( (const SfxUInt32Item*)pItem )->GetValue() : 0, (UINT32)1 );

	Fraction aUIScale = mpView->GetModel()->GetUIScale();

	// set Width & Height
	double nTmpWidth  = (double)OutputDevice::LogicToLogic( mlOldWidth, (MapUnit)mePoolUnit, MAP_100TH_MM );
	double nTmpHeight = (double)OutputDevice::LogicToLogic( mlOldHeight, (MapUnit)mePoolUnit, MAP_100TH_MM );
	nTmpWidth  = Fraction( nTmpWidth ) / aUIScale;
	nTmpHeight = Fraction( nTmpHeight ) / aUIScale;

	UINT32 nNorm = 10;
	int i;
	for( i = 0; i < maMtrWidth.GetDecimalDigits()-1; i++ )
		nNorm*=10;
	nTmpWidth*=(double)nNorm;

	nNorm = 10;
	for( i=0; i<maMtrHeight.GetDecimalDigits()-1; i++ )
		nNorm*=10;
	nTmpHeight*=(double)nNorm;

	nTmpWidth =  MetricField::ConvertDoubleValue( (double)nTmpWidth, maMtrWidth.GetBaseValue(), maMtrWidth.GetDecimalDigits(), FUNIT_100TH_MM, meDlgUnit );
	nTmpHeight = MetricField::ConvertDoubleValue( (double)nTmpHeight, maMtrHeight.GetBaseValue(), maMtrHeight.GetDecimalDigits(), FUNIT_100TH_MM, meDlgUnit );

    maMtrWidth.SetValue( sal_Int32(nTmpWidth), meDlgUnit );
    maMtrHeight.SetValue( sal_Int32(nTmpHeight), meDlgUnit );

	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_PROTECT_SIZE );

	if ( pItem )
	{
		maTsbSizeProtect.SetState( ( (const SfxBoolItem*)pItem )->GetValue()
							  ? STATE_CHECK : STATE_NOCHECK );
		maTsbSizeProtect.EnableTriState( FALSE );
	}
	else
		maTsbSizeProtect.SetState( STATE_DONTKNOW );

	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_AUTOWIDTH );
	if ( pItem )
	{
		maTsbAutoGrowWidth.SetState( ( ( const SfxBoolItem* )pItem )->GetValue()
						   ? STATE_CHECK : STATE_NOCHECK );
	}
	else
		maTsbAutoGrowWidth.SetState( STATE_DONTKNOW );

	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_AUTOHEIGHT );
	if ( pItem )
	{
		maTsbAutoGrowHeight.SetState( ( ( const SfxBoolItem* )pItem )->GetValue()
						   ? STATE_CHECK : STATE_NOCHECK );
	}
	else
		maTsbAutoGrowHeight.SetState( STATE_DONTKNOW );

	// Ist Abgleich gesetzt?
	String aStr = GetUserData();
	maCbxScale.Check( (BOOL)aStr.ToInt32() );

	maTsbSizeProtect.SaveValue();
	maTsbAutoGrowWidth.SaveValue();
	maTsbAutoGrowHeight.SaveValue();
	ClickSizeProtectHdl( NULL );

    // #i2379# Disable controls for protected objects
    ChangeSizeProtectHdl( this );
}

// -----------------------------------------------------------------------

SfxTabPage* SvxPositionSizeTabPage::Create( Window* pWindow,
				const SfxItemSet& rOutAttrs )
{
	return( new SvxPositionSizeTabPage( pWindow, rOutAttrs ) );
}

//------------------------------------------------------------------------

USHORT* SvxPositionSizeTabPage::GetRanges()
{
	return( pPosSizeRanges );
}

// -----------------------------------------------------------------------

void SvxPositionSizeTabPage::ActivatePage( const SfxItemSet& rSet )
{
	SfxRectangleItem* pRectItem = NULL;

	if( SFX_ITEM_SET == rSet.GetItemState( GetWhich( SID_ATTR_TRANSFORM_INTERN ) , FALSE,
									(const SfxPoolItem**) &pRectItem ) )
	{
		// Setzen der MinMax-Position
		maRect = pRectItem->GetValue();
		SetMinMaxPosition();
	}
}

// -----------------------------------------------------------------------

int SvxPositionSizeTabPage::DeactivatePage( SfxItemSet* _pSet )
{
    if( _pSet )
	{
		long lX = static_cast<long>(maMtrPosX.GetValue());
		long lY = static_cast<long>(maMtrPosY.GetValue());

		// #106330#
		// The below BugFix assumed that GetTopLeftPosition()
		// needs special coordinate systems. This is not true,
		// GetTopLeftPosition() just needs all parameters in one
		// coor system. Thus, this part below is not necessary and
		// leads to this new bug. Thus, i remove it again.
		// I checked that #106330# works and #101581# is fixed, too.
		//
		// // #101581# GetTopLeftPosition(...) needs coordinates
		// // after UI scaling, in real PagePositions. Thus I added
		// // that calculation here
		// Fraction aUIScale = mpView->GetModel()->GetUIScale();
		// lX += maAnchorPos.X();
		// lX = Fraction( lX ) * aUIScale;
		// lY += maAnchorPos.Y();
		// lY = Fraction( lY ) * aUIScale;
		
		GetTopLeftPosition( lX, lY, maRect );
		
		maRect.SetPos( Point( lX, lY ) );

        _pSet->Put( SfxRectangleItem( SID_ATTR_TRANSFORM_INTERN, maRect ) );

        FillItemSet( *_pSet );
	}
	return( LEAVE_PAGE );
}

//------------------------------------------------------------------------

IMPL_LINK( SvxPositionSizeTabPage, ChangePosProtectHdl, void *, EMPTYARG )
{
    // #106572# Remember user's last choice
	maTsbSizeProtect.SetState( maTsbPosProtect.GetState() == STATE_CHECK ? 
                               STATE_CHECK : mnProtectSizeState );

    UpdateControlStates();
	return( 0L );
}

//------------------------------------------------------------------------

void SvxPositionSizeTabPage::UpdateControlStates()
{
	const bool bPosProtect =  maTsbPosProtect.GetState() == STATE_CHECK;
	const bool bSizeProtect = maTsbSizeProtect.GetState() == STATE_CHECK;
	const bool bHeightChecked = !maTsbAutoGrowHeight.IsTriStateEnabled() && (maTsbAutoGrowHeight.GetState() == STATE_CHECK);
	const bool bWidthChecked = !maTsbAutoGrowWidth.IsTriStateEnabled() && (maTsbAutoGrowWidth.GetState() == STATE_CHECK);

	maFlPosition.Enable( !bPosProtect && !mbPageDisabled );
	maFtPosX.Enable( !bPosProtect && !mbPageDisabled );
	maMtrPosX.Enable( !bPosProtect && !mbPageDisabled );
	maFtPosY.Enable( !bPosProtect && !mbPageDisabled );
	maMtrPosY.Enable( !bPosProtect && !mbPageDisabled );
	maFtPosReference.Enable( !bPosProtect && !mbPageDisabled );
	maCtlPos.Enable( !bPosProtect );
	maTsbPosProtect.Enable( !mbProtectDisabled && !mbPageDisabled );

	maFlSize.Enable( !mbSizeDisabled && !bSizeProtect );
	maCtlSize.Enable( !mbSizeDisabled && !bSizeProtect && (!bHeightChecked || !bWidthChecked) );
	maFtWidth.Enable( !mbSizeDisabled && !bSizeProtect && !bWidthChecked );
	maMtrWidth.Enable( !mbSizeDisabled && !bSizeProtect && !bWidthChecked );
	maFtHeight.Enable( !mbSizeDisabled && !bSizeProtect && !bHeightChecked );
	maMtrHeight.Enable( !mbSizeDisabled && !bSizeProtect && !bHeightChecked );
	maCbxScale.Enable( !mbSizeDisabled && !bSizeProtect && !bHeightChecked && !bWidthChecked );
	maFtSizeReference.Enable( !mbSizeDisabled && !bSizeProtect );
	maFlProtect.Enable( !mbProtectDisabled );
	maTsbSizeProtect.Enable( !mbProtectDisabled && !bPosProtect );

	maCtlSize.Invalidate();
	maCtlPos.Invalidate();

}

//------------------------------------------------------------------------

IMPL_LINK( SvxPositionSizeTabPage, ChangeSizeProtectHdl, void *, EMPTYARG )
{
	if( maTsbSizeProtect.IsEnabled() )
	{
        // #106572# Remember user's last choice

        // Note: this works only as long as the dialog is open.  When
        // the user closes the dialog, there is no way to remember
        // whether size was enabled or disabled befor pos protect was
        // clicked. Thus, if pos protect is selected, the dialog is
        // closed and reopened again, unchecking pos protect will
        // always uncheck size protect, too. That's life.
        mnProtectSizeState = maTsbSizeProtect.GetState();
    }

    UpdateControlStates();

	return( 0L );
}

//------------------------------------------------------------------------

IMPL_LINK_INLINE_START( SvxPositionSizeTabPage, ChangePosXHdl, void *, EMPTYARG )
{
	return( 0L );
}
IMPL_LINK_INLINE_END( SvxPositionSizeTabPage, ChangePosXHdl, void *, EMPTYARG )

//------------------------------------------------------------------------

IMPL_LINK_INLINE_START( SvxPositionSizeTabPage, ChangePosYHdl, void *, EMPTYARG )
{
	return( 0L );
}
IMPL_LINK_INLINE_END( SvxPositionSizeTabPage, ChangePosYHdl, void *, EMPTYARG )

//------------------------------------------------------------------------

void SvxPositionSizeTabPage::SetMinMaxPosition()
{
	// position
	Rectangle aTmpRect = maWorkArea;

	switch ( maCtlPos.GetActualRP() )
	{
		case RP_LT:
			aTmpRect.Right()  -= maRect.Right() - maRect.Left();
			aTmpRect.Bottom() -= maRect.Bottom() - maRect.Top();
			break;
		case RP_MT:
			aTmpRect.Left()   += maRect.Center().X() - maRect.Left();
			aTmpRect.Right()  -= maRect.Center().X() - maRect.Left();
			aTmpRect.Bottom() -= maRect.Bottom() - maRect.Top();
			break;
		case RP_RT:
			aTmpRect.Left()   += maRect.Right() - maRect.Left();
			aTmpRect.Bottom() -= maRect.Bottom() - maRect.Top();
			break;
		case RP_LM:
			aTmpRect.Right()  -= maRect.Right() - maRect.Left();
			aTmpRect.Top()    += maRect.Center().Y() - maRect.Top();
			aTmpRect.Bottom() -= maRect.Center().Y() - maRect.Top();
			break;
		case RP_MM:
			aTmpRect.Left()   += maRect.Center().X() - maRect.Left();
			aTmpRect.Right()  -= maRect.Center().X() - maRect.Left();
			aTmpRect.Top()    += maRect.Center().Y() - maRect.Top();
			aTmpRect.Bottom() -= maRect.Center().Y() - maRect.Top();
			break;
		case RP_RM:
			aTmpRect.Left()   += maRect.Right() - maRect.Left();
			aTmpRect.Top()    += maRect.Center().Y() - maRect.Top();
			aTmpRect.Bottom() -= maRect.Center().Y() - maRect.Top();
			break;
		case RP_LB:
			aTmpRect.Right()  -= maRect.Right() - maRect.Left();
			aTmpRect.Top()    += maRect.Bottom() - maRect.Top();
			break;
		case RP_MB:
			aTmpRect.Left()   += maRect.Center().X() - maRect.Left();
			aTmpRect.Right()  -= maRect.Center().X() - maRect.Left();
			aTmpRect.Top()    += maRect.Bottom() - maRect.Top();
			break;
		case RP_RB:
			aTmpRect.Left()   += maRect.Right() - maRect.Left();
			aTmpRect.Top()    += maRect.Bottom() - maRect.Top();
			break;
	}

	long nMaxLong = static_cast<long>(MetricField::ConvertValue( LONG_MAX, 0, MAP_100TH_MM, meDlgUnit )) - 1L;

	if( Abs( aTmpRect.Left() ) > nMaxLong )
	{
		long nMult = aTmpRect.Left() < 0 ? -1 : 1;
		aTmpRect.Left() = nMaxLong * nMult;
	}
	if( Abs( aTmpRect.Right() ) > nMaxLong )
	{
		long nMult = aTmpRect.Right() < 0 ? -1 : 1;
		aTmpRect.Right() = nMaxLong * nMult;
	}
	if( Abs( aTmpRect.Top() ) > nMaxLong )
	{
		long nMult = aTmpRect.Top() < 0 ? -1 : 1;
		aTmpRect.Top() = nMaxLong * nMult;
	}
	if( Abs( aTmpRect.Bottom() ) > nMaxLong )
	{
		long nMult = aTmpRect.Bottom() < 0 ? -1 : 1;
		aTmpRect.Bottom() = nMaxLong * nMult;
	}

    maMtrPosX.SetMin( maMtrPosX.Normalize(aTmpRect.Left()) );
	maMtrPosX.SetFirst( maMtrPosX.Normalize(aTmpRect.Left()) );
    maMtrPosX.SetMax( maMtrPosX.Normalize(aTmpRect.Right()) );
	maMtrPosX.SetLast( maMtrPosX.Normalize(aTmpRect.Right()) );

    maMtrPosY.SetMin( maMtrPosY.Normalize(aTmpRect.Top()) );
	maMtrPosY.SetFirst( maMtrPosY.Normalize(aTmpRect.Top()) );
    maMtrPosY.SetMax( maMtrPosY.Normalize(aTmpRect.Bottom()) );
	maMtrPosY.SetLast( maMtrPosY.Normalize(aTmpRect.Bottom()) );

	// size
	aTmpRect = maWorkArea;

	switch ( maCtlSize.GetActualRP() )
	{
		case RP_LT:
			aTmpRect.SetSize( Size(
				aTmpRect.GetWidth() - ( maRect.Left() - aTmpRect.Left() ),
				aTmpRect.GetHeight() - ( maRect.Top() - aTmpRect.Top() ) ) );
			break;
		case RP_MT:
			aTmpRect.SetSize( Size(
					Min( maRect.Center().X() - aTmpRect.Left(),
						 aTmpRect.Right() - maRect.Center().X() ) * 2,
				aTmpRect.GetHeight() - ( maRect.Top() - aTmpRect.Top() ) ) );
			break;
		case RP_RT:
			aTmpRect.SetSize( Size(
				aTmpRect.GetWidth() - ( aTmpRect.Right() - maRect.Right() ),
				aTmpRect.GetHeight() - ( maRect.Top() - aTmpRect.Top() ) ) );
			break;
		case RP_LM:
			aTmpRect.SetSize( Size(
				aTmpRect.GetWidth() - ( maRect.Left() - aTmpRect.Left() ),
					Min( maRect.Center().Y() - aTmpRect.Top(),
						  aTmpRect.Bottom() - maRect.Center().Y() ) * 2 ) );
			break;
		case RP_MM:
		{
			long n1, n2, n3, n4, n5, n6;
			n1 = maRect.Center().X() - aTmpRect.Left();
			n2 = aTmpRect.Right() - maRect.Center().X();
			n3 = Min( n1, n2 );
			n4 = maRect.Center().Y() - aTmpRect.Top();
			n5 = aTmpRect.Bottom() - maRect.Center().Y();
			n6 = Min( n4, n5 );
			aTmpRect.SetSize( Size( n3 * 2, n6 * 3 ) );
			break;
		}
		case RP_RM:
			aTmpRect.SetSize( Size(
				aTmpRect.GetWidth() - ( aTmpRect.Right() - maRect.Right() ),
					Min( maRect.Center().Y() - aTmpRect.Top(),
						  aTmpRect.Bottom() - maRect.Center().Y() ) * 2 ) );
			break;
		case RP_LB:
			aTmpRect.SetSize( Size(
				aTmpRect.GetWidth() - ( maRect.Left() - aTmpRect.Left() ),
				aTmpRect.GetHeight() - ( aTmpRect.Bottom() - maRect.Bottom() ) ) );
			break;
		case RP_MB:
			aTmpRect.SetSize( Size(
					Min( maRect.Center().X() - aTmpRect.Left(),
							 aTmpRect.Right() - maRect.Center().X() ) * 2,
				aTmpRect.GetHeight() - ( maRect.Bottom() - aTmpRect.Bottom() ) ) );
			break;
		case RP_RB:
			aTmpRect.SetSize( Size(
				aTmpRect.GetWidth() - ( aTmpRect.Right() - maRect.Right() ),
				aTmpRect.GetHeight() - ( aTmpRect.Bottom() - maRect.Bottom() ) ) );
			break;
	}

    maMtrWidth.SetMax( maMtrWidth.Normalize(aTmpRect.GetWidth()) );
	maMtrWidth.SetLast( maMtrWidth.Normalize(aTmpRect.GetWidth()) );

    maMtrHeight.SetMax( maMtrHeight.Normalize(aTmpRect.GetHeight()) );
	maMtrHeight.SetLast( maMtrHeight.Normalize(aTmpRect.GetHeight()) );

}

//------------------------------------------------------------------------

void SvxPositionSizeTabPage::GetTopLeftPosition( long& rX, long& rY,
												const Rectangle& rRect )
{
	switch ( maCtlPos.GetActualRP() )
	{
		case RP_LT:
			break;
		case RP_MT:
			rX = rX- ( rRect.Center().X() - rRect.Left() );
			break;
		case RP_RT:
			rX = rX- ( rRect.Right() - rRect.Left() );
			break;
		case RP_LM:
			rY = rY- ( rRect.Center().Y() - rRect.Top() );
			break;
		case RP_MM:
			rX = rX- ( rRect.Center().X() - rRect.Left() );
			rY = rY- ( rRect.Center().Y() - rRect.Top() );
			break;
		case RP_RM:
			rX = rX- ( rRect.Right() - rRect.Left() );
			rY = rY- ( rRect.Center().Y() - rRect.Top() );
			break;
		case RP_LB:
			rY = rY- ( rRect.Bottom() - rRect.Top() );
			break;
		case RP_MB:
			rX = rX- ( rRect.Center().X() - rRect.Left() );
			rY = rY- ( rRect.Bottom() - rRect.Top() );
			break;
		case RP_RB:
			rX = rX- ( rRect.Right() - rRect.Left() );
			rY = rY- ( rRect.Bottom() - rRect.Top() );
			break;
	}
}

//------------------------------------------------------------------------

void SvxPositionSizeTabPage::PointChanged( Window* pWindow, RECT_POINT eRP )
{
	if( pWindow == &maCtlPos )
	{
		SetMinMaxPosition();
		switch( eRP )
		{
			case RP_LT:
				maMtrPosX.SetValue( maRect.Left() );
				maMtrPosY.SetValue( maRect.Top() );
				break;
			case RP_MT:
				maMtrPosX.SetValue( maRect.Center().X() );
				maMtrPosY.SetValue( maRect.Top() );
				break;
			case RP_RT:
				maMtrPosX.SetValue( maRect.Right() );
				maMtrPosY.SetValue( maRect.Top() );
				break;
			case RP_LM:
				maMtrPosX.SetValue( maRect.Left() );
				maMtrPosY.SetValue( maRect.Center().Y() );
				break;
			case RP_MM:
				maMtrPosX.SetValue( maRect.Center().X() );
				maMtrPosY.SetValue( maRect.Center().Y() );
				break;
			case RP_RM:
				maMtrPosX.SetValue( maRect.Right() );
				maMtrPosY.SetValue( maRect.Center().Y() );
				break;
			case RP_LB:
				maMtrPosX.SetValue( maRect.Left() );
				maMtrPosY.SetValue( maRect.Bottom() );
				break;
			case RP_MB:
				maMtrPosX.SetValue( maRect.Center().X() );
				maMtrPosY.SetValue( maRect.Bottom() );
				break;
			case RP_RB:
				maMtrPosX.SetValue( maRect.Right() );
				maMtrPosY.SetValue( maRect.Bottom() );
				break;
		}
	}
	else
	{
		meRP = eRP;

		Rectangle aTmpRect( GetRect() );
		SetMinMaxPosition();
	}
}

//------------------------------------------------------------------------

void SvxPositionSizeTabPage::DisableResize()
{
	mbSizeDisabled = true;
} 

//------------------------------------------------------------------------

void SvxPositionSizeTabPage::DisableProtect()
{
	mbProtectDisabled = true;
} 

//------------------------------------------------------------------------

Rectangle SvxPositionSizeTabPage::GetRect()
{
	Rectangle aTmpRect( maRect );
	aTmpRect.SetSize( Size( static_cast<long>(maMtrWidth.GetValue()),
                            static_cast<long>(maMtrHeight.GetValue()) ) );

	switch ( maCtlSize.GetActualRP() )
	{
		case RP_LT:
			// nichts!
			break;
		case RP_MT:
			aTmpRect.SetPos( Point( maRect.Left() -
						( aTmpRect.Right() - maRect.Right() ) / 2, maRect.Top() ) );
			break;
		case RP_RT:
			aTmpRect.SetPos( Point( maRect.Left() -
						( aTmpRect.Right() - maRect.Right() ), maRect.Top() ) );
			break;
		case RP_LM:
			aTmpRect.SetPos( Point( maRect.Left(), maRect.Top() -
						( aTmpRect.Bottom() - maRect.Bottom() ) / 2 ) );
			break;
		case RP_MM:
			aTmpRect.SetPos( Point( maRect.Left() -
						( aTmpRect.Right() - maRect.Right() ) / 2, maRect.Top() -
						( aTmpRect.Bottom() - maRect.Bottom() ) / 2 ) );
			break;
		case RP_RM:
			aTmpRect.SetPos( Point( maRect.Left() -
						( aTmpRect.Right() - maRect.Right() ), maRect.Top() -
						( aTmpRect.Bottom() - maRect.Bottom() ) / 2 ) );
			break;
		case RP_LB:
			aTmpRect.SetPos( Point( maRect.Left(), maRect.Top() -
						( aTmpRect.Bottom() - maRect.Bottom() ) ) );
			break;
		case RP_MB:
			aTmpRect.SetPos( Point( maRect.Left() -
						( aTmpRect.Right() - maRect.Right() ) / 2, maRect.Top() -
						( aTmpRect.Bottom() - maRect.Bottom() ) ) );
			break;
		case RP_RB:
			aTmpRect.SetPos( Point( maRect.Left() -
						( aTmpRect.Right() - maRect.Right() ), maRect.Top() -
						( aTmpRect.Bottom() - maRect.Bottom() ) ) );
			break;
	}
	return( aTmpRect );
}

//------------------------------------------------------------------------

IMPL_LINK( SvxPositionSizeTabPage, ChangeWidthHdl, void *, EMPTYARG )
{
	if( maCbxScale.IsChecked() &&
		maCbxScale.IsEnabled() )
	{
		sal_Int64 nHeight = sal_Int64( ((double) mlOldHeight * (double) maMtrWidth.GetValue()) / (double) mlOldWidth );
		if( nHeight <= maMtrHeight.GetMax( FUNIT_NONE ) )
		{
			maMtrHeight.SetUserValue( nHeight, FUNIT_NONE );
		}
		else
		{
			nHeight = maMtrHeight.GetMax( FUNIT_NONE );
			maMtrHeight.SetUserValue( nHeight );
			const sal_Int64 nWidth = sal_Int64( ((double) mlOldWidth * (double) nHeight) / (double) mlOldHeight );
			maMtrWidth.SetUserValue( nWidth, FUNIT_NONE );
		}
	}
	return( 0L );
}

//------------------------------------------------------------------------

IMPL_LINK( SvxPositionSizeTabPage, ChangeHeightHdl, void *, EMPTYARG )
{
	if( maCbxScale.IsChecked() &&
		maCbxScale.IsEnabled() )
	{
		sal_Int64 nWidth = sal_Int64( ((double) mlOldWidth * (double) maMtrHeight.GetValue()) / (double) mlOldHeight );
		if( nWidth <= maMtrWidth.GetMax( FUNIT_NONE ) )
		{
			maMtrWidth.SetUserValue( nWidth, FUNIT_NONE );
		}
		else
		{
			nWidth = maMtrWidth.GetMax( FUNIT_NONE );
			maMtrWidth.SetUserValue( nWidth );
			const sal_Int64 nHeight = sal_Int64( ((double) mlOldHeight * (double) nWidth) / (double) mlOldWidth );
			maMtrHeight.SetUserValue( nHeight, FUNIT_NONE );
		}
	}
	return( 0L );
}

//------------------------------------------------------------------------

IMPL_LINK( SvxPositionSizeTabPage, ClickSizeProtectHdl, void *, EMPTYARG )
{
	UpdateControlStates();
	return( 0L );
}

//------------------------------------------------------------------------

IMPL_LINK( SvxPositionSizeTabPage, ClickAutoHdl, void *, EMPTYARG )
{
	if( maCbxScale.IsChecked() )
	{
		mlOldWidth  = Max( GetCoreValue( maMtrWidth,  mePoolUnit ), 1L );
		mlOldHeight = Max( GetCoreValue( maMtrHeight, mePoolUnit ), 1L );
	}
	return( 0L );
}

//------------------------------------------------------------------------

void SvxPositionSizeTabPage::FillUserData()
{
	// Abgleich wird in der Ini-Datei festgehalten
	UniString aStr = UniString::CreateFromInt32( (sal_Int32) maCbxScale.IsChecked() );
	SetUserData( aStr );
}
