/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svxacorr.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 04:13:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MySVXACORR_HXX
#define _MySVXACORR_HXX

#ifndef _RTTI_HXX //autogen
#include <tools/rtti.hxx>
#endif
#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif
#ifndef INCLUDED_I18NPOOL_LANG_H
#include <i18npool/lang.h>
#endif
#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#ifndef _DATE_HXX //autogen
#include <tools/date.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SVXSWAFOPT_HXX
#include <bf_svx/swafopt.hxx>
#endif
class CharClass;
class SfxPoolItem; 
class SvStringsISortDtor;
class SvStorage;
class SvStorageRef;
namespace binfilter {

class SvxAutoCorrect;
class SfxObjectShell;
class SvxAutoCorrLanguageTable_Impl;
class SvxAutoCorrLastFileAskTable_Impl;

// Flags fuer die AutoKorrekt-Flags
const long CptlSttSntnc		= 0x00000001;	// Gross-Buchstaben am SatzAnfang
const long CptlSttWrd		= 0x00000002;	// keine 2 Gr.-Buchst. am WordAnfang
const long ChgFractionSymbol= 0x00000004;	// 1/2, 1/4, .. ersetzen
const long ChgOrdinalNumber = 0x00000008;	// Ordinal-Number 1st, 2nd,..
const long ChgToEnEmDash    = 0x00000010;	// - -> Endash/Emdash
const long ChgWeightUnderl  = 0x00000020;	// * -> Fett, _ -> unterstreichen
const long SetINetAttr      = 0x00000040;	// INetAttribut setzen
const long Autocorrect 		= 0x00000080;	// Autokorrektur aufrufen
const long ChgQuotes		= 0x00000100;	// doppelte Quotes ersetzen
const long SaveWordCplSttLst= 0x00000200;	// GrB. am SatzAnf. auto. aufnehmen
const long SaveWordWrdSttLst= 0x00000400;	// 2 GrB. am WortAnf. auto. aufnehmen
const long IngnoreDoubleSpace= 0x00000800;	// 2 Spaces ignorieren
const long ChgSglQuotes		= 0x00001000;	// einfache Quotes ersetzen

const long ChgWordLstLoad	= 0x20000000;	// Ersetzungsliste geladen
const long CplSttLstLoad	= 0x40000000;	// Exceptionlist fuer CplStart geladen
const long WrdSttLstLoad	= 0x80000000;	// Exceptionlist fuer WordStart geladen

// nur eine Mappingklasse



class SvxAutoCorrectLanguageLists
{
public:
	SvxAutoCorrectLanguageLists( SvxAutoCorrect& rParent,
			const String& rShareAutoCorrectFile,
			const String& rUserAutoCorrectFile,
			LanguageType eLang);
	~SvxAutoCorrectLanguageLists();
};

class SvxAutoCorrect
{

	String sShareAutoCorrFile, sUserAutoCorrFile;

	SvxSwAutoFmtFlags aSwFlags;		// StarWriter AutoFormat-Flags

	// alle Sprachen in einer Tabelle
	SvxAutoCorrLanguageTable_Impl* pLangTable;
	SvxAutoCorrLastFileAskTable_Impl* pLastFileTable;
	CharClass* pCharClass;

	LanguageType eCharClassLang;

	long nFlags;
	sal_Unicode cStartDQuote, cEndDQuote, cStartSQuote, cEndSQuote,
				c1Div2, c1Div4, c3Div4,
				cEmDash, cEnDash;

	// private methods


protected:
	//	- Text mit Attributierung (kann nur der SWG - SWG-Format!)
	//		rShort ist der Stream-Name - gecryptet!

	// geforderte Sprache in die Tabelle eintragen gfs. nur wenn das file existiert
	//	- return den Ersetzungstext (nur fuer SWG-Format, alle anderen
	//		koennen aus der Wortliste herausgeholt werden!)
	//		rShort ist der Stream-Name - gecryptet!
public:
	//The method below is changed from private to public by BerryJia for Bug95846 Time:2002-8-13 15:50


	SvxAutoCorrect( const String& rShareAutocorrFile,
					const String& rUserAutocorrFile );
	SvxAutoCorrect( const SvxAutoCorrect& );
	virtual ~SvxAutoCorrect();

	// fuehre eine AutoKorrektur aus.
	// returnt was ausgefuehrt wurde; entsprechend den obigen Flags

	// return fuer die Autotext Expandierung das vorherige Wort, was dem
	// AutoCorrect - Algorythmus entspricht.

	// suche das oder die Worte in der ErsetzungsTabelle.
	// rText - ueberpruefe in diesem Text die Worte der Liste
	// rStt - die gefundene Startposition
	// nEnd - zu ueberpruefende Position - ab dieser Pos nach vorne
	// rLang - Input: in welcher Sprache wird gesucht
	//			Output: in welcher "Sprach-Liste" wurde es gefunden

	// erfrage / setze die Zeichen fuer die Quote-Ersetzung
	sal_Unicode GetStartSingleQuote() const 		{ return cStartSQuote; }
	sal_Unicode GetEndSingleQuote() const			{ return cEndSQuote; }
	sal_Unicode GetStartDoubleQuote() const 		{ return cStartDQuote; }
	sal_Unicode GetEndDoubleQuote() const			{ return cEndDQuote; }

	void SetStartSingleQuote( const sal_Unicode cStart ) 	{ cStartSQuote = cStart; }
	void SetEndSingleQuote( const sal_Unicode cEnd ) 		{ cEndSQuote = cEnd; }
	void SetStartDoubleQuote( const sal_Unicode cStart ) 	{ cStartDQuote = cStart; }
	void SetEndDoubleQuote( const sal_Unicode cEnd ) 		{ cEndDQuote = cEnd; }


	// erfrage / setze den Namen der AutoKorrektur-Datei
	// defaultet auf "autocorr.dat"

	// erfrage / setze die aktuellen Einstellungen der AutoKorrektur
	long GetFlags() const						{ return nFlags; }
	inline SvxSwAutoFmtFlags&	GetSwFlags()	{ return aSwFlags;}
	BOOL IsAutoCorrFlag( long nFlag ) const
								{ return nFlags & nFlag ? TRUE : FALSE; }
	void SetAutoCorrFlag( long nFlag, BOOL bOn = TRUE );

	// Lade, Setze, Gebe - die Ersetzungsliste

	// Speichern von Wortersetzungen:
	//		Diese speichern direkt im Storage. Die Wortliste wird
	//		entsprechend aktualisiert!
	//	- purer Text
	//	- Text mit Attributierung (kann nur der SWG - SWG-Format!)

	//	- loesche einen Eintrag

	// Lade, Setze, Gebe - die Ausnahmeliste fuer Grossbuchstabe am
	// Satzanfang

	// fuegt ein einzelnes Wort hinzu. Die Liste wird sofort
	// in die Datei geschrieben!

	// Lade, Setze, Gebe die Ausnahmeliste fuer 2 Grossbuchstaben am
	// Wortanfang
	// fuegt ein einzelnes Wort hinzu. Die Liste wird sofort
	// in die Datei geschrieben!

	//ueber die Sprachen nach dem Eintrag suchen

	// die einzelnen Methoden fuer die Autokorrektur
	static long 	GetDefaultFlags();

};

}//end of namespace binfilter
#endif
