/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewshel.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 02:50:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_VIEWSHEL_HXX
#define _SCH_VIEWSHEL_HXX
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------

#ifndef _TOOLS_TABLE_HXX //autogen
#include <tools/table.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <bf_svx/svdpage.hxx>
#endif
#ifndef _VIEWFAC_HXX //autogen
#include <bf_sfx2/viewfac.hxx>
#endif
#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif
#ifndef _SV_EVENT_HXX //autogen
#include <vcl/event.hxx>
#endif
#ifndef _SCH_GLOB_HXX
#include "glob.hxx"
#endif
class TransferableDataHelper;
class TransferableClipboardListener;
namespace binfilter {

// UI Features
#define SCH_UI_FEATURE_THREE_D          1
#define SCH_UI_FEATURE_OWN_DATA         2

// Draw modes
#define OUTPUT_DRAWMODE_COLOR		(DRAWMODE_DEFAULT)
#define OUTPUT_DRAWMODE_GRAYSCALE   (DRAWMODE_GRAYLINE | DRAWMODE_GRAYFILL | DRAWMODE_BLACKTEXT | DRAWMODE_GRAYBITMAP | DRAWMODE_GRAYGRADIENT)
#define OUTPUT_DRAWMODE_BLACKWHITE  (DRAWMODE_BLACKLINE | DRAWMODE_BLACKTEXT | DRAWMODE_WHITEFILL | DRAWMODE_GRAYBITMAP | DRAWMODE_WHITEGRADIENT)
#define OUTPUT_DRAWMODE_CONTRAST	(DRAWMODE_SETTINGSLINE | DRAWMODE_SETTINGSFILL | DRAWMODE_SETTINGSTEXT | DRAWMODE_SETTINGSGRADIENT)

class SchFuPoor;
class SchView;
class SchChartDocShell;
class ChartModel;
class SchWindow;
class SvxRuler;


class ChXChartView;

class SchVisAreaChangedHint : public SfxHint
{
public:
	TYPEINFO();

    SchVisAreaChangedHint( const Rectangle & rNewRect );
    virtual ~SchVisAreaChangedHint();


private:
    Rectangle maNewRect;
};


/*************************************************************************
|*
|* Ableitung von SchViewShell fuer Drawing
|*
\************************************************************************/

class SchViewShell : public SfxViewShell
{
protected:
	BOOL			  bUserKnowsTranslation;
	SchView*          pChView;
	SchFuPoor*        pFuActual;
	SchFuPoor*        pFuOld;
	SchFuPoor*        pTempFuActual;
	SchChartDocShell* pDocSh;

	Table        aShellTable;              // fuer die ObjectBarShells
	USHORT       nCurrentObjectBar;        // ResourceID des aktuellen Object Bar
	BOOL         bObjectBarSwitchEnabled;  // zum Unterdruecken des Switchens
	Point        aMDPos;
	BOOL         bFirstStart;
	BOOL         bRepaintPossible;

            void Construct(SchChartDocShell& rDocSh);




public:
	TYPEINFO();

	SFX_DECL_VIEWFACTORY(SchViewShell);
	SFX_DECL_INTERFACE(SCH_IF_CHARTVIEWSHELL);

	SchViewShell(SfxViewFrame* pFrame, SfxViewShell* pOldShell);
	virtual ~SchViewShell();

	virtual SchView* GetView() const;

	virtual SfxPrinter* GetPrinter(BOOL bCreate = FALSE);


    // Mouse- & Key-Events

	virtual void Draw(OutputDevice &rDev, const Region &rReg) {}

	void    SetRepaintPossible (BOOL bNewRepaint) { bRepaintPossible = bNewRepaint; }
	void    SelectionHasChanged();

	void    GetMenuState(SfxItemSet &rSet);
	void    ExecStatusBar(SfxRequest& rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	void    ExecStatusBar(SfxRequest& rReq);
	void    GetStatusBarState(SfxItemSet& rSet);

	void    FuTemporary(SfxRequest &rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	void    FuTemporary(SfxRequest &rReq);
	void    FuPermanent(SfxRequest &rReq);
	void    FuSupport(SfxRequest &rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	void    FuSupport(SfxRequest &rReq);

	void    SetZoom(long nZoom);
	USHORT  SwitchObjectBar(USHORT nResId);
	USHORT  GetObjectBar() { return nCurrentObjectBar; }

#ifndef NOOLDSV
#endif

	void    ExecReq(SfxRequest& rReq);

	SchWindow* GetWindow() const { return (SchWindow*)SfxViewShell::GetWindow(); }
	void    SetMousePos (Point &rMDPos) { aMDPos = rMDPos; }

	SchChartDocShell* GetDocSh() const { return pDocSh; }
	
	// drag and drop
	
	virtual	BOOL HasUIFeature( ULONG nFeature );

    // SfxListener
	virtual void		Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

private:
	/**	@descr	This item set is used as a reference to determine those items that 
			where changed by the	3D flyer.
	*/
	SfxItemSet	*	mp3DFlyerReference;

	/**
		@descr	Set the given item set to the given object.  Handle the
			necessary special cases, like clearing data point item sets when
			setting their row's item set.
		@param	pObject	The object whose item set is to be changed.  If this
			pointer is NULL, then nothing is done.
		@param	aSet	The item set that replaces the object's item set.
		@return	Inform the caller whether a call to BuildChart() is necessary to
			reflect the changes made by setting the item set.
		@note	defined in source/ui/view/viewshe1.cxx
	*/

    /// listener for changes of the system clipboard
	TransferableClipboardListener* mpClipEvtLstnr;
    /// reflects if the current content of the system clipboard can be pasted
	BOOL			mbPastePossible;
    /// reflects if the current content of the system clipboard can be pasted in edit mode
	BOOL			mbTextPastePossible;

    /// the UNO representation of the view
    ChXChartView*     mpUNOController;
    /// to prevent broadcasting during a UI selection procedure
    sal_Bool          mbBroadcastSelectionChanges;
    /// if broadcasting was disabled this is set to sal_True when the selection changed meanwhile
    sal_Bool          mbPendingSelectionChange;

    /// to prevent broadcasting (e.g. during a UI selection procedure) set sal_False here

    /// permit access to AllowSelectionChangeBroadcasts
    friend class SuspendSelectionChangeBroadcasting;

	DECL_LINK( ClipboardChanged, TransferableDataHelper* );
};

/** This class works like a guard.  In the constructor the broadcasting of
    selection changes are broadcast to the UNO controller, in the destructor
    the broadcasting is re-enabled.
 */
class SuspendSelectionChangeBroadcasting
{
public:
    SuspendSelectionChangeBroadcasting( SchViewShell *  pViewShell );

private:
    SchViewShell* mpViewShell;
};

} //namespace binfilter
#endif          // _SCH_VIEWSHEL_HXX

