/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sbadll.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:53:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_SBADLL_HXX
#define _SBA_SBADLL_HXX

#ifndef _SFXMODULE_HXX //autogen
#include <bf_sfx2/module.hxx>
#endif
class SvFactory; 
class ResMgr; 

namespace binfilter {


/*************************************************************************
|*
|* This class is a wrapper for a Load-On-Demand-DLL. One instance
|* per SfxApplication will be created for the runtime of
|* SfxApplication-subclass::Main().
|*
|* Remember: Do export this class! It is used by the application.
|*
\************************************************************************/

//------------------------------------------------------------------------------------

//==================================================================
// SbaDLL
//==================================================================
class SbaDLL
{
protected:
	static void 	RegisterFactorys();
	static void 	RegisterInterfaces();

public:
					// Ctor/Dtor must be linked to the application
					SbaDLL();
					~SbaDLL();

					// static-init/exit-code must be linked to the application
	static void 	LibInit();	// called from SfxApplication-subclass::Init()
	static void 	LibExit();	// called from SfxApplication-subclass::Exit()

					// DLL-init/exit-code must be linked to the DLL only
	static void 	Init(); 	// called directly after loading the DLL
	static void 	Exit(); 	// called directly befor unloading the DLL
};


//==================================================================
// SbaModuleDummy
//==================================================================
class SbaModuleDummy : public SfxModule
{
public:
	TYPEINFO();

				// SvFactory name convention:
				// 'p' + SfxObjectShell-subclass + 'Factory'
    SfxObjectFactory    *pSbaQueryDocShFactory,
                        *pSbaTableDocShFactory,
                        *pSbaFormDocShFactory,
                        *pSbaReportDocShFactory,
                        *pSbaRelationsDocShFactory;

                        SbaModuleDummy(ResMgr* pResMgr
                                , BOOL bDummy
                                , SfxObjectFactory* p1
                                , SfxObjectFactory* p2
                                , SfxObjectFactory* p3
                                , SfxObjectFactory* p4
                                , SfxObjectFactory* p5 )
                            : SfxModule( pResMgr, bDummy, p1, p2, p3, p4, p5, NULL )
                            , pSbaQueryDocShFactory( p1 )
                            , pSbaTableDocShFactory( p2 )
                            , pSbaReportDocShFactory( p4 )
                            , pSbaFormDocShFactory( p3 )
                            , pSbaRelationsDocShFactory( p5 )
                        {}

    virtual SfxModule*  Load();
};



/*************************************************************************
|*
|* define dummy-version only if not in Sd-DLL
|*
\************************************************************************/

#define SBA_DLL() ( *(SbaModuleDummy**) GetAppData(SHL_SBA) )



} //namespace binfilter
#endif //_SBADLL_HXX
