/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmloff_XMLAutoTextEventExport.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 18:20:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLAUTOTEXTEVENTEXPORT_HXX
#include "XMLAutoTextEventExport.hxx"
#endif




#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTSSUPPLIER_HPP_
#include <com/sun/star/document/XEventsSupplier.hpp>
#endif






// #110680#
//#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
//#include <comphelper/processfactory.hxx>
//#endif


#ifndef _XMLOFF_XMLNMSPE_HXX
#include "xmlnmspe.hxx"
#endif

#ifndef _XMLOFF_NMSPMAP_HXX
#include "nmspmap.hxx"
#endif


#ifndef _XMLOFF_XMLEVENTEXPORT_HXX
#include "XMLEventExport.hxx"
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
namespace binfilter {


using namespace ::com::sun::star;
using namespace ::binfilter::xmloff::token;

// #110680#
// using ::comphelper::getProcessServiceFactory;
using ::rtl::OUString;
using ::rtl::OUStringBuffer;
using ::std::set;
using ::com::sun::star::beans::XPropertySet;
using ::com::sun::star::beans::PropertyValue;
using ::com::sun::star::container::XNameAccess;
using ::com::sun::star::container::XNameReplace;
using ::com::sun::star::document::XEventsSupplier;
using ::com::sun::star::frame::XModel;
using ::com::sun::star::lang::XMultiServiceFactory;
using ::com::sun::star::uno::Any;
using ::com::sun::star::uno::Exception;
using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::Sequence;
using ::com::sun::star::uno::XInterface;
using ::com::sun::star::uno::UNO_QUERY;
using ::com::sun::star::xml::sax::XDocumentHandler;


const sal_Char sAPI_AutoText[] = "com.sun.star.text.AutoTextContainer";


// #110680#
XMLAutoTextEventExport::XMLAutoTextEventExport(
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	) 
:		SvXMLExport( xServiceFactory, MAP_INCH, XML_AUTO_TEXT ),
		sEventType(RTL_CONSTASCII_USTRINGPARAM("EventType")),
		sNone(RTL_CONSTASCII_USTRINGPARAM("None"))
{
}


XMLAutoTextEventExport::~XMLAutoTextEventExport()
{
}


void XMLAutoTextEventExport::initialize( 
	const Sequence<Any> & rArguments )
		throw(uno::Exception, uno::RuntimeException)
{
	if (rArguments.getLength() > 1)
	{
		Reference<XEventsSupplier> xSupplier;
		rArguments[1] >>= xSupplier;
		if (xSupplier.is())
		{
			Reference<XNameAccess> xAccess(xSupplier->getEvents(), UNO_QUERY);
			xEvents = xAccess;
		}
		else
		{
			Reference<XNameReplace> xReplace;
			rArguments[1] >>= xReplace;
			if (xReplace.is())
			{
				Reference<XNameAccess> xAccess(xReplace, UNO_QUERY);
				xEvents = xAccess;
			}
			else
			{
				rArguments[1] >>= xEvents;
			}
		}
	}

	// call super class (for XHandler)
	SvXMLExport::initialize(rArguments);
}


sal_uInt32 XMLAutoTextEventExport::exportDoc( 
	enum XMLTokenEnum eClass)
{
	if (hasEvents())
	{
		GetDocHandler()->startDocument();

		addNamespaces();

		{
			// container element
			SvXMLElementExport aContainerElement(
				*this, XML_NAMESPACE_OFFICE, XML_AUTO_TEXT_EVENTS, 
				sal_True, sal_True);

			exportEvents();
		}

		// and close document again
		GetDocHandler()->endDocument();
	}

	return 0;
}

sal_Bool XMLAutoTextEventExport::hasEvents()
{
	// TODO: provide full implementation that check for presence of events
	return xEvents.is();
}

void XMLAutoTextEventExport::addNamespaces()
{
	// namespaces for office:, text: and script:
	GetAttrList().AddAttribute( 
		GetNamespaceMap().GetAttrNameByIndex( XML_NAMESPACE_TEXT ), 
		GetNamespaceMap().GetNameByIndex( XML_NAMESPACE_TEXT ) );
	GetAttrList().AddAttribute( 
		GetNamespaceMap().GetAttrNameByIndex( XML_NAMESPACE_SCRIPT ), 
		GetNamespaceMap().GetNameByIndex( XML_NAMESPACE_SCRIPT ) );
	GetAttrList().AddAttribute( 
		GetNamespaceMap().GetAttrNameByIndex( XML_NAMESPACE_OFFICE ), 
		GetNamespaceMap().GetNameByIndex( XML_NAMESPACE_OFFICE ) );
}

void XMLAutoTextEventExport::exportEvents()
{
	DBG_ASSERT(hasEvents(), "no events to export!");

	GetEventExport().Export(xEvents, sal_True);
}



// methods without content:

void XMLAutoTextEventExport::_ExportMeta() {}
void XMLAutoTextEventExport::_ExportScripts() {}
void XMLAutoTextEventExport::_ExportFontDecls() {}
void XMLAutoTextEventExport::_ExportStyles( sal_Bool bUsed ) {}
void XMLAutoTextEventExport::_ExportAutoStyles() {}
void XMLAutoTextEventExport::_ExportMasterStyles() {}
void XMLAutoTextEventExport::_ExportChangeTracking() {}
void XMLAutoTextEventExport::_ExportContent() {}



// methods to support the component registration

Sequence< OUString > SAL_CALL XMLAutoTextEventExport_getSupportedServiceNames()
	throw()
{
	Sequence< OUString > aSeq( 1 );
	aSeq[0] = XMLAutoTextEventExport_getImplementationName();
	return aSeq;
}

OUString SAL_CALL XMLAutoTextEventExport_getImplementationName() throw()
{
	return OUString( RTL_CONSTASCII_USTRINGPARAM( 
		"com.sun.star.comp.Writer.XMLAutotextEventsExporter" ) );
}

Reference< XInterface > SAL_CALL XMLAutoTextEventExport_createInstance(
		const Reference< XMultiServiceFactory > & rSMgr)
	throw( Exception )
{
	// #110680#
	// return (cppu::OWeakObject*)new XMLAutoTextEventExport;
	return (cppu::OWeakObject*)new XMLAutoTextEventExport(rSMgr);
}

}//end of namespace binfilter
