/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_linectrl.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:51:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

#include "dialogs.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_DASH_LIST		SID_DASH_LIST
#define ITEMID_LINEEND_LIST		SID_LINEEND_LIST


#ifndef _XDEF_HXX
#include "xdef.hxx"
#endif

#include "xattr.hxx"
#include "linectrl.hxx"
namespace binfilter {

// Fuer Linienenden-Controller
#define MAX_LINES 12

// STATIC DATA -----------------------------------------------------------

#define RESIZE_VALUE_POPUP(value_set)	\
{														\
    Size aSize = GetOutputSizePixel();					\
    aSize.Width()  -= 4;								\
    aSize.Height() -= 4;								\
    (value_set).SetPosSizePixel( Point(2,2), aSize );	\
}

#define CALCSIZE_VALUE_POPUP(value_set,item_size) \
{																	\
    Size aSize = (value_set).CalcWindowSizePixel( (item_size) );	\
    aSize.Width()  += 4;											\
    aSize.Height() += 4;											\
    SetOutputSizePixel( aSize );									\
}


/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineStyleToolBoxControl, XLineStyleItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineWidthToolBoxControl, XLineWidthItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineColorToolBoxControl, XLineColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineEndToolBoxControl,   SfxBoolItem );

/*************************************************************************
|*
|* SvxLineStyleToolBoxControl
|*
\************************************************************************/

/*?*/ SvxLineStyleToolBoxControl::SvxLineStyleToolBoxControl( USHORT nId,
/*?*/ 														ToolBox& rTbx,
/*?*/ 														SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind ),
/*?*/ 	aDashForwarder	( SID_ATTR_LINE_DASH, *this ),
/*?*/ 	pStyleItem		( NULL ),
/*?*/ 	pDashItem		( NULL ),
/*?*/ 	bUpdate			( FALSE )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	StartListening( rBind, TRUE );
/*?*/ }

/*?*/ SvxLineWidthToolBoxControl::SvxLineWidthToolBoxControl( USHORT nId,
/*?*/ 														ToolBox& rTbx,
/*?*/ 														SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	SfxApplication* pSfxApp = SFX_APP();
/*?*/ }

/*?*/ SvxLineColorToolBoxControl::SvxLineColorToolBoxControl( USHORT nId,
/*?*/ 														ToolBox& rTbx,
/*?*/ 														SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	StartListening( GetBindings() );
/*?*/ }


SvxLineEndToolBoxControl::SvxLineEndToolBoxControl(	USHORT  nId, ToolBox &rTbx, SfxBindings &rBindings ) :

	SfxToolBoxControl( nId, rTbx, rBindings )

{
}
}
