/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_clipboardctl.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:20:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif

#ifndef _SVX_CLIPBOARDCTL_HXX_
#include <clipboardctl.hxx>
#endif

#include <svxids.hrc>
namespace binfilter {

/////////////////////////////////////////////////////////////////

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxClipBoardControl, SfxVoidItem /*SfxUInt16Item*/ );


/*N*/ SvxClipBoardControl::SvxClipBoardControl(
/*N*/ 		USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBind ),
/*N*/ 	pPopup		(0),
/*N*/     nItemId     (nId),
/*N*/     aForwarder( SID_CLIPBOARD_FORMAT_ITEMS, *this ),
/*N*/     pClipboardFmtItem( 0 )
/*N*/ {
/*N*/ 	ToolBox& rBox = GetToolBox();
/*N*/ 	rBox.SetItemBits( nId, TIB_DROPDOWN | rBox.GetItemBits( nId ) );
/*N*/ 	rBox.Invalidate();
/*N*/ }


/*N*/ SvxClipBoardControl::~SvxClipBoardControl()
/*N*/ {
/*N*/ 	DelPopup();
/*N*/     delete pClipboardFmtItem;
/*N*/ }


/*N*/ SfxPopupWindow* SvxClipBoardControl::CreatePopupWindow()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
/*N*/ }


/*N*/ SfxPopupWindowType SvxClipBoardControl::GetPopupWindowType() const
/*N*/ {
/*N*/ 	return SFX_POPUPWINDOW_ONTIMEOUT;
/*N*/ }


/*N*/ void SvxClipBoardControl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/     if ( SID_CLIPBOARD_FORMAT_ITEMS == nSID )
/*N*/     {
/*N*/         DELETEZ( pClipboardFmtItem );
/*N*/         if ( eState >= SFX_ITEM_AVAILABLE )
/*N*/ 		{
/*N*/             pClipboardFmtItem = pState->Clone();
/*N*/             GetToolBox().SetItemBits( GetId(), GetToolBox().GetItemBits( GetId() ) | TIB_DROPDOWN );
/*N*/ 		}
/*N*/ 		else
/*N*/             GetToolBox().SetItemBits( GetId(), GetToolBox().GetItemBits( GetId() ) & ~TIB_DROPDOWN );
/*N*/         GetToolBox().Invalidate( GetToolBox().GetItemRect( GetId() ) );
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         // enable the item as a whole
/*N*/         GetToolBox().EnableItem( GetId(), (GetItemState(pState) != SFX_ITEM_DISABLED) );
/*N*/     }
/*N*/ }


/*N*/ void SvxClipBoardControl::DelPopup()
/*N*/ {
/*N*/ 	if(pPopup)
/*N*/ 	{
/*?*/ 		delete pPopup;
/*?*/ 		pPopup = 0;
/*N*/ 	}
/*N*/ }


/////////////////////////////////////////////////////////////////

}
