/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svxruler.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 17:18:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#include <string.h>
#include <limits.h>

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXRECTITEM_HXX
#include <svtools/rectitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
#pragma hdrstop

#define ITEMID_TABSTOP	0
#define ITEMID_LRSPACE 	0
#define ITEMID_PROTECT  0

#include "dialogs.hrc"
#include "ruler.hxx"
#include "rlrcitem.hxx"
#include "rulritem.hxx"
#include "tstpitem.hxx"
#include "lrspitem.hxx"
#include "protitem.hxx"
namespace binfilter {

#ifndef RULER_TAB_RTL
#define RULER_TAB_RTL           ((USHORT)0x0010)
#endif

// STATIC DATA -----------------------------------------------------------

#define CTRL_ITEM_COUNT 12
#define GAP 10
#define OBJECT_BORDER_COUNT 4
#define TAB_GAP 1
#define INDENT_GAP 2
#define INDENT_FIRST_LINE   4
#define INDENT_LEFT_MARGIN  5
#define INDENT_RIGHT_MARGIN 6
#define INDENT_LEFT_BORDER  2
#define INDENT_RIGHT_BORDER 3
#define INDENT_COUNT        5 //without the first two old values

#define PIXEL_H_ADJUST( l1, l2 ) (USHORT)PixelHAdjust(l1,l2)

#ifdef DEBUGLIN







#endif // DEBUGLIN
#ifdef DEBUG_RULER


/*N*/ #define ADD_DEBUG_TEXT(cDescription, sValue) \
/*N*/     RulerDebugWindow::AddDebugText(cDescription, sValue);
/*N*/ 
/*N*/ #define REMOVE_DEBUG_WINDOW \
/*N*/     delete pDebugWindow;    \
/*N*/     pDebugWindow = 0;
/*N*/ 
/*N*/ #else
/*N*/ #define ADD_DEBUG_TEXT(cDescription, sValue)
/*N*/ #define REMOVE_DEBUG_WINDOW
/*N*/ #endif

/*N*/ struct SvxRuler_Impl  {
/*N*/ 	USHORT *pPercBuf;
/*N*/ 	USHORT *pBlockBuf;
/*N*/ 	USHORT nPercSize;
/*N*/ 	long   nTotalDist;
/*N*/ 	long   lOldWinPos;
/*N*/ 	long   lMaxLeftLogic;
/*N*/ 	long   lMaxRightLogic;
/*N*/ 	long   lLastLMargin;
/*N*/ 	SvxProtectItem aProtectItem;
/*N*/     SfxBoolItem* pTextRTLItem;
/*N*/ 	USHORT nControlerItems;
/*N*/ 	USHORT nIdx;
/*N*/ 	USHORT nColLeftPix, nColRightPix; // Pixelwerte fuer linken / rechten Rand
/*N*/ 									  // bei Spalten; gepuffert, um Umrechenfehler
/*N*/ 									  // zu vermeiden.
/*N*/ 									  // Muesste vielleicht fuer weitere Werte
/*N*/ 									  // aufgebohrt werden
/*N*/ 	SvxRuler_Impl() :
/*N*/ 	pPercBuf(0), pBlockBuf(0), nPercSize(0), nTotalDist(0), nIdx(0),
/*N*/     nColLeftPix(0), nColRightPix(0), lOldWinPos(0), pTextRTLItem(0)
/*N*/ 	{
/*N*/ 	}
/*N*/ 	~SvxRuler_Impl()
/*N*/ 	{
/*N*/ 		nPercSize = 0; nTotalDist = 0;
/*N*/ 		delete[] pPercBuf; delete[] pBlockBuf; pPercBuf = 0;
/*N*/         delete pTextRTLItem;
/*N*/ 	}
/*N*/ 
/*N*/ };





// Konstruktor des Lineals

// SID_ATTR_ULSPACE, SID_ATTR_LRSPACE
// erwartet als Parameter SvxULSpaceItem f"ur Seitenr"ander
// (entweder links/rechts oder oben/unten)
// Lineal: SetMargin1, SetMargin2

// SID_RULER_PAGE_POS
// erwartet als Parameter Anfangswert der Seite sowie Seitenbreite
// Lineal: SetPagePos

// SID_ATTR_TABSTOP
// erwartet: SvxTabStopItem
// Lineal: SetTabs

// SID_ATTR_PARA_LRSPACE
// linker, rechter Absatzrand bei H-Lineal
// Lineal: SetIndents

// SID_RULER_BORDERS
// Tabellenraender, Spalten
// erwartet: so etwas wie SwTabCols
// Lineal: SetBorders


/*N*/ SvxRuler::SvxRuler
/*N*/ (
/*N*/  Window* pParent,                               // StarView Parent
/*N*/  Window* pWin,                                  // Ausgabefenster; wird fuer Umrechnung logische
/*N*/ 				// Einheiten <-> Pixel verwendet
/*N*/  USHORT  flags,                                 // Anzeige Flags, siehe ruler.hxx
/*N*/  SfxBindings &rBindings,                // zugeordnete Bindings
/*N*/  WinBits nWinStyle                              // StarView WinBits
/*N*/ )
/*N*/ : Ruler(pParent, nWinStyle),
/*N*/   pLRSpaceItem(0),
/*N*/   pMinMaxItem(0),
/*N*/   pULSpaceItem(0),
/*N*/   pTabStopItem(0),
/*N*/   pParaItem(0),
/*N*/   pParaBorderItem(0),
/*N*/   pPagePosItem(0),
/*N*/   pColumnItem(0),
/*N*/   pObjectItem(0),
/*N*/   pEditWin(pWin),
/*N*/   pIndents(0),
/*N*/   pBorders(new RulerBorder[1]), //wg 1 Spaltiger Tabellen
/*N*/   pObjectBorders(0),
/*N*/   nBorderCount(0),
/*N*/   nDefTabType(RULER_TAB_LEFT),
/*N*/   nTabCount(0),
/*N*/   lDefTabDist(50),
/*N*/   lTabPos(-1),
/*N*/   nTabBufSize(0),
/*N*/   pTabs(0),
/*N*/   nFlags(flags),
/*N*/   nDragOffset(0),
/*N*/   nDragType(NONE),
/*N*/   nMaxLeft(0),
/*N*/   nMaxRight(0),
/*N*/   bListening(FALSE),
/*N*/   bValid(FALSE),
/*N*/   bActive(TRUE),
/*N*/   bAppSetNullOffset(FALSE),  //Wird der 0-Offset des Lineals
/*N*/ 							 //durch die appl. gesetzt?
/*N*/   pBindings(&rBindings),
/*N*/   lLogicNullOffset(0),
/*N*/   lAppNullOffset(LONG_MAX),
/*N*/   lMinFrame(10),
/*N*/   lInitialDragPos(0),
/*N*/   pCtrlItem(new SvxRulerItem *[CTRL_ITEM_COUNT]),
/*N*/   pRuler_Imp(new SvxRuler_Impl)
/*
   [Beschreibung]

   ctor;
   Datenpuffer initialisieren; ControllerItems werden erzeugt

*/
/*N*/ {
/*N*/ 	memset(pCtrlItem, 0, sizeof(SvxRulerItem *) * CTRL_ITEM_COUNT);
/*N*/ 
/*N*/ 	rBindings.EnterRegistrations();
/*N*/ 
/*N*/ 	// Unterstuetzte Items anlegen
/*N*/ 	USHORT i = 0;
/*N*/ 	// Seitenraender
/*N*/ 
/*N*/ 	pCtrlItem[i++] = new SvxRulerItem(SID_RULER_LR_MIN_MAX, *this, rBindings);
/*N*/ 	if((nWinStyle & WB_VSCROLL) == WB_VSCROLL)
/*N*/ 	{
/*N*/ 		bHorz = FALSE;
/*N*/ 		pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_LONG_ULSPACE, *this, rBindings);
/*N*/     }
/*N*/ 	else
/*N*/ 	{
/*N*/ 		bHorz = TRUE;
/*N*/ 		pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_LONG_LRSPACE, *this, rBindings);
/*N*/ 	}
/*N*/ 
/*N*/ 	// Seitenposition
/*N*/ 	pCtrlItem[i++] = new SvxRulerItem(SID_RULER_PAGE_POS, *this, rBindings);
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_TABS) == SVXRULER_SUPPORT_TABS)
/*N*/ 	{
/*N*/         USHORT nTabStopId = bHorz ? SID_ATTR_TABSTOP : SID_ATTR_TABSTOP_VERTICAL;
/*N*/         pCtrlItem[i++] = new SvxRulerItem(nTabStopId, *this, rBindings);
/*N*/ 		SetExtraType(RULER_EXTRA_TAB, nDefTabType);
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/     if(0 != (nFlags & (SVXRULER_SUPPORT_PARAGRAPH_MARGINS |SVXRULER_SUPPORT_PARAGRAPH_MARGINS_VERTICAL)))
/*N*/ 	{
/*N*/ 		if(bHorz)
/*N*/ 			pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_PARA_LRSPACE, *this, rBindings);
/*N*/ 		else
/*N*/ 			pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_PARA_LRSPACE_VERTICAL, *this, rBindings);
/*N*/         pIndents = new RulerIndent[5+INDENT_GAP];
/*N*/ 		memset(pIndents, 0, sizeof(RulerIndent)*(3+INDENT_GAP));
/*N*/ 		pIndents[0].nStyle = RULER_STYLE_DONTKNOW;
/*N*/ 		pIndents[1].nStyle = RULER_STYLE_DONTKNOW;
/*N*/         pIndents[INDENT_FIRST_LINE].nStyle = RULER_INDENT_TOP;
/*N*/         pIndents[INDENT_LEFT_MARGIN].nStyle = RULER_INDENT_BOTTOM;
/*N*/         pIndents[INDENT_RIGHT_MARGIN].nStyle = RULER_INDENT_BOTTOM;
/*N*/         pIndents[INDENT_LEFT_BORDER].nStyle = RULER_INDENT_BORDER;
/*N*/         pIndents[INDENT_RIGHT_BORDER].nStyle = RULER_INDENT_BORDER;
/*N*/         for(USHORT nIn = 0; nIn < 7; nIn++)
/*N*/             pIndents[nIn].nPos = 0;
/*N*/     }
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_BORDERS) ==  SVXRULER_SUPPORT_BORDERS)
/*N*/     {
/*N*/         pCtrlItem[i++] = new SvxRulerItem(bHorz ? SID_RULER_BORDERS : SID_RULER_BORDERS_VERTICAL, *this, rBindings);
/*N*/     }
/*N*/ 
/*N*/     pCtrlItem[i++] = new SvxRulerItem(SID_RULER_TEXT_RIGHT_TO_LEFT, *this, rBindings);
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_OBJECT) == SVXRULER_SUPPORT_OBJECT)
/*N*/ 	{
/*?*/ 		pCtrlItem[i++] = new SvxRulerItem(SID_RULER_OBJECT, *this, rBindings );
/*?*/ 		pObjectBorders = new RulerBorder[OBJECT_BORDER_COUNT];
/*?*/ 		size_t nSize = sizeof( RulerBorder ) * OBJECT_BORDER_COUNT;
/*?*/ 		memset(pObjectBorders, 0, nSize);
/*?*/ 		for(USHORT i = 0; i < OBJECT_BORDER_COUNT; ++i)
/*?*/ 		{
/*?*/ 			pObjectBorders[i].nPos   = 0;
/*?*/ 			pObjectBorders[i].nWidth = 0;
/*?*/ 			pObjectBorders[i].nStyle = RULER_BORDER_MOVEABLE;
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pCtrlItem[i++] = new SvxRulerItem( SID_RULER_PROTECT, *this, rBindings );
/*N*/     pCtrlItem[i++] = new SvxRulerItem(SID_RULER_BORDER_DISTANCE, *this, rBindings);
/*N*/     pRuler_Imp->nControlerItems=i;
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_SET_NULLOFFSET) ==
/*N*/ 	   SVXRULER_SUPPORT_SET_NULLOFFSET)
/*?*/ 		SetExtraType(RULER_EXTRA_NULLOFFSET, 0);
/*N*/ 
/*N*/ 	rBindings.LeaveRegistrations();
/*N*/ }


/*N*/ __EXPORT SvxRuler::~SvxRuler()
/*
   [Beschreibung]

   Destruktor Lineal
   Freigabe interner Puffer


*/
/*N*/ {
/*N*/     REMOVE_DEBUG_WINDOW
/*N*/     if(bListening)
/*N*/ 		EndListening(*pBindings);
/*N*/ 
/*N*/ 	pBindings->EnterRegistrations();
/*N*/ 
/*N*/ 	for(USHORT i = 0; i < CTRL_ITEM_COUNT  && pCtrlItem[i]; ++i)
/*N*/ 		delete pCtrlItem[i];
/*N*/ 	delete[] pCtrlItem;
/*N*/ 
/*N*/ 	delete pLRSpaceItem;
/*N*/ 	delete pMinMaxItem;
/*N*/ 	delete pULSpaceItem;
/*N*/ 	delete pTabStopItem;
/*N*/ 	delete pParaItem;
/*N*/     delete pParaBorderItem;
/*N*/     delete pPagePosItem;
/*N*/ 	delete pColumnItem;
/*N*/ 	delete pObjectItem;
/*N*/ 	delete[] pIndents;
/*N*/ 	delete[] pBorders;
/*N*/ 	delete[] pObjectBorders;
/*N*/ 	delete[] pTabs;
/*N*/ 	delete pRuler_Imp;
/*N*/ 
/*N*/ 	pBindings->LeaveRegistrations();
/*N*/ }

/*

   [Beschreibung]

   Interne Umrechenroutinen

*/

/*N*/ long SvxRuler::ConvertHPosPixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(nVal, 0)).Width();
/*N*/ }

/*N*/ long SvxRuler::ConvertVPosPixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(0, nVal)).Height();
/*N*/ }

/*N*/ long SvxRuler::ConvertHSizePixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(nVal, 0)).Width();
/*N*/ }

/*N*/ long SvxRuler::ConvertVSizePixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(0, nVal)).Height();
/*N*/ }

/*N*/ long SvxRuler::ConvertPosPixel(long nVal) const
/*N*/ {
/*N*/ 	return bHorz ? ConvertHPosPixel(nVal): ConvertVPosPixel(nVal);
/*N*/ }

/*N*/ long SvxRuler::ConvertSizePixel(long nVal) const
/*N*/ {
/*N*/ 	return bHorz? ConvertHSizePixel(nVal): ConvertVSizePixel(nVal);
/*N*/ }















/*N*/ void SvxRuler::UpdateFrame()

/*
   [Beschreibung]

   Linken, oberen Rand aktualisieren
   Items werden in die Darstellung des Lineals uebersetzt.

*/

/*N*/ {
/*N*/ 	const USHORT nMarginStyle =
/*N*/ 		( pRuler_Imp->aProtectItem.IsSizeProtected() ||
/*N*/ 		  pRuler_Imp->aProtectItem.IsPosProtected() ) ?
/*N*/ 		0 : RULER_MARGIN_SIZEABLE;
/*N*/ 
/*N*/ 	if(pLRSpaceItem && pPagePosItem)
/*N*/ 	{
/*N*/ 		// wenn keine Initialisierung durch App Defaultverhalten
/*N*/ 		const long nOld = lLogicNullOffset;
/*N*/ 		lLogicNullOffset = pColumnItem?
/*N*/ 			pColumnItem->GetLeft(): pLRSpaceItem->GetLeft();
/*N*/ 		if(bAppSetNullOffset)
/*?*/ 			lAppNullOffset += lLogicNullOffset - nOld;
/*N*/ 		if(!bAppSetNullOffset || lAppNullOffset == LONG_MAX)
/*N*/ 		{
/*N*/ 			Ruler::SetNullOffset(ConvertHPosPixel(lLogicNullOffset));
/*N*/ 			SetMargin1( 0, nMarginStyle );
/*N*/ 			lAppNullOffset = 0;
/*N*/ 		}
/*N*/ 		else
/*?*/ 			SetMargin1( ConvertHPosPixel( lAppNullOffset ), nMarginStyle );
/*N*/ 		long lRight = 0;
/*N*/ 			// bei Tabelle rechten Rand der Tabelle auswerten
/*N*/ 		if(pColumnItem && pColumnItem->IsTable())
/*?*/ 			lRight = pColumnItem->GetRight();
/*N*/ 		else
/*N*/ 			lRight = pLRSpaceItem->GetRight();
/*N*/ 
/*N*/ 		ULONG aWidth=
/*N*/ 			ConvertHPosPixel(pPagePosItem->GetWidth() - lRight -
/*N*/ 									lLogicNullOffset + lAppNullOffset);
/*N*/ 		SetMargin2( aWidth, nMarginStyle );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		if(pULSpaceItem && pPagePosItem)
/*N*/ 		{
/*N*/ 			// Nullpunkt aus oberem Rand des umgebenden Rahmens
/*N*/ 			const long nOld = lLogicNullOffset;
/*N*/ 			lLogicNullOffset = pColumnItem?
/*N*/ 				pColumnItem->GetLeft(): pULSpaceItem->GetUpper();
/*N*/ 			if(bAppSetNullOffset)
/*?*/ 				lAppNullOffset += lLogicNullOffset - nOld;
/*N*/ 			if(!bAppSetNullOffset || lAppNullOffset == LONG_MAX) {
/*N*/ 				Ruler::SetNullOffset(ConvertVPosPixel(lLogicNullOffset));
/*N*/ 				lAppNullOffset = 0;
/*N*/ 				SetMargin1( 0, nMarginStyle );
/*N*/ 			}
/*N*/ 			else
/*?*/ 				SetMargin1( ConvertVPosPixel( lAppNullOffset ),nMarginStyle );
/*N*/ 
/*N*/ 			long lLower = pColumnItem ?
/*N*/ 				pColumnItem->GetRight() : pULSpaceItem->GetLower();
/*N*/ 
/*N*/ 			SetMargin2(ConvertVPosPixel(pPagePosItem->GetHeight() - lLower -
/*N*/ 										lLogicNullOffset + lAppNullOffset),
/*N*/ 										nMarginStyle );
/*N*/ 		}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// schaltet die Anzeige aus
/*N*/ 		SetMargin1();
/*N*/ 		SetMargin2();
/*N*/ 	}
/*N*/ 	if(pColumnItem)
/*N*/ 	{
/*?*/ 		pRuler_Imp->nColLeftPix = (USHORT) ConvertSizePixel(pColumnItem->GetLeft());
/*?*/ 		pRuler_Imp->nColRightPix = (USHORT) ConvertSizePixel(pColumnItem->GetRight());
/*N*/ 	}
/*N*/ 
/*N*/ }

/*N*/ void SvxRuler::MouseMove( const MouseEvent& rMEvt )
/*N*/ {
/*N*/ 	if( bActive )
/*N*/ 	{
/*N*/ 		pBindings->Update( SID_RULER_LR_MIN_MAX );
/*N*/ 		pBindings->Update( SID_ATTR_LONG_ULSPACE );
/*N*/ 		pBindings->Update( SID_ATTR_LONG_LRSPACE );
/*N*/ 		pBindings->Update( SID_RULER_PAGE_POS );
/*N*/         pBindings->Update( bHorz ? SID_ATTR_TABSTOP : SID_ATTR_TABSTOP_VERTICAL);
/*N*/         pBindings->Update( bHorz ? SID_ATTR_PARA_LRSPACE : SID_ATTR_PARA_LRSPACE_VERTICAL);
/*N*/         pBindings->Update( bHorz ? SID_RULER_BORDERS : SID_RULER_BORDERS_VERTICAL);
/*N*/ 		pBindings->Update( SID_RULER_OBJECT );
/*N*/ 		pBindings->Update( SID_RULER_PROTECT );
/*N*/ 	}
/*N*/ 	Ruler::MouseMove( rMEvt );
/*N*/ }
/*N*/ void SvxRuler::StartListening_Impl()
/*N*/ {
/*N*/     if(!bListening)
/*N*/ 	{
/*N*/ 		bValid = FALSE;
/*N*/ 		StartListening(*pBindings);
/*N*/ 		bListening = TRUE;
/*N*/ 	}
/*N*/ }

/*N*/ void SvxRuler::UpdateFrame
/*N*/ (
/*N*/  const SvxLongLRSpaceItem *pItem    // neuer Wert LRSpace
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer LRSpace merken; alten gfs. loeschen

*/

/*N*/ {
/*N*/   if(bActive)
/*N*/   {
/*N*/ 	delete pLRSpaceItem; pLRSpaceItem = 0;
/*N*/ 	if(pItem)
/*N*/ 		pLRSpaceItem = new SvxLongLRSpaceItem(*pItem);
/*N*/     StartListening_Impl();
/*N*/   }
/*N*/ }


/*N*/ void SvxRuler::UpdateFrameMinMax
/*N*/ (
/*N*/  const SfxRectangleItem *pItem  // Werte fuer MinMax
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer MinMax setzen; alten gfs. loeschen

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pMinMaxItem; pMinMaxItem = 0;
/*N*/ 		if(pItem)
/*N*/ 			pMinMaxItem = new SfxRectangleItem(*pItem);
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::UpdateFrame
/*N*/ (
/*N*/  const SvxLongULSpaceItem *pItem    // neuer Wert
/*N*/ )

/*
   [Beschreibung]

   Rechten / unteren Rand aktualisieren

*/


/*N*/ {
/*N*/   if(bActive && !bHorz)
/*N*/   {
/*N*/ 	delete pULSpaceItem; pULSpaceItem = 0;
/*N*/ 	if(pItem)
/*N*/ 		pULSpaceItem = new SvxLongULSpaceItem(*pItem);
/*N*/     StartListening_Impl();
/*N*/   }
/*N*/ }

/*N*/ void SvxRuler::Update( const SvxProtectItem* pItem )
/*N*/ {
/*N*/ 	if( pItem ) pRuler_Imp->aProtectItem = *pItem;
/*N*/ }
/* -----------------------------22.08.2002 13:10------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void SvxRuler::UpdateTextRTL(const SfxBoolItem* pItem)
/*N*/ {
/*N*/   if(bActive)
/*N*/   {
/*N*/     delete pRuler_Imp->pTextRTLItem; pRuler_Imp->pTextRTLItem = 0;
/*N*/ 	if(pItem)
/*N*/         pRuler_Imp->pTextRTLItem = new SfxBoolItem(*pItem);
/*N*/     SetTextRTL(pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue());
/*N*/     StartListening_Impl();
/*N*/   }
/*N*/ }

/*N*/ void SvxRuler::Update
/*N*/ (
/*N*/  const SvxColumnItem *pItem             // neuer Wert
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer Spaltendarstellung setzen

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pColumnItem; pColumnItem = 0;
/*N*/ 		if(pItem)
/*N*/ 		{
/*N*/ 			pColumnItem = new SvxColumnItem(*pItem);
/*N*/ 			if(!bHorz)
/*?*/ 				pColumnItem->SetWhich(SID_RULER_BORDERS_VERTICAL);
/*N*/ 		}
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }


/*N*/ void SvxRuler::UpdateColumns()
/*
   [Beschreibung]

   Anzeige der Spaltendarstellung aktualisieren

*/
/*N*/ {
/*N*/ 	if(pColumnItem && pColumnItem->Count() > 1)
/*N*/ 	{
/*?*/ 		if( nBorderCount < pColumnItem->Count())
/*?*/ 		{
/*?*/ 			delete[] pBorders;
/*?*/ 			nBorderCount = pColumnItem->Count();
/*?*/ 			pBorders = new RulerBorder[nBorderCount];
/*?*/ 			size_t nSize = sizeof( RulerBorder ) * nBorderCount;
/*?*/ 		}
/*?*/ 		USHORT nFlags = RULER_BORDER_VARIABLE;
/*?*/ 		BOOL bProtectColumns =
/*?*/ 			pRuler_Imp->aProtectItem.IsSizeProtected() ||
/*?*/ 			pRuler_Imp->aProtectItem.IsPosProtected();
/*?*/ 		if( !bProtectColumns )
/*?*/ 			nFlags |= RULER_BORDER_MOVEABLE;
/*?*/ 		if( pColumnItem->IsTable() )
/*?*/ 			nFlags |= RULER_BORDER_TABLE;
/*?*/ 		else
/*?*/ 			if ( !bProtectColumns )
/*?*/ 				nFlags |= RULER_BORDER_SIZEABLE;
/*?*/ 
/*?*/ 		for(USHORT i = 0; i < pColumnItem->Count()-1;++i)
/*?*/ 		{
/*?*/ 			pBorders[i].nStyle = nFlags;
/*?*/ 			if(!(*pColumnItem)[i].bVisible)
/*?*/ 				pBorders[i].nStyle |= RULER_STYLE_INVISIBLE;
/*?*/ 			pBorders[i].nPos =
/*?*/ 				ConvertPosPixel((*pColumnItem)[i].nEnd + lAppNullOffset);
/*?*/ 			pBorders[i].nWidth =
/*?*/ 				ConvertSizePixel((*pColumnItem)[i+1].nStart -
/*?*/ 								 (*pColumnItem)[i].nEnd);
/*?*/ 		}
/*?*/ 		const size_t nSize = sizeof(RulerBorder) * (pColumnItem->Count()-1);
/*?*/ 		SetBorders(pColumnItem->Count()-1, pBorders);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SetBorders();
/*N*/ 	}
/*N*/ }




/*N*/ void SvxRuler::UpdatePara()

/*
   [Beschreibung]

   Anzeige der Absatzeinzuege aktualisieren:
   Linken Rand, Erstzeileneinzug, rechten Rand Absatz aktualisieren
   pIndents[0] = Buffer fuer alten Einzug
   pIndents[1] = Buffer fuer alten Einzug
   pIndents[INDENT_FIRST_LINE] = Erstzeileneinzug
   pIndents[3] = linker Rand
   pIndents[4] = rechter Rand
   pIndents[5] = left border distance
   pIndents[6] = right border distance

*/

/*N*/ {
/*N*/ 	// Abhaengigkeit zu PagePosItem
/*N*/ 	if(pParaItem && pPagePosItem && !pObjectItem)
/*?*/ 	{
/*?*/         BOOL bRTLText = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
/*?*/         // Erstzeileneinzug, ist negativ zum linken Absatzrand
/*?*/         long nLeftFrameMargin = GetLeftFrameMargin();
/*?*/         long nRightFrameMargin = GetRightFrameMargin();
/*?*/         if(bRTLText)
/*?*/             pIndents[INDENT_FIRST_LINE].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                 nRightFrameMargin -
/*?*/                 pParaItem->GetTxtLeft() -
/*?*/ 				pParaItem->GetTxtFirstLineOfst() + lAppNullOffset );
/*?*/         else
/*?*/             pIndents[INDENT_FIRST_LINE].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nLeftFrameMargin +
/*?*/                     pParaItem->GetTxtLeft() +
/*?*/                     pParaItem->GetTxtFirstLineOfst() +
/*?*/                     lAppNullOffset);
/*?*/ 		if( pParaItem->IsAutoFirst() )
/*?*/             pIndents[INDENT_FIRST_LINE].nStyle |= RULER_STYLE_INVISIBLE;
/*?*/ 		else
/*?*/             pIndents[INDENT_FIRST_LINE].nStyle &= ~RULER_STYLE_INVISIBLE;
/*?*/ 
/*?*/         if(bRTLText)
/*?*/         {
/*?*/             // left margin
/*?*/             pIndents[INDENT_LEFT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nRightFrameMargin -
/*?*/                     pParaItem->GetTxtLeft() + lAppNullOffset);
/*?*/             // right margin
/*?*/             pIndents[INDENT_RIGHT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nLeftFrameMargin +
/*?*/                     pParaItem->GetRight() + lAppNullOffset);
/*?*/         }
/*?*/         else
/*?*/         {
/*?*/             // linker Rand
/*?*/             pIndents[INDENT_LEFT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nLeftFrameMargin +
/*?*/                     pParaItem->GetTxtLeft() + lAppNullOffset);
/*?*/             // rechter Rand, immer negativ zum rechten Rand des umgebenden Frames
/*?*/             pIndents[INDENT_RIGHT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nRightFrameMargin -
/*?*/                     pParaItem->GetRight() + lAppNullOffset);
/*?*/         }
/*?*/         if(pParaBorderItem)
/*?*/         {
/*?*/             pIndents[INDENT_LEFT_BORDER].nPos =
/*?*/             ConvertHPosPixel( nLeftFrameMargin + lAppNullOffset);
/*?*/             pIndents[INDENT_RIGHT_BORDER].nPos =
/*?*/                 ConvertHPosPixel(nRightFrameMargin - lAppNullOffset);
/*?*/             pIndents[INDENT_LEFT_BORDER].nStyle = pIndents[INDENT_RIGHT_BORDER].nStyle &= ~RULER_STYLE_INVISIBLE;
/*?*/         }
/*?*/         else
/*?*/             pIndents[INDENT_LEFT_BORDER].nStyle = pIndents[INDENT_RIGHT_BORDER].nStyle |= RULER_STYLE_INVISIBLE;
/*?*/ 
/*?*/         SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if(pIndents)
/*N*/ 		{
/*N*/             pIndents[INDENT_FIRST_LINE].nPos =
/*N*/             pIndents[INDENT_LEFT_MARGIN].nPos =
/*N*/             pIndents[INDENT_RIGHT_MARGIN].nPos = 0;
/*N*/ 		}
/*N*/ 		SetIndents();        // ausschalten
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::UpdatePara
/*N*/ (
/*N*/  const SvxLRSpaceItem *pItem    // neuer Wert Absatzeinzuege
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert Absatzeinzuege merken
*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pParaItem; pParaItem = 0;
/*N*/ 		if(pItem)
/*N*/ 			pParaItem = new SvxLRSpaceItem(*pItem);
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }
/*N*/ void SvxRuler::UpdateParaBorder(const SvxLRSpaceItem * pItem )
/*
   [Description]
   Border distance
*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/         delete pParaBorderItem; pParaBorderItem = 0;
/*N*/ 		if(pItem)
/*?*/             pParaBorderItem = new SvxLRSpaceItem(*pItem);
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }


/*N*/ void SvxRuler::UpdatePage()

/*
   [Beschreibung]

   Anzeige von Postion und Breite der Seite aktualisieren

*/

/*N*/ {
/*N*/ 	if(pPagePosItem)
/*N*/ 	{
/*N*/ 		// alle Objekte werden automatisch angepasst
/*N*/ 		if(bHorz)
/*N*/ 			SetPagePos(
/*N*/ 				pEditWin->LogicToPixel(pPagePosItem->GetPos()).X(),
/*N*/ 				pEditWin->LogicToPixel(Size(pPagePosItem->GetWidth(),0)).
/*N*/ 				Width());
/*N*/ 		else
/*N*/ 			SetPagePos(
/*N*/ 				pEditWin->LogicToPixel(pPagePosItem->GetPos()).Y(),
/*N*/ 				pEditWin->LogicToPixel(Size(0, pPagePosItem->GetHeight())).
/*N*/ 				Height());
/*N*/ 		if(bAppSetNullOffset)
/*?*/ 			SetNullOffset(ConvertSizePixel(-lAppNullOffset + lLogicNullOffset));
/*N*/ 	}
/*N*/ 	else
/*N*/ 		SetPagePos();
/*N*/ 
/*N*/ 	Point aPos(pEditWin->GetPosPixel()-GetPosPixel());
/*N*/ 	long lPos= bHorz ? aPos.X() : aPos.Y();
/*N*/ 
/*N*/ // Leider bekommen wir den Offset des Editfensters zum Lineal nie
/*N*/ // per Statusmeldung. Also setzen wir ihn selbst, wenn noetig.
/*N*/ 
/*N*/ 	if(lPos!=pRuler_Imp->lOldWinPos)
/*N*/ 	{
/*?*/ 		pRuler_Imp->lOldWinPos=lPos;
/*?*/ 		SetWinPos(lPos);
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::Update
/*N*/ (
/*N*/  const SvxPagePosSizeItem *pItem // neuer Wert Seitenattribute
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert Seitenattribute merken

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pPagePosItem; pPagePosItem = 0;
/*N*/ 		if(pItem)
/*N*/ 			pPagePosItem = new SvxPagePosSizeItem(*pItem);
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }



/*N*/ void SvxRuler::UpdateTabs()

/*
   [Beschreibung]

   Anzeige der Tabulatoren

*/

/*N*/ {
/*N*/ 	if(IsDrag())
/*N*/ 		return;
/*N*/ 	if(pPagePosItem && pParaItem && pTabStopItem && !pObjectItem)
/*N*/ 	{
/*N*/ 		// Puffer fuer DefaultTabStop
/*N*/ 		// Abstand letzter Tab <-> Rechter Absatzrand / DefaultTabDist
/*N*/ 		BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
/*N*/         long nLeftFrameMargin = GetLeftFrameMargin();
/*N*/         long nRightFrameMargin = GetRightFrameMargin();
/*N*/ 
/*N*/ 		const long lParaIndent =
/*N*/ 			nLeftFrameMargin + pParaItem->GetTxtLeft();
/*N*/ 		const long lLastTab =
/*N*/ 			 pTabStopItem->Count()?
/*N*/ 			  ConvertHPosPixel((*pTabStopItem)[pTabStopItem->Count()-1].GetTabPos()): 0;
/*N*/ 		const long lPosPixel =
/*N*/ 			ConvertHPosPixel(lParaIndent) + lLastTab;
/*N*/ 		const long lRightIndent =
/*N*/ 			ConvertHPosPixel(nRightFrameMargin - pParaItem->GetRight());
/*N*/ 		long nDefTabDist = ConvertHPosPixel(lDefTabDist);
/*N*/ 		if( !nDefTabDist )
/*N*/ 			nDefTabDist = 1;
/*N*/ 		const USHORT nDefTabBuf = lPosPixel > lRightIndent ||
/*N*/ 			lLastTab > lRightIndent
/*N*/ 				? 0
/*N*/ 				: (USHORT)( (lRightIndent - lPosPixel) / nDefTabDist );
/*N*/ 		const long nOldTabCount = nTabCount;
/*N*/ 
/*N*/ 		if(pTabStopItem->Count() + TAB_GAP + nDefTabBuf > nTabBufSize)
/*N*/ 		{
/*N*/ 			delete[] pTabs;
/*N*/ 			// 10 (GAP) auf Vorrat
/*N*/ 			nTabBufSize = pTabStopItem->Count() + TAB_GAP + nDefTabBuf + GAP;
/*N*/ 			pTabs = new RulerTab[nTabBufSize];
/*N*/ 		}
/*N*/ 
/*N*/ 		nTabCount = 0;
/*N*/ 		USHORT j;
/*N*/ 		const long lRightPixMargin = ConvertSizePixel(nRightFrameMargin - pParaItem->GetTxtLeft());
/*N*/ 		const long lParaIndentPix = ConvertSizePixel(lParaIndent);
/*N*/ 		for(j = 0; j < pTabStopItem->Count(); ++j)
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const SvxTabStop *pTab = &(*pTabStopItem)[j];
/*N*/ 		}
/*N*/ 		if(!pTabStopItem->Count())
/*N*/ 			pTabs[0].nPos = bRTL ? lRightPixMargin : lParaIndentPix;
/*N*/ 
/*?*/ 		// Rest mit Default-Tabs fuellen
/*?*/ 		if(bRTL)
/*?*/ 		{
/*?*/ 			for(j = 0; j < nDefTabBuf; ++j)
/*?*/ 			{
/*?*/ 				pTabs[nTabCount + TAB_GAP].nPos =
/*?*/ 					pTabs[nTabCount].nPos - nDefTabDist;
/*?*/ 
/*?*/ 				if(j == 0 )
/*?*/ 					pTabs[nTabCount + TAB_GAP].nPos -=
/*?*/ 						((pTabs[nTabCount + TAB_GAP].nPos - lRightPixMargin)
/*?*/ 						 % nDefTabDist );
/*?*/ 				if(pTabs[nTabCount+TAB_GAP].nPos <= lParaIndentPix)
/*?*/ 					break;
/*?*/ 				pTabs[nTabCount + TAB_GAP].nStyle = RULER_TAB_DEFAULT;
/*?*/ 				++nTabCount;
/*?*/ 			}
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			for(j = 0; j < nDefTabBuf; ++j)
/*?*/ 			{
/*?*/ 				pTabs[nTabCount + TAB_GAP].nPos =
/*?*/ 					pTabs[nTabCount].nPos + nDefTabDist;
/*?*/ 
/*?*/ 				if(j == 0 )
/*?*/ 					pTabs[nTabCount + TAB_GAP].nPos -=
/*?*/ 						((pTabs[nTabCount + TAB_GAP].nPos - lParaIndentPix)
/*?*/ 						 % nDefTabDist );
/*?*/ 				if(pTabs[nTabCount+TAB_GAP].nPos >= lRightIndent)
/*?*/ 					break;
/*?*/ 				pTabs[nTabCount + TAB_GAP].nStyle = RULER_TAB_DEFAULT;
/*?*/ 				++nTabCount;
/*?*/ 			}
/*?*/ 		}
/*?*/ 		const size_t nSize = sizeof(RulerTab) * nTabCount;
/*?*/ 		SetTabs(nTabCount, pTabs+TAB_GAP);
/*?*/ 		DBG_ASSERT(nTabCount + TAB_GAP <= nTabBufSize, "BufferSize zu klein");
/*?*/ 	}
/*?*/ 	else
/*N*/ 	{
/*N*/ 		SetTabs();
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::Update
/*N*/ (
/*N*/  const SvxTabStopItem *pItem    // Neuer Wert fuer Tabulatoren
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer Tabulatoren merken; alten gfs. loeschen

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pTabStopItem; pTabStopItem = 0;
/*N*/ 		if(pItem)
/*N*/ 		{
/*N*/ 			pTabStopItem = new SvxTabStopItem(*pItem);
/*N*/ 			if(!bHorz)
/*?*/ 				pTabStopItem->SetWhich(SID_ATTR_TABSTOP_VERTICAL);
/*N*/ 		}
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }






/*N*/ void SvxRuler::Update()

/*
   [Beschreibung]

   Aktualisierung der Anzeige anstossen

*/

/*N*/ {
/*N*/ 	if(IsDrag())
/*N*/ 		return;
/*N*/ 	UpdatePage();
/*N*/ 	UpdateFrame();
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_OBJECT) == SVXRULER_SUPPORT_OBJECT)
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	UpdateObject();
/*N*/ 	else
/*N*/ 		UpdateColumns();
/*N*/ 
/*N*/     if(0 != (nFlags & (SVXRULER_SUPPORT_PARAGRAPH_MARGINS |SVXRULER_SUPPORT_PARAGRAPH_MARGINS_VERTICAL)))
/*N*/ 	  UpdatePara();
/*N*/     if(0 != (nFlags & SVXRULER_SUPPORT_TABS))
/*N*/       UpdateTabs();
/*N*/ }















// linker Rand in App-Werten; ist entweder der Seitenrand (=0)
// oder der linke Rand der Spalte, die im Spaltenattribut als
// altuelle Spalte eingestellt ist.

/*N*/ long SvxRuler::GetLeftFrameMargin() const
/*N*/ {
/*N*/     long nLeft =
/*N*/         pColumnItem && pColumnItem->Count()?
/*N*/         (*pColumnItem)[pColumnItem->GetActColumn()].nStart : 0;
/*N*/     if(pParaBorderItem && (!pColumnItem || pColumnItem->IsTable()))
/*N*/         nLeft += pParaBorderItem->GetLeft();
/*N*/     return nLeft;
/*N*/ }




/*N*/ long SvxRuler::GetRightFrameMargin() const

/*
   [Beschreibung]

   Rechten umgebenden Rand erfragen (in logischen Einheiten)

*/

/*N*/ {
/*N*/ 	if(pColumnItem)
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(!IsActLastColumn( TRUE ))
/*N*/ 	}
/*N*/ 
/*N*/ 	long l = lLogicNullOffset;
/*N*/ 
/*N*/ 	// gfs. rechten Tabelleneinzug abziehen
/*N*/ 	if(pColumnItem && pColumnItem->IsTable())
/*?*/ 		l += pColumnItem->GetRight();
/*N*/     else if(bHorz && pLRSpaceItem)
/*N*/ 		l += pLRSpaceItem->GetRight();
/*N*/     else if(!bHorz && pULSpaceItem)
/*?*/         l += pULSpaceItem->GetLower();
/*N*/ 
/*N*/     if(pParaBorderItem &&
/*N*/         (!pColumnItem || pColumnItem->IsTable()||IsActLastColumn( TRUE )))
/*?*/         l += pParaBorderItem->GetRight();
/*N*/ 
/*N*/     if(bHorz)
/*N*/         l = pPagePosItem->GetWidth() - l;
/*N*/ 	else
/*?*/         l = pPagePosItem->GetHeight() - l;
/*N*/     return l;
/*N*/ }

#define NEG_FLAG ( (nFlags & SVXRULER_SUPPORT_NEGATIVE_MARGINS) == \
				   SVXRULER_SUPPORT_NEGATIVE_MARGINS )
#define TAB_FLAG ( pColumnItem && pColumnItem->IsTable() )




















/*N*/ void SvxRuler::SetActive(BOOL bOn)
/*N*/ {
/*N*/ 	if(bOn)
/*N*/ 	{
/*N*/ 		Activate();
/*		pBindings->Invalidate( SID_RULER_LR_MIN_MAX, TRUE, TRUE );
		pBindings->Update( SID_RULER_LR_MIN_MAX );
		pBindings->Invalidate( SID_ATTR_LONG_ULSPACE, TRUE, TRUE );
		pBindings->Update( SID_ATTR_LONG_ULSPACE );
		pBindings->Invalidate( SID_ATTR_LONG_LRSPACE, TRUE, TRUE );
		pBindings->Update( SID_ATTR_LONG_LRSPACE );
		pBindings->Invalidate( SID_RULER_PAGE_POS, TRUE, TRUE );
		pBindings->Update( SID_RULER_PAGE_POS );
		pBindings->Invalidate( SID_ATTR_TABSTOP, TRUE, TRUE );
		pBindings->Update( SID_ATTR_TABSTOP );
		pBindings->Invalidate( SID_ATTR_PARA_LRSPACE, TRUE, TRUE );
		pBindings->Update( SID_ATTR_PARA_LRSPACE );
		pBindings->Invalidate( SID_RULER_BORDERS, TRUE, TRUE );
		pBindings->Update( SID_RULER_BORDERS );
		pBindings->Invalidate( SID_RULER_OBJECT, TRUE, TRUE );
		pBindings->Update( SID_RULER_OBJECT );
		pBindings->Invalidate( SID_RULER_PROTECT, TRUE, TRUE );
		pBindings->Update( SID_RULER_PROTECT );*/
/*N*/ 	}
/*N*/ 	else
/*N*/ 		Deactivate();
/*N*/ 	if(bActive!=bOn)
/*N*/ 	{
/*N*/ 		pBindings->EnterRegistrations();
/*N*/ 		if(bOn)
/*N*/ 			for(USHORT i=0;i<pRuler_Imp->nControlerItems;i++)
/*N*/ 				pCtrlItem[i]->ReBind();
/*N*/ 		else
/*N*/ 			for(USHORT j=0;j<pRuler_Imp->nControlerItems;j++)
/*N*/ 				pCtrlItem[j]->UnBind();
/*N*/ 		pBindings->LeaveRegistrations();
/*N*/ 	}
/*N*/ 	bActive = bOn;
/*N*/ }




























/*
   [Beschreibung]

   Berechnet die Grenzwerte fuers Draggen; diese sind in Pixeln
   relativ zum Seitenrand

*/











/*N*/ void __EXPORT SvxRuler::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 							   const SfxHint& rHint, const TypeId& rHintType)
/*

   [Beschreibung]

   Benachrichtigung durch die Bindings, dass die Statusaktualisierung
   beendet ist.
   Das Lineal aktualisiert seine Darstellung und meldet sich bei den
   Bindings wieder ab.

*/

/*N*/ {
/*N*/ 	// Aktualisierung anstossen
/*N*/ 	if(bActive &&
/*N*/ 		rHint.Type() == TYPE(SfxSimpleHint) &&
/*N*/ 	 ((SfxSimpleHint&) rHint ).GetId() == SFX_HINT_UPDATEDONE ) {
/*N*/ 		Update();
/*N*/ 		EndListening(*pBindings);
/*N*/ 		bValid = TRUE;
/*N*/ 		bListening = FALSE;
/*N*/ 	}
/*N*/ }













/*N*/ BOOL SvxRuler::IsActLastColumn(
/*N*/ 	BOOL bForceDontConsiderHidden, USHORT nAct) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
/*N*/ }



}
