/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_unoctitm.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:10:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/





#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "unoctitm.hxx"
#include "frame.hxx"
#include "dispatch.hxx"
#include "sfxsids.hrc"


#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
//long nOfficeDispatchCount = 0;

/*?*/ SFX_IMPL_XINTERFACE_2( SfxUnoControllerItem, OWeakObject, ::com::sun::star::frame::XStatusListener, ::com::sun::star::lang::XEventListener )
/*?*/ SFX_IMPL_XTYPEPROVIDER_2( SfxUnoControllerItem, ::com::sun::star::frame::XStatusListener, ::com::sun::star::lang::XEventListener )

/*?*/ SfxUnoControllerItem::SfxUnoControllerItem( SfxControllerItem *pItem, SfxBindings& rBind, const String& rCmd )
/*?*/ 	: pCtrlItem( pItem )
/*?*/     , pBindings( &rBind )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ SfxUnoControllerItem::~SfxUnoControllerItem()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxUnoControllerItem::UnBind()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SAL_CALL SfxUnoControllerItem::statusChanged(const ::com::sun::star::frame::FeatureStateEvent& rEvent) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void  SAL_CALL SfxUnoControllerItem::disposing( const ::com::sun::star::lang::EventObject& rEvent ) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxUnoControllerItem::ReleaseDispatch()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxUnoControllerItem::GetNewDispatch()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  SfxUnoControllerItem::TryGetDispatch( SfxFrame *pFrame )
/*?*/ {
/*?*/ 	::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  xDisp;
/*?*/ 	SfxFrame *pParent = pFrame->GetParentFrame();
/*?*/ 	if ( pParent )
/*?*/ 		// parent may intercept
/*?*/ 		xDisp = TryGetDispatch( pParent );
/*?*/ 
/*?*/ 	// only components may intercept
/*?*/ 	if ( !xDisp.is() && pFrame->HasComponent() )
/*?*/ 	{
/*?*/ 		// no interception
/*?*/ 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >  xFrame = pFrame->GetFrameInterface();
/*?*/ 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider >  xProv( xFrame, ::com::sun::star::uno::UNO_QUERY );
/*?*/ 		if ( xProv.is() )
/*?*/ 			xDisp = xProv->queryDispatch( aCommand, ::rtl::OUString(), 0 );
/*?*/ 	}
/*?*/ 
/*?*/ 	return xDisp;
/*?*/ }

/*?*/ void SfxUnoControllerItem::Execute()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxUnoControllerItem::ReleaseBindings()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ void SfxStatusDispatcher::ReleaseAll()
/*N*/ {
/*N*/ 	::com::sun::star::lang::EventObject aObject;
/*N*/ 	aObject.Source = (::cppu::OWeakObject*) this;
/*N*/ 	aListeners.disposeAndClear( aObject );
/*N*/ }

/*N*/ void SAL_CALL SfxStatusDispatcher::dispatch( const ::com::sun::star::util::URL&, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& ) throw ( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ }

/*N*/ void SAL_CALL SfxStatusDispatcher::dispatchWithNotification( const ::com::sun::star::util::URL& aURL,
/*N*/         const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs,
/*N*/         const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchResultListener >& rListener ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ }

/*N*/ SFX_IMPL_XINTERFACE_1( SfxStatusDispatcher, OWeakObject, ::com::sun::star::frame::XNotifyingDispatch )
/*N*/ SFX_IMPL_XTYPEPROVIDER_1( SfxStatusDispatcher, ::com::sun::star::frame::XNotifyingDispatch )
//IMPLNAME "com.sun.star.comp.sfx2.StatusDispatcher",

/*N*/ SfxStatusDispatcher::SfxStatusDispatcher()
/*N*/ 	: aListeners( aMutex )
/*N*/ {
/*N*/ }

/*?*/ void SAL_CALL SfxStatusDispatcher::addStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SAL_CALL SfxStatusDispatcher::removeStatusListener( const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL ) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	aListeners.removeInterface( aURL.Complete, aListener );
/*?*/ }

/*N*/ SFX_IMPL_XINTERFACE_1( SfxOfficeDispatch, SfxStatusDispatcher, ::com::sun::star::lang::XUnoTunnel )
/*N*/ SFX_IMPL_XTYPEPROVIDER_2( SfxOfficeDispatch, ::com::sun::star::frame::XNotifyingDispatch, ::com::sun::star::lang::XUnoTunnel )


//-------------------------------------------------------------------------
// XUnoTunnel
/*N*/ sal_Int64 SAL_CALL SfxOfficeDispatch::getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& aIdentifier ) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	if ( aIdentifier == impl_getStaticIdentifier() )
/*N*/         return (sal_Int64)this;
/*N*/ 	else
/*N*/ 		return 0;
/*N*/ }

/* ASDBG
void* SfxOfficeDispatch::getImplementation(Reflection *p)
{
	if( p == ::getCppuType((const SfxOfficeDispatch*)0) )
		return this;
	else
		return ::cppu::OWeakObject::getImplementation(p);

}

Reflection* ::getCppuType((const SfxOfficeDispatch*)0)
{
	static StandardClassReflection aRefl(
		0,
		createStandardClass(
			"SfxOfficeDispatch", ::cppu::OWeakObject::get::cppu::OWeakObjectIdlClass(),
			1,
			::getCppuType((const ::com::sun::star::frame::XDispatch*)0) ) );
	return &aRefl;
}
*/

/*N*/ SfxOfficeDispatch::SfxOfficeDispatch( SfxBindings& rBindings, SfxDispatcher* pDispat, sal_uInt16 nSlotId, const ::com::sun::star::util::URL& rURL, sal_Bool bInter )
/*N*/     : bIntercept( bInter )
/*N*/ {
/*N*/ //    nOfficeDispatchCount++;
/*N*/ 
/*N*/     // this object is an adapter that shows a ::com::sun::star::frame::XDispatch-Interface to the outside and uses a SfxControllerItem to monitor a state
/*N*/     pControllerItem = new SfxDispatchController_Impl( this, &rBindings, pDispat, nSlotId, rURL, bInter );
/*N*/ }

/*N*/ SfxOfficeDispatch::SfxOfficeDispatch( SfxDispatcher* pDispat, sal_uInt16 nSlotId, const ::com::sun::star::util::URL& rURL, sal_Bool bInter )
/*N*/     : bIntercept( bInter )
/*N*/ {
//    nOfficeDispatchCount++;

    // this object is an adapter that shows a ::com::sun::star::frame::XDispatch-Interface to the outside and uses a SfxControllerItem to monitor a state
/*N*/     pControllerItem = new SfxDispatchController_Impl( this, NULL, pDispat, nSlotId, rURL, bInter );
/*N*/ }

/*N*/ SfxOfficeDispatch::~SfxOfficeDispatch()
/*N*/ {
//    --nOfficeDispatchCount;

/*N*/     if ( pControllerItem )
/*N*/     {
/*N*/         // when dispatch object is released, destroy its connection to this object and destroy it
/*N*/         pControllerItem->UnBindController();
/*N*/         delete pControllerItem;
/*N*/     }
/*N*/ }

#if defined(MACOSX) && (__GNUC__ < 3)
    //MACOSX moved outside of class above
    // {38 57 CA 80 09 36 11 d4 83 FE 00 50 04 52 6B 21}
/*N*/     static sal_uInt8 pGUID[16] = { 0x38, 0x57, 0xCA, 0x80, 0x09, 0x36, 0x11, 0xd4, 0x83, 0xFE, 0x00, 0x50, 0x04, 0x52, 0x6B, 0x21 };
/*N*/     static ::com::sun::star::uno::Sequence< sal_Int8 > seqID((sal_Int8*)pGUID,16) ;
/*N*/ #endif

/*N*/ const ::com::sun::star::uno::Sequence< sal_Int8 >& SfxOfficeDispatch::impl_getStaticIdentifier()
/*N*/ {
#if !(defined(MACOSX) && (__GNUC__ < 3))
    //MACOSX moved outside of class above
    // {38 57 CA 80 09 36 11 d4 83 FE 00 50 04 52 6B 21}
/*N*/     static sal_uInt8 pGUID[16] = { 0x38, 0x57, 0xCA, 0x80, 0x09, 0x36, 0x11, 0xd4, 0x83, 0xFE, 0x00, 0x50, 0x04, 0x52, 0x6B, 0x21 };
/*N*/     static ::com::sun::star::uno::Sequence< sal_Int8 > seqID((sal_Int8*)pGUID,16) ;
/*N*/ #endif
/*N*/     return seqID ;
/*N*/ }


/*?*/ void SAL_CALL SfxOfficeDispatch::dispatch( const ::com::sun::star::util::URL& aURL, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs ) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SAL_CALL SfxOfficeDispatch::dispatchWithNotification( const ::com::sun::star::util::URL& aURL,
/*?*/         const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs,
/*?*/         const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchResultListener >& rListener ) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SAL_CALL SfxOfficeDispatch::addStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ SfxDispatcher* SfxOfficeDispatch::GetDispatcher_Impl()
/*N*/ {
/*N*/     return pControllerItem->GetDispatcher();
/*N*/ }

/*N*/ SfxDispatchController_Impl::SfxDispatchController_Impl( SfxOfficeDispatch* pDisp, SfxBindings* pBind, SfxDispatcher* pDispat, sal_uInt16 nSlotId, const ::com::sun::star::util::URL& rURL, sal_Bool bInter )
/*N*/     : pDispatch( pDisp )
/*N*/ 	, aDispatchURL( rURL )
/*N*/     , pBindings( pBind )
/*N*/     , pDispatcher( pDispat )
/*N*/ 	, pLastState( 0 )
/*N*/     , nSlot( nSlotId )
/*N*/ {
/*N*/     SetId( nSlot );
/*N*/ }

/*N*/ SfxDispatchController_Impl::~SfxDispatchController_Impl()
/*N*/ {
/*N*/ 	if ( pLastState && !IsInvalidItem( pLastState ) )
/*?*/ 		delete pLastState;
/*N*/ 
/*N*/     if ( pDispatch )
/*N*/     {
/*?*/         // disconnect
/*?*/         pDispatch->pControllerItem = NULL;
/*?*/ 
/*?*/         // force all listeners to release the dispatch object
/*?*/         ::com::sun::star::lang::EventObject aObject;
/*?*/         aObject.Source = (::cppu::OWeakObject*) pDispatch;
/*?*/         pDispatch->GetListeners().disposeAndClear( aObject );
/*N*/     }
/*N*/ }

/*N*/ void SfxDispatchController_Impl::UnBindController()
/*N*/ {
/*N*/     pDispatch = NULL;
/*N*/     if ( IsBound() )
/*N*/     {
/*?*/         GetBindings().ENTERREGISTRATIONS();
/*?*/         SfxControllerItem::UnBind();
/*?*/         GetBindings().LEAVEREGISTRATIONS();
/*N*/     }
/*N*/ }

/*?*/ void SAL_CALL SfxDispatchController_Impl::dispatch( const ::com::sun::star::util::URL& aURL,
/*?*/         const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs,
/*?*/         const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchResultListener >& rListener ) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ SfxDispatcher* SfxDispatchController_Impl::GetDispatcher()
/*N*/ {
/*N*/     if ( !pDispatcher && pBindings )
/*?*/         pDispatcher = GetBindings().GetDispatcher_Impl();
/*N*/     return pDispatcher;
/*N*/ }

/*?*/ void SAL_CALL SfxDispatchController_Impl::addStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxDispatchController_Impl::StateChanged( sal_uInt16 nSID, SfxItemState eState, const SfxPoolItem* pState )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }


}
