/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_accelinfo.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:52:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "app.hxx"
#include "accmgr.hxx"



#ifndef _SFXMSGPOOL_HXX
#include <msgpool.hxx>
#endif


#ifndef _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif

namespace binfilter {

/*N*/ ::rtl::OUString SAL_CALL GetCommandURLFromKeyCode( const KeyCode& aKeyCode )
/*N*/ {
/*N*/     SfxAcceleratorManager* pAccManager = SFX_APP()->GetGlobalAcceleratorManager();
/*N*/ 	if ( pAccManager )
/*N*/ 	{
/*N*/ 		USHORT nId = pAccManager->GetId( aKeyCode );
/*N*/ 		if ( nId > 0 )
/*N*/ 		{
/*N*/             const SfxSlot* pSlot = SFX_APP()->GetSlotPool().GetSlot( nId );
/*N*/ 
/*N*/             // create the dispatch name from the slot data
/*N*/             ::com::sun::star::util::URL aURL;
/*N*/             String aName( pSlot && pSlot->pUnoName ? String::CreateFromAscii(pSlot->GetUnoName()) : String() );
/*N*/             String aCmd;
/*N*/             if ( aName.Len() )
/*N*/             {
/*N*/                 aCmd = DEFINE_CONST_UNICODE(".uno:");
/*N*/                 aCmd += aName;
/*N*/             }
/*N*/             else
/*N*/             {
/*N*/                 aCmd = DEFINE_CONST_UNICODE("slot:");
/*N*/                 aCmd += String::CreateFromInt32( nId );
/*N*/             }
/*N*/ 
/*N*/ 			return aCmd;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return ::rtl::OUString();
/*N*/ }
}
