/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_output.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:12:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#include <bf_svx/boxitem.hxx>
#include <svtools/colorcfg.hxx>
#include <bf_svx/shaditem.hxx>
#include <vcl/svapp.hxx>
#include <svtools/accessibilityoptions.hxx>

#include <math.h>

#include "output.hxx"
#include "cell.hxx"
#include "attrib.hxx"
#include "sclnlnk.hxx"
#include "chgtrack.hxx"
#include "gridmerg.hxx"
#include "invmerge.hxx"

#include "scmod.hxx"
#include "appoptio.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

//	Farben fuer ChangeTracking "nach Autor" wie im Writer (swmodul1.cxx)

#define SC_AUTHORCOLORCOUNT		9

static ColorData nAuthorColor[ SC_AUTHORCOLORCOUNT ] = {
					COL_LIGHTRED, 		COL_LIGHTBLUE,		COL_LIGHTMAGENTA,
					COL_GREEN,			COL_RED,			COL_BLUE,
					COL_BROWN,			COL_MAGENTA,		COL_CYAN };

//	Hilfsklasse, fuer die Farbzuordnung,
//	um nicht mehrfach hintereinander denselben User aus der Liste zu suchen


//------------------------------------------------------------------



//==================================================================

/*N*/ ScOutputData::ScOutputData( OutputDevice* pNewDev, ScOutputType eNewType,
/*N*/ 							RowInfo* pNewRowInfo, USHORT nNewCount, ScDocument* pNewDoc,
/*N*/ 							USHORT nNewTab, long nNewScrX, long nNewScrY,
/*N*/ 							USHORT nNewX1, USHORT nNewY1, USHORT nNewX2, USHORT nNewY2,
/*N*/ 							double nPixelPerTwipsX, double nPixelPerTwipsY,
/*N*/ 							const Fraction* pZoomX, const Fraction* pZoomY ) :
/*N*/ 	pDev( pNewDev ),
/*N*/ 	pRefDevice( pNewDev ),		// default is output device
/*N*/ 	pFmtDevice( pNewDev ),		// default is output device
/*N*/ 	eType( eNewType ),
/*N*/ 	pRowInfo( pNewRowInfo ),
/*N*/ 	nArrCount( nNewCount ),
/*N*/ 	pDoc( pNewDoc ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	nScrX( nNewScrX ),
/*N*/ 	nScrY( nNewScrY ),
/*N*/ 	nX1( nNewX1 ),
/*N*/ 	nY1( nNewY1 ),
/*N*/ 	nX2( nNewX2 ),
/*N*/ 	nY2( nNewY2 ),
/*N*/ 	nPPTX( nPixelPerTwipsX ),
/*N*/ 	nPPTY( nPixelPerTwipsY ),
/*N*/ 	bEditMode( FALSE ),
/*N*/ 	bMetaFile( FALSE ),
/*N*/ 	bPagebreakMode( FALSE ),
/*N*/ 	bSolidBackground( FALSE ),
/*N*/ 	bUseStyleColor( FALSE ),
/*N*/ 	bForceAutoColor( SC_MOD()->GetAccessOptions().GetIsAutomaticFontColor() ),
/*N*/ 	bSyntaxMode( FALSE ),
/*N*/ 	pValueColor( NULL ),
/*N*/ 	pTextColor( NULL ),
/*N*/ 	pFormulaColor( NULL ),
/*N*/ 	bSingleGrid( FALSE ),
/*N*/ 	aGridColor( COL_BLACK ),
/*N*/ 	bMarkClipped( FALSE ),			// FALSE fuer Drucker/Metafile etc.
/*N*/ 	bShowNullValues( TRUE ),
/*N*/ 	bShowFormulas( FALSE ),
/*N*/ 	bSnapPixel( FALSE ),
/*N*/ 	bShowSpellErrors( FALSE ),
/*N*/ 	pEditObj( NULL ),
/*N*/ 	pViewShell( NULL ),
/*N*/ 	bAnyRotated( FALSE ),
/*N*/ 	bAnyClipped( FALSE )
/*N*/ {
/*N*/ 	if (pZoomX)
/*N*/ 		aZoomX = *pZoomX;
/*N*/ 	else
/*?*/ 		aZoomX = Fraction(1,1);
/*N*/ 	if (pZoomY)
/*N*/ 		aZoomY = *pZoomY;
/*N*/ 	else
/*?*/ 		aZoomY = Fraction(1,1);
/*N*/ 
/*N*/ 	nVisX1 = nX1;
/*N*/ 	nVisY1 = nY1;
/*N*/ 	nVisX2 = nX2;
/*N*/ 	nVisY2 = nY2;
/*N*/ 	pDoc->StripHidden( nVisX1, nVisY1, nVisX2, nVisY2, nTab );
/*N*/ 
/*N*/ 	nScrW = 0;
/*N*/ 	for (USHORT nX=nVisX1; nX<=nVisX2; nX++)
/*N*/ 		nScrW += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*N*/ 
/*N*/ 	nScrH = 0;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 		nScrH += pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 	bTabProtected = pDoc->IsTabProtected( nTab );
/*N*/ 	nTabTextDirection = pDoc->GetEditTextDirection( nTab );
/*N*/ }

/*N*/ ScOutputData::~ScOutputData()
/*N*/ {
/*N*/ 	delete pValueColor;
/*N*/ 	delete pTextColor;
/*N*/ 	delete pFormulaColor;
/*N*/ }

/*N*/ void ScOutputData::SetGridColor( const Color& rColor )
/*N*/ {
/*N*/ 	aGridColor = rColor;
/*N*/ }

/*N*/ void ScOutputData::SetMarkClipped( BOOL bSet )
/*N*/ {
/*N*/ 	bMarkClipped = bSet;
/*N*/ }

/*N*/ void ScOutputData::SetShowNullValues( BOOL bSet )
/*N*/ {
/*N*/ 	bShowNullValues = bSet;
/*N*/ }

/*N*/ void ScOutputData::SetShowFormulas( BOOL bSet )
/*N*/ {
/*N*/ 	bShowFormulas = bSet;
/*N*/ }

/*N*/ void ScOutputData::SetShowSpellErrors( BOOL bSet )
/*N*/ {
/*N*/ 	bShowSpellErrors = bSet;
/*N*/ }




/*N*/ void ScOutputData::SetSingleGrid( BOOL bNewMode )
/*N*/ {
/*N*/ 	bSingleGrid = bNewMode;
/*N*/ }

/*N*/ void ScOutputData::SetSyntaxMode( BOOL bNewMode )
/*N*/ {
/*N*/ 	bSyntaxMode = bNewMode;
/*N*/ 	if (bNewMode)
/*?*/ 		if (!pValueColor)
/*?*/ 		{
/*?*/ 			pValueColor = new Color( COL_LIGHTBLUE );
/*?*/ 			pTextColor = new Color( COL_BLACK );
/*?*/ 			pFormulaColor = new Color( COL_GREEN );
/*?*/ 		}
/*N*/ }

/*N*/ void ScOutputData::DrawGrid( BOOL bGrid, BOOL bPage )
/*N*/ {
/*N*/ 	USHORT nX;
/*N*/ 	USHORT nY;
/*N*/ 	long nPosX;
/*N*/ 	long nPosY;
/*N*/ 	USHORT i;
/*N*/ 	USHORT nArrY;
/*N*/ 	BYTE nOldFlags = 0;
/*N*/ 	BYTE nFlags;
/*N*/ 	BOOL bSingle;
/*N*/ 	Color aPageColor;
/*N*/ 	Color aManualColor;
/*N*/ 
/*N*/ 	if (bPagebreakMode)
/*N*/ 		bPage = FALSE;			// keine "normalen" Umbrueche ueber volle Breite/Hoehe
/*N*/ 
/*N*/ 	//!	um den einen Pixel sieht das Metafile (oder die Druck-Ausgabe) anders aus
/*N*/ 	//!	als die Bildschirmdarstellung, aber wenigstens passen Druck und Metafile zusammen
/*N*/ 
/*N*/ 	Size aOnePixel = pDev->PixelToLogic(Size(1,1));
/*N*/ 	long nOneX = aOnePixel.Width();
/*N*/ 	long nOneY = aOnePixel.Height();
/*N*/ 	if (bMetaFile)
/*N*/ 		nOneX = nOneY = 1;
/*N*/ 
/*N*/ 	if ( eType == OUTTYPE_WINDOW )
/*N*/ 	{
/*N*/         const svtools::ColorConfig& rColorCfg = SC_MOD()->GetColorConfig();
/*N*/         aPageColor.SetColor( rColorCfg.GetColorValue(svtools::CALCPAGEBREAKAUTOMATIC).nColor );
/*N*/         aManualColor.SetColor( rColorCfg.GetColorValue(svtools::CALCPAGEBREAKMANUAL).nColor );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aPageColor = aGridColor;
/*N*/ 		aManualColor = aGridColor;
/*N*/ 	}
/*N*/ 
/*N*/ 	pDev->SetLineColor( aGridColor );
/*N*/ 	ScGridMerger aGrid( pDev, nOneX, nOneY );
/*N*/ 
/*N*/ 										//
/*N*/ 										//	Vertikale Linien
/*N*/ 										//
/*N*/ 
/*N*/ 	nPosX = nScrX;
/*N*/ 	for (nX=nX1; nX<=nX2; nX++)
/*N*/ 	{
/*N*/ 		USHORT nXplus1 = nX+1;
/*N*/ 		USHORT nXplus2 = nX+2;
/*N*/ 		USHORT nWidth = pRowInfo[0].pCellInfo[nXplus1].nWidth;
/*N*/ 		if (nWidth)
/*N*/ 		{
/*N*/ 			nPosX += nWidth;
/*N*/ 
/*N*/ 			if ( bPage )
/*N*/ 			{
/*N*/ 				//	Seitenumbrueche auch in ausgeblendeten suchen
/*N*/ 				nFlags = 0;
/*N*/ 				USHORT nCol = nXplus1;
/*N*/ 				while (nCol <= MAXCOL)
/*N*/ 				{
/*N*/ 					BYTE nDocFl = pDoc->GetColFlags( nCol, nTab );
/*N*/ 					nFlags = nDocFl & ( CR_PAGEBREAK | CR_MANUALBREAK );
/*N*/ 					if ( nFlags || !(nDocFl & CR_HIDDEN) )
/*N*/ 						break;
/*N*/ 					++nCol;
/*N*/ 				}
/*N*/ 
/*N*/ 				if (nFlags != nOldFlags)
/*N*/ 				{
/*N*/ 					aGrid.Flush();
/*N*/ 					pDev->SetLineColor( (nFlags & CR_MANUALBREAK) ? aManualColor :
/*N*/ 									 (nFlags) ? aPageColor : aGridColor );
/*N*/ 					nOldFlags = nFlags;
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			BOOL bDraw = bGrid || nOldFlags;	// einfaches Gitter nur wenn eingestellt
/*N*/ 
/*N*/ 			//!	Mit dieser Abfrage wird zuviel weggelassen, wenn ein automatischer
/*N*/ 			//!	Umbruch mitten in den Wiederholungsspalten liegt.
/*N*/ 			//!	Dann lieber den aeusseren Rahmen zweimal ausgeben...
/*N*/ #if 0
/*?*/ 			//	auf dem Drucker die Aussen-Linien weglassen (werden getrennt ausgegeben)
/*?*/ 			if ( eType == OUTTYPE_PRINTER && !bMetaFile )
/*?*/ 			{
/*?*/ 				if ( nX == MAXCOL )
/*?*/ 					bDraw = FALSE;
/*?*/ 				else if (pDoc->GetColFlags(nXplus1,nTab) & ( CR_PAGEBREAK | CR_MANUALBREAK ))
/*?*/ 					bDraw = FALSE;
/*?*/ 			}
/*N*/ #endif
/*N*/ 
/*N*/ 			USHORT nWidthXplus2 = pRowInfo[0].pCellInfo[nXplus2].nWidth;
/*N*/ 			bSingle = bSingleGrid;									//! in Fillinfo holen !!!!!
/*N*/ 			if ( nX<MAXCOL && !bSingle )
/*N*/ 			{
/*?*/ 				bSingle = ( nWidthXplus2 == 0 );
/*?*/ 				for (nArrY=1; nArrY+1<nArrCount && !bSingle; nArrY++)
/*?*/ 				{
/*?*/ 					if (pRowInfo[nArrY].pCellInfo[nXplus2].bHOverlapped)
/*?*/ 						bSingle = TRUE;
/*?*/ 					if (pRowInfo[nArrY].pCellInfo[nXplus1].bHideGrid)
/*?*/ 						bSingle = TRUE;
/*?*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			if (bDraw)
/*N*/ 			{
/*N*/ 				if ( nX<MAXCOL && bSingle )
/*N*/ 				{
/*N*/ 					USHORT nVisX = nXplus1;
/*N*/ 					while ( nVisX < MAXCOL && !pDoc->GetColWidth(nVisX,nTab) )
/*N*/ 						++nVisX;
/*N*/ 
/*N*/ 					nPosY = nScrY;
/*N*/ 					long nNextY;
/*N*/ 					for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 					{
/*N*/ 						RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 						nNextY = nPosY + pThisRowInfo->nHeight;
/*N*/ 
/*N*/ 						BOOL bHOver = pThisRowInfo->pCellInfo[nXplus1].bHideGrid;
/*N*/ 						if (!bHOver)
/*N*/ 						{
/*N*/ 							if (nWidthXplus2)
/*N*/ 								bHOver = pThisRowInfo->pCellInfo[nXplus2].bHOverlapped;
/*N*/ 							else
/*N*/ 							{
/*?*/ 								if (nVisX <= nX2)
/*?*/ 									bHOver = pThisRowInfo->pCellInfo[nVisX+1].bHOverlapped;
/*?*/ 								else
/*?*/ 									bHOver = ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 												nVisX,pThisRowInfo->nRowNo,nTab,ATTR_MERGE_FLAG))
/*?*/ 												->IsHorOverlapped();
/*?*/ 								if (bHOver)
/*?*/ 									bHOver = ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 												nXplus1,pThisRowInfo->nRowNo,nTab,ATTR_MERGE_FLAG))
/*?*/ 												->IsHorOverlapped();
/*N*/ 							}
/*N*/ 						}
/*N*/ 
/*N*/ 						if (pThisRowInfo->bChanged && !bHOver)
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 						}
/*N*/ 						nPosY = nNextY;
/*N*/ 					}
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 										//
/*N*/ 										//	Horizontale Linien
/*N*/ 										//
/*N*/ 
/*N*/ 	nPosY = nScrY;
/*N*/ 	for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		USHORT nArrYplus1 = nArrY+1;
/*N*/ 		nY = pRowInfo[nArrY].nRowNo;
/*N*/ 		USHORT nYplus1 = nY+1;
/*N*/ 		nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 		if (pRowInfo[nArrY].bChanged)
/*N*/ 		{
/*?*/ 			if ( bPage )
/*?*/ 			{
/*?*/ 				//	Seitenumbrueche auch in ausgeblendeten suchen
/*?*/ 				nFlags = 0;
/*?*/ 				USHORT nRow = nYplus1;
/*?*/ 				while (nRow <= MAXROW)
/*?*/ 				{
/*?*/ 					BYTE nDocFl = pDoc->GetRowFlags( nRow, nTab );
/*?*/ 					nFlags = nDocFl & ( CR_PAGEBREAK | CR_MANUALBREAK );
/*?*/ 					if ( nFlags || !(nDocFl & CR_HIDDEN) )
/*?*/ 						break;
/*?*/ 					++nRow;
/*?*/ 				}
/*?*/ 
/*?*/ 				if (nFlags != nOldFlags)
/*?*/ 				{
/*?*/ 					aGrid.Flush();
/*?*/ 					pDev->SetLineColor( (nFlags & CR_MANUALBREAK) ? aManualColor :
/*?*/ 									 (nFlags) ? aPageColor : aGridColor );
/*?*/ 					nOldFlags = nFlags;
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			BOOL bDraw = bGrid || nOldFlags;	// einfaches Gitter nur wenn eingestellt
/*?*/ 
/*?*/ 			//!	Mit dieser Abfrage wird zuviel weggelassen, wenn ein automatischer
/*?*/ 			//!	Umbruch mitten in den Wiederholungszeilen liegt.
/*?*/ 			//!	Dann lieber den aeusseren Rahmen zweimal ausgeben...
/*?*/ #if 0
/*?*/ 			//	auf dem Drucker die Aussen-Linien weglassen (werden getrennt ausgegeben)
/*?*/ 			if ( eType == OUTTYPE_PRINTER && !bMetaFile )
/*?*/ 			{
/*?*/ 				if ( nY == MAXROW )
/*?*/ 					bDraw = FALSE;
/*?*/ 				else if (pDoc->GetRowFlags(nYplus1,nTab) & ( CR_PAGEBREAK | CR_MANUALBREAK ))
/*?*/ 					bDraw = FALSE;
/*?*/ 			}
/*?*/ #endif
/*?*/ 
/*?*/ 			BOOL bNextYisNextRow = (pRowInfo[nArrYplus1].nRowNo == nYplus1);
/*?*/ 			bSingle = !bNextYisNextRow;				// Hidden
/*?*/ 			for (i=nX1; i<=nX2 && !bSingle; i++)
/*?*/ 			{
/*?*/ 				if (pRowInfo[nArrYplus1].pCellInfo[i+1].bVOverlapped)
/*?*/ 					bSingle = TRUE;
/*?*/ 			}
/*?*/ 
/*?*/ 			if (bDraw)
/*?*/ 			{
/*?*/ 				if ( bSingle && nY<MAXROW )
/*?*/ 				{
/*?*/ 					USHORT nVisY = pRowInfo[nArrYplus1].nRowNo;
/*?*/ 
/*?*/ 					nPosX = nScrX;
/*?*/ 					long nNextX;
/*?*/ 					for (i=nX1; i<=nX2; i++)
/*?*/ 					{
/*?*/ 						nNextX = nPosX + pRowInfo[0].pCellInfo[i+1].nWidth;
/*?*/ 						if (nNextX != nPosX)								// sichtbar
/*?*/ 						{
/*?*/ 							BOOL bVOver;
/*?*/ 							if ( bNextYisNextRow )
/*?*/ 								bVOver = pRowInfo[nArrYplus1].pCellInfo[i+1].bVOverlapped;
/*?*/ 							else
/*?*/ 							{
/*?*/ 								bVOver = ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 											i,nYplus1,nTab,ATTR_MERGE_FLAG))
/*?*/ 											->IsVerOverlapped()
/*?*/ 									&& 	 ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 											i,nVisY,nTab,ATTR_MERGE_FLAG))
/*?*/ 											->IsVerOverlapped();
/*?*/ 									//! nVisY aus Array ??
/*?*/ 							}
/*?*/ 							if (!bVOver)
/*?*/ 							{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 							}
/*?*/ 						}
/*?*/ 						nPosX = nNextX;
/*?*/ 					}
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//	----------------------------------------------------------------------------


/*N*/ void ScOutputData::FindRotated()
/*N*/ {
/*N*/ 	//!	nRotMax speichern
/*N*/ 	USHORT nRotMax = nX2;
/*N*/ 	for (USHORT nRotY=0; nRotY<nArrCount; nRotY++)
/*N*/ 		if (pRowInfo[nRotY].nRotMaxCol != SC_ROTMAX_NONE && pRowInfo[nRotY].nRotMaxCol > nRotMax)
/*N*/ 			nRotMax = pRowInfo[nRotY].nRotMaxCol;
/*N*/ 
/*N*/ 	for (USHORT nArrY=1; nArrY<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->nRotMaxCol != SC_ROTMAX_NONE &&
/*N*/ 			 ( pThisRowInfo->bChanged || pRowInfo[nArrY-1].bChanged ||
/*N*/ 			   ( nArrY+1<nArrCount && pRowInfo[nArrY+1].bChanged ) ) )
/*N*/ 		{
/*?*/ 			USHORT nY = pThisRowInfo->nRowNo;
/*?*/ 
/*?*/ 			for (USHORT nX=0; nX<=nRotMax; nX++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
/*?*/ 				const ScPatternAttr* pPattern = pInfo->pPatternAttr;
/*?*/ 				const SfxItemSet* pCondSet = pInfo->pConditionSet;
/*?*/ 
/*?*/ 				if ( !pPattern && (pDoc->GetColFlags(nX,nTab) & CR_HIDDEN) == 0 )
/*?*/ 				{
/*?*/ 					pPattern = pDoc->GetPattern( nX, nY, nTab );
/*?*/ 					pCondSet = pDoc->GetCondResult( nX, nY, nTab );
/*?*/ 				}
/*?*/ 
/*?*/ 				if ( pPattern )		// Spalte nicht ausgeblendet
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 BYTE nDir = pPattern->GetRotateDir( pCondSet );
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//	----------------------------------------------------------------------------



//	----------------------------------------------------------------------------


/*N*/ void ScOutputData::DrawBackground()
/*N*/ {
/*N*/ 	FindRotated();				//! von aussen ?
/*N*/ 
/*N*/ 	ScModule* pScMod = SC_MOD();
/*N*/ 
/*N*/ 	// used only if bSolidBackground is set (only for ScGridWindow):
/*N*/     Color aBgColor( pScMod->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor );
/*N*/ 
/*N*/ 	Rectangle aRect;
/*N*/ 	Size aOnePixel = pDev->PixelToLogic(Size(1,1));
/*N*/ 	long nOneX = aOnePixel.Width();
/*N*/ 	long nOneY = aOnePixel.Height();
/*N*/ 
/*N*/ 	if (bMetaFile)
/*N*/ 		nOneX = nOneY = 0;
/*N*/ 
/*N*/ 	pDev->SetLineColor();
/*N*/ 
/*N*/ 	BOOL bShowProt = bSyntaxMode && pDoc->IsTabProtected(nTab);
/*N*/ 	BOOL bDoAll = bShowProt || bPagebreakMode || bSolidBackground;
/*N*/ 
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor &&
/*N*/ 			Application::GetSettings().GetStyleSettings().GetHighContrastMode();
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		long nRowHeight = pThisRowInfo->nHeight;
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			if ( ( ( pThisRowInfo->bEmptyBack ) || bSyntaxMode ) && !bDoAll )
/*?*/ 			{
/*?*/ 				//	nichts
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 			}
/*N*/ 		}
/*N*/ 		nPosY += nRowHeight;
/*N*/ 	}
/*N*/ }

/*N*/ void ScOutputData::DrawShadow()
/*N*/ {
/*N*/ 	pDev->SetLineColor();
/*N*/ 
/*N*/ 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor && rStyleSettings.GetHighContrastMode();
/*N*/ 	Color aAutoTextColor;
/*N*/ 	if ( bCellContrast )
/*?*/         aAutoTextColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		long nRowHeight = pThisRowInfo->nHeight;
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			long nPosX = nScrX;
/*?*/ 
/*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*?*/ 			{
/*?*/ 				for (USHORT nPass=0; nPass<2; nPass++)			// horizontal / vertikal
/*?*/ 				{
/*?*/ 					const SvxShadowItem* pAttr = nPass ?
/*?*/ 							pThisRowInfo->pCellInfo[nX+1].pVShadowOrigin :
/*?*/ 							pThisRowInfo->pCellInfo[nX+1].pHShadowOrigin;
/*?*/ 					if (pAttr)
/*?*/ 					{
/*?*/ 						ScShadowPart ePart = nPass ?
/*?*/ 								pThisRowInfo->pCellInfo[nX+1].eVShadowPart :
/*?*/ 								pThisRowInfo->pCellInfo[nX+1].eHShadowPart;
/*?*/ 
/*?*/ 						long nMaxWidth = pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 						if (!nMaxWidth)
/*?*/ 						{
/*?*/ 							USHORT nWx = nX+1;
/*?*/ 							while (!pRowInfo[0].pCellInfo[nWx+1].nWidth && nWx<nX2)
/*?*/ 								++nWx;
/*?*/ 							nMaxWidth = pRowInfo[0].pCellInfo[nWx+1].nWidth;
/*?*/ 						}
/*?*/ 
/*?*/ 						Rectangle aRect( Point(nPosX,nPosY),
/*?*/ 										 Size( pRowInfo[0].pCellInfo[nX+1].nWidth,
/*?*/ 												pRowInfo[nArrY].nHeight ) );
/*?*/ 
/*?*/ 						long nSize = pAttr->GetWidth();
/*?*/ 						long nSizeX = (long)(nSize*nPPTX);
/*?*/ 						if (nSizeX >= nMaxWidth) nSizeX = nMaxWidth-1;
/*?*/ 						long nSizeY = (long)(nSize*nPPTY);
/*?*/ 						if (nSizeY >= nRowHeight) nSizeY = nRowHeight-1;
/*?*/ 
/*?*/ 						SvxShadowLocation eLoc = pAttr->GetLocation();
/*?*/ 
/*?*/ 						if (ePart == SC_SHADOW_HORIZ || ePart == SC_SHADOW_HSTART ||
/*?*/ 							ePart == SC_SHADOW_CORNER)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_TOPRIGHT)
/*?*/ 								aRect.Top() = aRect.Bottom() - nSizeY;
/*?*/ 							else
/*?*/ 								aRect.Bottom() = aRect.Top() + nSizeY;
/*?*/ 						}
/*?*/ 						if (ePart == SC_SHADOW_VERT || ePart == SC_SHADOW_VSTART ||
/*?*/ 							ePart == SC_SHADOW_CORNER)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_BOTTOMLEFT)
/*?*/ 								aRect.Left() = aRect.Right() - nSizeX;
/*?*/ 							else
/*?*/ 								aRect.Right() = aRect.Left() + nSizeX;
/*?*/ 						}
/*?*/ 						if (ePart == SC_SHADOW_HSTART)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_BOTTOMLEFT)
/*?*/ 								aRect.Right() -= nSizeX;
/*?*/ 							else
/*?*/ 								aRect.Left() += nSizeX;
/*?*/ 						}
/*?*/ 						if (ePart == SC_SHADOW_VSTART)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_TOPRIGHT)
/*?*/ 								aRect.Bottom() -= nSizeY;
/*?*/ 							else
/*?*/ 								aRect.Top() += nSizeY;
/*?*/ 						}
/*?*/ 
/*?*/ 						//! merge rectangles?
/*?*/ 						pDev->SetFillColor( bCellContrast ? aAutoTextColor : pAttr->GetColor() );
/*?*/ 						pDev->DrawRect( aRect );
/*?*/ 					}
/*?*/ 				}
/*?*/ 
/*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 			}
/*N*/ 		}
/*N*/ 		nPosY += nRowHeight;
/*N*/ 	}
/*N*/ }


//
//	Loeschen
//



//
//	Linien
//

inline void FinishOldRect( OutputDevice* pDev, Rectangle& rOldRect, BOOL& rOldValid )
{
	if ( rOldValid )
	{
		pDev->DrawRect( rOldRect );
 		rOldValid = FALSE;
 	}
}

/*N*/ void ScOutputData::DrawFrame()
/*N*/ {
/*N*/ 	ULONG nOldDrawMode = pDev->GetDrawMode();
/*N*/ 
/*N*/ 	Color aSingleColor;
/*N*/ 	BOOL bUseSingleColor = FALSE;
/*N*/ 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor && rStyleSettings.GetHighContrastMode();
/*N*/ 
/*N*/ 	//	#107519# if a Calc OLE object is embedded in Draw/Impress, the VCL DrawMode is used
/*N*/ 	//	for display mode / B&W printing. The VCL DrawMode handling doesn't work for lines
/*N*/ 	//	that are drawn with DrawRect, so if the line/background bits are set, the DrawMode
/*N*/ 	//	must be reset and the border colors handled here.
/*N*/ 	//	(Similar to fix for #72796# in SdrObject::ImpDrawLineGeometry)
/*N*/ 
/*N*/ 	if ( ( nOldDrawMode & DRAWMODE_WHITEFILL ) && ( nOldDrawMode & DRAWMODE_BLACKLINE ) )
/*N*/ 	{
/*?*/ 		pDev->SetDrawMode( nOldDrawMode & (~DRAWMODE_WHITEFILL) );
/*?*/ 		aSingleColor.SetColor( COL_BLACK );
/*?*/ 		bUseSingleColor = TRUE;
/*N*/ 	}
/*N*/ 	else if ( ( nOldDrawMode & DRAWMODE_SETTINGSFILL ) && ( nOldDrawMode & DRAWMODE_SETTINGSLINE ) )
/*N*/ 	{
/*?*/ 		pDev->SetDrawMode( nOldDrawMode & (~DRAWMODE_SETTINGSFILL) );
/*?*/ 		aSingleColor = rStyleSettings.GetWindowTextColor();		// same as used in VCL for DRAWMODE_SETTINGSLINE
/*?*/ 		bUseSingleColor = TRUE;
/*N*/ 	}
/*N*/ 	else if ( bCellContrast )
/*N*/ 	{
/*?*/ 		aSingleColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*?*/ 		bUseSingleColor = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bAnyRotated)
/*N*/ 	{
/*?*/ 		const Color* pForceColor = NULL;
/*?*/ 		if ( bUseSingleColor )
/*?*/ 			pForceColor = &aSingleColor;
/*?*/ 		DrawRotatedFrame( pForceColor );		// removes the lines that must not be painted here
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nArrY;
/*N*/ 	USHORT nArrX;
/*N*/ 
/*N*/ 	long nPosX;
/*N*/ 	long nPosY;
/*N*/ 
/*N*/ 	short nFirstSize;
/*N*/ 	short nSpaceSize;
/*N*/ 	short nSecondSize;
/*N*/ 
/*N*/ 	long nDrawX;
/*N*/ 	long nDrawY;
/*N*/ 	long nDrawStartX;
/*N*/ 	long nDrawStartY;
/*N*/ 	long nDrawEndX;
/*N*/ 	long nDrawEndY;
/*N*/ 
/*N*/ 	const SvxBorderLine* pDrawLine;
/*N*/ 	const SvxBorderLine* pOldLine = NULL;
/*N*/ 
/*N*/ 	Color aOldCol( COL_BLACK );
/*N*/ 
/*N*/ 	short nLinkRes[4];
/*N*/ 	ScLineStruct aDrawLine;
/*N*/ 	ScLineStruct aLineLT;
/*N*/ 	ScLineStruct aLineLB;
/*N*/ 	ScLineStruct aLineRT;
/*N*/ 	ScLineStruct aLineRB;
/*N*/ 	ScLineStruct aLineL;
/*N*/ 	ScLineStruct aLineR;
/*N*/ 
/*N*/ 	//	Dummy-Initialisierung
/*N*/ 	aDrawLine.nLeft   = 0;
/*N*/ 	aDrawLine.nMiddle = 0;
/*N*/ 	aDrawLine.nRight  = 0;
/*N*/ 	aLineLT = aDrawLine;
/*N*/ 	aLineLB = aDrawLine;
/*N*/ 	aLineRT = aDrawLine;
/*N*/ 	aLineRB = aDrawLine;
/*N*/ 	aLineL = aDrawLine;
/*N*/ 	aLineR = aDrawLine;
/*N*/ 
/*N*/ 	BOOL bIsLine;
/*N*/ 	BOOL bWasLine;
/*N*/ 
/*N*/ 	BOOL bOldValid = FALSE;								// Rechtecke zusammenfassen
/*N*/ 	Rectangle aOldRect;
/*N*/ 	BOOL bOldValid2 = FALSE;							// zweite Linien
/*N*/ 	Rectangle aOldRect2;
/*N*/ 
/*N*/ 	pDev->SetLineColor();
/*N*/ 	pDev->SetFillColor( aOldCol );
/*N*/ 
/*N*/ 				//
/*N*/ 				//			Horizontale Linien
/*N*/ 				//
/*N*/ 
/*N*/ 	nPosY = nScrY - 1;
/*N*/ 	for (nArrY=0; nArrY+1<nArrCount; nArrY++)			// einer vorher
/*N*/ 	{
/*N*/ 		if (nArrY>0)									// "nullte Zeile" ganz oben
/*N*/ 			nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 		long nSnapPosY = nPosY;
/*N*/ 		if (bSnapPixel)
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 			lcl_SnapPixelY(pDev,nSnapPosY);
/*N*/ 
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged || pRowInfo[nArrY+1].bChanged )
/*N*/ 		{
/*N*/ 			bWasLine = FALSE;
/*N*/ 			nPosX = nScrX - 1;
/*N*/ 
/*N*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*N*/ 			{
/*N*/ 				bIsLine = FALSE;
/*N*/ 				long nEndX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth;
/*N*/ 
/*N*/ 				pDrawLine = pThisRowInfo->pCellInfo[nX+1].pBottomLine;
/*N*/ 				if ( pDrawLine )
/*N*/ 				{
/*N*/ 					if ( pDrawLine->GetOutWidth() )
/*N*/ 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 					}
/*N*/ 				}
/*N*/ 				nPosX = nEndX;
/*N*/ 				bWasLine = bIsLine;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 				//
/*N*/ 				//			Vertikale Linien
/*N*/ 				//
/*N*/ 
/*N*/ 	nPosX = nScrX - 1;
/*N*/ 	for (nArrX=nX1; nArrX<=nX2+1; nArrX++)						// einer vorher
/*N*/ 	{
/*N*/ 		if (nArrX>nX1)											// "nullte Zeile" ganz links
/*N*/ 			nPosX += pRowInfo[0].pCellInfo[nArrX].nWidth;
/*N*/ 
/*N*/ 		long nSnapPosX = nPosX;
/*N*/ 		if (bSnapPixel)
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/			lcl_SnapPixelX(pDev,nSnapPosX);
/*N*/ 
/*N*/ 		bWasLine = FALSE;
/*N*/ 		nPosY = nScrY - 1;
/*N*/ 		for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 		{
/*N*/ 			bIsLine = FALSE;
/*N*/ 			long nEndY = nPosY + pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 			//	Zeile +-1 nur, um Variablen mitzufuehren, gezeichnet wird nicht
/*N*/ 			if ( pRowInfo[nArrY].bChanged ||
/*N*/ 				pRowInfo[nArrY+1].bChanged || pRowInfo[nArrY-1].bChanged )
/*N*/ 			{
/*N*/ 				pDrawLine = pRowInfo[nArrY].pCellInfo[nArrX].pRightLine;
/*N*/ 				if ( pDrawLine )
/*N*/ 				{
/*N*/ 					if ( pDrawLine->GetOutWidth() )
/*N*/ 					{
/*N*/ 						long nSnapPosY = nPosY;
/*N*/ 						long nSnapEndY = nEndY;
/*N*/ 						if (bSnapPixel)
/*N*/ 						{ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 						}
/*N*/ 
/*N*/ 						bIsLine = TRUE;
/*N*/ 						if ( pDrawLine != pOldLine )
/*N*/ 						{
/*N*/ 							Color aColor( pDrawLine->GetColor() );
/*N*/ 							if ( bUseSingleColor )
/*N*/ 								aColor = aSingleColor;
/*N*/ 							if ( aColor != aOldCol )
/*N*/ 							{ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 							}
/*N*/ 
/*N*/ 							nFirstSize = Max((short) 1, (short) ( pDrawLine->GetOutWidth() * nPPTX ));
/*N*/ 							if ( pDrawLine->GetInWidth() )
/*N*/ 							{
/*N*/ 								nSpaceSize = Max((short) 1, (short) ( pDrawLine->GetDistance() * nPPTX ));
/*N*/ 								nSecondSize = Max((short) 1, (short) ( pDrawLine->GetInWidth() * nPPTX ));
/*N*/ 							}
/*N*/ 							else
/*N*/ 							{
/*N*/ 								nSpaceSize = 0;
/*N*/ 								nSecondSize = 0;
/*N*/ 							}
/*N*/ 						}
/*N*/ 
/*N*/ 						nDrawX = nSnapPosX - (nFirstSize + nSpaceSize + nSecondSize - 1) / 2;
/*N*/ 
/*N*/ 						// durchzeichnen ?
/*N*/ 						//	(nur wenn nLinkRes gueltig -> bChanged)
/*N*/ 
/*N*/ 						if ( nArrY >= 2
/*N*/ 								&& pRowInfo[nArrY].bChanged
/*N*/ 								&& pRowInfo[nArrY-1].pCellInfo[nArrX].pRightLine 	== pRowInfo[nArrY-2].pCellInfo[nArrX].pRightLine
/*N*/ 								&& pRowInfo[nArrY-1].pCellInfo[nArrX].pBottomLine 	== pRowInfo[nArrY-2].pCellInfo[nArrX].pBottomLine
/*N*/ 								&& pRowInfo[nArrY  ].pCellInfo[nArrX].pRightLine 	== pRowInfo[nArrY-1].pCellInfo[nArrX].pRightLine
/*N*/ 								&& pRowInfo[nArrY  ].pCellInfo[nArrX].pBottomLine 	== pRowInfo[nArrY-1].pCellInfo[nArrX].pBottomLine
/*N*/ 								&& pRowInfo[nArrY+1].pCellInfo[nArrX].pRightLine 	== pRowInfo[nArrY  ].pCellInfo[nArrX].pRightLine
/*N*/ 								&& pRowInfo[nArrY-1].pCellInfo[nArrX+1].pBottomLine	== pRowInfo[nArrY-2].pCellInfo[nArrX+1].pBottomLine
/*N*/ 								&& pRowInfo[nArrY  ].pCellInfo[nArrX+1].pBottomLine	== pRowInfo[nArrY-1].pCellInfo[nArrX+1].pBottomLine )
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001_nLinkRes not init. 
/*N*/ 						}
/*N*/ 						else
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 						}
/*N*/ 
/*N*/ 						if (pRowInfo[nArrY].bChanged)
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 						}
/*N*/ 
/*N*/ 						pOldLine = pDrawLine;			// nur vorhandene
/*N*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/ 			nPosY = nEndY;
/*N*/ 			bWasLine = bIsLine;
/*N*/ 		}
/*N*/ 
/*N*/ 		//	Bei ausgeblendeten Spalten liegt die naechste Spalte an derselben Position
/*N*/ 		//	-> ohne FinishOldRect wuerden die Rechtecke dann weitergezeichnet (#31261#)
/*N*/ 		FinishOldRect( pDev, aOldRect, bOldValid );
/*N*/ 		FinishOldRect( pDev, aOldRect2, bOldValid2 );
/*N*/ 	}
/*N*/ 
/*N*/ 	FinishOldRect( pDev, aOldRect, bOldValid );
/*N*/ 	FinishOldRect( pDev, aOldRect2, bOldValid2 );
/*N*/ 
/*N*/ 	pDev->SetDrawMode(nOldDrawMode);
/*N*/ }

//	-------------------------------------------------------------------------

//	Linie unter der Zelle


// lcl_HorizLine muss genau zu normal ausgegebenen Linien passen!



//	Drucker


/*N*/ BOOL ScOutputData::SetChangedClip()
/*N*/ {
/*N*/ 	PolyPolygon aPoly;
/*N*/ 
/*N*/ 	Rectangle aDrawingRect;
/*N*/ 	aDrawingRect.Left() = nScrX;
/*N*/ 	aDrawingRect.Right() = nScrX+nScrW-1;
/*N*/ 
/*N*/ 	BOOL	bHad	= FALSE;
/*N*/ 	long	nPosY	= nScrY;
/*N*/ 	USHORT	nArrY;
/*N*/ 	for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*N*/ 			if (!bHad)
/*N*/ 			{
/*N*/ 				aDrawingRect.Top() = nPosY;
/*N*/ 				bHad = TRUE;
/*N*/ 			}
/*N*/ 			aDrawingRect.Bottom() = nPosY + pRowInfo[nArrY].nHeight - 1;
/*N*/ 		}
/*N*/ 		else if (bHad)
/*N*/ 		{
/*N*/ 			aPoly.Insert( Polygon( pDev->PixelToLogic(aDrawingRect) ) );
/*N*/ 			bHad = FALSE;
/*N*/ 		}
/*N*/ 		nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHad)
/*N*/ 		aPoly.Insert( Polygon( pDev->PixelToLogic(aDrawingRect) ) );
/*N*/ 
/*N*/ 	BOOL bRet = (aPoly.Count() != 0);
/*N*/ 	if (bRet)
/*N*/ 		pDev->SetClipRegion(Region(aPoly));
/*N*/ 	return bRet;
/*N*/ }

/*N*/ void ScOutputData::FindChanged()
/*N*/ {
/*N*/ 	USHORT	nX;
/*N*/ 	USHORT	nArrY;
/*N*/ 
/*N*/ 	BOOL bWasIdleDisabled = pDoc->IsIdleDisabled();
/*N*/ 	pDoc->DisableIdle( TRUE );
/*N*/ 	for (nArrY=0; nArrY<nArrCount; nArrY++)
/*N*/ 		pRowInfo[nArrY].bChanged = FALSE;
/*N*/ 
/*N*/ 	BOOL bProgress = FALSE;
/*N*/ 	for (nArrY=0; nArrY<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		for (nX=nX1; nX<=nX2; nX++)
/*N*/ 		{
/*N*/ 			ScBaseCell* pCell = pThisRowInfo->pCellInfo[nX+1].pCell;
/*N*/ 			if (pCell)
/*N*/ 				if (pCell->GetCellType() == CELLTYPE_FORMULA)
/*N*/ 				{
/*N*/ 					ScFormulaCell* pFCell = (ScFormulaCell*)pCell;
/*N*/ 					if ( !bProgress && pFCell->GetDirty() )
/*N*/ 					{
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ScProgress::CreateInterpretProgress( pDoc, TRUE );
/*N*/ 					}
/*N*/ 					if (!pFCell->IsRunning())
/*N*/ 					{
/*N*/ 						double aVal = pFCell->GetValue();
/*N*/ 						if (pFCell->IsChanged())
/*N*/ 						{
/*?*/ 							pThisRowInfo->bChanged = TRUE;
/*?*/ 							if ( pThisRowInfo->pCellInfo[nX+1].bMerged )
/*?*/ 							{
/*?*/ 								DBG_BF_ASSERT(0, "STRIP"); //STRIP001 USHORT nOverY = nArrY + 1;
/*?*/ 							}
/*N*/ 						}
/*N*/ 					}
/*N*/ 				}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if ( bProgress )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ScProgress::DeleteInterpretProgress();
/*N*/ 	pDoc->DisableIdle( bWasIdleDisabled );
/*N*/ }

/*N*/ void ScOutputData::DrawMark( Window* pWin )
/*N*/ {
/*N*/ 	Rectangle aRect;
/*N*/ 	ScInvertMerger aInvert( pWin );
/*N*/ 	//!	additional method AddLineRect for ScInvertMerger?
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			long nPosX = nScrX;
/*?*/ 			aRect = Rectangle( Point( nPosX,nPosY ), Size(0, pThisRowInfo->nHeight) );
/*?*/ 
/*?*/ 			BOOL bOldMarked = FALSE;
/*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*?*/ 			{
/*?*/ 				if ( pThisRowInfo->pCellInfo[nX+1].bMarked != bOldMarked )
/*?*/ 				{
/*?*/ 					if (bOldMarked && aRect.Right() >= aRect.Left())
							{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 						aInvert.AddRect( aRect );
/*?*/ 					aRect.Left() = nPosX;
/*?*/ 					bOldMarked = pThisRowInfo->pCellInfo[nX+1].bMarked;
/*?*/ 				}
/*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 				aRect.Right() = nPosX-1;
/*?*/ 			}
/*?*/ 			if (bOldMarked && aRect.Right() >= aRect.Left())
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				aInvert.AddRect( aRect );
/*N*/ 		}
/*N*/ 		nPosY += pThisRowInfo->nHeight;
/*N*/ 	}
/*N*/ }




/*N*/ void ScOutputData::DrawNoteMarks()
/*N*/ {
/*N*/ 	BOOL bFirst = TRUE;
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			long nPosX = nScrX;
/*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
/*?*/ 				ScBaseCell* pCell = pInfo->pCell;
/*?*/ 				BOOL bIsMerged = FALSE;
/*?*/ 
/*?*/ 				if ( nX==nX1 && pInfo->bHOverlapped && !pInfo->bVOverlapped )
/*?*/ 				{
/*?*/ 					// find start of merged cell
/*?*/ 					bIsMerged = TRUE;
/*?*/ 					USHORT nY = pRowInfo[nArrY].nRowNo;
/*?*/ 					USHORT nMergeX = nX;
/*?*/ 					USHORT nMergeY = nY;
/*?*/ 					pDoc->ExtendOverlapped( nMergeX, nMergeY, nX, nY, nTab );
/*?*/ 					pCell = pDoc->GetCell( ScAddress(nMergeX,nMergeY,nTab) );
/*?*/ 					// use origin's pCell for NotePtr test below
/*?*/ 				}
/*?*/ 
/*?*/ 				if ( pCell && pCell->GetNotePtr() && ( bIsMerged ||
/*?*/ 						( !pInfo->bHOverlapped && !pInfo->bVOverlapped ) ) )
/*?*/ 				{
/*?*/ 					if (bFirst)
/*?*/ 					{
/*?*/ 						pDev->SetLineColor();
/*?*/ 
/*?*/ 						const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
/*?*/ 						if ( bUseStyleColor && rStyleSettings.GetHighContrastMode() )
/*?*/                             pDev->SetFillColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*?*/ 						else
/*?*/ 							pDev->SetFillColor(COL_LIGHTRED);
/*?*/ 
/*?*/ 						bFirst = FALSE;
/*?*/ 					}
/*?*/ 
/*?*/ 					long nMarkX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth - 4;
/*?*/ 					if ( bIsMerged || pInfo->bMerged )
/*?*/ 					{
/*?*/ 						//	if merged, add widths of all cells
/*?*/ 						USHORT nNextX = nX + 1;
/*?*/ 						while ( nNextX <= nX2 + 1 && pThisRowInfo->pCellInfo[nNextX+1].bHOverlapped )
/*?*/ 						{
/*?*/ 							nMarkX += pRowInfo[0].pCellInfo[nNextX+1].nWidth;
/*?*/ 							++nNextX;
/*?*/ 						}
/*?*/ 					}
/*?*/ 					if ( nMarkX < nScrX+nScrW )
/*?*/ 						pDev->DrawRect( Rectangle( nMarkX,nPosY,nMarkX+2,nPosY+2 ) );
/*?*/ 				}
/*?*/ 
/*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 			}
/*N*/ 		}
/*N*/ 		nPosY += pThisRowInfo->nHeight;
/*N*/ 	}
/*N*/ }




/*M*/ void ScOutputData::DrawClipMarks()
/*M*/ {
/*M*/ 	if (!bAnyClipped)
/*M*/ 		return;
/*M*/ 
/*M*/ 	Color aArrowFillCol( COL_LIGHTRED );
/*M*/ 
/*M*/ 	ULONG nOldDrawMode = pDev->GetDrawMode();
/*M*/ 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
/*M*/ 	if ( bUseStyleColor && rStyleSettings.GetHighContrastMode() )
/*M*/ 	{
/*M*/ 		//	use DrawMode to change the arrow's outline color
/*M*/ 		pDev->SetDrawMode( nOldDrawMode | DRAWMODE_SETTINGSLINE );
/*M*/ 		//	use text color also for the fill color
/*N*/         aArrowFillCol.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*N*/ 	}
/*N*/ 
/*N*/ 	Rectangle aCellRect;
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/ 	pDev->SetDrawMode(nOldDrawMode);
/*N*/ }



}
