/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_formatsh.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:10:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _VCONT_HXX
#define _SI_NOOTHERFORMS
#define _VCTRLS_HXX
#define _SI_NOCONTROL
#define _SETBRW_HXX
#define _VCBRW_HXX
#define _SI_NOSBXCONTROLS

//------------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <svtools/whiter.hxx>

#define _ZFORLIST_DECLARE_TABLE
#include <bf_svx/boxitem.hxx>
#include <bf_sfx2/dispatch.hxx>
#include <bf_sfx2/templdlg.hxx>
#include <bf_sfx2/tplpitem.hxx>
#include <bf_svx/algitem.hxx>
#include <bf_svx/udlnitem.hxx>
#include <bf_svx/colritem.hxx>
#include <bf_svx/brshitem.hxx>
#include <bf_svx/frmdiritem.hxx>
#include <bf_svx/scripttypeitem.hxx>
#include <svtools/colorcfg.hxx>

#include "formatsh.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "docsh.hxx"
#include "patattr.hxx"
#include "scmod.hxx"
#include "stlpool.hxx"
#include "printfun.hxx"
#include "docpool.hxx"
#include "scresid.hxx"
#include "tabvwsh.hxx"

namespace binfilter {//STRIP009
#define ScFormatShell
#define	TableFont
#define FormatForSelection
#include "scslots.hxx"
#define Interior

/*N*/ TYPEINIT1( ScFormatShell, SfxShell );

/*N*/ SFX_IMPL_INTERFACE(ScFormatShell, SfxShell, ScResId(SCSTR_FORMATSHELL) )
/*N*/ {
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT | SFX_VISIBILITY_STANDARD |
/*N*/ 								SFX_VISIBILITY_SERVER,
/*N*/ 								ScResId(RID_OBJECTBAR_FORMAT));
/*N*/ 
/*N*/ }


/*N*/ ScFormatShell::ScFormatShell(ScViewData* pData) :
/*N*/ 	SfxShell(pData->GetViewShell()),
/*N*/ 	pViewData(pData)
/*N*/ {
/*N*/ 	ScTabViewShell*	pTabViewShell = GetViewData()->GetViewShell();
/*N*/ 
/*N*/ 	SetPool( &pTabViewShell->GetPool() );
/*N*/ 	SetUndoManager( pViewData->GetSfxDocShell()->GetUndoManager() );
/*N*/ 	SetHelpId(HID_SCSHELL_FORMATSH);
/*N*/ 	SetName(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Format")));
/*N*/ }

/*N*/ ScFormatShell::~ScFormatShell()
/*N*/ {
/*N*/ }

//------------------------------------------------------------------

/*N*/ void __EXPORT ScFormatShell::GetStyleState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScDocument*				pDoc  		= GetViewData()->GetDocument();
/*N*/ 	ScTabViewShell*	pTabViewShell  		= GetViewData()->GetViewShell();
/*N*/ 	SfxStyleSheetBasePool*	pStylePool	= pDoc->GetStyleSheetPool();
/*N*/ 	SfxStyleSheetBase*		pStyleSheet = NULL;
/*N*/ 
/*N*/ 	BOOL bProtected = FALSE;
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	for (USHORT i=0; i<nTabCount; i++)
/*N*/ 		if (pDoc->IsTabProtected(i))				// ueberhaupt eine Tabelle geschuetzt?
/*N*/ 			bProtected = TRUE;
/*N*/ 
/*N*/ 	SfxWhichIter	aIter(rSet);
/*N*/ 	USHORT			nWhich = aIter.FirstWhich();
/*N*/ 	USHORT			nSlotId = 0;
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		nSlotId = SfxItemPool::IsWhich( nWhich )
/*N*/ 					? GetPool().GetSlotId( nWhich )
/*N*/ 					: nWhich;
/*N*/ 
/*N*/ 		switch ( nSlotId )
/*N*/ 		{
/*N*/ 			case SID_STYLE_APPLY:
/*N*/ 				if ( !pStylePool )
/*?*/ 					rSet.DisableItem( nSlotId );
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY2:		// Zellvorlagen
/*N*/ 			{
/*N*/ 				SfxStyleSheet* pStyleSheet = (SfxStyleSheet*)
/*N*/ 											 pTabViewShell->GetStyleSheetFromMarked();
/*N*/ 
/*N*/ 				if ( pStyleSheet )
/*N*/ 					rSet.Put( SfxTemplateItem( nSlotId, pStyleSheet->GetName() ) );
/*N*/ 				else
/*?*/ 					rSet.Put( SfxTemplateItem( nSlotId, String() ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY4:		// Seitenvorlagen
/*N*/ 			{
/*N*/ 				USHORT			nCurTab		= GetViewData()->GetTabNo();
/*N*/ 				String			aPageStyle  = pDoc->GetPageStyle( nCurTab );
/*N*/ 				SfxStyleSheet*	pStyleSheet = (SfxStyleSheet*)pStylePool->
/*N*/ 									Find( aPageStyle, SFX_STYLE_FAMILY_PAGE );
/*N*/ 
/*N*/ 				if ( pStyleSheet )
/*N*/ 					rSet.Put( SfxTemplateItem( nSlotId, aPageStyle ) );
/*N*/ 				else
/*?*/ 					rSet.Put( SfxTemplateItem( nSlotId, String() ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_WATERCAN:
/*N*/ 			{
/*N*/ 				rSet.Put( SfxBoolItem( nSlotId, SC_MOD()->GetIsWaterCan() ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_UPDATE_BY_EXAMPLE:
/*N*/ 			{
/*N*/ 				ISfxTemplateCommon* pDesigner = SFX_APP()->
/*N*/ 						GetCurrentTemplateCommon(pTabViewShell->GetViewFrame()->GetBindings());
/*N*/ 				BOOL bPage = pDesigner && SFX_STYLE_FAMILY_PAGE == pDesigner->GetActualFamily();
/*N*/ 
/*N*/ 				if ( bProtected || bPage )
/*N*/ 					rSet.DisableItem( nSlotId );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			case SID_STYLE_EDIT:
/*N*/ 			case SID_STYLE_DELETE:
/*N*/ 			{
/*N*/ 				ISfxTemplateCommon* pDesigner = SFX_APP()->
/*N*/ 						GetCurrentTemplateCommon(pTabViewShell->GetViewFrame()->GetBindings());
/*N*/ 				BOOL bPage = pDesigner && SFX_STYLE_FAMILY_PAGE == pDesigner->GetActualFamily();
/*N*/ 
/*N*/ 				if ( bProtected && !bPage )
/*N*/ 					rSet.DisableItem( nSlotId );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			default:
/*N*/ 				break;
/*N*/ 		}
/*N*/ 
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------




//------------------------------------------------------------------

#define APPLY_HOR_JUSTIFY(j) \
	{																		\
		if ( !pHorJustify || (eHorJustify != (j) ) )                        \
			pTabViewShell->ApplyAttr( SvxHorJustifyItem( (j) ) );                          \
		else                                                                \
			pTabViewShell->ApplyAttr( SvxHorJustifyItem( SVX_HOR_JUSTIFY_STANDARD ) );     \
	}

#define APPLY_VER_JUSTIFY(j) \
	{																		\
		if ( !pVerJustify || (eVerJustify != (j) ) )                        \
			pTabViewShell->ApplyAttr( SvxVerJustifyItem( (j) ) );                          \
		else                                                                \
			pTabViewShell->ApplyAttr( SvxVerJustifyItem( SVX_VER_JUSTIFY_STANDARD ) );     \
	}



#undef APPLY_HOR_JUSTIFY
#undef APPLY_VER_JUSTIFY

//------------------------------------------------------------------


/*N*/ void ScFormatShell::GetAttrState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
/*N*/ 	const SfxItemSet&	 rAttrSet	= pTabViewShell->GetSelectionPattern()->GetItemSet();
/*N*/ 	const SfxItemSet*	 pParentSet = rAttrSet.GetParent();
/*N*/ 	const SvxBorderLine* pLine      = pTabViewShell->GetDefaultFrameLine();
/*N*/ 	const SvxBrushItem&  rBrushItem = (const SvxBrushItem&)rAttrSet.Get( ATTR_BACKGROUND );
/*N*/ 	UINT8				 nTrans		= rBrushItem.GetColor().GetTransparency();
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	rSet.Put( rAttrSet, FALSE );
/*N*/ 
/*N*/ 	//	choose font info according to selection script type
/*N*/ 	BYTE nScript = 0;		// GetSelectionScriptType never returns 0
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT, nScript );
/*N*/ 	}
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT_HEIGHT ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT_HEIGHT, nScript );
/*N*/ 	}
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch(nWhich)
/*N*/ 		{
/*N*/ 			case SID_BACKGROUND_COLOR:
/*N*/ 			{
/*N*/ 				Color aColor;
/*N*/ 				if ( nTrans == 255 )
/*N*/                     aColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor );
/*N*/ 				else
/*N*/ 					aColor = rBrushItem.GetColor();
/*N*/ 				rSet.Put( SvxColorItem( aColor, SID_BACKGROUND_COLOR ) );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_FRAME_LINECOLOR:
/*N*/ 			{
/*N*/ 				rSet.Put( SvxColorItem( pLine ? pLine->GetColor() : Color(),
/*N*/ 										SID_FRAME_LINECOLOR ) );
/*N*/ 			}
/*N*/ 			break;
/*?*/ 			case SID_ATTR_BRUSH:
/*?*/ 			{
/*?*/ 				rSet.Put( rBrushItem, GetPool().GetWhich(nWhich) );
/*?*/ 			}
/*?*/ 			break;
/*			case SID_ATTR_ALIGN_LINEBREAK:
			{
				const SfxBoolItem& rBreakItem = (const SfxBoolItem&)rAttrSet.Get( ATTR_LINEBREAK );
				rSet.Put( rBreakItem, GetPool().GetWhich(nWhich) );
			}
			break;
*/
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

/*N*/ void ScFormatShell::GetTextAttrState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScTabViewShell*	pTabViewShell  	= GetViewData()->GetViewShell();
/*N*/ 	const SfxItemSet& rAttrSet	= pTabViewShell->GetSelectionPattern()->GetItemSet();
/*N*/ 	rSet.Put( rAttrSet, FALSE ); // ItemStates mitkopieren
/*N*/ 
/*N*/ 	//	choose font info according to selection script type
/*N*/ 	BYTE nScript = 0;		// GetSelectionScriptType never returns 0
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT_WEIGHT ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT_WEIGHT, nScript );
/*N*/ 	}
/*N*/ 	if ( rSet.GetItemState( ATTR_FONT_POSTURE ) != SFX_ITEM_UNKNOWN )
/*N*/ 	{
/*N*/ 		if (!nScript) nScript = pTabViewShell->GetSelectionScriptType();
/*N*/ 		ScViewUtil::PutItemScript( rSet, rAttrSet, ATTR_FONT_POSTURE, nScript );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxItemState eState;
/*N*/ //	const SfxPoolItem* pItem;
/*N*/ 
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 	// eigene Kontrolle ueber RadioButton-Funktionalitaet:
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 	// Unterstreichung
/*N*/ 	//------------------------
/*N*/ 
/*N*/ 	eState = rAttrSet.GetItemState( ATTR_FONT_UNDERLINE, TRUE );
/*N*/ 	if ( eState == SFX_ITEM_DONTCARE )
/*N*/ 	{
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_NONE );
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_SINGLE );
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_DOUBLE );
/*?*/ 		rSet.InvalidateItem( SID_ULINE_VAL_DOTTED );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		FontUnderline eUnderline = ((const SvxUnderlineItem&)
/*N*/ 					rAttrSet.Get(ATTR_FONT_UNDERLINE)).GetUnderline();
/*N*/ 		USHORT nId = SID_ULINE_VAL_NONE;
/*N*/ 		switch (eUnderline)
/*N*/ 		{
/*N*/ 			case UNDERLINE_SINGLE:	nId = SID_ULINE_VAL_SINGLE;	break;
/*N*/ 			case UNDERLINE_DOUBLE:	nId = SID_ULINE_VAL_DOUBLE;	break;
/*N*/ 			case UNDERLINE_DOTTED:	nId = SID_ULINE_VAL_DOTTED;	break;
/*N*/ 			default:
/*N*/ 				break;
/*N*/ 		}
/*N*/ 		rSet.Put( SfxBoolItem( nId, TRUE ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	//------------------------
/*N*/ 	// horizontale Ausrichtung
/*N*/ 	//------------------------
/*N*/ 
/*N*/ 	const SvxHorJustifyItem* pHorJustify = NULL;
/*N*/ 	const SvxVerJustifyItem* pVerJustify = NULL;
/*N*/ 	SvxCellHorJustify        eHorJustify = SVX_HOR_JUSTIFY_STANDARD;
/*N*/ 	SvxCellVerJustify        eVerJustify = SVX_VER_JUSTIFY_STANDARD;
/*N*/ 	USHORT		 			 nWhich		 = 0;
/*N*/ 	BOOL					 bJustifyStd = FALSE;
/*N*/ 	SfxBoolItem				 aBoolItem	 ( 0, TRUE );
/*N*/ 
/*N*/ 	eState 	 = rAttrSet.GetItemState( ATTR_HOR_JUSTIFY, TRUE,
/*N*/ 										(const SfxPoolItem**)&pHorJustify );
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_SET:
/*N*/ 			{
/*N*/ 				eHorJustify = SvxCellHorJustify( pHorJustify->GetValue() );
/*N*/ 
/*N*/ 				switch ( SvxCellHorJustify( pHorJustify->GetValue() ) )
/*N*/ 				{
/*N*/ 					case SVX_HOR_JUSTIFY_STANDARD:
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_LEFT:
/*N*/ 						nWhich = SID_ALIGNLEFT;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_RIGHT:
/*N*/ 						nWhich = SID_ALIGNRIGHT;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_CENTER:
/*N*/ 						nWhich = SID_ALIGNCENTERHOR;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_BLOCK:
/*N*/ 						nWhich = SID_ALIGNBLOCK;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_HOR_JUSTIFY_REPEAT:
/*N*/ 					default:
/*N*/ 						bJustifyStd = TRUE;
/*N*/ 						break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*?*/ 		case SFX_ITEM_DONTCARE:
/*?*/ 			rSet.InvalidateItem( SID_ALIGNLEFT );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNRIGHT );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNCENTERHOR );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNBLOCK );
/*?*/ 			break;
/*?*/ 
/*N*/ 		default:
/*N*/ 			bJustifyStd = TRUE;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nWhich )
/*N*/ 	{
/*?*/ 		aBoolItem.SetWhich( nWhich );
/*?*/ 		rSet.Put( aBoolItem );
/*N*/ 	}
/*N*/ 	else if ( bJustifyStd )
/*N*/ 	{
/*N*/ 		aBoolItem.SetValue( FALSE );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNLEFT );	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNRIGHT );	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNCENTERHOR ); rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNBLOCK );	  rSet.Put( aBoolItem );
/*N*/ 		bJustifyStd = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	//------------------------
/*N*/ 	// vertikale Ausrichtung
/*N*/ 	//------------------------
/*N*/ 
/*N*/ 	nWhich = 0;
/*N*/ 	aBoolItem.SetValue( TRUE );
/*N*/ 
/*N*/ 	eState = rAttrSet.GetItemState( ATTR_VER_JUSTIFY, TRUE,
/*N*/ 									(const SfxPoolItem**)&pVerJustify );
/*N*/ 
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_SET:
/*N*/ 			{
/*N*/ 				eVerJustify = SvxCellVerJustify( pVerJustify->GetValue() );
/*N*/ 
/*N*/ 				switch ( eVerJustify )
/*N*/ 				{
/*N*/ 					case SVX_VER_JUSTIFY_TOP:
/*N*/ 						nWhich = SID_ALIGNTOP;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_VER_JUSTIFY_BOTTOM:
/*N*/ 						nWhich = SID_ALIGNBOTTOM;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_VER_JUSTIFY_CENTER:
/*N*/ 						nWhich = SID_ALIGNCENTERVER;
/*N*/ 						break;
/*N*/ 
/*N*/ 					case SVX_VER_JUSTIFY_STANDARD:
/*N*/ 					default:
/*N*/ 						bJustifyStd = TRUE;
/*N*/ 						break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*?*/ 		case SFX_ITEM_DONTCARE:
/*?*/ 			rSet.InvalidateItem( SID_ALIGNTOP );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNBOTTOM );
/*?*/ 			rSet.InvalidateItem( SID_ALIGNCENTERVER );
/*?*/ 			break;
/*?*/ 
/*N*/ 		default:
/*N*/ 			bJustifyStd = TRUE;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nWhich )
/*N*/ 	{
/*N*/ 		aBoolItem.SetWhich( nWhich );
/*N*/ 		rSet.Put( aBoolItem );
/*N*/ 	}
/*N*/ 	else if ( bJustifyStd )
/*N*/ 	{
/*N*/ 		aBoolItem.SetValue( FALSE );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNTOP );	  	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNBOTTOM );	  rSet.Put( aBoolItem );
/*N*/ 		aBoolItem.SetWhich( SID_ALIGNCENTERVER ); rSet.Put( aBoolItem );
/*N*/ 	}
/*N*/ }


//------------------------------------------------------------------


//------------------------------------------------------------------






/*M*/ void ScFormatShell::GetTextDirectionState( SfxItemSet& rSet )
/*M*/ {
/*M*/     ScTabViewShell* pTabViewShell = GetViewData()->GetViewShell();
/*M*/     const SfxItemSet& rAttrSet = pTabViewShell->GetSelectionPattern()->GetItemSet();
/*M*/ 
/*M*/     BOOL bVertDontCare =
/*M*/         (rAttrSet.GetItemState( ATTR_VERTICAL_ASIAN ) == SFX_ITEM_DONTCARE) ||
/*M*/         (rAttrSet.GetItemState( ATTR_ORIENTATION ) == SFX_ITEM_DONTCARE);
/*M*/     BOOL bLeftRight = !bVertDontCare &&
/*M*/         (((const SvxOrientationItem&) rAttrSet.Get( ATTR_ORIENTATION )).GetValue() != SVX_ORIENTATION_STACKED);
/*M*/     BOOL bTopBottom = !bVertDontCare && !bLeftRight &&
/*M*/         ((const SfxBoolItem&) rAttrSet.Get( ATTR_VERTICAL_ASIAN )).GetValue();
/*M*/ 
/*M*/     BOOL bBidiDontCare = (rAttrSet.GetItemState( ATTR_WRITINGDIR ) == SFX_ITEM_DONTCARE);
/*M*/     EEHorizontalTextDirection eBidiDir = EE_HTEXTDIR_DEFAULT;
/*M*/     if ( !bBidiDontCare )
/*M*/     {
/*M*/         SvxFrameDirection eCellDir = (SvxFrameDirection)((const SvxFrameDirectionItem&)
/*M*/                                         rAttrSet.Get( ATTR_WRITINGDIR )).GetValue();
/*M*/         if ( eCellDir == FRMDIR_ENVIRONMENT )
/*M*/             eBidiDir = (EEHorizontalTextDirection)GetViewData()->GetDocument()->
/*M*/                                 GetEditTextDirection( GetViewData()->GetTabNo() );
/*M*/         else if ( eCellDir == FRMDIR_HORI_RIGHT_TOP )
/*M*/             eBidiDir = EE_HTEXTDIR_R2L;
/*M*/         else
/*M*/             eBidiDir = EE_HTEXTDIR_L2R;
/*M*/     }
/*M*/ 
/*N*/ 	SvtLanguageOptions	aLangOpt;
/*N*/ 	BOOL bDisableCTLFont = !aLangOpt.IsCTLFontEnabled();
/*N*/ 	BOOL bDisableVerticalText = !aLangOpt.IsVerticalTextEnabled();
/*N*/ 
/*N*/     SfxWhichIter aIter( rSet );
/*N*/     USHORT nWhich = aIter.FirstWhich();
/*N*/     while( nWhich )
/*N*/     {
/*N*/         switch( nWhich )
/*N*/         {
/*N*/             case SID_TEXTDIRECTION_LEFT_TO_RIGHT:
/*N*/             case SID_TEXTDIRECTION_TOP_TO_BOTTOM:
/*N*/                 if ( bDisableVerticalText )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*?*/ 					if( bVertDontCare )
/*?*/ 						rSet.InvalidateItem( nWhich );
/*?*/ 					else if ( nWhich == SID_TEXTDIRECTION_LEFT_TO_RIGHT )
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, bLeftRight ) );
/*?*/ 					else
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, bTopBottom ) );
/*N*/ 				}
/*N*/             break;
/*N*/ 
/*N*/             case SID_ATTR_PARA_LEFT_TO_RIGHT:
/*N*/             case SID_ATTR_PARA_RIGHT_TO_LEFT:
/*N*/ 				if ( bDisableCTLFont )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*?*/ 					if ( bTopBottom )
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					else if ( bBidiDontCare )
/*?*/ 						rSet.InvalidateItem( nWhich );
/*?*/ 					else if ( nWhich == SID_ATTR_PARA_LEFT_TO_RIGHT )
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, eBidiDir == EE_HTEXTDIR_L2R ) );
/*?*/ 					else
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, eBidiDir == EE_HTEXTDIR_R2L ) );
/*N*/ 				}
/*N*/         }
/*M*/         nWhich = aIter.NextWhich();
/*M*/     }
/*M*/ }

}
