/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_drawutil.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:09:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------


#include "drawutil.hxx"
#include "document.hxx"
#include "viewdata.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

// -----------------------------------------------------------------------



/*N*/ void ScDrawUtil::CalcScale( ScDocument* pDoc, USHORT nTab,
/*N*/ 							USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow,
/*N*/ 							OutputDevice* pDev,
/*N*/ 							const Fraction& rZoomX, const Fraction& rZoomY,
/*N*/ 							double nPPTX, double nPPTY,
/*N*/ 							Fraction& rScaleX, Fraction& rScaleY )
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 
/*N*/ 	long nPixelX = 0;
/*N*/ 	long nTwipsX = 0;
/*N*/ 	long nPixelY = 0;
/*N*/ 	long nTwipsY = 0;
/*N*/ 	for (i=nStartCol; i<nEndCol; i++)
/*N*/ 	{
/*N*/ 		USHORT nWidth = pDoc->GetColWidth(i,nTab);
/*N*/ 		nTwipsX += (long) nWidth;
/*N*/ 		nPixelX += ScViewData::ToPixel( nWidth, nPPTX );
/*N*/ 	}
/*N*/ 	for (i=nStartRow; i<nEndRow; i++)
/*N*/ 	{
/*N*/ 		USHORT nHeight = pDoc->GetRowHeight(i,nTab);
/*N*/ 		nTwipsY += (long) nHeight;
/*N*/ 		nPixelY += ScViewData::ToPixel( nHeight, nPPTY );
/*N*/ 	}
/*N*/ 
/*N*/ 	MapMode aHMMMode( MAP_100TH_MM, Point(), rZoomX, rZoomY );
/*N*/ 	Point aPixelLog = pDev->PixelToLogic( Point( nPixelX,nPixelY ), aHMMMode );
/*N*/ 
/*N*/ 	//	Fraction(double) ctor can be used here (and avoid overflows of PixelLog * Zoom)
/*N*/ 	//	because ReduceInaccurate is called later anyway.
/*N*/ 
/*N*/ 	if ( aPixelLog.X() && nTwipsX )
/*N*/ 		rScaleX = Fraction( ((double)aPixelLog.X()) *
/*N*/ 							((double)rZoomX.GetNumerator()) /
/*N*/ 							((double)nTwipsX) /
/*N*/ 							((double)HMM_PER_TWIPS) /
/*N*/ 							((double)rZoomX.GetDenominator()) );
/*N*/ 	else
/*N*/ 		rScaleX = Fraction( 1, 1 );
/*N*/ 
/*N*/ 	if ( aPixelLog.Y() && nTwipsY )
/*N*/ 		rScaleY = Fraction( ((double)aPixelLog.Y()) *
/*N*/ 							((double)rZoomY.GetNumerator()) /
/*N*/ 							((double)nTwipsY) /
/*N*/ 							((double)HMM_PER_TWIPS) /
/*N*/ 							((double)rZoomY.GetDenominator()) );
/*N*/ 	else
/*N*/ 		rScaleY = Fraction( 1, 1 );
/*N*/ 
/*N*/ 	//	17 bits of accuracy are needed to always hit the right part of
/*N*/ 	//	cells in the last rows
/*N*/ 	rScaleX.ReduceInaccurate( 17 );
/*N*/ 	rScaleY.ReduceInaccurate( 17 );
/*N*/ }




}
