/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undoblk.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:58:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#include <bf_svx/boxitem.hxx>

#include "undoblk.hxx"
#include "docsh.hxx"
#include "globstr.hrc"
#include "target.hxx"
#include "refundo.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

TYPEINIT1(ScUndoEnterMatrix,		ScBlockUndo);



// To Do:
/*A*/	// SetOptimalHeight auf Dokument, wenn keine View
/*B*/	// gelinkte Tabellen
/*C*/	// ScArea
//?		// spaeter mal pruefen


// -----------------------------------------------------------------------
//
//		Zellen einfuegen
//		Zeilen einfgen
//		einzeln oder Block
//












// -----------------------------------------------------------------------
//
//		Zellen loeschen
//		Zeilen lschen
//		einzeln oder Block
//











// -----------------------------------------------------------------------
//
//		Zellen loeschen auf Mehrfachselektion
//











// -----------------------------------------------------------------------
//
//		Ausschneiden (Cut)
//











// -----------------------------------------------------------------------
//
//		Einfuegen (Paste)
//

/*N*/ ScUndoPaste::ScUndoPaste( ScDocShell* pNewDocShell,
/*N*/ 				USHORT nStartX, USHORT nStartY, USHORT nStartZ,
/*N*/ 				USHORT nEndX, USHORT nEndY, USHORT nEndZ,
/*N*/ 				const ScMarkData& rMark,
/*N*/ 				ScDocument* pNewUndoDoc, ScDocument* pNewRedoDoc,
/*N*/ 				USHORT nNewFlags,
/*N*/ 				ScRefUndoData* pRefData,
/*N*/ 				void* pFill1, void* pFill2, void* pFill3, 
/*N*/ 				BOOL bRedoIsFilled, const ScUndoPasteOptions* pOptions ) :
/*N*/ 	ScBlockUndo( pNewDocShell, ScRange( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ), SC_UNDO_SIMPLE ),
/*N*/ 	aMarkData( rMark ),
/*N*/ 	pUndoDoc( pNewUndoDoc ),
/*N*/ 	pRedoDoc( pNewRedoDoc ),
/*N*/ 	nFlags( nNewFlags ),
/*N*/ 	pRefUndoData( pRefData ),
/*N*/ 	pRefRedoData( NULL ),
/*N*/ 	bRedoFilled( bRedoIsFilled )
/*N*/ {
/*N*/ 	//	pFill1,pFill2,pFill3 are there so the ctor calls for simple paste (without cutting)
/*N*/ 	//	don't have to be changed and branched for 641.
/*N*/ 	//	They can be removed later.
/*N*/ 
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( !aMarkData.IsMarked() )				// no cell marked:
/*N*/ }

/*N*/ __EXPORT ScUndoPaste::~ScUndoPaste()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pRedoDoc;
/*N*/ 	delete pRefUndoData;
/*N*/ 	delete pRefRedoData;
/*N*/ }









// -----------------------------------------------------------------------
//
//		Verschieben/Kopieren (Drag & Drop)
//













// -----------------------------------------------------------------------
//
//		Liste der Bereichsnamen einfuegen
//		(Einfuegen|Name|Einfuegen =>[Liste])
//










// -----------------------------------------------------------------------
//
//		Szenario anwenden
//		(Extras|Szenarien)
//









// -----------------------------------------------------------------------
//
//		Vorlage anwenden
//		(Format|Vorlagenkatalog)
//

/*N*/ ScUndoSelectionStyle::ScUndoSelectionStyle( ScDocShell* pNewDocShell,
/*N*/ 									  const ScMarkData& rMark,
/*N*/ 									  const ScRange& rRange,
/*N*/ 									  const String& rName,
/*N*/ 											ScDocument* pNewUndoDoc ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aMarkData( rMark ),
/*N*/ 	aRange( rRange ),
/*N*/ 	aStyleName( rName ),
/*N*/ 	pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ 	aMarkData.MarkToMulti();
/*N*/ }

/*N*/ __EXPORT ScUndoSelectionStyle::~ScUndoSelectionStyle()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }

/*N*/ String __EXPORT ScUndoSelectionStyle::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_APPLYCELLSTYLE );
/*N*/ }





/*N*/ BOOL __EXPORT ScUndoSelectionStyle::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }



// -----------------------------------------------------------------------
//
//		Matrix-Formel eingeben
//

/*N*/ ScUndoEnterMatrix::ScUndoEnterMatrix( ScDocShell* pNewDocShell, const ScRange& rArea,
/*N*/ 									  ScDocument* pNewUndoDoc, const String& rForm ) :
/*N*/ 	ScBlockUndo( pNewDocShell, rArea, SC_UNDO_SIMPLE ),
/*N*/ 	pUndoDoc( pNewUndoDoc ),
/*N*/ 	aFormula( rForm )
/*N*/ {
/*N*/ 	SetChangeTrack();
/*N*/ }

/*N*/ __EXPORT ScUndoEnterMatrix::~ScUndoEnterMatrix()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }

/*N*/ String __EXPORT ScUndoEnterMatrix::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_ENTERMATRIX );
/*N*/ }

/*N*/ void ScUndoEnterMatrix::SetChangeTrack()
/*N*/ {
/*N*/ 	ScDocument* pDoc = pDocShell->GetDocument();
/*N*/ 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
/*N*/ 	if ( pChangeTrack )
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 pChangeTrack->AppendContentRange( aBlockRange, pUndoDoc,
/*N*/ 	else
/*N*/ 		nStartChangeAction = nEndChangeAction = 0;
/*N*/ }




/*N*/ BOOL __EXPORT ScUndoEnterMatrix::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

// -----------------------------------------------------------------------
//
//		Einzug vermindern / erhoehen
//









// -----------------------------------------------------------------------
//
//		Transliteration for cells
//








// -----------------------------------------------------------------------
//
//		einzelne Items per Which-IDs aus Bereich loeschen
//








// -----------------------------------------------------------------------
//
//		Alle Umbrueche einer Tabelle loeschen
//

/*N*/ ScUndoRemoveBreaks::ScUndoRemoveBreaks( ScDocShell* pNewDocShell,
/*N*/ 									USHORT nNewTab, ScDocument* pNewUndoDoc ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoRemoveBreaks::~ScUndoRemoveBreaks()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }






// -----------------------------------------------------------------------
//
//		Zusammenfassung aufheben (fuer einen ganzen Bereich)
//








// -----------------------------------------------------------------------
//
//		nur Umrandung setzen, per ScRangeList (StarOne)
//

/*N*/ ScRange lcl_TotalRange( const ScRangeList& rRanges )
/*N*/ {
/*N*/ 	ScRange aTotal;
/*N*/ 	ULONG nCount = rRanges.Count();
/*N*/ 	for (ULONG i=0; i<nCount; i++)
/*N*/ 	{
/*N*/ 		ScRange aRange = *rRanges.GetObject(i);
/*N*/ 		if (i==0)
/*N*/ 			aTotal = aRange;
/*N*/ 		else
/*N*/ 		{
/*N*/ 			if (aRange.aStart.Col() < aTotal.aStart.Col())
/*N*/ 				aTotal.aStart.SetCol(aRange.aStart.Col());
/*N*/ 			if (aRange.aStart.Row() < aTotal.aStart.Row())
/*N*/ 				aTotal.aStart.SetRow(aRange.aStart.Row());
/*N*/ 			if (aRange.aStart.Tab() < aTotal.aStart.Tab())
/*N*/ 				aTotal.aStart.SetTab(aRange.aStart.Tab());
/*N*/ 			if (aRange.aEnd.Col() > aTotal.aEnd.Col())
/*N*/ 				aTotal.aEnd.SetCol(aRange.aEnd.Col());
/*N*/ 			if (aRange.aEnd.Row() > aTotal.aEnd.Row())
/*N*/ 				aTotal.aEnd.SetRow(aRange.aEnd.Row());
/*N*/ 			if (aRange.aEnd.Tab() > aTotal.aEnd.Tab())
/*N*/ 				aTotal.aEnd.SetTab(aRange.aEnd.Tab());
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return aTotal;
/*N*/ }

/*N*/ ScUndoBorder::ScUndoBorder( ScDocShell* pNewDocShell,
/*N*/ 							const ScRangeList& rRangeList, ScDocument* pNewUndoDoc,
/*N*/ 							const SvxBoxItem& rNewOuter, const SvxBoxInfoItem& rNewInner ) :
/*N*/ 	ScBlockUndo( pNewDocShell, lcl_TotalRange(rRangeList), SC_UNDO_SIMPLE ),
/*N*/ 	pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ 	pRanges = new ScRangeList(rRangeList);
/*N*/ 	pOuter = new SvxBoxItem(rNewOuter);
/*N*/ 	pInner = new SvxBoxInfoItem(rNewInner);
/*N*/ }

/*N*/ __EXPORT ScUndoBorder::~ScUndoBorder()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pRanges;
/*N*/ 	delete pOuter;
/*N*/ 	delete pInner;
/*N*/ }









}
