/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewshe2.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/07/25 12:23:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SFX_TOPFRM_HXX //autogen wg. SfxTopViewFrame
#include <sfx2/topfrm.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS


#pragma hdrstop

#define ITEMID_LRSPACE          EE_PARA_LRSPACE
#define ITEMID_ULSPACE          EE_PARA_ULSPACE

#ifndef _SFX_HRC
#include <sfx2/sfx.hrc>
#endif
#include <svtools/style.hrc>

#include <svx/dialogs.hrc>

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif



#include "app.hrc"
#include "strings.hrc"
#include "schresid.hxx"
#include "glob.hrc"
#include "viewshel.hxx"
#include "schview.hxx"
#include "fudatrow.hxx"
#include "fudgrlin.hxx"
#include "uninstit.hxx"
#include "uninsleg.hxx"
#include "uninsaxi.hxx"
#include "unswitch.hxx"
#include "objid.hxx"
#include "dgrdata.hxx"
#include "fu3d.hxx"
#include "fuchrmap.hxx"

#include "chaxis.hxx"
#include "memchrt.hxx"


/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

void SchViewShell::FuTemporary(SfxRequest &rReq)
{
	USHORT nSlotId = rReq.GetSlot();

	if( nSlotId == SID_CONTEXT ||		// #67998# double clicked on status bar: do not deactivate current function
		nSlotId == SID_CONTEXT_TYPE )
	{
		return;
	}
	
	ChartModel* pChDoc = &pChView->GetDoc();

	if (pFuActual)
	{
		if( nSlotId != SID_DIAGRAM_DATA &&
			nSlotId != SID_CHARMAP )
		{
			pFuActual->Deactivate();
			if (pFuActual != pFuOld) delete pFuActual;
			pFuActual = NULL;
		}
	}

	switch( nSlotId )
	{
		case SID_RELOAD:
		{
			SfxViewFrame* pFrame = GetViewFrame();

			// nur wenn wir nicht IP sind
			if (pFrame->IsA(TYPE(SfxTopViewFrame)))
			{
				GetViewFrame()->GetDispatcher()->Execute( SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

				// normale Weiterleitung an ViewFrame zur Ausfuehrung
				const SfxPoolItem *pBaseRet = pFrame->ExecuteSlot(rReq);
				const SfxBoolItem *pRet = PTR_CAST(SfxBoolItem, pBaseRet);

				if (pRet && ((const SfxBoolItem *)pRet)->GetValue())
				{
					// Undo-Manager leeren

					pFrame->GetObjectShell()->GetUndoManager()->Clear();

					// sofort zurueckkehren, da diese ViewShell nicht mehr
					// gueltig ist
					return;
				}
			}
			break;
		}

		case SID_DIAGRAM_DATA:
			if (rReq.GetArgs())
			{
				GetViewFrame()->SetChildWindow
					(SchDiagramDataWrapper::GetChildWindowId(),
					 ((const SfxBoolItem&)(rReq.GetArgs()->
						Get(SID_DIAGRAM_DATA))).GetValue());
			}
			else
			{
				GetViewFrame()->ToggleChildWindow
					(SchDiagramDataWrapper::GetChildWindowId());
			}

			Invalidate();
			rReq.Done();
			break;

		case SID_DIAGRAM_OBJECTS:
		case SID_ATTR_CHAR_FONT:
		case SID_ATTR_CHAR_FONTHEIGHT:
		case SID_ATTR_CHAR_COLOR:
		case SID_ATTR_CHAR_WEIGHT:
		case SID_ATTR_CHAR_POSTURE:
		case SID_ATTR_CHAR_UNDERLINE:
		case SID_ATTR_CHAR_CONTOUR:
		case SID_ATTR_CHAR_STRIKEOUT:
		case SID_ATTR_CHAR_SHADOWED:
		{
			if (pChView->AreObjectsMarked())
			{
				const SdrMarkList& rMarkList = pChView->GetMarkedObjectList();

				if (rMarkList.GetMarkCount() >= 1)
				{
					SdrMark* pMark = rMarkList.GetMark(0);
					SdrObject* pObj = pMark->GetMarkedSdrObj();

					SchObjectId* pObjId = GetObjectId(*pObj);

					if (pObjId)
					{
						USHORT nId = 0;
						switch( pObjId->GetObjId() )
						{
							case CHOBJID_DIAGRAM_TITLE_X_AXIS :
								nId = SID_DIAGRAM_TITLE_X;
								break;

							case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
								nId = SID_DIAGRAM_TITLE_Y;
								break;

							case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
								nId = SID_DIAGRAM_TITLE_Z;
								break;

							case CHOBJID_TITLE_MAIN :
								nId = SID_DIAGRAM_TITLE_MAIN;
								break;

							case CHOBJID_TITLE_SUB :
								nId = SID_DIAGRAM_TITLE_SUB;
								break;

							case CHOBJID_DIAGRAM_FLOOR :
								nId = SID_DIAGRAM_FLOOR;
								break;

							case CHOBJID_DIAGRAM_WALL :
							case CHOBJID_DIAGRAM :
								if (pChDoc->IsAxisChart () && !pChDoc->IsNetChart ()) nId = SID_DIAGRAM_WALL;
								break;

							case CHOBJID_LEGEND :
								nId = SID_LEGEND;
								break;

							case CHOBJID_DIAGRAM_X_GRID_MAIN :
							case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP :
								nId = SID_DIAGRAM_GRID_X_MAIN;
								break;

							case CHOBJID_DIAGRAM_X_GRID_HELP :
							case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP :
								nId = SID_DIAGRAM_GRID_X_HELP;
								break;

							case CHOBJID_DIAGRAM_Y_GRID_MAIN :
							case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP :
								nId = SID_DIAGRAM_GRID_Y_MAIN;
								break;

							case CHOBJID_DIAGRAM_Y_GRID_HELP :
							case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP :
								nId = SID_DIAGRAM_GRID_Y_HELP;
								break;

							case CHOBJID_DIAGRAM_Z_GRID_MAIN :
							case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP :
								nId = SID_DIAGRAM_GRID_Z_MAIN;
								break;

							case CHOBJID_DIAGRAM_Z_GRID_HELP :
							case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP :
								nId = SID_DIAGRAM_GRID_Z_HELP;
								break;

							case CHOBJID_DIAGRAM_X_AXIS :
								nId = SID_DIAGRAM_AXIS_X;
								break;

							case CHOBJID_DIAGRAM_Y_AXIS :
								nId = SID_DIAGRAM_AXIS_Y;
								break;

							case CHOBJID_DIAGRAM_Z_AXIS :
								nId = SID_DIAGRAM_AXIS_Z;
								break;

							case CHOBJID_DIAGRAM_A_AXIS :
								nId = SID_DIAGRAM_AXIS_A;
								break;

							case CHOBJID_DIAGRAM_B_AXIS :
								nId = SID_DIAGRAM_AXIS_B;
								break;

							case CHOBJID_DIAGRAM_C_AXIS :
								nId = SID_DIAGRAM_AXIS_C;
								break;

							case CHOBJID_DIAGRAM_AREA:
							case CHOBJID_AREA :
								nId = SID_DIAGRAM_AREA;
								break;

							case CHOBJID_DIAGRAM_STACKEDGROUP:
								 DBG_TRACE("Chart (TVM) neue SID");
							case CHOBJID_DIAGRAM_DATA :
							case CHOBJID_DIAGRAM_SPECIAL_GROUP :
							case CHOBJID_DIAGRAM_ROWGROUP :
							case CHOBJID_DIAGRAM_ROWSLINE :
							case CHOBJID_LEGEND_SYMBOL_ROW :
							case CHOBJID_LEGEND_SYMBOL_COL :
								nId = SID_DATA_ROW_POINT;
								break;

							case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
								nId = SID_DIAGRAM_STOCK_LOSS;
								break;
							case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
								nId = SID_DIAGRAM_STOCK_PLUS;
								break;
							//case CHOBJID_DIAGRAM_STOCKLINE:
							case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
								nId = SID_DIAGRAM_STOCK_LINE;
								break;

							case CHOBJID_DIAGRAM_STATISTICS_GROUP :
								nId = SID_DIAGRAM_ERROR;
								break;

							case CHOBJID_DIAGRAM_AVERAGEVALUE :
								nId = SID_DIAGRAM_AVERAGEVALUE;
								break;

							case CHOBJID_DIAGRAM_REGRESSION :
								nId = SID_DIAGRAM_REGRESSION;
								break;


							default :
								DBG_TRACE1( "Unhandled CHOBJID in object properties: %ld", pObjId->GetObjId() );
								nId = 0;
								break;

						}
						if( nId > 0 )
						{
							SfxRequest aReq( nId, SFX_CALLMODE_SLOT, GetPool() );
							if (rReq.GetArgs()) aReq.SetArgs( *rReq.GetArgs() );
							ExecuteSlot( aReq );
						}
						else
						{
							Invalidate ();
							Cancel ();
						}
					}
					else
					{
						Invalidate ();
						Cancel ();
					}
				}
				else
				{
					Invalidate ();
					Cancel ();
				}
			}
			else
			{
				Invalidate ();
				Cancel ();
			}

			break;
		}

		case SID_DIAGRAM_STOCK_LINE:
		case SID_DIAGRAM_ERROR :
		case SID_DIAGRAM_AVERAGEVALUE :
		case SID_DIAGRAM_REGRESSION :
			pFuActual = new SchFuLine(this, GetWindow(), pChView, pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_DATA_ROW_POINT:
			pFuActual = new SchFuDataRowPoint(this, GetWindow(), pChView,
											  pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_3D_VIEW:
			pFuActual = new SchFu3D (this, GetWindow(), pChView, pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

// 		case SID_HAS_MAIN_TITLE:
// 		case SID_HAS_SUB_TITLE:
		case SID_TOGGLE_TITLE:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			BOOL bOldShowMain   = pChDoc->ShowMainTitle();
			String aOldMain     = pChDoc->MainTitle();
			BOOL bOldShowSub    = pChDoc->ShowSubTitle();
			String aOldSub      = pChDoc->SubTitle();
			BOOL bOldShowXAxis  = pChDoc->ShowXAxisTitle();
			String aOldXAxis    = pChDoc->XAxisTitle();
			BOOL bOldShowYAxis  = pChDoc->ShowYAxisTitle();
			String aOldYAxis    = pChDoc->YAxisTitle();
			BOOL bOldShowZAxis  = pChDoc->ShowZAxisTitle();
			String aOldZAxis    = pChDoc->ZAxisTitle();

            BOOL bNewShow = ! ( bOldShowMain || bOldShowSub );

			pChDoc->ChangeTitle(bNewShow, aOldMain, bNewShow,
								aOldSub, bOldShowXAxis, aOldXAxis,
								bOldShowYAxis, aOldYAxis, bOldShowZAxis,
								aOldZAxis);
			SchUndoInsertTitle* pUndo =
				new SchUndoInsertTitle(*pChDoc, bOldShowMain, aOldMain,
									   bOldShowSub, aOldSub, bOldShowXAxis,
									   aOldXAxis, bOldShowYAxis, aOldYAxis,
									   bOldShowZAxis, aOldZAxis, bNewShow,
									   aOldMain, bNewShow, aOldSub,
									   bOldShowXAxis, aOldXAxis,
									   bOldShowYAxis, aOldYAxis,
									   bOldShowZAxis, aOldZAxis);
			pUndo->SetComment(String(SchResId(STR_UNDO_TOGGLE_TITLE)));

			GetViewFrame()->GetObjectShell()->
				GetUndoManager()->AddUndoAction(pUndo);

			rReq.Done();
			Invalidate();
			break;
		}

		case SID_TOGGLE_LEGEND:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			SfxItemSet aAttr = pChDoc->GetLegendAttr();
			const SfxPoolItem *pPoolItem = NULL;
			SvxChartLegendPos ePos = (aAttr.GetItemState(SCHATTR_LEGEND_POS, TRUE, &pPoolItem) == SFX_ITEM_SET)
										 ? ((const SvxChartLegendPosItem*)pPoolItem)->GetValue()
										 : CHLEGEND_RIGHT;
			BOOL bOldVisibility = pChDoc->GetShowLegend ();
			BOOL bNewVisibility = ! bOldVisibility;

			pChDoc->SetShowLegend (bNewVisibility);

			SchUndoInsertLegend* pUndo = new SchUndoInsertLegend(*pChDoc, ePos, ePos, bOldVisibility, bNewVisibility);
			pUndo->SetComment(String(SchResId(STR_UNDO_TOGGLE_LEGEND)));

			GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);

			rReq.Done();
			Invalidate();
			pChDoc->BuildChart (FALSE);
			break;
		}

		case SID_HAS_X_DESCR:
		case SID_HAS_Y_DESCR:
		case SID_HAS_Z_DESCR:
		{
            DBG_ERROR( "Deprecated?" );
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			BOOL bOldXAxis      = pChDoc->ShowXAxis();
			BOOL bOldXGridMain  = pChDoc->ShowXGridMain();
			BOOL bOldXGridHelp  = pChDoc->ShowXGridHelp();
			BOOL bOldXDescr     = pChDoc->ShowXDescr();
			BOOL bOldYAxis      = pChDoc->ShowYAxis();
			BOOL bOldYGridMain  = pChDoc->ShowYGridMain();
			BOOL bOldYGridHelp  = pChDoc->ShowYGridHelp();
			BOOL bOldYDescr     = pChDoc->ShowYDescr();
			BOOL bOldZAxis      = pChDoc->ShowZAxis();
			BOOL bOldZGridMain  = pChDoc->ShowZGridMain();
			BOOL bOldZGridHelp  = pChDoc->ShowZGridHelp();
			BOOL bOldZDescr     = pChDoc->ShowZDescr();

			BOOL bOld2YAxis  = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->IsVisible();
			BOOL bOld2YDescr = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->HasDescription();
			BOOL bOld2XAxis  = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->IsVisible();
			BOOL bOld2XDescr = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->HasDescription();

			SFX_REQUEST_ARG( rReq, pXItem, SfxBoolItem, SID_HAS_X_DESCR, FALSE );
			SFX_REQUEST_ARG( rReq, pYItem, SfxBoolItem, SID_HAS_Y_DESCR, FALSE );
			SFX_REQUEST_ARG( rReq, pZItem, SfxBoolItem, SID_HAS_Z_DESCR, FALSE );
			BOOL bNewXDescr     = pXItem ? pXItem->GetValue() : bOldXDescr;
			BOOL bNewYDescr     = pYItem ? pYItem->GetValue() : bOldYDescr;
			BOOL bNewZDescr     = pZItem ? pZItem->GetValue() : bOldZDescr;

			pChDoc->ChangeAxis( bOldXAxis, bNewXDescr,
								bOldYAxis, bNewYDescr,
								bOldZAxis, bNewZDescr,
								bOld2YAxis,bOld2YDescr,
								bOld2XAxis,bOld2XDescr, TRUE );

			SchUndoInsertAxis* pUndo =
				new SchUndoInsertAxis( *pChDoc,
									   bOldXAxis, bOldXDescr,
									   bOldYAxis, bOldYDescr,
									   bOldZAxis, bOldZDescr,
									   bOld2YAxis,bOld2YDescr,
									   bOld2XAxis,bOld2XDescr,

									   bOldXAxis, bNewXDescr,
									   bOldYAxis, bNewYDescr,
									   bOldZAxis, bNewZDescr,
									   bOld2YAxis,bOld2YDescr,
									   bOld2XAxis,bOld2XDescr );

			pUndo->SetComment(String(SchResId(STR_UNDO_TOGGLE_AXIS_DESCR)));

			GetViewFrame()->GetObjectShell()->
				GetUndoManager()->AddUndoAction(pUndo);

			if( pXItem )
				rReq.AppendItem( SfxBoolItem( SID_HAS_X_DESCR, bNewXDescr ) );
			if( pYItem )
				rReq.AppendItem( SfxBoolItem( SID_HAS_Y_DESCR, bNewYDescr ) );
			if( pZItem )
				rReq.AppendItem( SfxBoolItem( SID_HAS_Z_DESCR, bNewZDescr ) );
			rReq.Done();
			Invalidate();
			break;
		}

// 		case SID_HAS_X_TITLE:
// 		case SID_HAS_Y_TITLE:
// 		case SID_HAS_Z_TITLE:
		case SID_TOGGLE_AXIS_TITLE:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			BOOL bOldShowMain   = pChDoc->ShowMainTitle();
			String aOldMain     = pChDoc->MainTitle();
			BOOL bOldShowSub    = pChDoc->ShowSubTitle();
			String aOldSub      = pChDoc->SubTitle();
			BOOL bOldShowXAxis  = pChDoc->ShowXAxisTitle();
			String aOldXAxis    = pChDoc->XAxisTitle();
			BOOL bOldShowYAxis  = pChDoc->ShowYAxisTitle();
			String aOldYAxis    = pChDoc->YAxisTitle();
			BOOL bOldShowZAxis  = pChDoc->ShowZAxisTitle();
			String aOldZAxis    = pChDoc->ZAxisTitle();

            BOOL bNewShow = ! ( bOldShowXAxis || bOldShowYAxis ||
                                (pChDoc->Is3DChart() && bOldShowZAxis) );

			pChDoc->ChangeTitle(bOldShowMain, aOldMain, bOldShowSub,
								aOldSub, bNewShow, aOldXAxis,
								bNewShow, aOldYAxis, bNewShow, aOldZAxis);
			SchUndoInsertTitle* pUndo =
				new SchUndoInsertTitle(*pChDoc, bOldShowMain, aOldMain,
									   bOldShowSub, aOldSub, bOldShowXAxis,
									   aOldXAxis, bOldShowYAxis, aOldYAxis,
									   bOldShowZAxis, aOldZAxis, bOldShowMain,
									   aOldMain, bOldShowSub, aOldSub,
									   bNewShow, aOldXAxis, bNewShow,
									   aOldYAxis, bNewShow, aOldZAxis);
			pUndo->SetComment(String(SchResId(STR_UNDO_TOGGLE_AXIS_TITLE)));

			GetViewFrame()->GetObjectShell()->
				GetUndoManager()->AddUndoAction(pUndo);

			rReq.Done();
			Invalidate();
			break;
		}

		case SID_TOGGLE_AXIS_DESCR:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			BOOL bOldXAxis      = pChDoc->ShowXAxis();
			BOOL bOldXDescr     = pChDoc->ShowXDescr();
			BOOL bOldYAxis      = pChDoc->ShowYAxis();
			BOOL bOldYDescr     = pChDoc->ShowYDescr();
			BOOL bOldZAxis      = pChDoc->ShowZAxis();
			BOOL bOldZDescr     = pChDoc->ShowZDescr();

			BOOL bOld2YAxis  = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->IsVisible();
			BOOL bOld2YDescr = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->HasDescription();
			BOOL bOld2XAxis  = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->IsVisible();
			BOOL bOld2XDescr = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->HasDescription();

			BOOL bNewDescr      = ! ( bOldXDescr || bOldYDescr || bOldZDescr );

			pChDoc->ChangeAxis( bOldXAxis, bNewDescr,
								bOldYAxis, bNewDescr,
								bOldZAxis, bNewDescr,
								bOld2YAxis,bOld2YDescr,
								bOld2XAxis,bOld2XDescr );

			SchUndoInsertAxis* pUndo =
				new SchUndoInsertAxis( *pChDoc,
									   bOldXAxis, bOldXDescr,
									   bOldYAxis, bOldYDescr,
									   bOldZAxis, bOldZDescr,
									   bOld2YAxis,bOld2YDescr,
									   bOld2XAxis,bOld2XDescr,

									   bOldXAxis, bNewDescr,
									   bOldYAxis, bNewDescr,
									   bOldZAxis, bNewDescr,
									   bOld2YAxis,bOld2YDescr,
									   bOld2XAxis,bOld2XDescr );

			pUndo->SetComment(String(SchResId(STR_UNDO_TOGGLE_AXIS_DESCR)));

			GetViewFrame()->GetObjectShell()->
				GetUndoManager()->AddUndoAction(pUndo);

			rReq.Done();
			Invalidate();
			break;
		}

		case SID_TOGGLE_GRID_HORZ:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			BOOL bOldXGridMain  = pChDoc->ShowXGridMain();
			BOOL bOldXGridHelp  = pChDoc->ShowXGridHelp();
			BOOL bOldYGridMain  = pChDoc->ShowYGridMain();
			BOOL bOldYGridHelp  = pChDoc->ShowYGridHelp();
			BOOL bOldZGridMain  = pChDoc->ShowZGridMain();
			BOOL bOldZGridHelp  = pChDoc->ShowZGridHelp();

			BOOL bNewXGridMain  = ! bOldXGridMain;

			pChDoc->ChangeGrid( bNewXGridMain, bOldXGridHelp,
								bOldYGridMain, bOldYGridHelp,
								bOldZGridMain, bOldZGridHelp );

			SchUndoInsertGrid* pUndo =
				new SchUndoInsertGrid( *pChDoc,
									   bOldXGridMain, bOldXGridHelp,
									   bOldYGridMain, bOldYGridHelp,
									   bOldZGridMain, bOldZGridHelp,
									   bNewXGridMain, bOldXGridHelp,
									   bOldYGridMain, bOldYGridHelp,
									   bOldZGridMain, bOldZGridHelp );

			pUndo->SetComment(String(SchResId(STR_UNDO_TOGGLE_GRID_HORZ)));

			GetViewFrame()->GetObjectShell()->
				GetUndoManager()->AddUndoAction(pUndo);

			rReq.Done();
			Invalidate();
			break;
		}

		case SID_TOGGLE_GRID_VERT:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			BOOL bOldXGridMain  = pChDoc->ShowXGridMain();
			BOOL bOldXGridHelp  = pChDoc->ShowXGridHelp();
			BOOL bOldYGridMain  = pChDoc->ShowYGridMain();
			BOOL bOldYGridHelp  = pChDoc->ShowYGridHelp();
			BOOL bOldZGridMain  = pChDoc->ShowZGridMain();
			BOOL bOldZGridHelp  = pChDoc->ShowZGridHelp();

			BOOL bNewYGridMain  = ! bOldYGridMain;

			pChDoc->ChangeGrid( bOldXGridMain, bOldXGridHelp,
								bNewYGridMain, bOldYGridHelp,
								bOldZGridMain, bOldZGridHelp );

			SchUndoInsertGrid* pUndo =
				new SchUndoInsertGrid( *pChDoc,
									   bOldXGridMain, bOldXGridHelp,
									   bOldYGridMain, bOldYGridHelp,
									   bOldZGridMain, bOldZGridHelp,

									   bOldXGridMain, bOldXGridHelp,
									   bNewYGridMain, bOldYGridHelp,
									   bOldZGridMain, bOldZGridHelp );

			pUndo->SetComment(String(SchResId(STR_UNDO_TOGGLE_GRID_VERT)));

			GetViewFrame()->GetObjectShell()->
				GetUndoManager()->AddUndoAction(pUndo);

			rReq.Done();
			Invalidate();
			break;
		}

		case SID_DATA_IN_ROWS:
		{
			if(pChDoc->GetChartData()->GetTranslation()!=TRANS_NONE)
			{
				InfoBox aInfoBox(NULL, String(SchResId(STR_TRANSLATED)));
				aInfoBox.Execute();
				bUserKnowsTranslation=TRUE;
				rReq.Done();
				Cancel();
			}
			else
			{
				GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

				BOOL bOldSwitch = pChDoc->IsSwitchData();
				if (pChDoc->ChangeSwitchData(FALSE))
				{
					SchUndoSwitchData* pUndo =
						new SchUndoSwitchData(*pChDoc, bOldSwitch, FALSE);
					pUndo->SetComment(String(SchResId(STR_UNDO_DATA_IN_ROWS)));

					GetViewFrame()->GetObjectShell()->
						GetUndoManager()->AddUndoAction(pUndo);
				}
				rReq.Done();
				Invalidate();
			}
			break;
		}

		case SID_DATA_IN_COLUMNS:
		{
			if(pChDoc->GetChartData()->GetTranslation()!=TRANS_NONE)
			{
				InfoBox aInfoBox(NULL, String(SchResId(STR_TRANSLATED)));
				aInfoBox.Execute();
				bUserKnowsTranslation=TRUE;
				rReq.Done();
				Cancel();
			}
			else
			{
				GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

				BOOL bOldSwitch = pChDoc->IsSwitchData();
				if (pChDoc->ChangeSwitchData(TRUE))
				{
					SchUndoSwitchData* pUndo =
						new SchUndoSwitchData(*pChDoc, bOldSwitch, TRUE);
					pUndo->SetComment(String(SchResId(STR_UNDO_DATA_IN_COLUMNS)));

					GetViewFrame()->GetObjectShell()->
						GetUndoManager()->AddUndoAction(pUndo);
				}
				rReq.Done();
				Invalidate();
			}
			break;
		}

		case SID_SET_DEFAULT:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			pChView->SetDefault();
			pChDoc->BuildChart(FALSE);
			rReq.Done();
			Invalidate();
		}
		break;

		case SID_CHARMAP:
			pFuActual = new SchFuCharMap( this, GetWindow(), pChView, pChDoc, rReq );
			Invalidate();
			Cancel();
			break;

		default:
			FuTemp2(rReq);
			break;
	}
}


