/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuinssts.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:24:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif

#pragma hdrstop

#include <sot/factory.hxx>

#include "schattr.hxx"
#define ITEMID_DOUBLE           0
#define ITEMID_CHARTKINDERROR   SCHATTR_STAT_KIND_ERROR
#define ITEMID_CHARTINDICATE    SCHATTR_STAT_INDICATE
#include <svx/chrtitem.hxx>

#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "datstat.hxx"
#include "undstat.hxx"
#include "fuinssts.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

TYPEINIT1(SchFuInsertStatistics, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuInsertStatistics::SchFuInsertStatistics(SchViewShell* pViewSh,
										   SchWindow* pWin, SchView* pView,
										   ChartModel* pDoc,
										   SfxRequest& rReq) :
	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	nMarkedID           = 0;

	const SfxItemSet* pArgs = rReq.GetArgs();

	SfxItemSet aInAttr(pViewSh->GetPool(),
					   SCHATTR_DUMMY0, SCHATTR_DUMMY0,
					   SCHATTR_STAT_START, SCHATTR_STAT_END, 0);
	SfxItemSet aOutAttr(pViewSh->GetPool(),
						SCHATTR_DUMMY0, SCHATTR_DUMMY0,
						SCHATTR_STAT_START, SCHATTR_STAT_END, 0);

	if (!pArgs)
	{
		BOOL              bOldAverageValue;
		SvxChartKindError eOldErrorKind;
		SvxChartIndicate  eOldIndicate;
		double            fOldPercent;
		double            fOldBigError;
		double            fConstPlus;
		double            fConstMinus;
		SvxChartRegress   eOldRegress;

		pDoc->GetStatistics (bOldAverageValue, eOldErrorKind, eOldIndicate,
							 fOldPercent, fOldBigError, fConstPlus, fConstMinus, eOldRegress);

		aInAttr.Put (SfxInt32Item (SCHATTR_DUMMY0, (INT32) pDoc->ChartStyle ()));
		aInAttr.Put (SfxBoolItem (SCHATTR_STAT_AVERAGE, bOldAverageValue));
		aInAttr.Put (SfxInt32Item (SCHATTR_STAT_KIND_ERROR, (INT32) eOldErrorKind));
		aInAttr.Put (SfxInt32Item (SCHATTR_STAT_INDICATE, (INT32) eOldIndicate));
		aInAttr.Put (SvxDoubleItem (fOldPercent, SCHATTR_STAT_PERCENT));
		aInAttr.Put (SvxDoubleItem (fOldBigError, SCHATTR_STAT_BIGERROR));
		aInAttr.Put (SvxDoubleItem (fConstPlus, SCHATTR_STAT_CONSTPLUS));
		aInAttr.Put (SvxDoubleItem (fConstMinus, SCHATTR_STAT_CONSTMINUS));
		aInAttr.Put (SfxInt32Item (SCHATTR_STAT_REGRESSTYPE, (INT32) eOldRegress));

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//		SchDataStatisticsDlg *pDlg = new SchDataStatisticsDlg(&pViewSh->GetViewFrame()->GetWindow(),
//				  			   	                              aInAttr);
		SchDataStatisticsDlg *pDlg = new SchDataStatisticsDlg(NULL, aInAttr);

		if (pDlg->Execute() == RET_OK)
		{
			pDlg->GetAttr(aOutAttr);
			rReq.Done(aOutAttr);

			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}
	}

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	if (pDoc->ChangeStatistics (aOutAttr))
	{
		SchUndoStatistics *pUndo = new SchUndoStatistics (*pDoc, aInAttr, aOutAttr);

		pUndo->SetComment(String(SchResId(STR_UNDO_STATISTICS)));
		pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	}

	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertStatistics::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertStatistics::Deactivate()
{
}



