#ifndef _PAGEPREVIEWLAYOUT_HXX
#define _PAGEPREVIEWLAYOUT_HXX

// template class <std::vector>
#include <vector>
// datatypes sal_xyz
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
// classes <Point>, <Size> and <Rectangle>
// auto strip #ifndef _GEN_HXX
// auto strip #include <tools/gen.hxx>
// auto strip #endif
// datatype <SwTwips>
// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>
// auto strip #endif
class OutputDevice; 
class Fraction; 
namespace binfilter {//STRIP009
class ViewShell;

class SwRootFrm;
class SwPageFrm;

struct PrevwPage;
// =============================================================================
/** page preview functionality in the writer

    OD 11.12.2002 #103492# - class <SwPagePreviewLayout>

    @author OD
*/
//STRIP001 class SwPagePreviewLayout
//STRIP001 {
//STRIP001 private:
//STRIP001     friend class ViewShell;
//STRIP001 
//STRIP001     /// number of horizontal and vertical twips for spacing between the pages.
//STRIP001     const SwTwips mnXFree;
//STRIP001     const SwTwips mnYFree;
//STRIP001 
//STRIP001     /// view shell the print preview is generated for.
//STRIP001     ViewShell& mrParentViewShell;
//STRIP001     /// top layout frame of the layout for accessing the pages
//STRIP001     const SwRootFrm& mrLayoutRootFrm;
//STRIP001 
//STRIP001     /// boolean indicating, if the layout information (number of columns and rows)
//STRIP001     /// are valid.
//STRIP001     bool        mbLayoutInfoValid;
//STRIP001     /// boolean indicating, if the the calculated print preview layout sizes
//STRIP001     /// ( windows size in twips, maximal page size, column width, row height,
//STRIP001     ///   width and height of a print preview page, size of the print preview
//STRIP001     ///   document ) are valid
//STRIP001     bool        mbLayoutSizesValid;
//STRIP001     /// boolean indicating, if the the paint information ( physical number of
//STRIP001     ///   start page, start column and row, paint offsets, rectangle visible of
//STRIP001     ///   the print preview document.
//STRIP001     bool        mbPaintInfoValid;
//STRIP001 
//STRIP001     Size        maWinSize;
//STRIP001     sal_uInt16  mnCols;
//STRIP001     sal_uInt16  mnRows;
//STRIP001     sal_uInt16  mnPages;
//STRIP001     // OD 19.02.2003 #107369# - new flag for leaving blank left-top-corner
//STRIP001     bool        mbLeaveLeftTopBlank;
//STRIP001 
//STRIP001     Size        maMaxPageSize;
//STRIP001     Rectangle   maPreviewDocRect;
//STRIP001     SwTwips     mnColWidth;
//STRIP001     SwTwips     mnRowHeight;
//STRIP001     SwTwips     mnPrevwLayoutWidth;
//STRIP001     SwTwips     mnPrevwLayoutHeight;
//STRIP001     bool        mbDoesLayoutColsFitIntoWindow;
//STRIP001     bool        mbDoesLayoutRowsFitIntoWindow;
//STRIP001 
//STRIP001     sal_uInt16  mnPaintPhyStartPageNum;
//STRIP001     sal_uInt16  mnPaintStartCol;
//STRIP001     sal_uInt16  mnPaintStartRow;
//STRIP001     bool        mbNoPageVisible;
//STRIP001     Point       maPaintStartPageOffset;
//STRIP001     Point       maPaintPreviewDocOffset;
//STRIP001     Point       maAdditionalPaintOffset;
//STRIP001     Rectangle   maPaintedPrevwDocRect;
//STRIP001     sal_uInt16  mnSelectedPageNum;
//STRIP001 
//STRIP001     std::vector<PrevwPage*> maPrevwPages;
//STRIP001 
//STRIP001     /** clear internal data about current page preview
//STRIP001 
//STRIP001         OD 11.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void _Clear();
//STRIP001 
//STRIP001     /** helper method to clear preview page layout sizes
//STRIP001 
//STRIP001         OD 18.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void _ClearPrevwLayoutSizes();
//STRIP001 
//STRIP001     /** helper method to clear data in preview page vectors
//STRIP001 
//STRIP001         OD 13.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void _ClearPrevwPageData();
//STRIP001 
//STRIP001     /** calculate page preview layout sizes
//STRIP001 
//STRIP001         OD 18.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void _CalcPrevwLayoutSizes();
//STRIP001 
//STRIP001     /** apply new zoom at given view shell
//STRIP001 
//STRIP001         OD 11.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _aNewZoom
//STRIP001         input parameter - new zoom percentage
//STRIP001     */
//STRIP001     void _ApplyNewZoomAtViewShell( sal_uInt8 _aNewZoom );
//STRIP001 
//STRIP001     /** calculate additional paint offset
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001         helper method called by <Prepare> in order to calculate an additional
//STRIP001         paint offset to center output in given window size.
//STRIP001         The booleans <mbDoesLayoutRowsFitIntoWindow> and <mbDoesLayoutColsFitIntoWindow>
//STRIP001         are also determined.
//STRIP001         preconditions:
//STRIP001         (1) preview layout is given (number of rows and columns).
//STRIP001         (2) window size is given.
//STRIP001         (3) height of row and width of column are calculated.
//STRIP001         (4) paint offset of start page is calculated.
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void _CalcAdditionalPaintOffset();
//STRIP001 
//STRIP001     /** calculate painted preview document rectangle
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001         helper method called by <Prepare> in order to calculate the rectangle,
//STRIP001         which will be painted for the document arranged by the given preview
//STRIP001         layout.
//STRIP001         preconditions:
//STRIP001         (1) paint offset of document preview is calculated.
//STRIP001         (2) size of document preview is calculated.
//STRIP001         (3) additional paint offset is calculated - see <_CalcAdditionalPaintOffset>.
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void _CalcDocPrevwPaintRect();
//STRIP001 
//STRIP001     /** determines preview data for a given page and a given preview offset
//STRIP001 
//STRIP001         OD 13.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _rPage
//STRIP001         input parameter - constant reference to page frame, for which the
//STRIP001         preview data will be calculated.
//STRIP001 
//STRIP001         @param _rPrevwOffset
//STRIP001         input parameter - constant reference to the offset the given page has
//STRIP001         in the current preview window.
//STRIP001         Note: Offset can be negative.
//STRIP001 
//STRIP001         @param _opPrevwPage
//STRIP001         output parameter - calculated preview data.
//STRIP001 
//STRIP001         @return boolean, indicating, if calculation was successful.
//STRIP001     */
//STRIP001     bool _CalcPreviewDataForPage( const SwPageFrm& _rPage,
//STRIP001                                   const Point& _rPrevwOffset,
//STRIP001                                   PrevwPage* _opPrevwPage );
//STRIP001 
//STRIP001     /** calculate preview pages
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001         helper method called by <Prepare> in order to determine which pages
//STRIP001         will be visible in the current preview and calculate the data needed
//STRIP001         to paint these pages. Also the accessible pages with its needed data
//STRIP001         are determined.
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void _CalcPreviewPages();
//STRIP001 
//STRIP001     /** get preview page by physical page number
//STRIP001 
//STRIP001         OD 17.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nPageNum
//STRIP001         input parameter - physical page number of page, for which the preview
//STRIP001         page will be returned.
//STRIP001 
//STRIP001         @return pointer to preview page of current preview pages. If page doesn't
//STRIP001         belongs to current preview pages, <0> is returned.
//STRIP001     */
//STRIP001     const PrevwPage* _GetPrevwPageByPageNum( const sal_uInt16 _nPageNum ) const;
//STRIP001 
//STRIP001     /** paint selection mark at page
//STRIP001 
//STRIP001         OD 17.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     const void _PaintSelectMarkAtPage( const PrevwPage* _aSelectedPrevwPage ) const;
//STRIP001 
//STRIP001 public:
//STRIP001     /** constructor of <SwPagePreviewLayout>
//STRIP001 
//STRIP001         OD 11.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _rParentViewShell
//STRIP001         input parameter - reference to the view shell the page preview
//STRIP001         layout belongs to. Reference will be hold as member <mrParentViewShell>.
//STRIP001         Adjustments/Changes at this view shell:
//STRIP001         (1) Adjustment of the mapping mode at the output device.
//STRIP001         (2) Change of the zoom at the view options.
//STRIP001         (3) Preparations for paint of the page preview.
//STRIP001 
//STRIP001         @param _rLayoutRootFrm
//STRIP001         input parameter - constant reference to the root frame of the layout.
//STRIP001         Reference will be hold as member <mrLayoutRootFrm> in order to get
//STRIP001         access to the page frames.
//STRIP001     */
//STRIP001     SwPagePreviewLayout( ViewShell& _rParentViewShell,
//STRIP001                          const SwRootFrm&    _rLayoutRootFrm );
//STRIP001 
//STRIP001     /** destructor of <SwPagePreviewLayout>
//STRIP001 
//STRIP001         OD 17.12.2002 #103492#
//STRIP001 
//STRIP001         @author
//STRIP001     */
//STRIP001     inline ~SwPagePreviewLayout()
//STRIP001     {
//STRIP001         _ClearPrevwPageData();
//STRIP001     }
//STRIP001 
//STRIP001     /** init page preview layout
//STRIP001 
//STRIP001         OD 11.12.2002 #103492#
//STRIP001         initialize the page preview settings for a given layout.
//STRIP001         side effects:
//STRIP001         (1) If parameter <_bCalcScale> is true, mapping mode with calculated
//STRIP001         scaling is set at the output device and the zoom at the view options of
//STRIP001         the given view shell is set with the calculated scaling.
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nCols
//STRIP001         input parameter - initial number of page columns in the preview.
//STRIP001 
//STRIP001         @param _nRows
//STRIP001         input parameter - initial number of page rows in the preview.
//STRIP001 
//STRIP001         @param _rPxWinSize
//STRIP001         input parameter - window size in which the preview will be displayed and
//STRIP001         for which the scaling will be calculated.
//STRIP001 
//STRIP001         @param _orMaxPageSize
//STRIP001         output parameter - maximal size in width and height of all pages
//STRIP001 
//STRIP001         @param _orPreviewDocSize
//STRIP001         output parameter - size of the document in the proposed preview layout
//STRIP001         included the spacing between the pages.
//STRIP001 
//STRIP001         @param _bCalcScale
//STRIP001         input parameter - control, if method should calculate the needed
//STRIP001         scaling for the proposed preview layout for the given window size
//STRIP001         and sets the scaling at the output device and the view options.
//STRIP001 
//STRIP001         @return boolean, indicating, if preview layout is successful initialized.
//STRIP001     */
//STRIP001     bool Init( const sal_uInt16 _nCols,
//STRIP001                const sal_uInt16 _nRows,
//STRIP001                const Size&      _rPxWinSize,
//STRIP001                const bool       _bCalcScale
//STRIP001               );
//STRIP001 
//STRIP001     /** method to adjust page preview layout to document changes
//STRIP001 
//STRIP001         OD 18.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @return boolean, indicating, if preview layout is successful initialized.
//STRIP001     */
//STRIP001     bool ReInit();
//STRIP001 
//STRIP001     /** prepare paint of page preview
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001         With the valid preview layout settings - calculated and set by method
//STRIP001         <Init(..)> - the paint of a specific part of the virtual preview
//STRIP001         document is prepared. The corresponding part is given by either
//STRIP001         a start page (parameter <_nProposedStartPageNum>) or a absolute position
//STRIP001         (parameter <_aProposedStartPoint>).
//STRIP001         The accessibility preview will also be updated via a corresponding
//STRIP001         method call.
//STRIP001         OD 21.03.2003 #108282# - delete parameter _onStartPageVirtNum
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nProposedStartPageNum [0..<number of document pages>]
//STRIP001         input parameter - proposed number of page, which should be painted in
//STRIP001         the left-top-corner in the current output device. input parameter
//STRIP001         <_bStartWithPageAtFirstCol> influences, if proposed page is actual
//STRIP001         painted in the left-top-corner.
//STRIP001 
//STRIP001         @param _nProposedStartPos [(0,0)..<PreviewDocumentSize>]
//STRIP001         input parameter - proposed absolute position in the virtual preview
//STRIP001         document, which should be painted in the left-top-corner in the current
//STRIP001         output device.
//STRIP001 
//STRIP001         @param _rPxWinSize
//STRIP001         input parameter - pixel size of window the preview will be painted in.
//STRIP001 
//STRIP001         @param _onStartPageNum
//STRIP001         output parameter - physical number of page, which will be painted in the
//STRIP001         left-top-corner in the current output device.
//STRIP001 
//STRIP001         @param _orDocPreviewPaintRect
//STRIP001         output parameter - rectangle of preview document, which will be painted.
//STRIP001 
//STRIP001         @param _bStartWithPageAtFirstCol
//STRIP001         input parameter with default value "true" - controls, if start page
//STRIP001         is set to page in first column the proposed start page is located.
//STRIP001 
//STRIP001         @return boolean, indicating, if prepare of preview paint was successful.
//STRIP001     */
//STRIP001     bool Prepare( const sal_uInt16 _nProposedStartPageNum,
//STRIP001                   const Point      _aProposedStartPos,
//STRIP001                   const Size&      _rPxWinSize,
//STRIP001                   sal_uInt16&      _onStartPageNum,
//STRIP001                   Rectangle&       _orDocPreviewPaintRect,
//STRIP001                   const bool       _bStartWithPageAtFirstCol = true
//STRIP001                 );
//STRIP001 
//STRIP001     /** get selected page number
//STRIP001 
//STRIP001         OD 13.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     inline sal_uInt16 SelectedPage()
//STRIP001     {
//STRIP001         return mnSelectedPageNum;
//STRIP001     }
//STRIP001 
//STRIP001     /** set selected page number
//STRIP001 
//STRIP001         OD 14.01.2003 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     inline void SetSelectedPage( sal_uInt16 _nSelectedPageNum )
//STRIP001     {
//STRIP001         mnSelectedPageNum = _nSelectedPageNum;
//STRIP001     }
//STRIP001 
//STRIP001     /** paint prepared preview
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _aOutRect
//STRIP001         input parameter - Twip rectangle of window, which should be painted.
//STRIP001 
//STRIP001         @return boolean, indicating, if paint of preview was performed
//STRIP001     */
//STRIP001     bool Paint( const Rectangle _aOutRect ) const;
//STRIP001 
//STRIP001     /** repaint pages on page preview
//STRIP001 
//STRIP001         OD 18.12.2002 #103492#
//STRIP001         method to invalidate visible pages due to changes in a different
//STRIP001         view shell.
//STRIP001 
//STRIP001         @author OD
//STRIP001     */
//STRIP001     void Repaint( const Rectangle _aInvalidCoreRect ) const;
//STRIP001 
//STRIP001     /** paint to mark new selected page
//STRIP001 
//STRIP001         OD 17.12.2002 #103492#
//STRIP001         Perform paint for current selected page in order to unmark it.
//STRIP001         Set new selected page and perform paint to mark this page.
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nNewSelectedPage
//STRIP001         input parameter - physical number of page, which will be marked as selected.
//STRIP001     */
//STRIP001     void MarkNewSelectedPage( const sal_uInt16 _nSelectedPage );
//STRIP001 
//STRIP001     /** calculate start position for new scale
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001         calculate new start position for a new scale. Calculation bases on the
//STRIP001         current visible part of the document arranged in the given preview layout.
//STRIP001         preconditions:
//STRIP001         (1) new scaling is already set at the given output device.
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @return Point, start position for new scale
//STRIP001     */
//STRIP001     Point GetPreviewStartPosForNewScale( const Fraction& _aNewScale,
//STRIP001                                          const Fraction& _aOldScale,
//STRIP001                                          const Size&     _aNewWinSize ) const;
//STRIP001 
//STRIP001     /** determines, if page with given page number is visible in preview
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nPageNum
//STRIP001         input parameter - physical number of page, for which it will be
//STRIP001         determined, if it is visible.
//STRIP001 
//STRIP001         @return boolean, indicating, if page with given page number is visible
//STRIP001         in preview.
//STRIP001     */
//STRIP001     bool IsPageVisible( const sal_uInt16 _nPageNum ) const;
//STRIP001 
//STRIP001     /** calculate data to bring new selected page into view.
//STRIP001 
//STRIP001         OD 12.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nHoriMove
//STRIP001         input parameter - positive/negative number of columns the current
//STRIP001         selected page have to be moved.
//STRIP001 
//STRIP001         @param _nVertMove
//STRIP001         input parameter - positive/negative number of rows the current
//STRIP001         selected page have to be moved.
//STRIP001 
//STRIP001         @param _orNewSelectedPage
//STRIP001         output parameter - number of new selected page
//STRIP001 
//STRIP001         @param _orNewStartPage
//STRIP001         output parameter - number of new start page
//STRIP001 
//STRIP001         @param _orNewStartPos
//STRIP001         output parameter - new start position in document preview
//STRIP001 
//STRIP001         @return boolean - indicating, that move was sucessful.
//STRIP001     */
//STRIP001     bool CalcStartValuesForSelectedPageMove( const sal_Int16  _nHoriMove,
//STRIP001                                              const sal_Int16  _nVertMove,
//STRIP001                                              sal_uInt16&      _orNewSelectedPage,
//STRIP001                                              sal_uInt16&      _orNewStartPage,
//STRIP001                                              Point&           _orNewStartPos ) const;
//STRIP001 
//STRIP001     /** checks, if given position is inside a shown document page
//STRIP001 
//STRIP001         OD 17.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _aPrevwPos
//STRIP001         input parameter - position inside the visible preview window.
//STRIP001 
//STRIP001         @param _orDocPos
//STRIP001         output parameter - corresponding position in the document, if given
//STRIP001         preview position is inside a shown document page, not an empty page.
//STRIP001         If not, it's value is <Point( 0, 0 )>.
//STRIP001 
//STRIP001         @param _obPosInEmptyPage
//STRIP001         output parameter - indicates, that given preview position lays inside
//STRIP001         an shown empty page.
//STRIP001 
//STRIP001         @param _onPageNum
//STRIP001         output parameter - corresponding physical number of page, if given
//STRIP001         preview position is inside a shown document page, considers also empty
//STRIP001         pages. If not, it's value is <0>.
//STRIP001 
//STRIP001         @return boolean - indicating, that given preview position lays inside
//STRIP001         a shown document preview page, not an empty page.
//STRIP001     */
//STRIP001     bool IsPrevwPosInDocPrevwPage( const Point  _aPrevwPos,
//STRIP001                                    Point&       _orDocPos,
//STRIP001                                    bool&        _obPosInEmptyPage,
//STRIP001                                    sal_uInt16&  _onPageNum ) const;
//STRIP001 
//STRIP001     inline bool DoesPreviewLayoutRowsFitIntoWindow() const
//STRIP001     {
//STRIP001         return mbDoesLayoutRowsFitIntoWindow;
//STRIP001     }
//STRIP001 
//STRIP001     inline bool DoesPreviewLayoutColsFitIntoWindow() const
//STRIP001     {
//STRIP001         return mbDoesLayoutColsFitIntoWindow;
//STRIP001     }
//STRIP001 
//STRIP001     inline bool PreviewLayoutValid() const
//STRIP001     {
//STRIP001         return mbLayoutInfoValid && mbLayoutSizesValid && mbPaintInfoValid;
//STRIP001     }
//STRIP001 
//STRIP001     /** determine preview window page scroll amount
//STRIP001 
//STRIP001         OD 17.12.2002 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nWinPagesToScroll
//STRIP001         input parameter - number of preview window pages the scroll amount has
//STRIP001         to be calculated for. Negative values for preview window page up
//STRIP001         scrolling, positive values for preview window page down scrolling.
//STRIP001 
//STRIP001         @return scroll amount in SwTwips
//STRIP001     */
//STRIP001     SwTwips GetWinPagesScrollAmount( const sal_Int16 _nWinPagesToScroll ) const;
//STRIP001 
//STRIP001     /** determine window preview page the page with the given number is on.
//STRIP001 
//STRIP001         OD 17.01.2003 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nPageNum
//STRIP001         input parameter - physical page number of page, for which the preview
//STRIP001         window page number has to be calculated.
//STRIP001 
//STRIP001         @return number of preview window page the page with the given physical
//STRIP001         page number is on
//STRIP001     */
//STRIP001     sal_uInt16 GetWinPageNumOfPage( sal_uInt16 _nPageNum ) const;
//STRIP001 
//STRIP001     /** determine row the page with the given number is in
//STRIP001 
//STRIP001         OD 17.01.2003 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nPageNum
//STRIP001         input parameter - physical page number of page, for which the row in
//STRIP001         preview layout has to be calculated.
//STRIP001 
//STRIP001         @return number of row the page with the given physical page number is in
//STRIP001     */
//STRIP001     sal_uInt16 GetRowOfPage( sal_uInt16 _nPageNum ) const;
//STRIP001 
//STRIP001     /** determine column the page with the given number is in
//STRIP001 
//STRIP001         OD 17.01.2003 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nPageNum
//STRIP001         input parameter - physical page number of page, for which the column in
//STRIP001         preview layout has to be calculated.
//STRIP001 
//STRIP001         @return number of column the page with the given physical page number is in
//STRIP001     */
//STRIP001     sal_uInt16 GetColOfPage( sal_uInt16 _nPageNum ) const;
//STRIP001 
//STRIP001     // OD 18.12.2002 #103492#
//STRIP001     Size GetMaxPageSize() const;
//STRIP001 
//STRIP001     // OD 18.12.2002 #103492#
//STRIP001     Size GetPrevwDocSize() const;
//STRIP001 
//STRIP001     /** get size of a preview page by its physical page number
//STRIP001 
//STRIP001         OD 15.01.2003 #103492#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nPageNum
//STRIP001         input parameter - pysical page number of preview page, for which the
//STRIP001         page size has to be returned.
//STRIP001 
//STRIP001         @return an object of class <Size>
//STRIP001     */
//STRIP001     Size GetPrevwPageSizeByPageNum( sal_uInt16 _nPageNum ) const;
//STRIP001 
//STRIP001     /** get virtual page number by its physical page number
//STRIP001 
//STRIP001         OD 21.03.2003 #108282#
//STRIP001 
//STRIP001         @author OD
//STRIP001 
//STRIP001         @param _nPageNum
//STRIP001         input parameter - pysical page number of preview page, for which the
//STRIP001         virtual page number has to be determined.
//STRIP001 
//STRIP001         @return virtual page number of page given by its physical page number,
//STRIP001         if the page is in the current preview pages vector, otherwise 0.
//STRIP001     */
//STRIP001     sal_uInt16 GetVirtPageNumByPageNum( sal_uInt16 _nPageNum ) const;
//STRIP001 };

} //namespace binfilter
#endif // _PAGEPREVIEWLAYOUT_HXX
