/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: statmplx.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:39:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXSTATMPLX_HXX
#define _SFXSTATMPLX_HXX

#include <ctrlitem.hxx>
namespace binfilter {

class SfxStatusForwarder_Impl;

//====================================================================

class SfxStatusMultiplexer: public SfxPoolItem, public SfxListener

/*	[Beschreibung]

	Mit Instanzen dieser Klasse kann eine einzelne <SfxControllerItem> Instanz
	(z.B. ein <SfxToolBoxControl>) auf die Status mehrerer Slots reagieren.

	So etwas wird ben"otigt, wenn die Status nicht unabh"angig voneinander
	sind, sondern z.B. eine Position relativ zu einer anderen ist. Dann
	sammelt der SfxStatusMultiplexer die verschiedenen Status und leitet
	sie erst wenn alle verf"ugbar sind oder keine weiteren mehr folgen sind
	an das eigentlichen SfxControllerItem weiter.

	[Beispiel]

	class MyToolBoxControl: public SfxToolBoxControl
	{
		SfxStatusMultiplexer	aMpx;

	protected:
		virtual void            StateChanged( SfxPoolItem *pStatus );
		...

	public:
								MyToolBoxControl( USHORT nMasterSlotId );
								...
	};

	MyToolBoxControl::MyToolBoxControl( USHORT nMasterSlotId ):
		SfxToolBoxControl( nMasterSlotId ),
		aMpx( *this, SID_SLAVE_SLOT_1, SID_SLAVE_SLOT_2, ..., 0 )
	{
	}

	void MyToolBoxControl::StateChanged( SfxPoolItem *pStatus )
	{
		if ( pStatus == &aMpx )
		{
			SfxPoolItem *pSlave1 = aMpx.GetStatus( SID_SLAVE_SLOT_1 );
			...
		}
	}
*/

{
	USHORT					 nCount;
	SfxStatusForwarder_Impl* pForwarder;

protected:
	void				StateChanged( SfxStatusForwarder_Impl *pFrom,
									  SfxPoolItem *pItem );
	virtual void		SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
								const SfxHint& rHint, const TypeId& rHintType );

public:
						SfxStatusMultiplexer( SfxControllerItem &rController,
											  USHORT nSlotId, ... );
						~SfxStatusMultiplexer();

	SfxPoolItem*		GetStatus( USHORT nSlotId ) const;
};


}//end of namespace binfilter
#endif

