/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwsh5.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:37:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------
#define _ZFORLIST_DECLARE_TABLE
// auto strip #include "scitems.hxx"
// auto strip #include <svtools/smplhint.hxx>
// auto strip #include <svtools/zforlist.hxx>
// auto strip #include <bf_svx/numfmtsh.hxx>
// auto strip #include <bf_svx/numinf.hxx>
#include <bf_svx/svxids.hrc>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/objsh.hxx>

#include "tabvwsh.hxx"
#include "bf_sc.hrc"
// auto strip #include "global.hxx"
#include "document.hxx"
// auto strip #include "cell.hxx"
#include "globstr.hrc"
#include "scmod.hxx"
#include "uiitems.hxx"
// auto strip #include "editsh.hxx"
#include "hints.hxx"
namespace binfilter {


//==================================================================

/*N*/ void __EXPORT ScTabViewShell::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 						 const SfxHint& rHint, const TypeId& rHintType )
/*N*/ {
/*N*/ 	if (rHint.ISA(SfxSimpleHint))						// ohne Parameter
/*N*/ 	{
/*N*/ 		ULONG nSlot = ((SfxSimpleHint&)rHint).GetId();
/*N*/ 		switch ( nSlot )
/*N*/ 		{
/*N*/ 			case FID_DATACHANGED:
/*N*/ 				UpdateFormulas();
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_REFMODECHANGED:
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 					BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 /*?*/ 					if (!bRefMode)
//STRIP001 /*?*/ 						StopRefMode();
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						GetSelEngine()->Reset();
//STRIP001 /*?*/ 						GetFunctionSet()->SetAnchorFlag(TRUE);
//STRIP001 /*?*/ 						//	AnchorFlag, damit gleich mit Control angehaengt werden kann
//STRIP001 /*?*/ 					}
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*N*/ 			case FID_KILLEDITVIEW:
/*N*/ 			case FID_KILLEDITVIEW_NOPAINT:
/*N*/ 				StopEditShell();
/*N*/ 				KillEditView( nSlot == FID_KILLEDITVIEW_NOPAINT );
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SFX_HINT_DOCCHANGED:
/*N*/ 				{
/*N*/ 					ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 					if (!pDoc->HasTable( GetViewData()->GetTabNo() ))
/*N*/ 					{
/*N*/ 						SetTabNo(0);
/*N*/ 					}
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SC_HINT_DRWLAYER_NEW:
/*N*/ 				MakeDrawView();
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SC_HINT_DOC_SAVED:
/*N*/ 				{
/*N*/ 					//	beim "Save as" kann ein vorher schreibgeschuetztes Dokument
/*N*/ 					//	bearbeitbar werden, deshalb die Layer-Locks neu (#39884#)
/*N*/ 					//	(Invalidate etc. passiert schon vom Sfx her)
/*N*/ 					//	#42091# bei SID_EDITDOC kommt kein SFX_HINT_TITLECHANGED, darum
/*N*/ 					//	der eigene Hint aus DoSaveCompleted
/*N*/ 					//!	was ist mit SFX_HINT_SAVECOMPLETED ?
/*N*/ 
/*N*/ 					UpdateLayerLocks();
/*N*/ 
/*N*/ 					//	#54891# Design-Modus bei jedem Speichern anzupassen, waere zuviel
/*N*/ 					//	(beim Speichern unter gleichem Namen soll er unveraendert bleiben)
/*N*/ 					//	Darum nur bei SFX_HINT_MODECHANGED (vom ViewFrame)
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SFX_HINT_MODECHANGED:
/*N*/ 				//	#54891#/#58510# Da man sich nicht mehr darauf verlassen kann, woher
/*N*/ 				//	dieser Hint kommt, den Design-Modus immer dann umschalten, wenn der
/*N*/ 				//	ReadOnly-Status sich wirklich geaendert hat:
/*N*/ 
/*N*/ 				if ( GetViewData()->GetSfxDocShell()->IsReadOnly() != bReadOnly )
/*N*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 					bReadOnly = GetViewData()->GetSfxDocShell()->IsReadOnly();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 					SfxBoolItem aItem( SID_FM_DESIGN_MODE, !bReadOnly);
//STRIP001 /*N*/ 					GetViewData()->GetDispatcher().Execute( SID_FM_DESIGN_MODE, SFX_CALLMODE_ASYNCHRON,
//STRIP001 /*N*/ 												&aItem, 0L );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 					UpdateInputContext();
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case SC_HINT_SHOWRANGEFINDER:
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				PaintRangeFinder();
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SC_HINT_FORCESETTAB:
/*?*/ 				SetTabNo( GetViewData()->GetTabNo(), TRUE );
/*?*/ 				break;
/*?*/ 
/*N*/ 			default:
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if (rHint.ISA(ScPaintHint))					// neu zeichnen
/*N*/ 	{
/*N*/ 		ScPaintHint* pHint = (ScPaintHint*) &rHint;
/*N*/ 		USHORT nParts = pHint->GetParts();
/*N*/ 		USHORT nTab = GetViewData()->GetTabNo();
/*N*/ 		if (pHint->GetStartTab() <= nTab && pHint->GetEndTab() >= nTab)
/*N*/ 		{
/*N*/ 			if (nParts & PAINT_EXTRAS)			// zuerst, falls Tabelle weg ist !!!
/*N*/ 				if (PaintExtras())
/*?*/ 					nParts = PAINT_ALL;
/*N*/ 
/*N*/ 			if (nParts & PAINT_SIZE)
/*?*/ 				RepeatResize(); 					//! InvalidateBorder ???
/*N*/ 			if (nParts & PAINT_GRID)
/*N*/ 				PaintArea( pHint->GetStartCol(), pHint->GetStartRow(),
/*N*/ 						   pHint->GetEndCol(), pHint->GetEndRow() );
/*N*/ 			if (nParts & PAINT_MARKS)
/*?*/ 				PaintArea( pHint->GetStartCol(), pHint->GetStartRow(),
/*?*/ 						   pHint->GetEndCol(), pHint->GetEndRow(), SC_UPDATE_MARKS );
/*N*/ 			if (nParts & PAINT_LEFT)
/*N*/ 				PaintLeftArea( pHint->GetStartRow(), pHint->GetEndRow() );
/*N*/ 			if (nParts & PAINT_TOP)
/*N*/ 				PaintTopArea( pHint->GetStartCol(), pHint->GetEndCol() );
/*N*/ 			if (nParts & PAINT_INVERT)
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				InvertBlockMark( pHint->GetStartCol(), pHint->GetStartRow(),
											//STRIP001 /*?*/ 								 pHint->GetEndCol(), pHint->GetEndRow() );
/*N*/ 
/*N*/ 			HideNoteMarker();
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if (rHint.ISA(ScEditViewHint))					// Edit-View anlegen
/*N*/ 	{
/*?*/ 		//	ScEditViewHint kommt nur an aktiver View an
/*?*/ 
/*?*/ 		ScEditViewHint* pHint = (ScEditViewHint*) &rHint;
/*?*/ 		USHORT nTab = GetViewData()->GetTabNo();
/*?*/ 		if ( pHint->GetTab() == nTab )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 /*?*/ 			USHORT nCol = pHint->GetCol();
//STRIP001 /*?*/ 			USHORT nRow = pHint->GetRow();
//STRIP001 /*?*/ #if 0
//STRIP001 /*?*/ // Abfrage ist ueberfluessig, passiert bereits in ScInputHandler StartTable
//STRIP001 /*?*/ //			if (pDoc->IsSelectionOrBlockEditable( nTab, nCol,nRow, nCol,nRow ))
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				HideNoteMarker();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				MakeEditView( pHint->GetEngine(), nCol, nRow );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				StopEditShell();					// sollte nicht gesetzt sein
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				ScSplitPos eActive = GetViewData()->GetActivePart();
//STRIP001 /*?*/ 				if ( GetViewData()->HasEditView(eActive) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					//	MakeEditView geht schief, wenn der Cursor ausserhalb des
//STRIP001 /*?*/ 					//	Bildschirms steht. GetEditView gibt dann eine nicht aktive
//STRIP001 /*?*/ 					//	View zurueck, darum die Abfrage HasEditView.
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					EditView* pView = GetViewData()->GetEditView(eActive);	// ist nicht 0
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					SetEditShell(pView ,TRUE);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ #if 0
//STRIP001 /*?*/ //			else
//STRIP001 /*?*/ //				if (GetViewData()->IsActive())
//STRIP001 /*?*/ //					ErrorMessage(STR_PROTECTIONERR);
//STRIP001 /*?*/ #endif
/*?*/ 		}
/*N*/ 	}
/*N*/ 	else if (rHint.ISA(ScTablesHint))				// Tabelle eingefuegt / geloescht
/*N*/ 	{
/*N*/ 			//	aktuelle Tabelle zuerst holen (kann bei DeleteTab an ViewData geaendert werden)
/*N*/ 		USHORT nActiveTab = GetViewData()->GetTabNo();
/*N*/ 
/*N*/ 		const ScTablesHint& rTabHint = (const ScTablesHint&)rHint;
/*N*/ 		USHORT nTab1 = rTabHint.GetTab1();
/*N*/ 		USHORT nTab2 = rTabHint.GetTab2();
/*N*/ 		USHORT nId  = rTabHint.GetId();
/*N*/ 		switch (nId)
/*N*/ 		{
/*N*/ 			case SC_TAB_INSERTED:
/*N*/ 				GetViewData()->InsertTab( nTab1 );
/*N*/ 				break;
/*?*/ 			case SC_TAB_DELETED:
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				GetViewData()->DeleteTab( nTab1 );
/*?*/ 				break;
/*?*/ 			case SC_TAB_MOVED:
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				GetViewData()->MoveTab( nTab1, nTab2 );
/*?*/ 				break;
/*?*/ 			case SC_TAB_COPIED:
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				GetViewData()->CopyTab( nTab1, nTab2 );
/*?*/ 				break;
/*N*/ 			case SC_TAB_HIDDEN:
/*N*/ 				break;
/*N*/ 			default:
/*N*/ 				DBG_ERROR("unbekannter ScTablesHint");
/*N*/ 		}
/*N*/ 
/*N*/ 		//	hier keine Abfrage auf IsActive() mehr, weil die Aktion von Basic ausgehen
/*N*/ 		//	kann und dann auch die aktive View umgeschaltet werden muss.
/*N*/ 
/*N*/ 		USHORT nNewTab = nActiveTab;
/*N*/ 		BOOL bForce = FALSE;
/*N*/ 		switch (nId)
/*N*/ 		{
/*N*/ 			case SC_TAB_INSERTED:
/*N*/ 				if ( nTab1 <= nNewTab )				// vorher eingefuegt
/*N*/ 					++nNewTab;
/*N*/ 				break;
/*N*/ 			case SC_TAB_DELETED:
/*N*/ 				if ( nTab1 < nNewTab )				// vorher geloescht
/*N*/ 					--nNewTab;
/*N*/ 				else if ( nTab1 == nNewTab )		// aktuelle geloescht
/*N*/ 					bForce = TRUE;
/*N*/ 				break;
/*N*/ 			case SC_TAB_MOVED:
/*N*/ 				if ( nNewTab == nTab1 )				// verschobene Tabelle
/*N*/ 					nNewTab = nTab2;
/*N*/ 				else if ( nTab1 < nTab2 )			// nach hinten verschoben
/*N*/ 				{
/*N*/ 					if ( nNewTab > nTab1 && nNewTab <= nTab2 )		// nachrueckender Bereich
/*N*/ 						--nNewTab;
/*N*/ 				}
/*N*/ 				else								// nach vorne verschoben
/*N*/ 				{
/*N*/ 					if ( nNewTab >= nTab2 && nNewTab < nTab1 )		// nachrueckender Bereich
/*N*/ 						++nNewTab;
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			case SC_TAB_COPIED:
/*N*/ 				if ( nNewTab >= nTab2 )				// vorher eingefuegt
/*N*/ 					++nNewTab;
/*N*/ 				break;
/*N*/ 			case SC_TAB_HIDDEN:
/*N*/ 				if ( nTab1 == nNewTab )				// aktuelle ausgeblendet
/*N*/ 					bForce = TRUE;
/*N*/ 				break;
/*N*/ 		}
/*N*/ 
/*N*/ 		ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 		if ( nNewTab >= pDoc->GetTableCount() )
/*N*/ 			nNewTab = pDoc->GetTableCount() - 1;
/*N*/ 
/*N*/ 		SetTabNo( nNewTab, bForce );
/*N*/ 	}
/*N*/ 	else if (rHint.ISA(ScIndexHint))
/*N*/ 	{
/*?*/ 		const ScIndexHint& rIndexHint = (const ScIndexHint&)rHint;
/*?*/ 		USHORT nId = rIndexHint.GetId();
/*?*/ 		USHORT nIndex = rIndexHint.GetIndex();
/*?*/ 		switch (nId)
/*?*/ 		{
/*?*/ 			case SC_HINT_SHOWRANGEFINDER:
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				PaintRangeFinder( nIndex );
/*?*/ 				break;
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxViewShell::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
/*N*/ }

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::MakeNumberInfoItem( ScDocument*		 pDoc,
//STRIP001 										 ScViewData*		 pViewData,
//STRIP001 										 SvxNumberInfoItem** ppItem )
//STRIP001 {
//STRIP001 	//------------------------------
//STRIP001 	// NumberInfo-Item konstruieren:
//STRIP001 	//------------------------------
//STRIP001 	ScBaseCell* 		pCell = NULL;
//STRIP001 	SvxNumberValueType	eValType		= SVX_VALUE_TYPE_UNDEFINED;
//STRIP001 	double				nCellValue		= 0;
//STRIP001 	String				aCellString;
//STRIP001 
//STRIP001 	pDoc->GetCell( pViewData->GetCurX(),
//STRIP001 				   pViewData->GetCurY(),
//STRIP001 				   pViewData->GetTabNo(),
//STRIP001 				   pCell );
//STRIP001 
//STRIP001 	if ( pCell )
//STRIP001 	{
//STRIP001 		switch ( pCell->GetCellType() )
//STRIP001 		{
//STRIP001 			case CELLTYPE_VALUE:
//STRIP001 				{
//STRIP001 					nCellValue = ((ScValueCell*)pCell)->GetValue();
//STRIP001 					eValType = SVX_VALUE_TYPE_NUMBER;
//STRIP001 					aCellString.Erase();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CELLTYPE_STRING:
//STRIP001 				{
//STRIP001 					((ScStringCell*)pCell)->GetString( aCellString );
//STRIP001 					eValType = SVX_VALUE_TYPE_STRING;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CELLTYPE_FORMULA:
//STRIP001 				{
//STRIP001 					if ( ((ScFormulaCell*)pCell)->IsValue() )
//STRIP001 					{
//STRIP001 						nCellValue = ((ScFormulaCell*)pCell)->GetValue();
//STRIP001 						eValType = SVX_VALUE_TYPE_NUMBER;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nCellValue = 0;
//STRIP001 						eValType   = SVX_VALUE_TYPE_UNDEFINED;
//STRIP001 					}
//STRIP001 					aCellString.Erase();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				nCellValue = 0;
//STRIP001 				eValType   = SVX_VALUE_TYPE_UNDEFINED;
//STRIP001 				aCellString.Erase();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else // Zelle noch leer (== nicht erzeugt)
//STRIP001 	{
//STRIP001 		nCellValue = 0;
//STRIP001 		eValType   = SVX_VALUE_TYPE_UNDEFINED;
//STRIP001 		aCellString.Erase();
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( eValType )
//STRIP001 	{
//STRIP001 		case SVX_VALUE_TYPE_STRING:
//STRIP001 			*ppItem = new SvxNumberInfoItem(
//STRIP001 								pDoc->GetFormatTable(),
//STRIP001 								aCellString,
//STRIP001 								SID_ATTR_NUMBERFORMAT_INFO );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SVX_VALUE_TYPE_NUMBER:
//STRIP001 			*ppItem = new SvxNumberInfoItem(
//STRIP001 								pDoc->GetFormatTable(),
//STRIP001 								nCellValue,
//STRIP001 								SID_ATTR_NUMBERFORMAT_INFO );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SVX_VALUE_TYPE_UNDEFINED:
//STRIP001 		default:
//STRIP001 			*ppItem = new SvxNumberInfoItem(
//STRIP001 								pDoc->GetFormatTable(),
//STRIP001 								(const USHORT)
//STRIP001 								SID_ATTR_NUMBERFORMAT_INFO );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::UpdateNumberFormatter(
//STRIP001 						ScDocument* 			 pDoc,
//STRIP001 						const SvxNumberInfoItem& rInfoItem )
//STRIP001 {
//STRIP001 	const ULONG nDelCount = rInfoItem.GetDelCount();
//STRIP001 
//STRIP001 	if ( nDelCount > 0 )
//STRIP001 	{
//STRIP001 		const ULONG* pDelArr = rInfoItem.GetDelArray();
//STRIP001 
//STRIP001 		for ( USHORT i=0; i<nDelCount; i++ )
//STRIP001 			rInfoItem.GetNumberFormatter()->DeleteEntry( pDelArr[i] );
//STRIP001 	}
//STRIP001 
//STRIP001 	// sollte besser UpdateNumberFormats() heissen ?
//STRIP001 	pDoc->DeleteNumberFormat( rInfoItem.GetDelArray(),
//STRIP001 							  rInfoItem.GetDelCount() );
//STRIP001 }






}
