/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_prevwsh.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:32:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #include <bf_svx/zoom.hxx>
#include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #include <bf_sfx2/topfrm.hxx>
// auto strip #include <svtools/printdlg.hxx>
// auto strip #include <svtools/stritem.hxx>
// auto strip #include <svtools/whiter.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <tools/urlobj.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>

#include "prevwsh.hxx"
// auto strip #include "preview.hxx"
// auto strip #include "scmod.hxx"
// auto strip #include "inputhdl.hxx"
#include "docsh.hxx"
// auto strip #include "tabvwsh.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "editutil.hxx"
#include "scresid.hxx"
#include "globstr.hrc"
#include "bf_sc.hrc"
// auto strip #ifndef _SC_VIEWSETTINGSSEQUENCEDEFINES_HXX
// auto strip #include "ViewSettingsSequenceDefines.hxx"
// auto strip #endif
// auto strip #include "tpprint.hxx"

// auto strip #ifndef _XMLOFF_XMLUCONV_HXX
// auto strip #include <bf_xmloff/xmluconv.hxx>
// auto strip #endif
// auto strip #ifndef _RTL_USTRBUF_HXX_
// auto strip #include <rtl/ustrbuf.hxx>
// auto strip #endif

//	fuer Rad-Maus
#define SC_DELTA_ZOOM	10

#define SC_USERDATA_SEP	';'

using namespace ::com::sun::star;

// -----------------------------------------------------------------------
namespace binfilter {
#define ScPreviewShell
#include "scslots.hxx"

//STRIP001 TYPEINIT1( ScPreviewShell, SfxViewShell );

/*N*/ SFX_IMPL_INTERFACE( ScPreviewShell, SfxViewShell, ScResId(SCSTR_PREVIEWSHELL) )
/*N*/ {
/*N*/ 	SFX_OBJECTBAR_REGISTRATION(SFX_OBJECTBAR_OBJECT|SFX_VISIBILITY_STANDARD|
/*N*/ 								SFX_VISIBILITY_SERVER|SFX_VISIBILITY_READONLYDOC,
/*N*/ 								ScResId(RID_OBJECTBAR_PREVIEW));
/*N*/ 	SFX_POPUPMENU_REGISTRATION(ScResId(RID_POPUP_PREVIEW));
/*N*/ }

/*N*/ SFX_IMPL_VIEWFACTORY( ScPreviewShell, ScResId(STR_NONAME) )
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(ScDocShell);
/*N*/ }

//------------------------------------------------------------------

//STRIP001 void ScPreviewShell::Construct( Window* pParent )
//STRIP001 {
//STRIP001 	eZoom = SVX_ZOOM_WHOLEPAGE;
//STRIP001 
//STRIP001 	pCorner = new ScrollBarBox( pParent, WB_SIZEABLE );
//STRIP001 
//STRIP001 	pHorScroll = new ScrollBar(pParent, WB_HSCROLL );
//STRIP001 	pVerScroll = new ScrollBar(pParent, WB_VSCROLL);
//STRIP001 
//STRIP001     // SSA: --- RTL --- no mirroring for horizontal scrollbars
//STRIP001     pHorScroll->EnableRTL( FALSE );
//STRIP001 
//STRIP001 	pHorScroll->SetEndScrollHdl( LINK( this, ScPreviewShell, ScrollHandler ) );
//STRIP001 	pVerScroll->SetEndScrollHdl( LINK( this, ScPreviewShell, ScrollHandler ) );
//STRIP001 
//STRIP001 	pPreview = new ScPreview( pParent, pDocShell, this );
//STRIP001 
//STRIP001 	SetPool( &SC_MOD()->GetPool() );
//STRIP001 	SetWindow( pPreview );
//STRIP001 	StartListening(*pDocShell);
//STRIP001 	StartListening(*SFX_APP());
//STRIP001 	SfxBroadcaster* pDrawBC = pDocShell->GetDocument()->GetDrawBroadcaster();
//STRIP001 	if (pDrawBC)
//STRIP001 		StartListening(*pDrawBC);
//STRIP001 
//STRIP001 //	pPreview->Show();			// wird vom Sfx angezeigt
//STRIP001 	pHorScroll->Show();
//STRIP001 	pVerScroll->Show();
//STRIP001 	pCorner->Show();
//STRIP001 	SetHelpId( HID_SCSHELL_PREVWSH );
//STRIP001 	SetName(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Preview")));
//STRIP001 }
//STRIP001 
//STRIP001 ScPreviewShell::ScPreviewShell( SfxViewFrame* pViewFrame,
//STRIP001 								const ScPreviewShell& rWin ) :
//STRIP001 //STRIP001  	SfxViewShell( pViewFrame, SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_CAN_PRINT | SFX_VIEW_HAS_PRINTOPTIONS ),
//STRIP001 	pDocShell( rWin.pDocShell ),
//STRIP001 	aSourceData( rWin.aSourceData ),
//STRIP001 	nSourceDesignMode( rWin.nSourceDesignMode ),
//STRIP001 	pAccessibilityBroadcaster( NULL )
//STRIP001 {
//STRIP001 	Construct( &pViewFrame->GetWindow() );
//STRIP001 }
//STRIP001 
//STRIP001 ScPreviewShell::ScPreviewShell( SfxViewFrame* pViewFrame,
//STRIP001 								Window *pParent ) :
//STRIP001 	SfxViewShell( pViewFrame, SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_CAN_PRINT | SFX_VIEW_HAS_PRINTOPTIONS ),
//STRIP001 	pDocShell( (ScDocShell*)pViewFrame->GetObjectShell() ),
//STRIP001 	nSourceDesignMode( SC_FORCEMODE_NONE ),
//STRIP001 	pAccessibilityBroadcaster( NULL )
//STRIP001 {
//STRIP001 	Construct( pParent );
//STRIP001 }
//STRIP001 
//STRIP001 ScPreviewShell::ScPreviewShell( SfxViewFrame* pViewFrame,
//STRIP001 								SfxViewShell* pOldSh ) :
//STRIP001 	SfxViewShell( pViewFrame, SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_CAN_PRINT | SFX_VIEW_HAS_PRINTOPTIONS ),
//STRIP001 	pDocShell( (ScDocShell*)pViewFrame->GetObjectShell() ),
//STRIP001 	nSourceDesignMode( SC_FORCEMODE_NONE ),
//STRIP001 	pAccessibilityBroadcaster( NULL )
//STRIP001 {
//STRIP001 	Construct( &pViewFrame->GetWindow() );
//STRIP001 
//STRIP001 	if ( pOldSh && pOldSh->ISA( ScTabViewShell ) )
//STRIP001 	{
//STRIP001 		//	store view settings, show table from TabView
//STRIP001 		//!	store live ScViewData instead, and update on ScTablesHint?
//STRIP001 		//!	or completely forget aSourceData on ScTablesHint?
//STRIP001 
//STRIP001 		ScTabViewShell* pTabViewShell = ((ScTabViewShell*)pOldSh);
//STRIP001 		ScViewData* pData = pTabViewShell->GetViewData();
//STRIP001 		pData->WriteUserData( aSourceData );
//STRIP001 		InitStartTable( pData->GetTabNo() );
//STRIP001 
//STRIP001 		//	#106334# also have to store the TabView's DesignMode state
//STRIP001 		//	(only if draw view exists)
//STRIP001 		SdrView* pDrawView = pTabViewShell->GetSdrView();
//STRIP001 		if ( pDrawView )
//STRIP001 			nSourceDesignMode = pDrawView->IsDesignMode();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 __EXPORT ScPreviewShell::~ScPreviewShell()
//STRIP001 {
//STRIP001     // #108333#; notify Accessibility that Shell is dying and before destroy all
//STRIP001     BroadcastAccessibility( SfxSimpleHint( SFX_HINT_DYING ) );
//STRIP001     DELETEZ(pAccessibilityBroadcaster);
//STRIP001 
//STRIP001     SfxBroadcaster* pDrawBC = pDocShell->GetDocument()->GetDrawBroadcaster();
//STRIP001 	if (pDrawBC)
//STRIP001 		EndListening(*pDrawBC);
//STRIP001 	EndListening(*SFX_APP());
//STRIP001 	EndListening(*pDocShell);
//STRIP001 
//STRIP001 	SetWindow(0);
//STRIP001 	delete pPreview;
//STRIP001 	delete pHorScroll;
//STRIP001 	delete pVerScroll;
//STRIP001 	delete pCorner;
//STRIP001 
//STRIP001 	//	#97612# normal mode of operation is switching back to default view in the same frame,
//STRIP001 	//	so there's no need to activate any other window here anymore
//STRIP001 }
//STRIP001 
//STRIP001 void ScPreviewShell::InitStartTable(USHORT nTab)
//STRIP001 {
//STRIP001 	pPreview->SetPageNo( pPreview->GetFirstPage(nTab) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------
//STRIP001 
//STRIP001 String __EXPORT ScPreviewShell::GetDescription() const
//STRIP001 {
//STRIP001 	return String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(" ** Test ** "));
//STRIP001 }
//STRIP001 
//STRIP001 Size __EXPORT ScPreviewShell::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	Size aOptSize(100,100);
//STRIP001 
//STRIP001 	ScTabViewShell*     pViewSh = pDocShell->GetBestViewShell();
//STRIP001 
//STRIP001 	if ( pViewSh )
//STRIP001 	{
//STRIP001 		ScViewData*			pViewData	= pViewSh->GetViewData();
//STRIP001 		USHORT				nCurTab		= pViewData->GetTabNo();
//STRIP001 		ScDocument*			pDoc		= pDocShell->GetDocument();
//STRIP001 		ScStyleSheetPool*	pStylePool  = pDoc->GetStyleSheetPool();
//STRIP001 		SfxStyleSheetBase*	pStyleSheet = pStylePool->Find(
//STRIP001 											pDoc->GetPageStyle( nCurTab ),
//STRIP001 											SFX_STYLE_FAMILY_PAGE );
//STRIP001 
//STRIP001 		DBG_ASSERT( pStyleSheet, "PageStyle not found :-/" );
//STRIP001 
//STRIP001 		if ( pStyleSheet )
//STRIP001 		{
//STRIP001 			const SfxItemSet&  rSet 	 = pStyleSheet->GetItemSet();
//STRIP001 			const SvxSizeItem& rItem	 = (const SvxSizeItem&)rSet.Get( ATTR_PAGE_SIZE );
//STRIP001 			const Size&		   rPageSize = rItem.GetSize();
//STRIP001 
//STRIP001 			aOptSize.Width()  = (long) (rPageSize.Width()  * pViewData->GetPPTX());
//STRIP001 			aOptSize.Height() = (long) (rPageSize.Height() * pViewData->GetPPTY());
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DBG_ERROR( "TabViewShell not found :-/" );
//STRIP001 
//STRIP001 	return aOptSize;
//STRIP001 }

//STRIP001 void __EXPORT ScPreviewShell::AdjustPosSizePixel( const Point &rPos, const Size &rSize )
//STRIP001 {
//STRIP001 	long nBarW = GetViewFrame()->GetWindow().GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 	long nBarH = nBarW;
//STRIP001 //	long nBarW = pVerScroll->GetSizePixel().Width();
//STRIP001 //	long nBarH = pHorScroll->GetSizePixel().Height();
//STRIP001 
//STRIP001 	Size aOutSize( rSize.Width()-nBarW, rSize.Height()-nBarH );
//STRIP001 	pPreview->SetPosSizePixel( rPos, aOutSize );
//STRIP001 	pHorScroll->SetPosSizePixel( Point( rPos.X(), rPos.Y() + aOutSize.Height() ),
//STRIP001 								 Size( aOutSize.Width(), nBarH ) );
//STRIP001 	pVerScroll->SetPosSizePixel( Point( rPos.X() + aOutSize.Width(), rPos.Y() ),
//STRIP001 								 Size( nBarW, aOutSize.Height() ) );
//STRIP001 	pCorner->SetPosSizePixel( Point( rPos.X() + aOutSize.Width(), rPos.Y() + aOutSize.Height() ),
//STRIP001 							  Size( nBarW, nBarH ) );
//STRIP001 
//STRIP001 	if ( SVX_ZOOM_WHOLEPAGE == eZoom )
//STRIP001 		pPreview->SetZoom( pPreview->GetOptimalZoom(FALSE) );
//STRIP001 	else if ( SVX_ZOOM_PAGEWIDTH == eZoom )
//STRIP001 		pPreview->SetZoom( pPreview->GetOptimalZoom(TRUE) );
//STRIP001 
//STRIP001 	UpdateScrollBars();
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::InnerResizePixel( const Point &rOfs, const Size &rSize )
//STRIP001 {
//STRIP001 	AdjustPosSizePixel( rOfs,rSize );
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::OuterResizePixel( const Point &rOfs, const Size &rSize )
//STRIP001 {
//STRIP001 	AdjustPosSizePixel( rOfs,rSize );
//STRIP001 }
//STRIP001 
//STRIP001 void ScPreviewShell::UpdateScrollBars()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nTab = pPreview->GetTab();
//STRIP001 
//STRIP001 	ScStyleSheetPool*	pStylePool	= pDoc->GetStyleSheetPool();
//STRIP001 	SfxStyleSheetBase*	pStyleSheet = pStylePool->Find( pDoc->GetPageStyle( nTab ),
//STRIP001 														SFX_STYLE_FAMILY_PAGE );
//STRIP001 	DBG_ASSERT(pStyleSheet,"StyleSheet nicht gefunden");
//STRIP001 	if (!pStyleSheet) return;
//STRIP001 	const SfxItemSet* pParamSet = &pStyleSheet->GetItemSet();
//STRIP001 
//STRIP001 	Size aPageSize = ((const SvxSizeItem&) pParamSet->Get(ATTR_PAGE_SIZE)).GetSize();
//STRIP001 	aPageSize.Width()  = (long) (aPageSize.Width()  * HMM_PER_TWIPS );
//STRIP001 	aPageSize.Height() = (long) (aPageSize.Height() * HMM_PER_TWIPS );
//STRIP001 
//STRIP001 	//	for centering, page size without the shadow is used
//STRIP001 
//STRIP001 	Size aWindowSize = pPreview->GetOutputSize();
//STRIP001 
//STRIP001 	Point aOfs = pPreview->GetOffset();
//STRIP001 	long nMaxPos;
//STRIP001 
//STRIP001 	pHorScroll->SetRange( Range( 0, aPageSize.Width() ) );
//STRIP001 	pHorScroll->SetLineSize( aWindowSize.Width() / 16 );
//STRIP001 	pHorScroll->SetPageSize( aWindowSize.Width() );
//STRIP001 	pHorScroll->SetVisibleSize( aWindowSize.Width() );
//STRIP001 	nMaxPos = aPageSize.Width() - aWindowSize.Width();
//STRIP001 	if (nMaxPos<0)
//STRIP001 	{
//STRIP001 		//	page smaller than window -> center (but put scrollbar to 0)
//STRIP001 		aOfs.X() = 0;
//STRIP001 		pPreview->SetXOffset( nMaxPos / 2 );
//STRIP001 	}
//STRIP001 	else if (aOfs.X() < 0)
//STRIP001 	{
//STRIP001 		//	page larger than window -> never use negative offset
//STRIP001 		aOfs.X() = 0;
//STRIP001 		pPreview->SetXOffset( 0 );
//STRIP001 	}
//STRIP001 	else if (aOfs.X() > nMaxPos)
//STRIP001 	{
//STRIP001 		//	limit offset to align with right edge of window
//STRIP001 		aOfs.X() = nMaxPos;
//STRIP001 		pPreview->SetXOffset(nMaxPos);
//STRIP001 	}
//STRIP001 	pHorScroll->SetThumbPos( aOfs.X() );
//STRIP001 
//STRIP001 	pVerScroll->SetRange( Range( 0, aPageSize.Height() ) );
//STRIP001 	pVerScroll->SetLineSize( aWindowSize.Height() / 16 );
//STRIP001 	pVerScroll->SetPageSize( aWindowSize.Height() );
//STRIP001 	pVerScroll->SetVisibleSize( aWindowSize.Height() );
//STRIP001 	nMaxPos = aPageSize.Height() - aWindowSize.Height();
//STRIP001 	if (nMaxPos<0)
//STRIP001 	{
//STRIP001 		//	page smaller than window -> center (but put scrollbar to 0)
//STRIP001 		aOfs.Y() = 0;
//STRIP001 		pPreview->SetYOffset( nMaxPos / 2 );
//STRIP001 	}
//STRIP001 	else if (aOfs.Y() < 0)
//STRIP001 	{
//STRIP001 		//	page larger than window -> never use negative offset
//STRIP001 		aOfs.Y() = 0;
//STRIP001 		pPreview->SetYOffset( 0 );
//STRIP001 	}
//STRIP001 	else if (aOfs.Y() > nMaxPos)
//STRIP001 	{
//STRIP001 		//	limit offset to align with window bottom
//STRIP001 		aOfs.Y() = nMaxPos;
//STRIP001 		pPreview->SetYOffset(nMaxPos);
//STRIP001 	}
//STRIP001 	pVerScroll->SetThumbPos( aOfs.Y() );
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK (ScPreviewShell,ScrollHandler, ScrollBar* ,pScroll )
//STRIP001 {
//STRIP001 	long nDelta = pScroll->GetDelta();
//STRIP001 	long nPos = pScroll->GetThumbPos();
//STRIP001 
//STRIP001 	BOOL bHoriz = ( pScroll == pHorScroll );
//STRIP001 	if (bHoriz)
//STRIP001 		pPreview->SetXOffset( nPos );
//STRIP001 	else
//STRIP001 		pPreview->SetYOffset( nPos );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScPreviewShell::ScrollCommand( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 	const CommandWheelData* pData = rCEvt.GetWheelData();
//STRIP001 	if ( pData && pData->GetMode() == COMMAND_WHEEL_ZOOM )
//STRIP001 	{
//STRIP001 		long nOld = pPreview->GetZoom();
//STRIP001 		long nNew = nOld;
//STRIP001 		if ( pData->GetDelta() < 0 )
//STRIP001 			nNew = Max( (long) MINZOOM, (long)( nOld - SC_DELTA_ZOOM ) );
//STRIP001 		else
//STRIP001 			nNew = Min( (long) MAXZOOM, (long)( nOld + SC_DELTA_ZOOM ) );
//STRIP001 
//STRIP001 		if ( nNew != nOld )
//STRIP001 		{
//STRIP001 			eZoom = SVX_ZOOM_PERCENT;
//STRIP001 			pPreview->SetZoom( (USHORT)nNew );
//STRIP001 		}
//STRIP001 
//STRIP001 		bDone = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bDone = pPreview->HandleScrollCommand( rCEvt, pHorScroll, pVerScroll );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bDone;
//STRIP001 }
//STRIP001 
//STRIP001 SfxPrinter* __EXPORT ScPreviewShell::GetPrinter( BOOL bCreate )
//STRIP001 {
//STRIP001 	//	Drucker ist immer da (wird fuer die FontListe schon beim Starten angelegt)
//STRIP001 	return pDocShell->GetPrinter();
//STRIP001 }
//STRIP001 
//STRIP001 USHORT __EXPORT ScPreviewShell::SetPrinter( SfxPrinter *pNewPrinter, USHORT nDiffFlags )
//STRIP001 {
//STRIP001 	return pDocShell->SetPrinter( pNewPrinter, nDiffFlags );
//STRIP001 }
//STRIP001 
//STRIP001 PrintDialog* __EXPORT ScPreviewShell::CreatePrintDialog( Window* pParent )
//STRIP001 {
//STRIP001 	pDocShell->GetDocument()->SetPrintOptions();	// Optionen aus OFA am Printer setzen
//STRIP001 	SfxPrinter* pPrinter = GetPrinter();
//STRIP001 
//STRIP001 	const long	 nCurPage	 = pPreview->GetPageNo()+1;
//STRIP001 	const long	 nDocPageMax = pPreview->GetTotalPages();
//STRIP001 	PrintDialog* pDlg  		 = new PrintDialog( pParent );
//STRIP001 // wenn zu langsam wieder einbauen
//STRIP001 //	if ( pPreview->AllTested() )
//STRIP001 //		nPageMax = pPreview->GetTotalPages();
//STRIP001 
//STRIP001 	if ( nDocPageMax > 0 )
//STRIP001 		pDlg->SetRangeText( String::CreateFromInt32( nCurPage ) );
//STRIP001 
//STRIP001 	pDlg->EnableRange	( PRINTDIALOG_ALL );
//STRIP001 	pDlg->EnableRange	( PRINTDIALOG_RANGE );
//STRIP001 	pDlg->SetFirstPage	( 1 );
//STRIP001 	pDlg->SetMinPage	( 1 );
//STRIP001 	pDlg->SetLastPage	( (USHORT)nDocPageMax );
//STRIP001 	pDlg->SetMaxPage	( (USHORT)nDocPageMax );
//STRIP001 	pDlg->EnableCollate	();
//STRIP001 
//STRIP001 	// Selektion hier nicht
//STRIP001 
//STRIP001 	return pDlg;
//STRIP001 }
//STRIP001 
//STRIP001 SfxTabPage* ScPreviewShell::CreatePrintOptionsPage( Window *pParent, const SfxItemSet &rOptions )
//STRIP001 {
//STRIP001 	return ScTpPrintOptions::Create( pParent, rOptions );
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::PreparePrint( PrintDialog* pPrintDialog )
//STRIP001 {
//STRIP001 	SfxViewShell::PreparePrint( pPrintDialog );
//STRIP001 	pDocShell->PreparePrint( pPrintDialog, NULL );
//STRIP001 }
//STRIP001 
//STRIP001 USHORT __EXPORT ScPreviewShell::Print( SfxProgress& rProgress, PrintDialog* pPrintDialog )
//STRIP001 {
//STRIP001 	pDocShell->GetDocument()->SetPrintOptions();	// Optionen aus OFA am Printer setzen
//STRIP001 
//STRIP001 	// get the list of affected sheets (using the "only selected sheets" option) before SfxViewShell::Print
//STRIP001     USHORT nTabCount = pDocShell->GetDocument()->GetTableCount();
//STRIP001     uno::Sequence<sal_Int32> aSheets(nTabCount);
//STRIP001     for ( USHORT nTab=0; nTab<nTabCount; nTab++ )
//STRIP001     	aSheets[nTab] = nTab;
//STRIP001 
//STRIP001     uno::Sequence < beans::PropertyValue > aProps(1);
//STRIP001     aProps[0].Name=::rtl::OUString::createFromAscii("PrintSheets");
//STRIP001     aProps[0].Value <<= aSheets;
//STRIP001     SetAdditionalPrintOptions( aProps );
//STRIP001 
//STRIP001 	SfxViewShell::Print( rProgress, pPrintDialog );
//STRIP001 	pDocShell->Print( rProgress, pPrintDialog, NULL, pPreview, FALSE );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ScPreviewShell::Activate(BOOL bMDI)
//STRIP001 {
//STRIP001 	SfxViewShell::Activate(bMDI);
//STRIP001 
//STRIP001 	//!	Basic etc. -> auslagern in eigene Datei (s. tabvwsh4)
//STRIP001 
//STRIP001 	if (bMDI)
//STRIP001 	{
//STRIP001 		// InputHdl ist jetzt meistens Null, keine Assertion mehr!
//STRIP001 		ScInputHandler*	pInputHdl = SC_MOD()->GetInputHdl();
//STRIP001 		if ( pInputHdl )
//STRIP001 			pInputHdl->NotifyChange( NULL );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::Deactivate(BOOL bMDI)
//STRIP001 {
//STRIP001 	SfxViewShell::Deactivate(bMDI);
//STRIP001 
//STRIP001 	if (bMDI)
//STRIP001 	{
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::Execute( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_FORMATPAGE:
//STRIP001 		case SID_STATUS_PAGESTYLE:
//STRIP001 		case SID_HFEDIT:
//STRIP001 			pDocShell->ExecutePageStyle( *this, rReq, pPreview->GetTab() );
//STRIP001 			break;
//STRIP001 		case SID_REPAINT:
//STRIP001 			pPreview->Invalidate();
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		case SID_PREV_TABLE: // Accelerator
//STRIP001 		case SID_PREVIEW_PREVIOUS:
//STRIP001 			{
//STRIP001 				long nPage = pPreview->GetPageNo();
//STRIP001 				long nTotal = pPreview->GetTotalPages();
//STRIP001 				if (nTotal && nPage > 0)
//STRIP001 					pPreview->SetPageNo( nPage-1 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_NEXT_TABLE: // Accelerator
//STRIP001 		case SID_PREVIEW_NEXT:
//STRIP001 			{
//STRIP001 				BOOL bAllTested	= pPreview->AllTested();
//STRIP001 				long nPage = pPreview->GetPageNo();
//STRIP001 				long nTotal = pPreview->GetTotalPages();
//STRIP001 				if (nTotal && (nPage+1 < nTotal || !bAllTested))
//STRIP001 					pPreview->SetPageNo( nPage+1 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_CURSORTOPOFFILE: // Accelerator
//STRIP001 		case SID_PREVIEW_FIRST:
//STRIP001 			{
//STRIP001 				long nPage = pPreview->GetPageNo();
//STRIP001 				long nTotal = pPreview->GetTotalPages();
//STRIP001 				if (nTotal && nPage != 0)
//STRIP001 					pPreview->SetPageNo( 0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_CURSORENDOFFILE: // Accelerator
//STRIP001 		case SID_PREVIEW_LAST:
//STRIP001 			{
//STRIP001 				if (!pPreview->AllTested())
//STRIP001 					pPreview->CalcAll();
//STRIP001 
//STRIP001 				long nPage = pPreview->GetPageNo();
//STRIP001 				long nTotal = pPreview->GetTotalPages();
//STRIP001 				if (nTotal && nPage+1 != nTotal)
//STRIP001 					pPreview->SetPageNo( nTotal-1 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_ATTR_ZOOM:
//STRIP001 		case FID_SCALE:
//STRIP001 			{
//STRIP001 				USHORT		nZoom		= 100;
//STRIP001 				BOOL		bCancel		= FALSE;
//STRIP001 
//STRIP001 				eZoom = SVX_ZOOM_PERCENT;
//STRIP001 
//STRIP001 				if ( pReqArgs )
//STRIP001 				{
//STRIP001 
//STRIP001 					const SvxZoomItem& rZoomItem = (const SvxZoomItem&)
//STRIP001 												   pReqArgs->Get(SID_ATTR_ZOOM);
//STRIP001 
//STRIP001 					eZoom = rZoomItem.GetType();
//STRIP001 					nZoom = rZoomItem.GetValue();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SfxItemSet		aSet	 ( GetPool(), SID_ATTR_ZOOM, SID_ATTR_ZOOM );
//STRIP001 					SvxZoomItem		aZoomItem( SVX_ZOOM_PERCENT, pPreview->GetZoom(), SID_ATTR_ZOOM );
//STRIP001 
//STRIP001 					aSet.Put( aZoomItem );
//STRIP001 					SvxZoomDialog* pDlg = pDlg = new SvxZoomDialog( NULL, aSet );
//STRIP001 					pDlg->SetLimits( 20, 400 );
//STRIP001 					pDlg->HideButton( ZOOMBTN_OPTIMAL );
//STRIP001 					bCancel = ( RET_CANCEL == pDlg->Execute() );
//STRIP001 
//STRIP001 					if ( !bCancel )
//STRIP001 					{
//STRIP001 						const SvxZoomItem&	rZoomItem = (const SvxZoomItem&)
//STRIP001 												pDlg->GetOutputItemSet()->
//STRIP001 													Get( SID_ATTR_ZOOM );
//STRIP001 
//STRIP001 						eZoom = rZoomItem.GetType();
//STRIP001 						nZoom = rZoomItem.GetValue();
//STRIP001 					}
//STRIP001 
//STRIP001 					delete pDlg;
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( !bCancel )
//STRIP001 				{
//STRIP001 					switch ( eZoom )
//STRIP001 					{
//STRIP001 						case SVX_ZOOM_OPTIMAL:
//STRIP001 						case SVX_ZOOM_WHOLEPAGE:
//STRIP001 							nZoom = pPreview->GetOptimalZoom(FALSE);
//STRIP001 							break;
//STRIP001 						case SVX_ZOOM_PAGEWIDTH:
//STRIP001 							nZoom = pPreview->GetOptimalZoom(TRUE);
//STRIP001 							break;
//STRIP001 					}
//STRIP001 
//STRIP001 					pPreview->SetZoom( nZoom );
//STRIP001 					rReq.Done();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_PREVIEW_ZOOMIN:
//STRIP001 			{
//STRIP001 				USHORT nNew = pPreview->GetZoom() + 20 ;
//STRIP001 				nNew -= nNew % 20;
//STRIP001 				pPreview->SetZoom( nNew );
//STRIP001 				eZoom = SVX_ZOOM_PERCENT;
//STRIP001 				rReq.Done();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_PREVIEW_ZOOMOUT:
//STRIP001 			{
//STRIP001 				USHORT nNew = pPreview->GetZoom() - 1;
//STRIP001 				nNew -= nNew % 20;
//STRIP001 				pPreview->SetZoom( nNew );
//STRIP001 				eZoom = SVX_ZOOM_PERCENT;
//STRIP001 				rReq.Done();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_PRINTPREVIEW:
//STRIP001 		case SID_PREVIEW_CLOSE:
//STRIP001 			//	print preview is now always in the same frame as the tab view
//STRIP001 			//	-> always switch this frame back to normal view
//STRIP001 			//	(ScTabViewShell ctor reads stored view data)
//STRIP001 
//STRIP001             GetViewFrame()->GetDispatcher()->Execute( SID_VIEWSHELL0, SFX_CALLMODE_ASYNCHRON );
//STRIP001 			break;
//STRIP001 		case SID_CURSORPAGEUP:
//STRIP001 		case SID_CURSORPAGEDOWN:
//STRIP001 		case SID_CURSORHOME:
//STRIP001 		case SID_CURSOREND:
//STRIP001 		case SID_CURSORUP:
//STRIP001 		case SID_CURSORDOWN:
//STRIP001 		case SID_CURSORLEFT:
//STRIP001 		case SID_CURSORRIGHT:
//STRIP001 			DoScroll( nSlot );
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::GetState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	pPreview->SetInGetState(TRUE);
//STRIP001 
//STRIP001 	USHORT nTab		= pPreview->GetTab();
//STRIP001 	long nPage		= pPreview->GetPageNo();
//STRIP001 	long nTotal		= pPreview->GetTotalPages();
//STRIP001 	USHORT nZoom	= pPreview->GetZoom();
//STRIP001 	BOOL bAllTested	= pPreview->AllTested();
//STRIP001 
//STRIP001 	SfxWhichIter aIter(rSet);
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		switch (nWhich)
//STRIP001 		{
//STRIP001 			case SID_STATUS_PAGESTYLE:
//STRIP001 			case SID_HFEDIT:
//STRIP001 				pDocShell->GetStatePageStyle( *this, rSet, nTab );
//STRIP001 				break;
//STRIP001 			case SID_UNDO:
//STRIP001 			case SID_REDO:
//STRIP001 			case SID_REPEAT:
//STRIP001 				rSet.DisableItem(nWhich);
//STRIP001 				break;
//STRIP001 			case SID_PREVIEW_PREVIOUS:
//STRIP001 			case SID_PREVIEW_FIRST:
//STRIP001 				if (!nTotal || nPage==0)
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 				break;
//STRIP001 			case SID_PREVIEW_NEXT:
//STRIP001 			case SID_PREVIEW_LAST:
//STRIP001 				if (bAllTested)
//STRIP001 					if (!nTotal || nPage==nTotal-1)
//STRIP001 						rSet.DisableItem(nWhich);
//STRIP001 				break;
//STRIP001 			case SID_PREVIEW_ZOOMIN:
//STRIP001 				if (nZoom >= 400)
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 				break;
//STRIP001 			case SID_PREVIEW_ZOOMOUT:
//STRIP001 				if (nZoom <= 20)
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 				break;
//STRIP001 			case SID_ATTR_ZOOM:
//STRIP001 				{
//STRIP001 					SvxZoomItem aZoom( eZoom, nZoom, nWhich );
//STRIP001 					aZoom.SetValueSet( SVX_ZOOM_ENABLE_ALL & ~SVX_ZOOM_ENABLE_OPTIMAL );
//STRIP001 					rSet.Put( aZoom );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SID_STATUS_DOCPOS:
//STRIP001 				rSet.Put( SfxStringItem( nWhich, pPreview->GetPosString() ) );
//STRIP001 				break;
//STRIP001 			case SID_PRINTPREVIEW:
//STRIP001 				rSet.Put( SfxBoolItem( nWhich, TRUE ) );
//STRIP001 				break;
//STRIP001 			case SID_FORMATPAGE:
//STRIP001 				//!	bei geschuetzten Tabellen ???
//STRIP001 				if (pDocShell->IsReadOnly())
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 
//STRIP001 	pPreview->SetInGetState(FALSE);
//STRIP001 }
//STRIP001 
//STRIP001 void ScPreviewShell::FillFieldData( ScHeaderFieldData& rData )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nTab = pPreview->GetTab();
//STRIP001 	pDoc->GetName( nTab, rData.aTabName );
//STRIP001 
//STRIP001 	rData.aTitle		= pDocShell->GetTitle();
//STRIP001 	const INetURLObject& rURLObj = pDocShell->GetMedium()->GetURLObject();
//STRIP001 	rData.aLongDocName	= rURLObj.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 	if ( rData.aLongDocName.Len() )
//STRIP001 		rData.aShortDocName = rURLObj.GetName( INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 	else
//STRIP001 		rData.aShortDocName = rData.aLongDocName = rData.aTitle;
//STRIP001 	rData.nPageNo		= pPreview->GetPageNo() + 1;
//STRIP001 
//STRIP001 	BOOL bAllTested	= pPreview->AllTested();
//STRIP001 	if (bAllTested)
//STRIP001 		rData.nTotalPages = pPreview->GetTotalPages();
//STRIP001 	else
//STRIP001 		rData.nTotalPages = 99;
//STRIP001 
//STRIP001 	//	eNumType kennt der Dialog selber
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::WriteUserData(String& rData, BOOL bBrowse)
//STRIP001 {
//STRIP001 	//	nZoom
//STRIP001 	//	nPageNo
//STRIP001 
//STRIP001 	rData =  String::CreateFromInt32(pPreview->GetZoom());
//STRIP001 	rData += (sal_Unicode) SC_USERDATA_SEP;
//STRIP001 	rData += String::CreateFromInt32(pPreview->GetPageNo());
//STRIP001 
//STRIP001 	if ( aSourceData.Len() )
//STRIP001 	{
//STRIP001 		//	add settings from tabview in parentheses
//STRIP001 
//STRIP001 		rData += (sal_Unicode) SC_USERDATA_SEP;
//STRIP001 		rData += (sal_Unicode) '(';
//STRIP001 		rData += aSourceData;
//STRIP001 		rData += (sal_Unicode) ')';
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScPreviewShell::ReadUserData(const String& rData, BOOL bBrowse)
//STRIP001 {
//STRIP001 	xub_StrLen nCount = rData.GetTokenCount();
//STRIP001 	if (nCount)
//STRIP001 	{
//STRIP001 		xub_StrLen nIndex = 0;
//STRIP001 		pPreview->SetZoom((USHORT)rData.GetToken( 0, SC_USERDATA_SEP, nIndex ).ToInt32());
//STRIP001 		pPreview->SetPageNo(rData.GetToken( 0, SC_USERDATA_SEP, nIndex ).ToInt32());
//STRIP001 		eZoom = SVX_ZOOM_PERCENT;
//STRIP001 
//STRIP001 		//	tabview data is enclosed in parentheses
//STRIP001 
//STRIP001 		String aTabStr = rData.Copy( nIndex );
//STRIP001 		if ( aTabStr.GetChar(0) == '(' )
//STRIP001 		{
//STRIP001 			xub_StrLen nParPos = aTabStr.Search( ')' );
//STRIP001 			if ( nParPos != STRING_NOTFOUND )
//STRIP001 			{
//STRIP001 				//	get the string in the parentheses
//STRIP001 				aSourceData = aTabStr.Copy( 1, nParPos - 1 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::WriteUserDataSequence(uno::Sequence < beans::PropertyValue >& rSeq, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	rSeq.realloc(3);
//STRIP001 	beans::PropertyValue* pSeq = rSeq.getArray();
//STRIP001 	if(pSeq)
//STRIP001 	{
//STRIP001 		sal_uInt16 nViewID(GetViewFrame()->GetCurViewId());
//STRIP001 		pSeq[0].Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(SC_VIEWID));
//STRIP001 		::rtl::OUStringBuffer sBuffer(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(SC_VIEW)));
//STRIP001 		SvXMLUnitConverter::convertNumber(sBuffer, static_cast<sal_Int32>(nViewID));
//STRIP001 		pSeq[0].Value <<= sBuffer.makeStringAndClear();
//STRIP001 		pSeq[1].Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(SC_ZOOMVALUE));
//STRIP001 		pSeq[1].Value <<= sal_Int32 (pPreview->GetZoom());
//STRIP001 		pSeq[2].Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("PageNumber"));
//STRIP001 		pSeq[2].Value <<= pPreview->GetPageNo();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScPreviewShell::ReadUserDataSequence(const uno::Sequence < beans::PropertyValue >& rSeq, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	sal_Int32 nCount(rSeq.getLength());
//STRIP001 	if (nCount)
//STRIP001 	{
//STRIP001 		sal_Int32 nTemp;
//STRIP001 		const beans::PropertyValue* pSeq = rSeq.getConstArray();
//STRIP001 		if(pSeq)
//STRIP001 		{
//STRIP001 			for(sal_Int32 i = 0; i < nCount; i++, pSeq++)
//STRIP001 			{
//STRIP001 				::rtl::OUString sName(pSeq->Name);
//STRIP001 				if(sName.compareToAscii(SC_ZOOMVALUE) == 0)
//STRIP001 				{
//STRIP001 					if (pSeq->Value >>= nTemp)
//STRIP001 						pPreview->SetZoom(sal_uInt16(nTemp));
//STRIP001 				}
//STRIP001 				else if (sName.compareToAscii("PageNumber") == 0)
//STRIP001 				{
//STRIP001 					if (pSeq->Value >>= nTemp)
//STRIP001 						pPreview->SetPageNo(nTemp);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ScPreviewShell::DoScroll( USHORT nMode )
//STRIP001 {
//STRIP001 	Point	aCurPos, aPrevPos;
//STRIP001 
//STRIP001 	long nHRange	= pHorScroll->GetRange().Max();
//STRIP001 	long nHLine		= pHorScroll->GetLineSize();
//STRIP001 	long nHPage		= pHorScroll->GetPageSize();
//STRIP001 	long nVRange	= pVerScroll->GetRange().Max();
//STRIP001 	long nVLine		= pVerScroll->GetLineSize();
//STRIP001 	long nVPage		= pVerScroll->GetPageSize();
//STRIP001 
//STRIP001 	aCurPos.X() = pHorScroll->GetThumbPos();
//STRIP001 	aCurPos.Y() = pVerScroll->GetThumbPos();
//STRIP001 	aPrevPos = aCurPos;
//STRIP001 
//STRIP001 	switch( nMode )
//STRIP001 	{
//STRIP001 		case SID_CURSORUP:
//STRIP001 			aCurPos.Y() -= nVLine;
//STRIP001 			break;
//STRIP001 		case SID_CURSORDOWN:
//STRIP001 			aCurPos.Y() += nVLine;
//STRIP001 			break;
//STRIP001 		case SID_CURSORLEFT:
//STRIP001 			aCurPos.X() -= nHLine;
//STRIP001 			break;
//STRIP001 		case SID_CURSORRIGHT:
//STRIP001 			aCurPos.X() += nHLine;
//STRIP001 			break;
//STRIP001 		case SID_CURSORPAGEUP:
//STRIP001 			aCurPos.Y() -= nVPage;
//STRIP001 			break;
//STRIP001 		case SID_CURSORPAGEDOWN:
//STRIP001 			aCurPos.Y() += nVPage;
//STRIP001 			break;
//STRIP001 		case SID_CURSORHOME:
//STRIP001 			aCurPos.Y() = 0;
//STRIP001 			aCurPos.X() = 0;
//STRIP001 			break;
//STRIP001 		case SID_CURSOREND:
//STRIP001 			aCurPos.Y() = nVRange;
//STRIP001 			aCurPos.X() = nHRange;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 		// nHRange-nHPage kann negativ sein, deshalb Abfrage auf < 0 hinterher
//STRIP001 
//STRIP001 	if( aCurPos.Y() > (nVRange-nVPage) )	aCurPos.Y() = (nVRange-nVPage);
//STRIP001 	if( aCurPos.Y() < 0 )					aCurPos.Y() = 0;
//STRIP001 	if( aCurPos.X() > (nHRange-nHPage) )	aCurPos.X() = (nHRange-nHPage);
//STRIP001 	if( aCurPos.X() < 0 )					aCurPos.X() = 0;
//STRIP001 
//STRIP001 	if( aCurPos.Y() != aPrevPos.Y() )
//STRIP001 	{
//STRIP001 		pVerScroll->SetThumbPos( aCurPos.Y() );
//STRIP001 		pPreview->SetYOffset( aCurPos.Y() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aCurPos.X() != aPrevPos.X() )
//STRIP001 	{
//STRIP001 		pHorScroll->SetThumbPos( aCurPos.X() );
//STRIP001 		pPreview->SetXOffset( aCurPos.X() );
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 void ScPreviewShell::AddAccessibilityObject( SfxListener& rObject )
//STRIP001 {
//STRIP001 	if (!pAccessibilityBroadcaster)
//STRIP001 		pAccessibilityBroadcaster = new SfxBroadcaster;
//STRIP001 
//STRIP001 	rObject.StartListening( *pAccessibilityBroadcaster );
//STRIP001 }
//STRIP001 
//STRIP001 void ScPreviewShell::RemoveAccessibilityObject( SfxListener& rObject )
//STRIP001 {
//STRIP001 	if (pAccessibilityBroadcaster)
//STRIP001 		rObject.EndListening( *pAccessibilityBroadcaster );
//STRIP001 	else
//STRIP001 		DBG_ERROR("kein Accessibility-Broadcaster??!?");
//STRIP001 }
//STRIP001 
//STRIP001 void ScPreviewShell::BroadcastAccessibility( const SfxHint &rHint )
//STRIP001 {
//STRIP001 	if (pAccessibilityBroadcaster)
//STRIP001 		pAccessibilityBroadcaster->Broadcast( rHint );
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScPreviewShell::HasAccessibilityObjects()
//STRIP001 {
//STRIP001 	return pAccessibilityBroadcaster && pAccessibilityBroadcaster->HasListeners();
//STRIP001 }
//STRIP001 
//STRIP001 const ScPreviewLocationData& ScPreviewShell::GetLocationData()
//STRIP001 {
//STRIP001 	return pPreview->GetLocationData();
//STRIP001 }
//STRIP001 
//STRIP001 ScDocument* ScPreviewShell::GetDocument()
//STRIP001 {
//STRIP001 	return pDocShell->GetDocument();
//STRIP001 }


}
